/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.entity.common.ComBuyers;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.models.order.policy.service.InsBuyersService;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.models.order.policy.service.InsTopBuyersService;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.TopBuyersVo;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${systemPath}/exports/credit"})
public class InsBuyerController
extends BaseController {
    @Autowired
    private InsInsuranceSlipService insInsuranceSlipService;
    @Autowired
    private InsBuyersService insBuyersService;
    @Autowired
    private InsTopBuyersService insTopBuyersService;
    private static final String EXPORTS_CREDIT_LIST = InsBuyerController.getViewPath((String)"admin/policy/export/policy_credit_list");
    private static final String EXPORTS_CREDIT_DETATIL = InsBuyerController.getViewPath((String)"admin/policy/export/policy_credit_detatil");
    private static final String EXPORTS_CREDIT_DETATIL_INFO = InsBuyerController.getViewPath((String)"admin/policy/export/policy_credit_detatil_info");

    @RequestMapping(value={"/policyChange"})
    public String policyChange(Model model, DwzPage page) {
        SysUser user = SysUserUtils.getUser();
        List<TopBuyersVo> bList = this.insTopBuyersService.findTopBuyersOrder(page, user);
        model.addAttribute("bList", bList);
        return EXPORTS_CREDIT_LIST;
    }

    @RequestMapping(value={"/getTopBuyers/{oid}"})
    public String getTopBuyers(@PathVariable Long oid, ModelMap model) {
        TopBuyersVo topBuyersVo = this.insTopBuyersService.getBuyersVoById(oid);
        model.addAttribute("topBuyersVo", (Object)topBuyersVo);
        return EXPORTS_CREDIT_DETATIL;
    }

    @RequestMapping(value={"/getTopBuyersInfo/{oid}"})
    public String getTopBuyersInfo(@PathVariable Long oid, ModelMap model) {
        TopBuyersVo topBuyersVo = this.insTopBuyersService.getBuyersVoById(oid);
        model.addAttribute("topBuyersVo", (Object)topBuyersVo);
        return EXPORTS_CREDIT_DETATIL_INFO;
    }

    @RequestMapping(value={"/quotaApproval"})
    @ResponseBody
    public AjaxResult quotaApproval(ModelMap model, TopBuyersVo buyersVo, String buyerCode) {
        if (buyersVo.getOid() != null) {
            long oid = Long.parseLong(buyersVo.getOid());
            StTopBuyers topBuyers = this.insTopBuyersService.packagingInsTopBuyers(oid);
            if (buyersVo.getReplaystatus().equals("0")) {
                topBuyers.setReply_remark(buyersVo.getReply_remark());
                topBuyers.setApply_type("1");
                topBuyers.setReply_date(new Date());
                this.insTopBuyersService.updateById(topBuyers);
                return this.success(true, "\u62d2\u6279\u6210\u529f\uff01");
            }
            if (buyerCode == null || "".equals(buyerCode)) {
                return this.fail(false, "\u5356\u5bb6\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
            }
            topBuyers.setReply_amount(buyersVo.getReply_amount());
            topBuyers.setUnused_amount(buyersVo.getReply_amount());
            topBuyers.setApply_type("2");
            ComBuyers buyers = topBuyers.getCom_buyer();
            buyers.setCode(buyerCode);
            this.insBuyersService.updateById(buyers);
            topBuyers.setReply_date((Date)DateUtil.getTimestamp());
            this.insTopBuyersService.updateById(topBuyers);
            return this.json(true, "/exports/credit/policyChange");
        }
        return this.fail(false, "\u63d0\u4ea4\u5931\u8d25");
    }

    public static String game(int count) throws Exception {
        Random r = new Random();
        StringBuffer sb = new StringBuffer();
        String str = "0123456789";
        for (int i = 0; i < count; ++i) {
            int num = r.nextInt(str.length());
            sb.append(str.charAt(num));
            str = str.replace(str.charAt(num) + "", "");
        }
        return sb.toString();
    }
}

