/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.SpecialCreditSt;
import com.bcxin.ins.entity.policy_special.StArDebtors;
import com.bcxin.ins.entity.policy_special.StBadDebt;
import com.bcxin.ins.entity.policy_special.StCreditManagement;
import com.bcxin.ins.entity.policy_special.StServiceDescription;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.entity.policy_special.StTurnover;
import com.bcxin.ins.models.order.policy.dao.InsCommonExportDao;
import com.bcxin.ins.models.order.policy.service.InsArDebtorsService;
import com.bcxin.ins.models.order.policy.service.InsBadAnalysisService;
import com.bcxin.ins.models.order.policy.service.InsBadDebtService;
import com.bcxin.ins.models.order.policy.service.InsCommonExportService;
import com.bcxin.ins.models.order.policy.service.InsCreditManagementService;
import com.bcxin.ins.models.order.policy.service.InsDebtAgesService;
import com.bcxin.ins.models.order.policy.service.InsForecastedDetailService;
import com.bcxin.ins.models.order.policy.service.InsManagerDetailService;
import com.bcxin.ins.models.order.policy.service.InsOverdueDetailService;
import com.bcxin.ins.models.order.policy.service.InsPastBadDetailService;
import com.bcxin.ins.models.order.policy.service.InsRecentYearsSellService;
import com.bcxin.ins.models.order.policy.service.InsServiceDescriptionService;
import com.bcxin.ins.models.order.policy.service.InsTopBuyersService;
import com.bcxin.ins.models.order.policy.service.InsTurnoverService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsCommonExportServiceImpl
extends ServiceImpl<InsCommonExportDao, SpecialCreditSt>
implements InsCommonExportService {
    @Autowired
    private InsCommonExportDao dao;
    @Autowired
    private InsServiceDescriptionService insServiceDescriptionService;
    @Autowired
    private InsTurnoverService insTurnoverService;
    @Autowired
    private InsBadDebtService insBadDebtService;
    @Autowired
    private InsTopBuyersService insTopBuyersService;
    @Autowired
    private InsArDebtorsService insArDebtorsService;
    @Autowired
    private InsCreditManagementService insCreditManagementService;
    @Autowired
    private InsForecastedDetailService insForecastedDetailService;
    @Autowired
    private InsRecentYearsSellService insRecentYearsSellService;
    @Autowired
    private InsPastBadDetailService insPastBadDetailService;
    @Autowired
    private InsBadAnalysisService insBadAnalysisService;
    @Autowired
    private InsOverdueDetailService insOverdueDetailService;
    @Autowired
    private InsDebtAgesService insDebtAgesService;
    @Autowired
    private InsManagerDetailService insManagerDetailService;

    @Override
    public SpecialCreditSt getInsCommonExportBusiness(Long oid) {
        SpecialCreditSt insCommonExport = this.dao.selectById(oid);
        if (insCommonExport != null) {
            this.setServiceDescription(insCommonExport);
            this.setInsTurnover(insCommonExport);
            this.setInsBadDebt(insCommonExport);
            this.setInsCreditManagement(insCommonExport);
            this.setTopBuyers(insCommonExport);
            this.setInsArDebtors(insCommonExport);
        }
        return insCommonExport;
    }

    @Override
    public SpecialCreditSt initInsCommonExport() {
        SpecialCreditSt insCommonExport = new SpecialCreditSt();
        insCommonExport.setService_description(this.insServiceDescriptionService.initInsServiceDescription());
        insCommonExport.setTurnover(this.insTurnoverService.initInsTurnover());
        insCommonExport.setBad_debt(this.insBadDebtService.initInsBadDebt());
        insCommonExport.setCredit_management(this.insCreditManagementService.initInsCreditManagement());
        this.dao.insert(insCommonExport);
        return insCommonExport;
    }

    private void setServiceDescription(SpecialCreditSt insCommonExport) {
        StServiceDescription result = insCommonExport.getService_description();
        if (result != null) {
            insCommonExport.setService_description((StServiceDescription)this.insServiceDescriptionService.selectById(result.getSt_service_description_id()));
        }
    }

    private void setInsTurnover(SpecialCreditSt insCommonExport) {
        StTurnover result = insCommonExport.getTurnover();
        if (result != null) {
            insCommonExport.setTurnover(this.insTurnoverService.packagingInsTurnover(result.getSt_turnover_id()));
        }
    }

    private void setInsBadDebt(SpecialCreditSt insCommonExport) {
        StBadDebt result = insCommonExport.getBad_debt();
        if (result != null) {
            insCommonExport.setBad_debt(this.insBadDebtService.packagingInsBadDebt(result.getSt_bad_debt_id()));
        }
    }

    private void setInsCreditManagement(SpecialCreditSt insCommonExport) {
        StCreditManagement result = insCommonExport.getCredit_management();
        if (result != null) {
            insCommonExport.setCredit_management(this.insCreditManagementService.packagingInsCreditManagement(result.getSt_credit_management_id()));
        }
    }

    private void setTopBuyers(SpecialCreditSt insCommonExport) {
        List<StTopBuyers> insTopBuyersList = this.insTopBuyersService.selectInsTopBuyersBySpecialID(insCommonExport.getSpecial_credit_st_id());
        if (insTopBuyersList.size() > ConstProp.INT_NUMBER_ZERO) {
            insCommonExport.setTopBuyers(insTopBuyersList);
        }
    }

    private void setInsArDebtors(SpecialCreditSt insCommonExport) {
        List<StArDebtors> insArDebtorsList = this.insArDebtorsService.selectInsArDebtorsByInsCommonExport(insCommonExport.getSpecial_credit_st_id());
        if (insArDebtorsList.size() > ConstProp.INT_NUMBER_ZERO) {
            insCommonExport.setInsArDebtors(insArDebtorsList);
        }
    }

    @Override
    public void getCommonExportVo_1BySpecial_id(CommonExportVo_1 vo, Long ceID) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(ceID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insCommonExport), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insServiceDescriptionService.accordingToInsServiceDescriptionIntoCommonExportVo_1(vo, insCommonExport.getService_description());
        StTurnover turnover = insCommonExport.getTurnover();
        this.insTurnoverService.accordingToInsTurnoverIntoCommonExportVo_1(vo, turnover);
        vo.setForecastedDetailList(this.insForecastedDetailService.packagingForecastedDetailVoListByInsForecastedDetailList(turnover.getForecastedDetailList()));
        vo.setRecentYearsSellList(this.insRecentYearsSellService.packagingRecentYearsSellVoListByInsRecentYearsSellList(turnover.getRecentYearsSellList()));
    }

    @Override
    public void getCommonExportVo_2BySpecial_id(CommonExportVo_2 vo, Long ceID) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(ceID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insCommonExport), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setDebtAgesList(this.insDebtAgesService.getDebtAgesVoListByInsDebtAgesList(insCommonExport.getBad_debt().getInsDebtAges()));
        vo.setOverdueDetailList(this.insOverdueDetailService.getOverdueDetailVoListByInsOverdueDetailList(insCommonExport.getBad_debt().getInsOverdueDetail()));
        vo.setBadAnalysisList(this.insBadAnalysisService.getBadAnalysisVoListByInsBadAnalysisList(insCommonExport.getBad_debt().getInsBadAnalysis()));
        this.insBadDebtService.accordingToInsBadDebtIntoBadDebtVo(vo, insCommonExport.getBad_debt());
        vo.setPastBadDetailList(this.insPastBadDetailService.getPastBadDetailVoListByInsPastBadDetailList(insCommonExport.getBad_debt().getInsPastBadDetail()));
        vo.setTopBuyersList(this.insTopBuyersService.getTopBuyersVoListBySpecialID(insCommonExport.getSpecial_credit_st_id()));
        vo.setArDebtorsList(this.insArDebtorsService.getArDebtorsVoListByCommon_export_id(insCommonExport.getSpecial_credit_st_id()));
    }

    @Override
    public void getCommonExportVo_3BySpecial_id(CommonExportVo_3 vo, Long ceID) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(ceID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insCommonExport), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insCreditManagementService.accordingToInsCreditManagementIntoCommonExportVo_3(vo, insCommonExport.getCredit_management());
        vo.setManagerDetailList(this.insManagerDetailService.getManagerDetailVoListByInsManagerDetailList(insCommonExport.getCredit_management().getInsManagerDetail()));
    }

    @Override
    public void accordingToTheCommonExportVo_1SetUpInsCommonExport(CommonExportVo_1 vo, Long special_id) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(special_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insCommonExport);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insServiceDescriptionService.accordingToTheCommonExportVo_1SetUpInsServiceDescription(vo, insCommonExport.getService_description().getSt_service_description_id());
        this.insTurnoverService.accordingToTheCommonExportVo_1SetUpInsTurnover(vo, insCommonExport.getTurnover().getSt_turnover_id());
        this.insForecastedDetailService.setForecastedDetailByForecastedDetailVo(vo.getForecastedDetailList(), insCommonExport.getTurnover().getSt_turnover_id());
        this.insRecentYearsSellService.setRecentYearsSellByRecentYearsSellVo(vo.getRecentYearsSellList(), insCommonExport.getTurnover().getSt_turnover_id());
        this.dao.updateById(insCommonExport);
    }

    @Override
    public void accordingToTheCommonExportVo_2SetUpInsCommonExport(CommonExportVo_2 vo, Long special_id) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(special_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insCommonExport);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insDebtAgesService.setDebtAgesByDebtAgesVo(vo.getDebtAgesList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
        this.insOverdueDetailService.setOverdueDetailByOverdueDetailVo(vo.getOverdueDetailList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
        this.insBadAnalysisService.setBadAnalysisByBadAnalysisVo(vo.getBadAnalysisList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
        this.insBadDebtService.accordingToTheCommonExportVo_2SetUpInsBadDebt(vo, insCommonExport.getBad_debt().getSt_bad_debt_id());
        this.insPastBadDetailService.setPastBadDetailByPastBadDetailVo(vo.getPastBadDetailList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
        this.insTopBuyersService.setTopBuyersByTopBuyersVo(vo.getTopBuyersList(), insCommonExport.getSpecial_credit_st_id());
        this.insArDebtorsService.setArDebtorsByArDebtorsVo(vo.getArDebtorsList(), insCommonExport.getSpecial_credit_st_id());
        this.dao.updateById(insCommonExport);
    }

    @Override
    public void accordingToTheCommonExportVo_3SetUpInsCommonExport(CommonExportVo_3 vo, Long special_id) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(special_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insCommonExport);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insCreditManagementService.accordingToTheCommonExportVo_3SetUpInsCreditManagement(vo, insCommonExport.getCredit_management().getSt_credit_management_id());
        this.insManagerDetailService.setManagerDetailByManagerDetailVo(vo.getManagerDetailList(), insCommonExport.getCredit_management().getSt_credit_management_id());
        this.dao.updateById(insCommonExport);
    }
}

