/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.models.order.policy.dao.InsAgreementDao;
import com.bcxin.ins.models.order.policy.service.InsAgreementService;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsAgreementServiceImpl
extends ServiceImpl<InsAgreementDao, InsAgreement>
implements InsAgreementService {
    @Autowired
    private InsAgreementDao dao;
    @Autowired
    private InsInsuranceSlipService insInsuranceSlipService;

    @Override
    public InsAgreement initAgreement() {
        InsAgreement insAgreement = new InsAgreement();
        this.dao.insert(insAgreement);
        return insAgreement;
    }

    @Override
    public InsAgreement selectById(Long oid) {
        return this.dao.selectById(oid);
    }

    @Override
    public InsAgreement selectInsAgreementByInsInsuranceSlip(Long insurance_slip_id) {
        return this.dao.selectInsAgreementByInsInsuranceSlip(insurance_slip_id);
    }

    @Override
    public void willInsurePolicyVoChangeIntoInsAgreement(Long insurance_slip_id, String externalReference) {
        InsAgreement insAgreement = this.selectInsAgreementByInsInsuranceSlip(insurance_slip_id);
        if (insAgreement == null) {
            insAgreement = this.initAgreement();
        }
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.packagingInsInsuranceSlip(insurance_slip_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)insAgreement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        insAgreement.setExternal_reference(externalReference);
        insAgreement.setPro_primary(insInsuranceSlip.getPro_primary());
        insAgreement.setIns_insurance_slip(insInsuranceSlip);
        insAgreement.setMail_policy_id(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        insAgreement.setRegister_user_id(insInsuranceSlip.getRegister_user_id());
        insAgreement.setSpecial_id(insInsuranceSlip.getSpecial_id());
        this.dao.updateById(insAgreement);
    }
}

