/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.dto.ResultDto;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.IpAddress;
import com.bcxin.ins.vo.ConstProp;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFilter
implements Filter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer MAX_COUNT = 10;
    private static final Long MAX_TIME_SECOND = 300L;
    private static String COUNT = "count";
    private static String TIME = "time";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String ip = IpAddress.getIpAddress((HttpServletRequest)request);
        String url = request.getServletPath().replace("/", "");
        String path = request.getRequestURL().toString().split("\\?")[0];
        if (path.contains(".php")) {
            IPFilter.returnWriter("502 Bad Gateway", response);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!IPFilter.checkUrl(url, ip, request)) {
            IPFilter.returnWriter("ERROR\uff1a\u672a\u5b8c\u6210\u56fe\u5f62\u9a8c\u8bc1\u7801\u9a8c\u8bc1\uff0c\u8bf7\u6c42\u6765\u6e90\u975e\u6cd5\uff01", response);
            return;
        }
        if (IPFilter.noneUrl(request.getServletPath())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        int count = 0;
        Long time = System.currentTimeMillis();
        JSONObject json = null;
        try {
            String key = "BLB:CACHE:UIP-" + String.valueOf(ip) + "-" + url;
            if (JedisUtils.exists((String)key) && StringUtils.isNotEmpty((CharSequence)JedisUtils.get((String)key))) {
                json = JSON.parseObject((String)JedisUtils.get((String)key));
                count = Integer.parseInt(String.valueOf(json.get((Object)COUNT)));
                Long initTime = Long.parseLong(String.valueOf(json.get((Object)TIME)));
                Long jetLag = (time - initTime) / 1000L;
                if (jetLag >= MAX_TIME_SECOND) {
                    this.logger.debug("      ====== IP\u8fc7\u6ee4\u5668 > 5m\uff1akey:" + key + ",count:" + count + ",jetLag:" + jetLag + " ======      ");
                    IPFilter.setRedisContent(json, key, String.valueOf(1), String.valueOf(time));
                } else {
                    if (count > MAX_COUNT) {
                        this.logger.debug("      ====== IP\u8fc7\u6ee4\u5668\u8d85\u51fa\u9884\u671f\uff1akey:" + key + ",count:" + count + ",jetLag:" + jetLag + " ======      ");
                        IPFilter.returnWriter("\u8b66\u544a\uff01\uff01\u60a8\u7684\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", response);
                        return;
                    }
                    this.logger.debug("      ====== IP\u8fc7\u6ee4\u5668 < 5m\uff1akey:" + key + ",count:" + count + ",jetLag:" + jetLag + " ======      ");
                    IPFilter.setRedisContent(json, key, String.valueOf(count + 1), "");
                }
            } else {
                this.logger.debug("      ====== IP\u8fc7\u6ee4\u5668\u521d\u59cb\uff1akey:" + key + ",count:" + count + ",time:" + time + " ======      ");
                IPFilter.setRedisContent(json, key, String.valueOf(count + 1), String.valueOf(time));
            }
        }
        catch (Exception e) {
            IPFilter.returnWriter("IP\u8fc7\u6ee4\u5668\u4e1a\u52a1\u5904\u7406\u5f02\u5e38\uff0cERROR\uff1a" + e.getMessage(), response);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private static boolean checkUrl(String url, String ip, HttpServletRequest request) {
        if (url.contains("registersendAuthCode")) {
            String key;
            String[] vals = request.getParameterValues("check_code");
            if (vals == null) {
                return false;
            }
            String code = vals[0];
            if (StringUtils.isNotEmpty((CharSequence)code) && JedisUtils.exists((String)(key = "BLB:CACHE:CIP-" + String.valueOf(ip))) && StringUtils.isNotEmpty((CharSequence)JedisUtils.get((String)key))) {
                String sessionyanz = JedisUtils.get((String)key);
                JedisUtils.del((String)key);
                if (code.equals(sessionyanz)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean noneUrl(String url) {
        return url.contains("/admin");
    }

    private static void setRedisContent(JSONObject json, String key, String count, String time) {
        if (json == null) {
            json = new JSONObject();
        }
        if (StringUtils.isNotEmpty((CharSequence)count)) {
            json.put(COUNT, (Object)count);
        }
        if (StringUtils.isNotEmpty((CharSequence)time)) {
            json.put(TIME, (Object)time);
        }
        JedisUtils.set((String)key, (String)json.toString(), (int)ConstProp.ONE_HOURS_TIMEOUT_SECONDS);
    }

    private static void returnWriter(String msg, HttpServletResponse response) throws IOException {
        ResultDto dto = new ResultDto(msg, "300", "", "", "");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().print(JSON.toJSONString((Object)dto));
    }

    public void destroy() {
    }
}

