/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.thrApi;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.GYXPolicyVo;
import com.bcxin.ins.vo.InsOrderSearchVo;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/api/order"})
public class Order_API_Controller
extends BaseController {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private InsPreservationDetailAPIService insPreservationDetailAPIService;
    private static String POLICYTOTALS = "policyTotals";
    private static String POLICYSTATUS = "policyStatus";
    private static String TYPELIST = "typeList";
    private static String NATURELIST = "natureList";

    @RequestMapping(value={"/addPreservationView"})
    public ModelAndView addPreservationView(String data) {
        ModelAndView view = new ModelAndView();
        HashMap map = new HashMap();
        List list = null;
        try {
            list = MessageUtils.getList((String)data, InsPreservationDetailVo.class, (String)"vo");
            String orderNo = MessageUtils.getStringValueByKey((String)data, (String)"orderNo");
            String inceptionDate = MessageUtils.getStringValueByKey((String)data, (String)"inceptionDate");
            String reviseType = MessageUtils.getStringValueByKey((String)data, (String)"reviseType");
            if ("1".equals(reviseType)) {
                view.setViewName("/coninsweb/personalCenter/preservation/api/add_preservation_list");
            } else if ("2".equals(reviseType)) {
                view.setViewName("/coninsweb/personalCenter/preservation/api/minus_preservation_list");
            }
            InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
            iprVo.setIns_insurance_slip_id(orderNo);
            iprVo.setInception_date(inceptionDate);
            iprVo.setRevise_type(reviseType);
            iprVo.setInsPreservationDetailVoList(list);
            view.addObject("iprVo", (Object)iprVo);
            this.setTokenByApi(view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    @RequestMapping(value={"/saveOrderPreservation"})
    public void saveOrderPreservation(String data, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = null;
        try {
            list = MessageUtils.getList((String)data, InsPreservationDetailVo.class, (String)"vo");
            String orderNo = MessageUtils.getStringValueByKey((String)data, (String)"orderNo");
            String inceptionDate = MessageUtils.getStringValueByKey((String)data, (String)"inceptionDate");
            String reviseType = MessageUtils.getStringValueByKey((String)data, (String)"reviseType");
            for (InsPreservationDetailVo ipdVo : list) {
                String result = this.insPreservationDetailAPIService.personnelToCheck(ipdVo, reviseType);
                if ("300".equals(result.split("#")[0])) {
                    this.returnFailedMessage(map, result.split("#")[1], response);
                }
                ipdVo.setRevise_type(reviseType);
            }
            map.put("vo", list);
            map.put("orderNo", orderNo);
            map.put("inceptionDate", inceptionDate);
            map.put("reviseType", reviseType);
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(orderNo)));
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            map.put("externalReference", dto.getExternal_reference());
            map.put("applicantName", dto.getApplicant_name());
            map.put("productName", pd.getProduct_name());
            map.put("responsibilityVo1", ((ResponsibilityVo)pd.getResponsibilityVoList().get(0)).getShow_name() + ((ResponsibilityVo)pd.getResponsibilityVoList().get(0)).getFcy());
            map.put("responsibilityVo2", ((ResponsibilityVo)pd.getResponsibilityVoList().get(1)).getShow_name() + ((ResponsibilityVo)pd.getResponsibilityVoList().get(1)).getFcy());
            map.put("responsibilityVo3", ((ResponsibilityVo)pd.getResponsibilityVoList().get(2)).getShow_name() + ((ResponsibilityVo)pd.getResponsibilityVoList().get(2)).getFcy());
            List dList = this.insPreservationRecordAPIService.saveOrderPreservation(map);
            if (dList != null) {
                map.put("list", dList);
                this.returnSuccessStatus(map, response);
            } else {
                this.returnFailedStatus(map, response);
            }
        }
        catch (Exception e) {
            this.returnFailedStatus(map, response);
            e.printStackTrace();
        }
    }

    private void returnSuccessStatus(Map<String, Object> map, HttpServletResponse response) {
        map.put("status", "200");
        map.put("message", "Operate Success!");
        MessageUtils.returnMessage((String)MessageUtils.packageMap(map), (HttpServletResponse)response);
    }

    private void returnFailedMessage(Map<String, Object> map, String msg, HttpServletResponse response) {
        map.put("status", "300");
        map.put("message", msg);
        MessageUtils.returnMessage((String)MessageUtils.packageMap(map), (HttpServletResponse)response);
    }

    private void returnFailedStatus(Map<String, Object> map, HttpServletResponse response) {
        map.put("status", "300");
        map.put("message", "Operate Error!");
        MessageUtils.returnMessage((String)MessageUtils.packageMap(map), (HttpServletResponse)response);
    }

    private void returnFailedKeyStatus(Map<String, Object> map, HttpServletResponse response) {
        map.put("status", "301");
        map.put("message", "Operate Error!");
        MessageUtils.returnMessage((String)MessageUtils.packageMap(map), (HttpServletResponse)response);
    }

    @RequestMapping(value={"myOrder"})
    public ModelAndView myOrderInit(String policyStatus, DwzPage page, HttpServletRequest request) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView("forward:/synopsis/loseView");
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/order/orderList");
        if (policyStatus == null) {
            policyStatus = "1";
        }
        page.setNumPerPage(5);
        String businessType = this.getRequest().getParameter("businessType");
        String keyword = this.getRequest().getParameter("keyword");
        String starDate = this.getRequest().getParameter("starDate");
        String endDate = this.getRequest().getParameter("endDate");
        view.addObject("businessType", (Object)businessType);
        view.addObject("userdetail", (Object)userdetail);
        try {
            InsOrderSearchVo search = InsOrderSearchVo.build((Long)Long.parseLong(userdetail.getOid()), (String)policyStatus, (String)this.getProductSn(userdetail.getWeb_type()), (String)keyword, (String)starDate, (String)endDate, (String)businessType, (DwzPage)page);
            view.addObject(POLICYTOTALS, (Object)this.policyService.findTotalPolicyNum(search));
            view.addObject("orderList", (Object)this.policyService.findPolicyForPage(search));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.addObject(POLICYSTATUS, (Object)policyStatus);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"tabTotal"})
    public ModelAndView tabTotal(String policyStatus) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ModelAndView view = new ModelAndView("/coninsweb/api/order/tabTotal");
        if (StringUtils.isEmpty((CharSequence)policyStatus) || "null".equals(policyStatus)) {
            policyStatus = "1";
        }
        if (userdetail == null) {
            view.addObject(POLICYTOTALS, null);
        } else {
            String businessType = this.getRequest().getParameter("businessType");
            String keyword = this.getRequest().getParameter("keyword");
            String starDate = this.getRequest().getParameter("starDate");
            String endDate = this.getRequest().getParameter("endDate");
            InsOrderSearchVo search = InsOrderSearchVo.build((Long)Long.parseLong(userdetail.getOid()), (String)policyStatus, (String)this.getProductSn(userdetail.getWeb_type()), (String)keyword, (String)starDate, (String)endDate, (String)businessType, null);
            view.addObject(POLICYTOTALS, (Object)this.policyService.findTotalPolicyNum(search));
        }
        view.addObject(POLICYSTATUS, (Object)policyStatus);
        this.setTokenByApi(view);
        return view;
    }

    private String getProductSn(String webType) {
        String result = "";
        if (webType.contains("ARS")) {
            result = "TYX,GZZRX";
        } else if (webType.contains("PSS")) {
            result = "TYX,GZX,ZZX";
        }
        return result;
    }

    @RequestMapping(value={"getOrderListForPage"})
    public ModelAndView getOrderListForPage(String policyStatus, DwzPage page, HttpServletRequest request) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView("forward:/synopsis/loseView");
        }
        String businessType = this.getRequest().getParameter("businessType");
        String keyword = this.getRequest().getParameter("keyword");
        String starDate = this.getRequest().getParameter("starDate");
        String endDate = this.getRequest().getParameter("endDate");
        ModelAndView view = new ModelAndView("/coninsweb/api/order/orderList_table");
        InsOrderSearchVo search = InsOrderSearchVo.build((Long)Long.parseLong(userdetail.getOid()), (String)policyStatus, (String)this.getProductSn(userdetail.getWeb_type()), (String)keyword, (String)starDate, (String)endDate, (String)businessType, (DwzPage)page);
        view.addObject("orderList", (Object)this.policyService.findPolicyForPage(search));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"getOnGoingOrderListForPage"})
    public ModelAndView getOnGoingOrderListForPage(String policyStatus, DwzPage page, HttpServletRequest request) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView("forward:/synopsis/loseView");
        }
        String keyword = this.getRequest().getParameter("keyword");
        String starDate = this.getRequest().getParameter("starDate");
        String endDate = this.getRequest().getParameter("endDate");
        ModelAndView view = new ModelAndView("/coninsweb/api/order/orderList_table");
        InsOrderSearchVo search = InsOrderSearchVo.build((Long)Long.parseLong(userdetail.getOid()), (String)policyStatus, (String)this.getProductSn(userdetail.getWeb_type()), (String)keyword, (String)starDate, (String)endDate, (String)"", (DwzPage)page);
        view.addObject("orderList", (Object)this.policyService.findPolicyForPage(search));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"orderDetailByOrderID/{order_id}"})
    public ModelAndView exportDetailByOrderID(@PathVariable Long order_id, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView("forward:/synopsis/loseView");
        }
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        if (dto == null) {
            view.addObject("userdetail", (Object)userdetail);
            this.setTokenByApi(view);
            return view;
        }
        if (StringUtils.isEmpty((CharSequence)dto.getProduct_code())) {
            view.addObject("dto", (Object)dto);
            view.addObject("userdetail", (Object)userdetail);
            this.setTokenByApi(view);
            return view;
        }
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        if ("TYX".equals(dto.getProduct_code().split("-")[0])) {
            view.setViewName("/coninsweb/api/order/gmr_policyDetail");
            GMRPolicyVo vo = this.policyService.accordingToOrderIDToGetGMRPolicyVo(order_id);
            if (vo != null) {
                List typeList = IdType.doList();
                List natureList = NatureLinkage.doList();
                view.addObject("vo", (Object)vo);
                view.addObject(TYPELIST, (Object)typeList);
                view.addObject(NATURELIST, (Object)natureList);
                view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
                if (vo.getSpecialExhibitionVo() != null) {
                    view.addObject("ex_pca", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getSpecialExhibitionVo().getEx_province(), (String)vo.getSpecialExhibitionVo().getEx_city(), (String)vo.getSpecialExhibitionVo().getEx_county()));
                }
            }
        } else if ("ZZX".equals(dto.getProduct_code().split("-")[0])) {
            view.setViewName("/coninsweb/api/lote/policyDetails/lote_policy_detail");
            LOTEPolicyVo vo = this.policyService.accordingToOrderIDToGetLOTEPolicyVo(order_id);
            view.addObject("vo", (Object)vo);
            view.addObject("comTypeList", (Object)IdType.comList());
            List natureList = NatureLinkage.doList();
            view.addObject(NATURELIST, (Object)natureList);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
            view.addObject("ex_pca", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getSpecialExhibitionVo().getEx_province(), (String)vo.getSpecialExhibitionVo().getEx_city(), (String)vo.getSpecialExhibitionVo().getEx_county()));
        } else if (dto.getProduct_code().contains("GZX-PAC")) {
            view.setViewName("/coninsweb/api/gzx/policyDetails/gzx_policy_detail");
            SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
            view.addObject("comTypeList", (Object)IdType.comList());
            List natureList = NatureLinkage.doList();
            view.addObject(NATURELIST, (Object)natureList);
            view.addObject("vo", (Object)vo);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        } else if (dto.getProduct_code().contains("GZX-HT")) {
            view.setViewName("/coninsweb/api/gzx/policyDetails/gzx_policy_detail");
            SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
            view.addObject("comTypeList", (Object)IdType.comList());
            List natureList = NatureLinkage.doList();
            view.addObject(NATURELIST, (Object)natureList);
            view.addObject("pd", (Object)this.productService.getProduct(Long.parseLong(dto.getProduct_oid())));
            view.addObject("vo", (Object)vo);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        } else if (dto.getProduct_code().contains("GYX")) {
            view.setViewName("/coninsweb/api/gyx/gyx_policyDetail");
            GYXPolicyVo vo = this.policyService.accordingToOrderIDToGetGYXPolicyVo(order_id);
            if (vo != null) {
                List typeList = IdType.doList();
                view.addObject("vo", (Object)vo);
                view.addObject(TYPELIST, (Object)typeList);
                view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            }
        } else if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && dto.getProduct_code().contains("GZZRX")) {
            view.setViewName("/coninsweb/api/gzzrx/policyDetails/gzzrx_policy_detail");
            view.addObject("pd", (Object)this.productService.getProduct(Long.parseLong(dto.getProduct_oid())));
            SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
            List typeList = IdType.doList();
            List natureList = NatureLinkage.doList();
            view.addObject(TYPELIST, (Object)typeList);
            view.addObject(NATURELIST, (Object)natureList);
            view.addObject("vo", (Object)vo);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        }
        view.addObject("dto", (Object)dto);
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"copyOrder"})
    @ResponseBody
    public ResultDto copyOrder(HttpServletRequest request) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ResultDto("\u7528\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01", "300", "", "", "");
        }
        String order_id = request.getParameter("order_id");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return new ResultDto("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", "300", "", "", "");
        }
        if (this.isCopyCount(userdetail.getOid())) {
            return new ResultDto("\u590d\u5236\u529f\u80fd\u4f7f\u7528\u6b21\u6570\u5df2\u8d85\u8fc7\u4e0a\u9650\uff01", "300", "", "", "");
        }
        return this.policyService.copyPolicy(Long.valueOf(Long.parseLong(order_id)));
    }

    private boolean isCopyCount(String uId) {
        String key = "BLB:CACHE:COPY-" + uId;
        String countStr = JedisUtils.get((String)key);
        int count = 1;
        if (StringUtils.isNotEmpty((CharSequence)countStr)) {
            count = Integer.parseInt(countStr);
            if (count == 10) {
                return true;
            }
            ++count;
        }
        JedisUtils.set((String)key, (String)(count + ""), (int)ConstProp.ONE_DAY_TIMEOUT_SECONDS);
        return false;
    }

    @RequestMapping(value={"deleteOrder"})
    @ResponseBody
    public JSONObject deleteOrder(HttpServletRequest request) {
        JSONObject json = new JSONObject();
        String message = "";
        String status = "300";
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            message = "\u7528\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01";
        } else {
            String order_id = request.getParameter("order_id");
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(order_id)));
            if (!dto.getPolicy_status().equals("1") && !dto.getPolicy_status().equals("4")) {
                message = "\u72b6\u6001\u4e3a\uff1a" + SysDictUtils.getDictLabel((String)dto.getPolicy_status(), (String)"order_status", (String)"") + " \u8ba2\u5355\u65e0\u6cd5\u5220\u9664\uff01";
            } else {
                dto.setPolicy_status("13");
                String orderID = this.policyService.updateOrderFormStatus(dto);
                if (StringUtils.isNotEmpty((CharSequence)orderID)) {
                    message = "\u8ba2\u5355\u5220\u9664\u6210\u529f\uff01";
                    status = "200";
                } else {
                    message = "\u8ba2\u5355\u5220\u9664\u5931\u8d25\uff01";
                }
            }
        }
        json.put("message", (Object)message);
        json.put("status", (Object)status);
        return json;
    }

    @RequestMapping(value={"/policyDal"})
    public void policyDal(String data, HttpServletResponse response) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String order_id = MessageUtils.getStringValueByKey((String)data, (String)"order_id");
        if (StringUtils.isNotEmpty((CharSequence)order_id)) {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(order_id)));
            if (dto != null) {
                map.put("order_id", dto.getOid());
                map.put("product_name", dto.getProduct_name());
                map.put("insurance_ame", dto.getInsurance_name());
                map.put("inception_date", dto.getInception_date());
                map.put("planned_end_date", dto.getPlanned_end_date());
                map.put("gross_premium", dto.getGross_premium());
                map.put("applicant_name", dto.getApplicant_name());
                GMRPolicyVo vo = this.policyService.accordingToOrderIDToGetGMRPolicyVo(Long.valueOf(Long.parseLong(order_id)));
                if (vo != null && vo.getRoleSubjectList().size() > 1) {
                    map.put("ins_count", String.valueOf(vo.getRoleSubjectList().size() - 1));
                }
                this.returnSuccessStatus(map);
            } else {
                this.returnFailedStatus(map);
            }
        } else {
            this.returnFailedStatus(map);
        }
        MessageUtils.returnMessage((String)MessageUtils.packageMap(map), (HttpServletResponse)response);
    }

    private void returnSuccessStatus(Map<String, Object> map) {
        map.put("status", "200");
        map.put("message", "Operate Success!");
    }

    private void returnFailedStatus(Map<String, Object> map) {
        map.put("status", "300");
        map.put("message", "Operate Error!");
    }
}

