/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.report.controller.app;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.Auth;
import com.bcxin.ins.core.service.MyTposThrUserService;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.InsCommonReportAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/app/report"})
public class InsCommonReport_APP_Controller
extends BaseController {
    @Autowired
    private InsCommonReportAPIService insCommonReportAPIService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ClientUserService clientUserService;
    @Autowired
    private MyTposThrUserService myTposThrUserService;

    private Result checkLogin(String party, String token) {
        Auth auth = this.myTposThrUserService.isAuth(party, token, this.getRequest());
        if (auth.isSuccess()) {
            JSONObject json = (JSONObject)auth.getData();
            if (this.clientUserService.saveClientUserVo(party, json.get((Object)"login_name") != null ? String.valueOf(json.get((Object)"login_name")) : String.valueOf(json.get((Object)"user_id")), String.valueOf(json.get((Object)"user_id")))) {
                if (party.contains("SAAS")) {
                    return Result.success((String)"\u767b\u5f55\u6210\u529f!");
                }
                return Result.fail((String)"\u65e0\u6548\u6765\u6e90\uff01");
            }
            return Result.fail((String)"\u767b\u5f55\u5931\u8d25\uff01");
        }
        return Result.fail((String)auth.getMsg());
    }

    @RequestMapping(value={"reportList"})
    @ResponseBody
    public Result reportList() throws UnsupportedEncodingException {
        Result result;
        String party = this.getRequest().getParameter("party");
        String token = this.getRequest().getParameter("token");
        if (StringUtils.isEmpty((CharSequence)party) || StringUtils.isEmpty((CharSequence)token)) {
            return Result.fail((String)"\u5e73\u53f0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null && "-1".equals((result = this.checkLogin(party, token)).getRetType())) {
            return result;
        }
        String saasIdCardNo = this.getRequest().getParameter("saasIdCardNo");
        String status = this.getRequest().getParameter("status");
        if (StringUtils.isEmpty((CharSequence)saasIdCardNo) || StringUtils.isEmpty((CharSequence)status)) {
            return Result.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.insCommonReportAPIService.selectReportListByIdCardNo(status, saasIdCardNo);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)list);
    }

    @RequestMapping(value={"getReportById/{report_id}"})
    @ResponseBody
    public Result getReportById(@PathVariable Long report_id) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            String party = this.getRequest().getParameter("party");
            String token = this.getRequest().getParameter("token");
            if (StringUtils.isEmpty((CharSequence)party) || StringUtils.isEmpty((CharSequence)token)) {
                return Result.fail((String)"\u5e73\u53f0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            Result result = this.checkLogin(party, token);
            if ("-1".equals(result.getRetType())) {
                return result;
            }
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.insCommonReportAPIService.getInsCommonReportVoInfoById(report_id, 0));
    }

    @RequestMapping(value={"/saveReport"})
    @ResponseBody
    public Result saveReport(InsCommonReportVo vo) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            String party = this.getRequest().getParameter("party");
            String token = this.getRequest().getParameter("token");
            if (StringUtils.isEmpty((CharSequence)party) || StringUtils.isEmpty((CharSequence)token)) {
                return Result.fail((String)"\u5e73\u53f0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            Result result = this.checkLogin(party, token);
            if ("-1".equals(result.getRetType())) {
                return result;
            }
            userdetail = UserSupportUtil.getSessionUser();
        }
        vo.setSaas_com_id(userdetail.getWeb_id());
        ResultDto dto = this.insCommonReportAPIService.saveInsCommonReportByApp(vo, Long.valueOf(Long.parseLong(userdetail.getOid())));
        if ("300".equals(dto.getStatusCode())) {
            return Result.fail((String)dto.getMessage());
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)dto.getNavTabId());
    }

    @RequestMapping(value={"/saveUploadFile"})
    @ResponseBody
    public Result saveUploadFile(InsCommonReportVo vo) {
        ResultDto dto;
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            String party = this.getRequest().getParameter("party");
            String token = this.getRequest().getParameter("token");
            if (StringUtils.isEmpty((CharSequence)party) || StringUtils.isEmpty((CharSequence)token)) {
                return Result.fail((String)"\u5e73\u53f0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            Result result = this.checkLogin(party, token);
            if ("-1".equals(result.getRetType())) {
                return result;
            }
        }
        if ("300".equals((dto = this.insCommonReportAPIService.saveUploadFile(vo)).getStatusCode())) {
            return Result.fail((String)dto.getMessage());
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getFileIdByPath"})
    @ResponseBody
    public Result getFileIdByPath() {
        this.logger.info("getFileIdByPath:star");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            String party = this.getRequest().getParameter("party");
            String token = this.getRequest().getParameter("token");
            if (StringUtils.isEmpty((CharSequence)party) || StringUtils.isEmpty((CharSequence)token)) {
                return Result.fail((String)"\u5e73\u53f0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            Result result = this.checkLogin(party, token);
            if ("-1".equals(result.getRetType())) {
                return result;
            }
        }
        this.logger.info("getFileIdByPath:auth success");
        String path = this.getRequest().getParameter("path");
        String sign = this.getRequest().getParameter("sign");
        if (StringUtils.isEmpty((CharSequence)path)) {
            return Result.fail((String)"path\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)sign)) {
            return Result.fail((String)"sign\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        path = path.replaceAll("%3A", ":").replaceAll("%2F", "/");
        String fileId = this.insCommonReportAPIService.getFileIdByPath(path, sign);
        this.logger.info("getFileIdByPath:fileId checked");
        if (StringUtils.isEmpty((CharSequence)fileId)) {
            return Result.fail((String)"fileId\u83b7\u53d6\u5931\u8d25\uff01");
        }
        this.logger.info("getFileIdByPath:end");
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)fileId);
    }

    @RequestMapping(value={"/findPolicyByIdCard"})
    @ResponseBody
    public Result findPolicyByIdCard() {
        String saasIdCardNo;
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            String party = this.getRequest().getParameter("party");
            String token = this.getRequest().getParameter("token");
            if (StringUtils.isEmpty((CharSequence)party) || StringUtils.isEmpty((CharSequence)token)) {
                return Result.fail((String)"\u5e73\u53f0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            Result result = this.checkLogin(party, token);
            if ("-1".equals(result.getRetType())) {
                return result;
            }
        }
        if (StringUtils.isEmpty((CharSequence)(saasIdCardNo = this.getRequest().getParameter("saasIdCardNo")))) {
            return Result.fail((String)"idCardNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List list = this.policyService.orderList(saasIdCardNo);
        if (list.size() == 0) {
            return Result.fail((String)"\u65e0\u4fdd\u5355\uff01");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)list);
    }
}

