/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.InsCommonReportAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/pc/report"})
public class InsCommonReportController
extends BaseController {
    @Autowired
    private InsCommonReportAPIService insCommonReportAPIService;
    @Autowired
    private PolicyService policyService;

    @LoginRequired(methodParamKey={}, requestParamKey={"keyword", "status", "startDate", "endDate"}, redirectUrl="pc/report/reportList?status={status}&startDate={startDate}&endDate={endDate}&keyword={keyword}")
    @RequestMapping(value={"reportList"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u7406\u8d54\u7ba1\u7406-\u62a5\u6848\u5217\u8868")
    public ModelAndView reportList(HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String status = request.getParameter("status");
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/report/reportList");
        page.setNumPerPage(10);
        view.addObject("reportList", (Object)this.insCommonReportAPIService.selectInsCommonReportVoListByOrderID(keyword, status, startDate, endDate, Long.valueOf(Long.parseLong(userdetail.getOid())), page));
        view.addObject("status", (Object)status);
        view.addObject("startDate", (Object)startDate);
        view.addObject("endDate", (Object)endDate);
        view.addObject("keyword", (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"getReportListForPage"})
    public ModelAndView getPayListForPage(HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String status = request.getParameter("status");
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/report/reportList_table");
        view.addObject("reportList", (Object)this.insCommonReportAPIService.selectInsCommonReportVoListByOrderID(keyword, status, startDate, endDate, Long.valueOf(Long.parseLong(userdetail.getOid())), page));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#report_id"}, redirectUrl="pc/report/getInsCommonReportByReportId/{report_id}")
    @RequestMapping(value={"getInsCommonReportByReportId/{report_id}"})
    public ModelAndView getInsCommonReportByReportId(@PathVariable Long report_id, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        InsCommonReportVo vo = this.insCommonReportAPIService.getInsCommonReportVoById(report_id);
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(vo.getIns_insurance_slip_id())));
        if ("1".equals(vo.getIs_sync()) && (dto.getProduct_code().contains("GZZRX-PAC") || dto.getProduct_code().contains("GZZRX-CA"))) {
            view.setViewName("/coninsweb/personalCenter/report/xxReportDetail");
        } else {
            view.setViewName("/coninsweb/personalCenter/report/reportDetail");
        }
        view.addObject("report_id", (Object)report_id);
        view.addObject("product_code", (Object)dto.getProduct_code());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="pc/report/reportInit/{order_id}")
    @RequestMapping(value={"reportInit/{order_id}"})
    public ModelAndView reportInit(@PathVariable Long order_id, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        view.setViewName("/coninsweb/personalCenter/report/addReport");
        view.addObject("policy_no", (Object)dto.getExternal_reference());
        view.addObject("order_id", (Object)dto.getOid());
        view.addObject("product_code", (Object)dto.getProduct_code());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#report_id"}, redirectUrl="pc/report/continueReport/{report_id}")
    @RequestMapping(value={"continueReport/{report_id}"})
    public ModelAndView continueReport(@PathVariable Long report_id, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        InsCommonReportVo vo = this.insCommonReportAPIService.getInsCommonReportVoById(report_id);
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(vo.getIns_insurance_slip_id())));
        view.setViewName("/coninsweb/personalCenter/report/addReport");
        view.addObject("report_id", (Object)report_id);
        view.addObject("order_id", (Object)dto.getOid());
        view.addObject("product_code", (Object)dto.getProduct_code());
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/queryByID/{report_id}"})
    @ResponseBody
    public Object queryByID(@PathVariable Long report_id, Model model) {
        return this.insCommonReportAPIService.getInsCommonReportVoInfoById(report_id, 0);
    }

    @RequestMapping(value={"/isValidTime"})
    @ResponseBody
    public ResultDto isValidTime(String order_id, String time) {
        if (StringUtils.isEmpty((CharSequence)order_id) || StringUtils.isEmpty((CharSequence)time)) {
            return new ResultDto("", "300", "", "", "");
        }
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(order_id)));
        if (dto == null) {
            return new ResultDto("", "300", "", "", "");
        }
        Date d1 = DateUtil.convertStringToDate((String)time);
        Date d2 = DateUtil.convertStringToDate((String)dto.getInception_date());
        Date d3 = DateUtil.convertStringToDate((String)dto.getPlanned_end_date());
        boolean b1 = DateUtil.compareDates((Date)d2, (Date)d1);
        boolean b2 = DateUtil.compareDates((Date)d1, (Date)new Date());
        boolean b3 = DateUtil.compareDates((Date)d1, (Date)d3);
        if (b1 && b2 && b3) {
            return new ResultDto("", "200", "", "", "");
        }
        return new ResultDto("", "300", "", "", "");
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u62a5\u6848-\u63d0\u4ea4\u62a5\u6848\u4fe1\u606f")
    @RequestMapping(value={"/saveReport"})
    @ResponseBody
    public ResultDto saveReport(InsCommonReportVo vo, HttpServletRequest request) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ResultDto("\u767b\u5f55\u72b6\u6001\u5df2\u8fc7\u671f\uff01", "300", "", "", "");
        }
        return this.insCommonReportAPIService.saveInsCommonReport(vo, Long.valueOf(Long.parseLong(userdetail.getOid())));
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u62a5\u6848-\u9644\u4ef6\u8865\u4f20")
    @RequestMapping(value={"/saveUploadFile"})
    @ResponseBody
    public ResultDto saveUploadFile(InsCommonReportVo vo) {
        return this.insCommonReportAPIService.saveUploadFile(vo);
    }

    @RequestMapping(value={"deleteReport"})
    @ResponseBody
    public JSONObject deleteReport(long oid) {
        JSONObject json = new JSONObject();
        String message = "\u62a5\u6848\u7533\u8bf7\u4fe1\u606f\u5220\u9664\u5931\u8d25\uff01";
        String status = "300";
        if (this.insCommonReportAPIService.delectInsCommonReportByOid(Long.valueOf(oid))) {
            message = "\u62a5\u6848\u7533\u8bf7\u4fe1\u606f\u5220\u9664\u6210\u529f\uff01";
            status = "200";
        }
        json.put("message", (Object)message);
        json.put("status", (Object)status);
        return json;
    }

    @RequestMapping(value={"sendApi/{report_id}"})
    @ResponseBody
    public String sendApi(@PathVariable Long report_id) throws Exception {
        String a = this.insCommonReportAPIService.draftWord(report_id);
        return a;
    }
}

