/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.preservation.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.Auth;
import com.bcxin.ins.core.service.MyTposThrUserService;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.OSSFileUtil;
import com.bcxin.ins.vo.BLBAPIPreservationVo;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationPayVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/api/preservation"})
public class InsPreservation_API_Controller
extends BaseController {
    @Autowired
    private InsPreservationResultSetAPIService insPreservationResultSetAPIService;
    @Autowired
    private InsPreservationDetailAPIService insPreservationDetailAPIService;
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;
    @Autowired
    private MyTposThrUserService myTposThrUserService;
    @Autowired
    private ClientUserService clientUserService;
    @Autowired
    private InsPreservationPayAPIService insPreservationPayAPIService;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;
    private static String PAYLIST = "payList";
    private static String PAY_STATUS = "pay_status";
    private static String PAYVO = "payVo";
    private static String RECORDVOLIST = "recordVoList";
    private static String PRESERVATIONID = "preservationId";
    private static String POLICYID = "policyId";
    private static String NOWDATE = "nowDate";
    private static String IPDVOLIST = "ipdVoList";
    private static String IPRSVOLIST = "iprsVoList";
    private static String IPRLIST = "iprList";
    private static String REVISE_STATUS = "revise_status";
    private static String START_TIME = "start_time";
    private static String END_TIME = "end_time";
    private static String KEYWORD = "keyword";
    private static String IPRVO = "iprVo";
    private static String DETAILLIST = "detailList";
    private static String ORDERVO = "orderVo";
    private static String RESULTSETLIST = "resultSetList";
    private static String MIN = "min";
    private static String MAX = "max";

    private int partyLogin(String user_id, String login_name, String party, String token) {
        int sgin = ConstProp.INT_NUMBER_ZERO;
        if (StringUtils.isBlank((String)user_id) || StringUtils.isBlank((String)login_name) || StringUtils.isBlank((String)party) || StringUtils.isBlank((String)token)) {
            return ConstProp.INT_NUMBER_ONE;
        }
        Auth auth = this.myTposThrUserService.isAuth(party, token, this.getRequest());
        if (!auth.isSuccess()) {
            return ConstProp.INT_NUMBER_ONE;
        }
        if (!this.clientUserService.saveClientUserVo(party, login_name, user_id)) {
            return ConstProp.INT_NUMBER_ONE;
        }
        if (auth.getData() != null && auth.getData() != "") {
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return sgin;
            }
            String key = "ADDRESS-" + userdetail.getOid();
            if (StringUtils.isEmpty((String)JedisUtils.get((String)key))) {
                JedisUtils.set((String)key, (String)String.valueOf(auth.getData()), (int)ConstProp.ONE_HOURS_TIMEOUT_SECONDS);
            }
        }
        return sgin;
    }

    @RequestMapping(value={"/resultSet/addPreservationView"})
    public ModelAndView addPreservationView(String data, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        HashMap map = new HashMap();
        List list = null;
        try {
            list = MessageUtils.getList((String)data, InsPreservationDetailVo.class, (String)"vo");
            String user_id = MessageUtils.getStringValueByKey((String)data, (String)"user_id");
            String login_name = MessageUtils.getStringValueByKey((String)data, (String)"login_name");
            String party = MessageUtils.getStringValueByKey((String)data, (String)"party");
            String token = MessageUtils.getStringValueByKey((String)data, (String)"token");
            int sgin = this.partyLogin(user_id, login_name, party, token);
            if (sgin == ConstProp.INT_NUMBER_ONE) {
                view.setViewName("forward:/synopsis/loseView");
                return view;
            }
            String orderNo = MessageUtils.getStringValueByKey((String)data, (String)"orderNo");
            String reviseType = MessageUtils.getStringValueByKey((String)data, (String)"reviseType");
            if ("1".equals(reviseType)) {
                OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(orderNo)));
                view.addObject(ORDERVO, (Object)orderVo);
                view.setViewName("/coninsweb/api/preservation/resultSet/add_special_preservation_list");
            } else if ("2".equals(reviseType)) {
                List resultSets = this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null, Long.valueOf(Long.parseLong(orderNo)), "", "0", "", "");
                block2: for (InsPreservationDetailVo ipdVo : list) {
                    for (InsPreservationResultSet iprs : resultSets) {
                        if (!ipdVo.getId_card().equals(iprs.getId_card())) continue;
                        if (iprs.getIns_preservation_result_set_id() != null) {
                            ipdVo.setBusiness_id(String.valueOf(iprs.getIns_preservation_result_set_id()));
                            ipdVo.setBusiness_type("PRESERVE");
                            continue block2;
                        }
                        ipdVo.setBusiness_id(String.valueOf(iprs.getBelong_to_id()));
                        ipdVo.setBusiness_type(iprs.getBelong_to_type());
                        continue block2;
                    }
                }
                view.setViewName("/coninsweb/api/preservation/resultSet/minus_special_preservation_list");
            }
            InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
            iprVo.setIns_insurance_slip_id(orderNo);
            iprVo.setRevise_type(reviseType);
            iprVo.setInsPreservationDetailVoList(list);
            view.addObject(IPRVO, (Object)iprVo);
            view.addObject(IPDVOLIST, (Object)list);
            String resultDate = this.insPreservationRecordAPIService.getEffectiveByPolicyId(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
            view.addObject(MIN, (Object)resultDate.split(",")[0]);
            view.addObject(MAX, (Object)resultDate.split(",")[1]);
            this.setTokenByApi(view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/resultSet/test"})
    public ModelAndView test() {
        ModelAndView view = new ModelAndView();
        view.setViewName("/coninsweb/api/preservation/resultSet/test");
        return view;
    }

    @RequestMapping(value={"/resultSet/sassPreservationView"})
    public ModelAndView sassPreservationView(String revise_type, String order_id, String cacheId) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        this.logger.info("===========[sassPreservationView]\uff1aSAAS\u4fdd\u5168\u64cd\u4f5c\u65b9\u6cd5\u5f00\u59cb");
        ModelAndView view = new ModelAndView();
        List list = this.policyService.getPreservationDetailVoByApi(cacheId, userdetail.getWeb_type());
        try {
            this.logger.info("===========[sassPreservationView]\uff08\u53c2\u6570\uff09\uff1aorder_id=" + order_id + "&revise_type=" + revise_type + "&cacheId=" + cacheId);
            List resultSets = this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null, Long.valueOf(Long.parseLong(order_id)), "", "0", "", "");
            ArrayList<InsPreservationDetailVo> isIPDList = new ArrayList<InsPreservationDetailVo>();
            if ("1".equals(revise_type)) {
                for (InsPreservationDetailVo ipdVo : list) {
                    for (InsPreservationResultSet iprs : resultSets) {
                        if (!ipdVo.getId_card().equals(iprs.getId_card())) continue;
                        isIPDList.add(ipdVo);
                        list.remove(ipdVo);
                    }
                }
                OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(order_id)));
                view.addObject(ORDERVO, (Object)orderVo);
                view.setViewName("/coninsweb/api/preservation/resultSet/add_sass_preservation_list");
            } else if ("2".equals(revise_type)) {
                block4: for (InsPreservationDetailVo ipdVo : list) {
                    for (InsPreservationResultSet iprs : resultSets) {
                        if (!ipdVo.getId_card().equals(iprs.getId_card())) continue;
                        if (iprs.getIns_preservation_result_set_id() != null) {
                            ipdVo.setBusiness_id(String.valueOf(iprs.getIns_preservation_result_set_id()));
                            ipdVo.setBusiness_type("PRESERVE");
                            continue block4;
                        }
                        ipdVo.setBusiness_id(String.valueOf(iprs.getBelong_to_id()));
                        ipdVo.setBusiness_type(iprs.getBelong_to_type());
                        continue block4;
                    }
                }
                view.setViewName("/coninsweb/api/preservation/resultSet/minus_sass_preservation_list");
            }
            this.logger.info("===========[sassPreservationView](\u9875\u9762\u5730\u5740)\uff1a" + view.getViewName());
            InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
            iprVo.setIns_insurance_slip_id(order_id);
            iprVo.setRevise_type(revise_type);
            iprVo.setInsPreservationDetailVoList(list);
            view.addObject(IPRVO, (Object)iprVo);
            view.addObject(IPDVOLIST, (Object)list);
            String resultDate = this.insPreservationRecordAPIService.getEffectiveByPolicyId(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
            view.addObject(MIN, (Object)resultDate.split(",")[0]);
            view.addObject(MAX, (Object)resultDate.split(",")[1]);
            this.setTokenByApi(view);
        }
        catch (Exception e) {
            this.logger.info("===========[sassPreservationView](\u5f02\u5e38)\uff1a" + e);
            e.printStackTrace();
        }
        this.logger.info("===========[sassPreservationView]\uff1a\u65b9\u6cd5\u7ed3\u675f");
        return view;
    }

    @RequestMapping(value={"/resultSet/openMessage"})
    public ModelAndView openMessage() {
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/openMessage");
        this.setTokenByApi(view);
        return view;
    }

    private boolean setSignPD(String orderID) {
        String key = "BLB:CACHE:POLICY-PD-SIGN-" + orderID;
        if (JedisUtils.exists((String)key)) {
            return false;
        }
        JedisUtils.set((String)key, (String)orderID, (int)50);
        return true;
    }

    private void closeSignPD(String orderID) {
        String key = "BLB:CACHE:POLICY-PD-SIGN-" + orderID;
        if (JedisUtils.exists((String)key)) {
            JedisUtils.del((String)key);
        }
    }

    @RequestMapping(value={"/resultSet/sassAddPreservationService"})
    @ResponseBody
    public Result sassAddPreservationService(BLBAPIPreservationVo blbVo) {
        this.logger.info("===========[sassAddPreservationService]\uff1aSAAS\u4fdd\u5168\u64cd\u4f5c\u65b9\u6cd5\u5f00\u59cb");
        ClientUserVo userdetail = this.clientUserService.getClientUserVoForThir(blbVo.getUser_id(), blbVo.getParty());
        if (userdetail == null) {
            return Result.fail((String)"\u65e0\u7528\u6237\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((String)blbVo.getListStr())) {
            String str = blbVo.getListStr().replaceAll("&quot;", "\"");
            blbVo.setListStr(str);
            blbVo.setList(JSONArray.parseArray((String)blbVo.getListStr(), InsPreservationDetailVo.class));
        }
        InsPreservationRecordVo vo = new InsPreservationRecordVo();
        vo.setComId(userdetail.getWeb_id());
        String payurl = "";
        try {
            vo.setIns_insurance_slip_id(blbVo.getOrder_id());
            vo.setRevise_type("1");
            vo.setInception_date(blbVo.getInception_date());
            vo.setInsPreservationDetailVoList(blbVo.getList());
            vo.resetName();
            String result = this.insPreservationDetailAPIService.detailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                return Result.fail((String)result.split("#")[1]);
            }
            String str = this.insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(), vo.getInsPreservationDetailVoList());
            if ("300".equals(str.split("#")[0])) {
                return Result.fail((String)str.split("#")[1]);
            }
            if (StringUtils.isNotEmpty((String)blbVo.getOrder_id()) && !this.setSignPD(blbVo.getOrder_id())) {
                return Result.fail((String)"\u4fdd\u5355\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u6279\u6539\u4efb\u52a1\uff0c\u9884\u8ba130\u79d2\u540e\u53ef\u91cd\u65b0\u53d1\u8d77\u64cd\u4f5c");
            }
            this.logger.info("===========[sassAddPreservationService]\uff1a\u4eba\u5458\u4fe1\u606f\u6821\u9a8c\u7ed3\u675f");
            Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, "1");
            this.logger.info("===========[sassAddPreservationService]\uff1a\u7ebf\u4e0a\u5ba1\u6838\u64cd\u4f5c\u7ed3\u675f\uff1amap=" + (map != null ? JSON.toJSONString((Object)map) : "null"));
            if (map != null) {
                if ("300".equals(map.get("ret"))) {
                    this.closeSignPD(blbVo.getOrder_id());
                    if (StringUtils.isNotEmpty((String)((String)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                        this.insPreservationRecordAPIService.recordRestPAC(vo);
                        this.myAsyncExecutor.execute(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid()));
                    }
                    return Result.fail((String)((String)map.get("msg")));
                }
                if (StringUtils.isNotEmpty((String)((String)map.get("batchApplyNumber")))) {
                    vo.setRevise_serial_number((String)map.get("batchApplyNumber"));
                    payurl = (String)map.get("payurl");
                }
                vo.setRecordRest(map);
            }
        }
        catch (Exception e) {
            this.closeSignPD(blbVo.getOrder_id());
            this.logger.info("===========[sassAddPreservationService](\u5f02\u5e38)\uff1a" + e);
            return Result.fail((String)e.getMessage());
        }
        this.insPreservationRecordAPIService.recordRest(vo);
        this.closeSignPD(blbVo.getOrder_id());
        return Result.success((String)"\u6279\u6539\u4fe1\u606f\u5df2\u6210\u529f\u63d0\u4ea4\u5904\u7406\uff01", (Object)payurl);
    }

    @RequestMapping(value={"/resultSet/sassMinusPreservationService"})
    @ResponseBody
    public Result sassMinusPreservationService(BLBAPIPreservationVo blbVo) {
        this.logger.info("===========[sassMinusPreservationService]\uff1aSAAS\u4fdd\u5168\u64cd\u4f5c\u65b9\u6cd5\u5f00\u59cb");
        ClientUserVo userdetail = this.clientUserService.getClientUserVoForThir(blbVo.getUser_id(), blbVo.getParty());
        if (userdetail == null) {
            return Result.fail((String)"\u65e0\u7528\u6237\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((String)blbVo.getListStr())) {
            String str = blbVo.getListStr().replaceAll("&quot;", "\"");
            blbVo.setListStr(str);
            blbVo.setList(JSONArray.parseArray((String)blbVo.getListStr(), InsPreservationDetailVo.class));
        }
        InsPreservationRecordVo vo = new InsPreservationRecordVo();
        vo.setComId(userdetail.getWeb_id());
        try {
            vo.setIns_insurance_slip_id(blbVo.getOrder_id());
            vo.setRevise_type("2");
            vo.setInception_date(blbVo.getInception_date());
            vo.setInsPreservationDetailVoList(blbVo.getList());
            vo.resetName();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                InsPreservationResultSet resultSet = this.insPreservationResultSetAPIService.getResultSetBypolicyIdAndCardNo(ipdVo.getId_card(), Long.valueOf(Long.parseLong(vo.getIns_insurance_slip_id())));
                if (resultSet == null) {
                    return Result.fail((String)("\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + ipdVo.getId_card() + "\u672a\u627e\u5230\u4eba\u5458\u4fe1\u606f\uff01"));
                }
                ipdVo.setBusiness_id(String.valueOf(resultSet.getIns_preservation_result_set_id()));
                ipdVo.setPrev_card(ipdVo.getId_card());
                ipdVo.setCareer(resultSet.getCareer());
                ipdVo.setName(resultSet.getName());
                ipdVo.setId_card(resultSet.getId_card());
                ipdVo.setRevise_type("2");
            }
            String result = this.insPreservationDetailAPIService.detailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                return Result.fail((String)result.split("#")[1]);
            }
            String str = this.insPreservationDetailAPIService.notUnderWarrantyIdCardNo(vo.getIns_insurance_slip_id(), vo.getInsPreservationDetailVoList());
            if ("300".equals(str.split("#")[0])) {
                return Result.fail((String)str.split("#")[1]);
            }
            if (StringUtils.isNotEmpty((String)blbVo.getOrder_id()) && !this.setSignPD(blbVo.getOrder_id())) {
                return Result.fail((String)"\u4fdd\u5355\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u6279\u6539\u4efb\u52a1\uff0c\u9884\u8ba130\u79d2\u540e\u53ef\u91cd\u65b0\u53d1\u8d77\u64cd\u4f5c");
            }
            this.logger.info("===========[sassMinusPreservationService]\uff1a\u4eba\u5458\u4fe1\u606f\u6821\u9a8c\u7ed3\u675f");
            Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, "1");
            this.logger.info("===========[sassMinusPreservationService]\uff1a\u7ebf\u4e0a\u5ba1\u6838\u64cd\u4f5c\u7ed3\u675f\uff1amap=" + (map != null ? JSON.toJSONString((Object)map) : "null"));
            if (map != null) {
                if ("300".equals(map.get("ret"))) {
                    this.closeSignPD(blbVo.getOrder_id());
                    if (StringUtils.isNotEmpty((String)((String)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                        this.insPreservationRecordAPIService.recordRestPAC(vo);
                        this.myAsyncExecutor.execute(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid()));
                    }
                    return Result.fail((String)((String)map.get("msg")));
                }
                vo.setRecordRest(map);
            }
        }
        catch (Exception e) {
            this.closeSignPD(blbVo.getOrder_id());
            this.logger.info("===========[sassMinusPreservationService](\u5f02\u5e38)\uff1a" + e);
            return Result.fail((String)e.getMessage());
        }
        this.insPreservationRecordAPIService.recordRest(vo);
        this.closeSignPD(blbVo.getOrder_id());
        return Result.success((String)"\u6279\u6539\u4fe1\u606f\u5df2\u6210\u529f\u63d0\u4ea4\u5904\u7406\uff01");
    }

    @RequestMapping(value={"/resultSet/sassSpecialMinusPreservationService"})
    @ResponseBody
    public Result sassSpecialMinusPreservationService(BLBAPIPreservationVo blbVo) {
        this.logger.info("===========[sassMinusPreservationService]\uff1aSAAS\u4fdd\u5168\u64cd\u4f5c\u65b9\u6cd5\u5f00\u59cb");
        ClientUserVo userdetail = this.clientUserService.getClientUserVoForThir(blbVo.getUser_id(), blbVo.getParty());
        if (userdetail == null) {
            return Result.fail((String)"\u65e0\u7528\u6237\u4fe1\u606f");
        }
        InsPreservationRecordVo vo = new InsPreservationRecordVo();
        vo.setComId(userdetail.getWeb_id());
        try {
            List list;
            if (StringUtils.isNotEmpty((String)blbVo.getListStr()) && StringUtils.isNotEmpty((String)blbVo.getOrder_id())) {
                list = this.insPreservationResultSetAPIService.findInsPreservationDetailVoByIdCards(Long.valueOf(Long.parseLong(blbVo.getOrder_id())), blbVo.getListStr());
                if (list.size() == 0) {
                    return Result.fail((String)"\u5728\u4fdd\u4eba\u5458\u6570\u636e\u4e2d\u672a\u5339\u914d\u5230\u51cf\u5458\u64cd\u4f5c\u4eba\u5458\u4fe1\u606f\uff01");
                }
            } else {
                return Result.fail((String)"\u672a\u627e\u5230\u8ba2\u5355\u6216\u4eba\u5458\u4fe1\u606f\uff01");
            }
            blbVo.setList(list);
            vo.setIns_insurance_slip_id(blbVo.getOrder_id());
            vo.setRevise_type("2");
            vo.setInception_date(blbVo.getInception_date());
            vo.setInsPreservationDetailVoList(blbVo.getList());
            vo.resetName();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                InsPreservationResultSet resultSet = this.insPreservationResultSetAPIService.getResultSetBypolicyIdAndCardNo(ipdVo.getId_card(), Long.valueOf(Long.parseLong(vo.getIns_insurance_slip_id())));
                if (resultSet == null) {
                    return Result.fail((String)("\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + ipdVo.getId_card() + "\u672a\u627e\u5230\u4eba\u5458\u4fe1\u606f\uff01"));
                }
                ipdVo.setBusiness_id(String.valueOf(resultSet.getIns_preservation_result_set_id()));
                ipdVo.setPrev_card(ipdVo.getId_card());
                ipdVo.setCareer(resultSet.getCareer());
                ipdVo.setName(resultSet.getName());
                ipdVo.setId_card(resultSet.getId_card());
                ipdVo.setRevise_type("2");
            }
            String result = this.insPreservationDetailAPIService.detailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                return Result.fail((String)result.split("#")[1]);
            }
            if (StringUtils.isNotEmpty((String)blbVo.getOrder_id()) && !this.setSignPD(blbVo.getOrder_id())) {
                return Result.fail((String)"\u4fdd\u5355\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u6279\u6539\u4efb\u52a1\uff0c\u9884\u8ba130\u79d2\u540e\u53ef\u91cd\u65b0\u53d1\u8d77\u64cd\u4f5c");
            }
            this.logger.info("===========[sassMinusPreservationService]\uff1a\u4eba\u5458\u4fe1\u606f\u6821\u9a8c\u7ed3\u675f");
            Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, "1");
            this.logger.info("===========[sassMinusPreservationService]\uff1a\u7ebf\u4e0a\u5ba1\u6838\u64cd\u4f5c\u7ed3\u675f\uff1amap=" + (map != null ? JSON.toJSONString((Object)map) : "null"));
            if (map != null) {
                if ("300".equals(map.get("ret"))) {
                    this.closeSignPD(blbVo.getOrder_id());
                    if (StringUtils.isNotEmpty((String)((String)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                        this.insPreservationRecordAPIService.recordRestPAC(vo);
                        this.myAsyncExecutor.execute(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid()));
                    }
                    return Result.fail((String)((String)map.get("msg")));
                }
                vo.setRecordRest(map);
            }
        }
        catch (Exception e) {
            this.closeSignPD(blbVo.getOrder_id());
            this.logger.info("===========[sassMinusPreservationService](\u5f02\u5e38)\uff1a" + e);
            return Result.fail((String)e.getMessage());
        }
        this.insPreservationRecordAPIService.recordRest(vo);
        this.closeSignPD(blbVo.getOrder_id());
        return Result.success((String)"\u6279\u6539\u4fe1\u606f\u5df2\u6210\u529f\u63d0\u4ea4\u5904\u7406\uff01");
    }

    @RequestMapping(value={"/resultSet/sassFindPerNameByIdCard"})
    @ResponseBody
    public Result sassFindPerNameByIdCard(BLBAPIPreservationVo blbVo) {
        this.logger.info("===========[sassFindPerNameByIdCard]\uff1asaas\u8eab\u4efd\u8bc1\u67e5\u8be2\u5bf9\u5e94\u5728\u4fdd\u4eba\u5458\u4fe1\u606f\u5f00\u59cb");
        String listStr = blbVo.getListStr();
        try {
            if (StringUtils.isNotBlank((String)listStr)) {
                List list = this.insPreservationResultSetAPIService.sassFindPerNameByIdCard(listStr.split(","));
                if (list.size() > 0) {
                    this.logger.info("===========[sassFindPerNameByIdCard]\uff1asaas\u8eab\u4efd\u8bc1\u67e5\u8be2\u5bf9\u5e94\u5728\u4fdd\u4eba\u5458\u4fe1\u606f\u7ed3\u675f");
                    return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)JSON.toJSONString((Object)list));
                }
                return Result.fail((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5728\u4fdd\u4eba\u5458\uff01");
            }
            return Result.fail((String)"\u6570\u636e\u7f3a\u5931\uff01");
        }
        catch (Exception e) {
            this.logger.info("===========[sassFindPerNameByIdCard](\u5f02\u5e38)\uff1a" + e);
            return Result.fail((String)e.getMessage());
        }
    }

    @LoginRequired
    @RequestMapping(value={"recordList"})
    public ModelAndView recordList(String revise_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/recordList");
        page.setNumPerPage(5);
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((String)end_time)) {
            et = end_time + " 23:59:59";
        }
        view.addObject(IPRLIST, (Object)this.insPreservationRecordAPIService.findInsPreservationRecordByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), revise_status, start_time, et, keyword));
        view.addObject(REVISE_STATUS, (Object)revise_status);
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"getRecordListForPage"})
    public ModelAndView ListForPage(String revise_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((String)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/recordList_table");
        view.addObject(IPRLIST, (Object)this.insPreservationRecordAPIService.findInsPreservationRecordByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), revise_status, start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"getRecordDetailByPreservationId/{preservationId}"})
    public ModelAndView getRecordDetailByPreservationId(@PathVariable Long preservationId, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        InsPreservationRecordVo iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
        if ("1".equals(iprVo.getRevise_type()) && "1".equals(iprVo.getRevise_status())) {
            view.setViewName("/coninsweb/api/preservation/addRecordDetail");
        }
        if ("3".equals(iprVo.getRevise_type())) {
            view.setViewName("/coninsweb/api/preservation/recordRepDetail");
        } else {
            view.setViewName("/coninsweb/api/preservation/recordDetail");
        }
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
        view.addObject(ORDERVO, (Object)orderVo);
        view.addObject(IPRVO, (Object)iprVo);
        view.addObject(DETAILLIST, (Object)iprVo.getInsPreservationDetailVoList());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"recordDetailListForPage"})
    public ModelAndView recordDetailListForPage(Long preservationId, String keyword, DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/recordDetail_table");
        view.addObject(DETAILLIST, (Object)this.insPreservationDetailAPIService.findInsPreservationDetailByKeyword(page, preservationId, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"againRecord"})
    @ResponseBody
    public JSONObject againRecord(long oid) {
        String message;
        JSONObject json = new JSONObject();
        String status = "300";
        try {
            if (this.insPreservationRecordAPIService.againRecord(Long.valueOf(oid))) {
                message = "\u518d\u6b21\u63d0\u4ea4\u5ba1\u6838\u6210\u529f\uff01";
                status = "200";
            } else {
                message = "\u63d0\u4ea4\u5ba1\u6838\u5931\u8d25\uff01";
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        json.put("message", (Object)message);
        json.put("status", (Object)status);
        return json;
    }

    @RequestMapping(value={"addAgainRecord"})
    @ResponseBody
    public ResultDto addAgainRecord(InsPreservationRecordVo vo) {
        List ipdVoList = vo.getInsPreservationDetailVoList();
        for (InsPreservationDetailVo ipdVo : ipdVoList) {
            String result = this.insPreservationDetailAPIService.personnelToCheck(ipdVo, vo.getRevise_type());
            if ("300".equals(result.split("#")[0])) {
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
            ipdVo.setRevise_type("1");
        }
        if (this.insPreservationRecordAPIService.addAgainRecord(Long.valueOf(Long.parseLong(vo.getOid())), ipdVoList)) {
            return new ResultDto("\u518d\u6b21\u63d0\u4ea4\u5ba1\u6838\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u63d0\u4ea4\u5ba1\u6838\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"deleteInsPreservationRecord"})
    @ResponseBody
    public JSONObject deleteInsPreservationRecord(long oid) {
        JSONObject json = new JSONObject();
        String message = "\u4fdd\u5168\u7533\u8bf7\u5355\u5220\u9664\u5931\u8d25\uff01";
        String status = "300";
        if (this.insPreservationRecordAPIService.deleteInsPreservationRecord(Long.valueOf(oid))) {
            message = "\u4fdd\u5168\u7533\u8bf7\u5355\u5220\u9664\u6210\u529f\uff01";
            status = "200";
        }
        json.put("message", (Object)message);
        json.put("status", (Object)status);
        return json;
    }

    @RequestMapping(value={"revokeInsPreservationRecord"})
    @ResponseBody
    public JSONObject revokeInsPreservationRecord(long oid) {
        JSONObject json = new JSONObject();
        String message = "\u4fdd\u5168\u7533\u8bf7\u5355\u64a4\u9500\u5931\u8d25\uff01";
        String status = "300";
        if (this.insPreservationRecordAPIService.revokeInsPreservationRecord(Long.valueOf(oid))) {
            message = "\u4fdd\u5168\u7533\u8bf7\u5355\u64a4\u9500\u6210\u529f\uff01";
            status = "200";
        }
        json.put("message", (Object)message);
        json.put("status", (Object)status);
        return json;
    }

    @LoginRequired
    @RequestMapping(value={"thr_preservation_view"})
    public ModelAndView thr_preservation_view(String operate, Long preservationId) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ModelAndView view = new ModelAndView();
        if (preservationId == null) {
            this.setTokenByApi(view);
            return view;
        }
        InsPreservationRecordVo iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
        if ("add".equals(operate)) {
            view.setViewName("/coninsweb/api/preservation/update_detail_add");
        } else if ("minus".equals(operate)) {
            view.setViewName("/coninsweb/api/preservation/update_detail_minus");
            List rsaList = this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null, Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())), "", "0", "", "");
            view.addObject("rsaNum", (Object)(rsaList != null ? rsaList.size() : 0));
            view.addObject("ipdNum", (Object)(iprVo.getInsPreservationDetailVoList() != null ? iprVo.getInsPreservationDetailVoList().size() : 0));
        } else {
            view.setViewName("/coninsweb/api/preservation/update_detail_replace");
        }
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
        view.addObject(ORDERVO, (Object)orderVo);
        view.addObject(IPRVO, (Object)iprVo);
        String resultDate = this.insPreservationRecordAPIService.getEffectiveByPolicyId(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
        view.addObject(MIN, (Object)resultDate.split(",")[0]);
        view.addObject(MAX, (Object)resultDate.split(",")[1]);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"update_detail_add_upload"})
    public ModelAndView update_detail_add_upload(Long preservationId) {
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/update_detail_add_upload");
        if (preservationId != null) {
            InsPreservationRecordVo iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
            List list = iprVo.getInsPreservationDetailVoList();
            for (InsPreservationDetailVo ipdVo : this.getValueSessionRecord()) {
                list.add(ipdVo);
            }
            OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
            view.addObject(ORDERVO, (Object)orderVo);
            view.addObject(IPDVOLIST, (Object)list);
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/down_preservation_list"})
    public void downPreservationList(HttpServletRequest req, HttpServletResponse resp) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return;
        }
        String userId = userdetail.getOid();
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String name = req.getParameter("name");
        this.insPreservationDetailAPIService.downPreservationList(userId, keyword, name, start_time, end_time, resp);
    }

    @RequestMapping(value={"/uploadRoleFile"})
    @ResponseBody
    public ResultDto uploadRoleFile(MultipartHttpServletRequest request) throws Exception {
        JSONObject jo;
        MultipartFile roleFile = request.getFile("role_record");
        List list = null;
        String[] arrStr = new String[]{"name", "id_type", "id_card", "tel", "career", "scheme", "sex", "birthday"};
        if (roleFile != null) {
            jo = this.insPreservationDetailAPIService.readIPDExcel(roleFile);
            if (!"200".equals(jo.get((Object)"ret"))) {
                return new ResultDto(String.valueOf(jo.get((Object)"msg")), "300", "", "", "");
            }
        } else {
            return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
        }
        list = (List)jo.get((Object)"list");
        if (list != null && !list.isEmpty()) {
            if (this.setValueSessionRecord(list)) {
                return new ResultDto("\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01", "200", "", "", "");
            }
            return new ResultDto("\u6570\u636e\u7f13\u5b58\u5931\u8d25\uff01", "300", "", "", "");
        }
        return new ResultDto("\u672a\u89e3\u6790\u5230\u53ef\u7528\u6570\u636e\uff01", "300", "", "", "");
    }

    private boolean setValueSessionRecord(List<InsPreservationDetailVo> list) {
        JedisUtils.setObject((String)("ipdVoList:" + this.getToken()), list, (int)180);
        return true;
    }

    private List<InsPreservationDetailVo> getValueSessionRecord() {
        List list = (List)JedisUtils.getObject((String)("ipdVoList:" + this.getToken()));
        JedisUtils.delObject((String)("ipdVoList:" + this.getToken()));
        return list;
    }

    @LoginRequired
    @RequestMapping(value={"/resultSet/resultSetList"})
    public ModelAndView resultSetList(Long policyId, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/resultSetList");
        page.setNumPerPage(10);
        view.addObject("userdetail", (Object)userdetail);
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        if (userdetail.getOid().equals(orderVo.getUser_oid())) {
            view.addObject(RESULTSETLIST, (Object)this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page, policyId, keyword, "0", "", ""));
            view.addObject(ORDERVO, (Object)orderVo);
        }
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/resultSet/getResultSetListForPage"})
    public ModelAndView ListForPage(Long policyId, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/resultSetList_table");
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        if (userdetail.getOid().equals(orderVo.getUser_oid())) {
            view.addObject(RESULTSETLIST, (Object)this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page, policyId, keyword, "0", "", ""));
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/resultSet/noResultSetList"})
    public ModelAndView noResultSetList(Long policyId, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/noResultSetList");
        page.setNumPerPage(10);
        String et = "";
        if (StringUtils.isNotEmpty((String)end_time)) {
            et = end_time + " 23:59:59";
        }
        view.addObject("userdetail", (Object)userdetail);
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        if (userdetail.getOid().equals(orderVo.getUser_oid())) {
            view.addObject(RESULTSETLIST, (Object)this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page, policyId, keyword, "1", start_time, et));
            view.addObject(ORDERVO, (Object)orderVo);
        }
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/resultSet/getNoResultSetListForPage"})
    public ModelAndView getNoResultSetListForPage(Long policyId, String start_time, String end_time, String keyword, DwzPage page) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String et = "";
        if (StringUtils.isNotEmpty((String)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/noResultSetList_table");
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        if (userdetail.getOid().equals(orderVo.getUser_oid())) {
            view.addObject(RESULTSETLIST, (Object)this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page, policyId, keyword, "1", start_time, et));
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/resultSet/schemeDetail"})
    public ModelAndView schemeDetail(Long policyId) {
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/scheme_detail");
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        view.addObject(ORDERVO, (Object)orderVo);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/resultSet/add_preservation_view"})
    public ModelAndView add_preservation_view(Long policyId) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/add_preservation_list");
        InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
        iprVo.setIns_insurance_slip_id(String.valueOf(policyId));
        String resultDate = this.insPreservationRecordAPIService.getEffectiveByPolicyId(policyId);
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        view.addObject(ORDERVO, (Object)orderVo);
        view.addObject(MIN, (Object)resultDate.split(",")[0]);
        view.addObject(MAX, (Object)resultDate.split(",")[1]);
        view.addObject("preservationVo", (Object)iprVo);
        view.addObject(NOWDATE, (Object)DateUtil.getCurrentDateTime());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/resultSet/add_upload_view"})
    public ModelAndView add_upload_view(Long preservationId, HttpServletRequest request) {
        String product_code = request.getParameter("product_code");
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/add_upload_list");
        if (preservationId != null) {
            view.addObject(IPRSVOLIST, (Object)this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId));
        }
        view.addObject("product_code", (Object)product_code);
        view.addObject(IPRSVOLIST, this.getValueSession());
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_RECORD, title="\u3010\u8bf7\u6c42\u3011\u4e2a\u4eba\u4e2d\u5fc3-\u589e\u5458")
    @LoginRequired
    @RequestMapping(value={"/resultSet/add_preservation_service"})
    @ResponseBody
    public ResultDto add_preservation_service(InsPreservationRecordVo vo, String sign) {
        if ("1".equals(sign)) {
            vo.resetName();
            String result = this.insPreservationDetailAPIService.detailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
        } else {
            ArrayList<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                if (!StringUtils.isNotEmpty((String)ipdVo.getName()) && !StringUtils.isNotEmpty((String)ipdVo.getId_card()) && !StringUtils.isNotEmpty((String)ipdVo.getTel()) && !StringUtils.isNotEmpty((String)ipdVo.getBirthday())) continue;
                ipdVoSortList.add(ipdVo);
            }
            if (ipdVoSortList.size() == 0) {
                return new ResultDto("\u6682\u5b58\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", "300", "", "", "");
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
        }
        String str = this.insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(), vo.getInsPreservationDetailVoList());
        if ("300".equals(str.split("#")[0])) {
            return new ResultDto(str.split("#")[1], "300", "", "", "");
        }
        Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, sign);
        if (map != null) {
            if ("300".equals(map.get("ret"))) {
                if (StringUtils.isNotEmpty((String)((String)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                    this.insPreservationRecordAPIService.recordRestPAC(vo);
                    this.myAsyncExecutor.execute(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid()));
                }
                return new ResultDto((String)map.get("msg"), "300", "", "", "");
            }
            if (StringUtils.isNotEmpty((String)((String)map.get("batchApplyNumber")))) {
                vo.setRevise_serial_number((String)map.get("batchApplyNumber"));
            }
        }
        if (this.insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign), vo, vo.getInsPreservationDetailVoList())) {
            if (!"1".equals(sign)) {
                return new ResultDto("\u4fdd\u5b58\u6210\u529f\uff0c\u8bf7\u8fdb\u5165\u201c\u6279\u6539\u7533\u8bf7\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u4fdd\u5b58\u7684\u6279\u6539\u7533\u8bf7\uff01", "200", "", "", "");
            }
            this.insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
            String m = "\u6279\u6539\u4fe1\u606f\u6210\u529f\u63d0\u4ea4\u5ba1\u6838\uff01";
            if (map != null && !map.containsKey("isPendingApproval")) {
                m = "\u6279\u6539\u4fe1\u606f\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            }
            String payurl = (String)map.get("payurl");
            return new ResultDto(m, "200", vo.getOid(), "", payurl);
        }
        return new ResultDto("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
    }

    @LoginRequired
    @RequestMapping(value={"/resultSet/minus_or_replace_view"})
    public ModelAndView minus_preservation_view(Long policyId, Long preservationId, String check_some, String operate) {
        ModelAndView view = new ModelAndView();
        if ("minus".equals(operate)) {
            view.setViewName("/coninsweb/api/preservation/resultSet/minus_preservation_list");
        } else if ("replace".equals(operate)) {
            view.setViewName("/coninsweb/api/preservation/resultSet/replace_preservation_list");
        }
        InsPreservationRecordVo iprVo = null;
        if (preservationId != null) {
            iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
        } else {
            String[] arr;
            iprVo = new InsPreservationRecordVo();
            iprVo.setIns_insurance_slip_id(String.valueOf(policyId));
            ArrayList<InsPreservationResultSetVo> iprsVoList = new ArrayList<InsPreservationResultSetVo>();
            InsPreservationResultSetVo iprsVo = null;
            for (String str : arr = check_some.split("#")) {
                if (StringUtils.isEmpty((String)str)) continue;
                String oid = str.split(";")[0];
                String sign = str.split(";")[1];
                iprsVo = this.insPreservationResultSetAPIService.getInsPreservationResultSetVoByOidAndSign(oid, sign);
                iprsVoList.add(iprsVo);
                iprsVo = null;
            }
            iprVo.setInsPreservationResultSetVoList(iprsVoList);
        }
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        view.addObject(ORDERVO, (Object)orderVo);
        String resultDate = this.insPreservationRecordAPIService.getEffectiveByPolicyId(policyId);
        view.addObject(MIN, (Object)resultDate.split(",")[0]);
        view.addObject(MAX, (Object)resultDate.split(",")[1]);
        view.addObject(POLICYID, (Object)policyId);
        view.addObject("preservationVo", (Object)iprVo);
        view.addObject(NOWDATE, (Object)DateUtil.getCurrentDateTime());
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_RECORD, title="\u3010\u8bf7\u6c42\u3011\u4e2a\u4eba\u4e2d\u5fc3-\u51cf\u5458")
    @LoginRequired
    @RequestMapping(value={"/resultSet/minus_preservation_service"})
    @ResponseBody
    public ResultDto minus_preservation_service(InsPreservationRecordVo vo, String sign) throws Exception {
        if ("1".equals(sign)) {
            vo.resetName();
            String result = this.insPreservationDetailAPIService.detailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
        } else {
            ArrayList<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                InsPreservationResultSet resultSet;
                if (StringUtils.isNotEmpty((String)vo.getIns_insurance_slip_id()) && (resultSet = this.insPreservationResultSetAPIService.getResultSetBypolicyIdAndCardNo(ipdVo.getId_card(), Long.valueOf(Long.parseLong(vo.getIns_insurance_slip_id())))) != null) {
                    ipdVo.setBusiness_id(String.valueOf(resultSet.getIns_preservation_result_set_id()));
                    ipdVo.setPrev_card(ipdVo.getId_card());
                    ipdVo.setCareer(resultSet.getCareer());
                    ipdVo.setName(resultSet.getName());
                    ipdVo.setId_card(resultSet.getId_card());
                }
                if (!StringUtils.isNotEmpty((String)ipdVo.getBusiness_id()) && !StringUtils.isNotEmpty((String)ipdVo.getBusiness_type())) continue;
                ipdVoSortList.add(ipdVo);
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
        }
        Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, sign);
        if (map != null && "300".equals(map.get("ret"))) {
            if (StringUtils.isNotEmpty((String)((String)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                this.insPreservationRecordAPIService.recordRestPAC(vo);
                this.myAsyncExecutor.execute(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid()));
            }
            return new ResultDto((String)map.get("msg"), "300", "", "", "");
        }
        if (this.insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign), vo, vo.getInsPreservationDetailVoList())) {
            if (!"1".equals(sign)) {
                return new ResultDto("\u4fdd\u5b58\u6210\u529f\uff0c\u8bf7\u8fdb\u5165\u201c\u6279\u6539\u7533\u8bf7\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u4fdd\u5b58\u7684\u6279\u6539\u7533\u8bf7\uff01", "200", "", "", "");
            }
            this.insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
            String m = "\u6279\u6539\u4fe1\u606f\u6210\u529f\u63d0\u4ea4\u5ba1\u6838\uff01";
            if (map != null && !map.containsKey("isPendingApproval")) {
                m = "\u6279\u6539\u4fe1\u606f\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            }
            return new ResultDto(m, "200", "", "", "");
        }
        return new ResultDto("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_RECORD, title="\u3010\u8bf7\u6c42\u3011\u4e2a\u4eba\u4e2d\u5fc3-\u51cf\u5458")
    @LoginRequired
    @RequestMapping(value={"/resultSet/update_detail_minus_service"})
    @ResponseBody
    public ResultDto update_detail_minus_service(InsPreservationRecordVo vo, String sign) throws Exception {
        List ipdVoList = vo.getInsPreservationDetailVoList();
        if (ipdVoList == null) {
            return new ResultDto("\u5f53\u524d\u4fdd\u5168\u65e0\u6709\u6548\u4eba\u5458\u4fe1\u606f\u8bf7\u624b\u52a8\u5220\u9664\u8be5\u5355", "300", "", "", "");
        }
        if ("1".equals(sign)) {
            vo.resetName();
            String result = this.insPreservationDetailAPIService.detailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
        } else {
            ArrayList<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                if (!StringUtils.isNotEmpty((String)ipdVo.getOid())) continue;
                ipdVoSortList.add(ipdVo);
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
        }
        Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, sign);
        if (map != null && "300".equals(map.get("ret"))) {
            if (StringUtils.isNotEmpty((String)((String)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                this.insPreservationRecordAPIService.recordRestPAC(vo);
                this.myAsyncExecutor.execute(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid()));
            }
            return new ResultDto((String)map.get("msg"), "300", "", "", "");
        }
        if (this.insPreservationRecordAPIService.minusInsPreservationRecord(Integer.parseInt(sign), vo, vo.getInsPreservationDetailVoList())) {
            if (!"1".equals(sign)) {
                return new ResultDto("\u4fdd\u5b58\u6210\u529f\uff0c\u8bf7\u8fdb\u5165\u201c\u6279\u6539\u7533\u8bf7\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u4fdd\u5b58\u7684\u6279\u6539\u7533\u8bf7\uff01", "200", "", "", "");
            }
            this.insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
            String m = "\u6279\u6539\u4fe1\u606f\u6210\u529f\u63d0\u4ea4\u5ba1\u6838\uff01";
            if (map != null && !map.containsKey("isPendingApproval")) {
                m = "\u6279\u6539\u4fe1\u606f\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            }
            return new ResultDto(m, "200", "", "", "");
        }
        return new ResultDto("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_RECORD, title="\u3010\u8bf7\u6c42\u3011\u4e2a\u4eba\u4e2d\u5fc3-\u66ff\u6362")
    @LoginRequired
    @RequestMapping(value={"/resultSet/replace_preservation_service"})
    @ResponseBody
    public ResultDto replace_preservation_service(InsPreservationRecordVo vo, String sign) {
        if ("1".equals(sign)) {
            vo.resetName();
            String result = this.insPreservationDetailAPIService.detailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
        } else {
            ArrayList<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                if (!StringUtils.isNotEmpty((String)ipdVo.getBusiness_id()) && !StringUtils.isNotEmpty((String)ipdVo.getBusiness_type())) continue;
                ipdVoSortList.add(ipdVo);
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
        }
        String str = this.insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(), vo.getInsPreservationDetailVoList());
        if ("300".equals(str.split("#")[0])) {
            return new ResultDto(str.split("#")[1], "300", "", "", "");
        }
        Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, sign);
        if (map != null && "300".equals(map.get("ret"))) {
            if (StringUtils.isNotEmpty((String)((String)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                this.insPreservationRecordAPIService.recordRestPAC(vo);
                this.myAsyncExecutor.execute(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid()));
            }
            return new ResultDto((String)map.get("msg"), "300", "", "", "");
        }
        if (this.insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign), vo, vo.getInsPreservationDetailVoList())) {
            if (!"1".equals(sign)) {
                return new ResultDto("\u4fdd\u5b58\u6210\u529f\uff0c\u8bf7\u8fdb\u5165\u201c\u6279\u6539\u7533\u8bf7\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u4fdd\u5b58\u7684\u6279\u6539\u7533\u8bf7\uff01", "200", "", "", "");
            }
            this.insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
            String m = "\u6279\u6539\u4fe1\u606f\u6210\u529f\u63d0\u4ea4\u5ba1\u6838\uff01";
            if (map != null && !map.containsKey("isPendingApproval")) {
                m = "\u6279\u6539\u4fe1\u606f\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            }
            return new ResultDto(m, "200", "", "", "");
        }
        return new ResultDto("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/resultSet/deleteRecordDetail"})
    @ResponseBody
    public JSONObject deleteRecordDetail(long oid) {
        JSONObject json = new JSONObject();
        String message = "\u4eba\u5458\u4fe1\u606f\u5220\u9664\u5931\u8d25\uff01";
        String status = "300";
        if (this.insPreservationDetailAPIService.deleteInsPreservationDetail(Long.valueOf(oid))) {
            message = "\u4eba\u5458\u4fe1\u606f\u5220\u9664\u6210\u529f\uff01";
            status = "200";
        }
        json.put("message", (Object)message);
        json.put("status", (Object)status);
        return json;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/resultSet/uploadRoleFile"})
    @ResponseBody
    public ResultDto resultUploadRoleFile(MultipartHttpServletRequest request) throws Exception {
        MultipartFile roleFile = request.getFile("role_record");
        List list = null;
        if (roleFile == null) return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
        JSONObject jo = this.insPreservationResultSetAPIService.readIPRSExcel(roleFile);
        if (!"200".equals(jo.get((Object)"ret"))) return new ResultDto(String.valueOf(jo.get((Object)"msg")), "300", "", "", "");
        list = (List)jo.get((Object)"list");
        if (list.size() < 1) {
            return new ResultDto("Excel\u4e2d\u65e0\u4eba\u5458\u6570\u636e\u6216\u5b58\u5728\u7a7a\u767d\u884c\uff01", "300", "", "", "");
        }
        if (list == null || list.isEmpty()) return new ResultDto("\u672a\u89e3\u6790\u5230\u53ef\u7528\u6570\u636e\uff01", "300", "", "", "");
        if (!this.setValueSession(list)) return new ResultDto("\u6570\u636e\u7f13\u5b58\u5931\u8d25\uff01", "300", "", "", "");
        return new ResultDto("\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01", "200", "", "", "");
    }

    private boolean setValueSession(List<InsPreservationResultSetVo> list) {
        JedisUtils.setObject((String)("iprsVoList:" + this.getToken()), list, (int)180);
        return true;
    }

    private List<InsPreservationResultSetVo> getValueSession() {
        List list = (List)JedisUtils.getObject((String)("iprsVoList:" + this.getToken()));
        JedisUtils.delObject((String)("iprsVoList:" + this.getToken()));
        return list;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/payList"})
    public ModelAndView payList(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/payList");
        page.setNumPerPage(5);
        String et = "";
        if (StringUtils.isNotEmpty((String)end_time)) {
            et = end_time + " 23:59:59";
        }
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationBillVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), pay_status, start_time, et, keyword));
        view.addObject(PAY_STATUS, (Object)pay_status);
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/getPayListForPage"})
    public ModelAndView getPayListForPage(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((String)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/payList_table");
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationBillVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), pay_status, start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/billList"})
    public ModelAndView billList(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String parentPayId = request.getParameter("parentPayId");
        String isPart = request.getParameter("isPart");
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/billList");
        page.setNumPerPage(5);
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        InsPreservationPayVo payVo = this.insPreservationPayAPIService.findInsPreservationPayVoById(Long.valueOf(Long.parseLong(parentPayId)));
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationChildBillVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), pay_status, start_time, et, keyword));
        view.addObject(PAY_STATUS, (Object)pay_status);
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        view.addObject("insPreservationPayVo", (Object)payVo);
        view.addObject("parentPayId", (Object)parentPayId);
        view.addObject("isPart", (Object)isPart);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/getBillListForPage"})
    public ModelAndView getBillListForPage(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String parentPayId = request.getParameter("parentPayId");
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/billList_table");
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationChildBillVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), pay_status, start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/settlementList"})
    public ModelAndView settlementList(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/settlementList");
        page.setNumPerPage(5);
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationSettlementVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), start_time, et, keyword));
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/getSettlementListForPage"})
    public ModelAndView getSettlementListForPage(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/settlementList_table");
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationSettlementVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/settlementBillList"})
    public ModelAndView settlementBillList(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String parentPayId = request.getParameter("parentPayId");
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/settlementBillList");
        page.setNumPerPage(5);
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationChildSettlementVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), start_time, et, keyword));
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        view.addObject("parentPayId", (Object)parentPayId);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/getSettlementBillListForPage"})
    public ModelAndView getSettlementBillListForPage(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String parentPayId = request.getParameter("parentPayId");
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/settlementBillList_table");
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationChildSettlementVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/getInsPreservationPayByPayId/{payId}"})
    public ModelAndView getInsPreservationPayByPayId(@PathVariable Long payId, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        InsPreservationPayVo payVo = this.insPreservationPayAPIService.findInsPreservationPayVoById(payId);
        List list = this.productService.getProductsByOnLine(payVo.getProduct_code());
        view.setViewName("/coninsweb/personalCenter/preservation/pay/payDetail");
        view.addObject(PAYVO, (Object)payVo);
        view.addObject("productDto", list.get(0));
        view.addObject(RECORDVOLIST, (Object)payVo.getInsPreservationRecordVoList());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/pay/getRecordVoListForPage"})
    public ModelAndView getRecordVoListForPage(Long payId, String keyword, DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/recordVoList_table");
        view.addObject(RECORDVOLIST, (Object)this.insPreservationRecordAPIService.findInsPreservationRecordVoByPayId(page, payId, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/pay/uploadFilePay"})
    @ResponseBody
    public ResultDto uploadFilePay(MultipartHttpServletRequest request) throws Exception {
        MultipartFile pay_file = request.getFile("pay_file");
        String payId = request.getParameter("payId");
        if (pay_file == null || StringUtils.isEmpty((String)payId)) {
            return new ResultDto("\u4e0a\u4f20\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
        }
        String path = OSSFileUtil.huaweiOBSFileUpload((MultipartFile)pay_file, (String)"/record/");
        if (StringUtils.isNotEmpty((String)path)) {
            if (this.insPreservationPayAPIService.savePayPath(Long.valueOf(Long.parseLong(payId)), path)) {
                return new ResultDto("\u4fdd\u5168\u7f34\u8d39\u6570\u636e\u66f4\u65b0\u6210\u529f\uff01", "200", "", "", "");
            }
            return new ResultDto("\u4fdd\u5168\u7f34\u8d39\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
        }
        return new ResultDto("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\uff01", "300", "", "", "");
    }

    @LoginRequired
    @RequestMapping(value={"/pay/createPartBill"})
    @ResponseBody
    public String createPartBill(String isSummaryBill, String payIds) {
        JSONObject json = this.insPreservationPayAPIService.createPartBill(isSummaryBill, payIds.split(","));
        return json.toJSONString();
    }

    @LoginRequired
    @RequestMapping(value={"/pay/createPartBillByNo"})
    @ResponseBody
    public String createPartBillByNo(String isSummaryBill, String payNos) {
        JSONObject json = this.insPreservationPayAPIService.createPartBillByNo(isSummaryBill, payNos.split(","));
        return json.toJSONString();
    }

    @RequestMapping(value={"/pay/downBillPay"})
    public void downBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String pay_status = req.getParameter("pay_status");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.insPreservationPayAPIService.downBillPay(Long.valueOf(Long.parseLong(userdetail.getOid())), pay_status, start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/pay/downChildBillPay"})
    public void downChildBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String pay_status = req.getParameter("pay_status");
        String parentPayId = req.getParameter("parentPayId");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.insPreservationPayAPIService.downChildBillPay(Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), pay_status, start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/pay/downSettlementPay"})
    public void downSettlementPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.insPreservationPayAPIService.downSettlementPay(Long.valueOf(Long.parseLong(userdetail.getOid())), start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/pay/downChildSettlementBillPay"})
    public void downChildSettlementBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String parentPayId = req.getParameter("parentPayId");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.insPreservationPayAPIService.downChildSettlementBillPay(Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/down_result_set/{oid}"})
    public void downResultSet(@PathVariable Long oid, HttpServletResponse resp) {
        this.insPreservationResultSetAPIService.downResultSet(oid, resp);
    }

    @RequestMapping(value={"/down_preservation_detail/{preservationId}"})
    public void downPreservationDetail(@PathVariable Long preservationId, HttpServletResponse resp) {
        this.insPreservationDetailAPIService.downPreservationDetail(preservationId, resp);
    }
}

