/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.preservation.controller;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsPreservationPay;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.OSSFileUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationPayVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/pc/preservation/pay"})
public class InsPreservationPayController
extends BaseController {
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private InsPreservationPayAPIService insPreservationPayAPIService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;
    private static String PAYLIST = "payList";
    private static String PAY_STATUS = "pay_status";
    private static String START_TIME = "start_time";
    private static String END_TIME = "end_time";
    private static String KEYWORD = "keyword";
    private static String PAYVO = "payVo";
    private static String RECORDVOLIST = "recordVoList";

    @LoginRequired(methodParamKey={"0#pay_status", "1#start_time", "2#end_time"}, requestParamKey={"keyword"}, redirectUrl="pc/preservation/pay/payList?pay_status={pay_status}&start_time={start_time}&end_time={end_time}&keyword={keyword}")
    @RequestMapping(value={"payList"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u4eba\u5458\u7ba1\u7406-\u4fdd\u5168\u8d26\u5355")
    public ModelAndView payList(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/payList");
        page.setNumPerPage(5);
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationBillVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), pay_status, start_time, et, keyword));
        view.addObject(PAY_STATUS, (Object)pay_status);
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"getPayListForPage"})
    public ModelAndView getPayListForPage(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/payList_table");
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationBillVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), pay_status, start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#pay_status", "1#start_time", "2#end_time"}, requestParamKey={"keyword", "parentPayId", "isPart"}, redirectUrl="pc/preservation/pay/billList?pay_status={pay_status}&start_time={start_time}&end_time={end_time}&keyword={keyword}&parentPayId={parentPayId}&isPart={isPart}")
    @RequestMapping(value={"billList"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u4eba\u5458\u7ba1\u7406-\u4fdd\u5168\u8d26\u5355-\u8d26\u5355\u8be6\u60c5")
    public ModelAndView billList(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String parentPayId = request.getParameter("parentPayId");
        String isPart = request.getParameter("isPart");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/billList");
        page.setNumPerPage(5);
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        InsPreservationPayVo payVo = this.insPreservationPayAPIService.findInsPreservationPayVoById(Long.valueOf(Long.parseLong(parentPayId)));
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationChildBillVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), pay_status, start_time, et, keyword));
        view.addObject(PAY_STATUS, (Object)pay_status);
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        view.addObject("insPreservationPayVo", (Object)payVo);
        view.addObject("parentPayId", (Object)parentPayId);
        view.addObject("isPart", (Object)isPart);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"getBillListForPage"})
    public ModelAndView getBillListForPage(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String parentPayId = request.getParameter("parentPayId");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/billList_table");
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationChildBillVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), pay_status, start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#start_time", "1#end_time"}, requestParamKey={"keyword"}, redirectUrl="pc/preservation/pay/settlementList?start_time={start_time}&end_time={end_time}&keyword={keyword}")
    @RequestMapping(value={"settlementList"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u4eba\u5458\u7ba1\u7406-\u4fdd\u5168\u7ed3\u7b97\u5355")
    public ModelAndView settlementList(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/settlementList");
        page.setNumPerPage(5);
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationSettlementVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), start_time, et, keyword));
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"getSettlementListForPage"})
    public ModelAndView getSettlementListForPage(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/settlementList_table");
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationSettlementVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#start_time", "1#end_time"}, requestParamKey={"keyword", "parentPayId"}, redirectUrl="pc/preservation/pay/settlementBillList?start_time={start_time}&end_time={end_time}&keyword={keyword}&parentPayId={parentPayId}")
    @RequestMapping(value={"settlementBillList"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u4eba\u5458\u7ba1\u7406-\u4fdd\u5168\u7ed3\u7b97\u5355-\u7ed3\u7b97\u8be6\u60c5")
    public ModelAndView settlementBillList(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String parentPayId = request.getParameter("parentPayId");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/settlementBillList");
        page.setNumPerPage(5);
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationChildSettlementVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), start_time, et, keyword));
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        view.addObject("parentPayId", (Object)parentPayId);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"getSettlementBillListForPage"})
    public ModelAndView getSettlementBillListForPage(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        String parentPayId = request.getParameter("parentPayId");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/settlementBillList_table");
        view.addObject(PAYLIST, (Object)this.insPreservationPayAPIService.findInsPreservationChildSettlementVoByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#payId"}, redirectUrl="pc/preservation/pay/getInsPreservationPayByPayId/{payId}")
    @RequestMapping(value={"getInsPreservationPayByPayId/{payId}"})
    public ModelAndView getInsPreservationPayByPayId(@PathVariable Long payId, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        InsPreservationPayVo payVo = this.insPreservationPayAPIService.findInsPreservationPayVoById(payId);
        List list = this.productService.getProductsByOnLine(payVo.getProduct_code());
        view.setViewName("/coninsweb/personalCenter/preservation/pay/payDetail");
        view.addObject(PAYVO, (Object)payVo);
        view.addObject("productDto", list.get(0));
        view.addObject(RECORDVOLIST, (Object)payVo.getInsPreservationRecordVoList());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"getRecordVoListForPage"})
    public ModelAndView getRecordVoListForPage(Long payId, String keyword, DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/recordVoList_table");
        view.addObject(RECORDVOLIST, (Object)this.insPreservationRecordAPIService.findInsPreservationRecordVoByPayId(page, payId, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/uploadFilePay"})
    @ResponseBody
    public ResultDto uploadFilePay(MultipartHttpServletRequest request) throws Exception {
        MultipartFile pay_file = request.getFile("pay_file");
        String payId = request.getParameter("payId");
        if (pay_file != null && StringUtils.isNotEmpty((CharSequence)payId)) {
            String path = OSSFileUtil.huaweiOBSFileUpload((MultipartFile)pay_file, (String)"/record/");
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                if (this.insPreservationPayAPIService.savePayPath(Long.valueOf(Long.parseLong(payId)), path)) {
                    return new ResultDto("\u4fdd\u5168\u7f34\u8d39\u6570\u636e\u66f4\u65b0\u6210\u529f\uff01", "200", "", "", "");
                }
                return new ResultDto("\u4fdd\u5168\u7f34\u8d39\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
            }
            return new ResultDto("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\uff01", "300", "", "", "");
        }
        return new ResultDto("\u4e0a\u4f20\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"recordPayment/{oid}"})
    public ModelAndView recordPayment(@PathVariable String oid) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/recordPayment");
        InsPreservationRecordVo record = this.insPreservationRecordAPIService.findIPRVoById(Long.valueOf(Long.parseLong(oid)));
        InsPreservationPayVo ippay = this.insPreservationPayAPIService.findIPPayVoById(Long.valueOf(Long.parseLong(record.getIns_preservation_pay_id())));
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(record.getIns_insurance_slip_id())));
        view.addObject("record", (Object)record);
        view.addObject("ippay", (Object)ippay);
        view.addObject("vo", (Object)vo);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"createPartBill"})
    @ResponseBody
    public String createPartBill(String isSummaryBill, String payIds) {
        JSONObject json = this.insPreservationPayAPIService.createPartBill(isSummaryBill, payIds.split(","));
        return json.toJSONString();
    }

    @RequestMapping(value={"createPartBillByNo"})
    @ResponseBody
    public String createPartBillByNo(String isSummaryBill, String payNos) {
        JSONObject json = this.insPreservationPayAPIService.createPartBillByNo(isSummaryBill, payNos.split(","));
        return json.toJSONString();
    }

    @RequestMapping(value={"/downBillPay"})
    public void downBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String pay_status = req.getParameter("pay_status");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.insPreservationPayAPIService.downBillPay(Long.valueOf(Long.parseLong(userdetail.getOid())), pay_status, start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/downChildBillPay"})
    public void downChildBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String pay_status = req.getParameter("pay_status");
        String parentPayId = req.getParameter("parentPayId");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.insPreservationPayAPIService.downChildBillPay(Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), pay_status, start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/downSettlementPay"})
    public void downSettlementPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.insPreservationPayAPIService.downSettlementPay(Long.valueOf(Long.parseLong(userdetail.getOid())), start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/downChildSettlementBillPay"})
    public void downChildSettlementBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String parentPayId = req.getParameter("parentPayId");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.insPreservationPayAPIService.downChildSettlementBillPay(Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(Long.parseLong(parentPayId)), start_time, et, keyword, resp);
    }

    @RequestMapping(value={"isSuccessPay/{oid}"})
    @ResponseBody
    public String isSuccessPay(@PathVariable long oid) {
        JSONObject json = new JSONObject();
        InsPreservationPay pay = (InsPreservationPay)this.insPreservationPayAPIService.selectById((Serializable)Long.valueOf(oid));
        String status = "300";
        if (pay != null && "3".equals(pay.getPay_status())) {
            status = "200";
        }
        json.put("status", (Object)status);
        return json.toJSONString();
    }

    @RequestMapping(value={"getFP/{oid}"})
    @ResponseBody
    public Result getFP(@PathVariable long oid) {
        return this.insPreservationPayAPIService.getFP(Long.valueOf(oid));
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"finishPay"})
    public ModelAndView finishPay() {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/finishPay");
        this.setTokenByApi(view);
        return view;
    }
}

