/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component
@OrderSupplyType(type=OrderSupplyType.OrderSupplyTypeEnum.POLICY_INIT)
public class StragegyPolicyInit
implements OrderSupplyStrategy {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        ModelAndView view = new ModelAndView();
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("XYX-DQCK")) {
            this.dqckInit(pd, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("XYX-XWCK")) {
            this.xwckInit(pd, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("BZX-SSBQ")) {
            this.ssbqInit(pd, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZX")) {
            this.gzxInit(pd, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX")) {
            String personNum = request.getParameter("personNum");
            this.tyxInit(personNum, pd, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX")) {
            String personNum = request.getParameter("personNum");
            this.gzzrxInit(personNum, pd, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX")) {
            this.zzxInit(pd, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GCTB")) {
            this.gctbInit(pd, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GCLY")) {
            this.gclyInit(pd, view);
        }
        view.addObject("pd", (Object)pd);
        return view;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        return null;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        return null;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        return null;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        return null;
    }

    private void tyxInit(String personNum, ProductVo pd, ModelAndView view) {
        view.setViewName("/coninsweb/api/gmr/policy/gmr_enterBasicInfo");
        int num = 0;
        if (StringUtils.isNotEmpty((CharSequence)personNum)) {
            num = Integer.parseInt(personNum);
        }
        GMRPolicyVo vo = new GMRPolicyVo();
        MailPolicyVo mVo = new MailPolicyVo();
        mVo.setNeed_receipt("1");
        vo.setMailPolicyVo(mVo);
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (StringUtils.isNotEmpty((CharSequence)userdetail.getWeb_type())) {
            List doList = null;
            if (userdetail.getWeb_type().contains("ARS")) {
                doList = this.policyService.getComAndEmpByUserID_BBDAPI(userdetail.getWeb_id(), userdetail.getWeb_type());
            }
            if (userdetail.getWeb_type().contains("SAAS") || userdetail.getWeb_type().contains("PASP")) {
                doList = this.policyService.getComAndEmpByUserID_API(userdetail.getWeb_id(), userdetail.getWeb_type());
            }
            if (doList != null) {
                List<RoleSubjectVo> voList = this.sortRoleList(doList, num, 0);
                vo.setRoleSubjectList(voList);
                if (doList.size() > 0 && doList.size() < 4) {
                    int ct = 4 - doList.size();
                    RoleSubjectVo nullVo = null;
                    for (int i = 0; i < ct; ++i) {
                        nullVo = new RoleSubjectVo();
                        nullVo.setKind("2");
                        doList.add(nullVo);
                        nullVo = null;
                    }
                }
            }
        }
        view.addObject("vo", (Object)vo);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("dto", (Object)dto);
        view.addObject("comTypeList", (Object)IdType.comList());
        view.addObject("personTypeList", (Object)IdType.personList());
        view.addObject("natureList", (Object)NatureLinkage.getListByProvince((String)""));
        view.addObject("idOptionList", (Object)SysDictUtils.getDictList((String)"idOption"));
        view.addObject("businessAreaList", (Object)SysDictUtils.getDictList((String)"businessArea"));
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
    }

    private List<RoleSubjectVo> sortRoleList(List<RoleSubjectVo> doList, int num, int type) {
        ArrayList<RoleSubjectVo> results = new ArrayList<RoleSubjectVo>();
        if (doList == null) {
            if (num > 0) {
                RoleSubjectVo appRole = new RoleSubjectVo();
                appRole.setKind("1");
                results.add(appRole);
                RoleSubjectVo insRole = null;
                for (int i = 0; i < num; ++i) {
                    insRole = new RoleSubjectVo();
                    insRole.setKind("2");
                    insRole.setMajor_group("1");
                    results.add(insRole);
                    insRole = null;
                }
                return results;
            }
            return null;
        }
        ArrayList<RoleSubjectVo> insurceRoleList = new ArrayList<RoleSubjectVo>();
        for (RoleSubjectVo vo : doList) {
            if ("1".equals(vo.getKind())) {
                results.add(vo);
                continue;
            }
            insurceRoleList.add(vo);
        }
        if (results.size() == 0) {
            RoleSubjectVo vo = new RoleSubjectVo();
            vo.setKind("1");
            results.add(vo);
        }
        if (type == 0) {
            if (insurceRoleList.size() > 0) {
                int insRoleNum = insurceRoleList.size();
                if (insRoleNum < num) {
                    results.addAll(insurceRoleList);
                    int lastNum = num - insRoleNum;
                    for (int i = 0; i < lastNum; ++i) {
                        RoleSubjectVo rvo = new RoleSubjectVo();
                        rvo.setKind("2");
                        rvo.setMajor_group("1");
                        results.add(rvo);
                    }
                } else if (insRoleNum == num) {
                    results.addAll(insurceRoleList);
                } else if (num == 0) {
                    results.addAll(insurceRoleList);
                } else {
                    for (int i = 0; i < num; ++i) {
                        results.add((RoleSubjectVo)insurceRoleList.get(i));
                    }
                }
            }
        } else {
            results.addAll(insurceRoleList);
        }
        return results;
    }

    private void gzzrxInit(String personNum, ProductVo pd, ModelAndView view) {
        view.setViewName("/coninsweb/api/gzzrx/policy/gzzrx_enter_basic_info");
        int num = 0;
        if (StringUtils.isNotEmpty((CharSequence)personNum)) {
            num = Integer.parseInt(personNum);
        }
        SpecialHirelingVo vo = new SpecialHirelingVo();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (StringUtils.isNotEmpty((CharSequence)userdetail.getWeb_type())) {
            List doList = null;
            if (userdetail.getWeb_type().contains("ARS")) {
                doList = this.policyService.getComAndEmpByUserID_BBDAPI(userdetail.getWeb_id(), userdetail.getWeb_type());
            }
            if (userdetail.getWeb_type().contains("SAAS") || userdetail.getWeb_type().contains("PASP")) {
                doList = this.policyService.getComAndEmpByUserID_API(userdetail.getWeb_id(), userdetail.getWeb_type());
            }
            if (doList != null) {
                ArrayList appList = Lists.newArrayList();
                List<RoleSubjectVo> voList = this.sortRoleList(doList, num, 0);
                appList.add(voList.get(0));
                vo.setRoleSubjectList((List)appList);
                vo.setHirelingVoList(this.setHVoByRole(voList));
            }
        }
        view.addObject("vo", (Object)vo);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("dto", (Object)dto);
        view.addObject("comTypeList", (Object)IdType.comList());
        view.addObject("personTypeList", (Object)IdType.personList());
        view.addObject("natureList", (Object)NatureLinkage.getListByProvince((String)""));
        view.addObject("idOptionList", (Object)SysDictUtils.getDictList((String)"idOption"));
        view.addObject("businessAreaList", (Object)SysDictUtils.getDictList((String)"businessArea"));
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
    }

    private List<HirelingVo> setHVoByRole(List<RoleSubjectVo> voList) {
        ArrayList hVoList = Lists.newArrayList();
        HirelingVo hVo = null;
        for (RoleSubjectVo rsVo : voList) {
            if ("1".equals(rsVo.getKind())) continue;
            hVo = new HirelingVo();
            hVo.setName(rsVo.getName_cn());
            hVo.setId_card(rsVo.getOrganization_code());
            hVo.setId_type(rsVo.getId_type());
            hVo.setMobile(rsVo.getMobile());
            hVo.setBirth_date(rsVo.getBirth_date());
            hVo.setCareer(rsVo.getMajor_group());
            hVo.setSex(rsVo.getSex());
            hVoList.add(hVo);
        }
        if (hVoList.size() < 3) {
            for (int i = 0; i <= 3 - hVoList.size(); ++i) {
                hVo = new HirelingVo();
                hVoList.add(hVo);
            }
        }
        return hVoList;
    }

    private void zzxInit(ProductVo pd, ModelAndView view) {
        view.setViewName("/coninsweb/api/lote/policy/lote_enterBasicInfo");
        LOTEPolicyVo vo = new LOTEPolicyVo();
        MailPolicyVo mVo = new MailPolicyVo();
        vo.setMailPolicyVo(mVo);
        view.addObject("vo", (Object)vo);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("dto", (Object)dto);
        view.addObject("comTypeList", (Object)IdType.comList());
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
    }

    private void dqckInit(ProductVo pd, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_1");
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("dto", (Object)dto);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
        view.addObject("listType", (Object)SysDictUtils.getDictList((String)"organizationType"));
        view.addObject("listCurrency", (Object)SysDictUtils.getDictList((String)"currencyRequired"));
        view.addObject("listPaymentTerms", (Object)SysDictUtils.getDictList((String)"paymentTerms"));
    }

    private void xwckInit(ProductVo pd, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_mi");
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("dto", (Object)dto);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
        MicroExportVo vo = new MicroExportVo();
        this.setDay(vo);
        view.addObject("vo", (Object)vo);
        view.addObject("listComType", (Object)SysDictUtils.getDictList((String)"comType"));
        view.addObject("listComNature", (Object)SysDictUtils.getDictList((String)"comNature"));
        view.addObject("listIndustry", (Object)SysDictUtils.getDictList((String)"industry"));
        view.addObject("listPayLimit", (Object)SysDictUtils.getDictList((String)"payLimit"));
        view.addObject("listProRata", (Object)SysDictUtils.getDictList((String)"proRata"));
        view.addObject("listAnnualCurrency", (Object)SysDictUtils.getDictList((String)"annualCurrency"));
        view.addObject("listDisputes", (Object)SysDictUtils.getDictList((String)"disputes"));
    }

    private void setDay(MicroExportVo vo) {
        String tom = DateUtil.getTomorrow();
        String nextOne = "";
        try {
            nextOne = DateUtil.dateAdd((int)1, (String)tom, (int)1);
            nextOne = DateUtil.dateAdd((int)3, (String)nextOne, (int)-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setInception_date(tom);
        vo.setPlanned_end_date(nextOne);
    }

    private void gzxInit(ProductVo pd, ModelAndView view) {
        view.setViewName("/coninsweb/api/gzx/policy/gzx_enterBasicInfo");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        SpecialPublicDutyVo vo = new SpecialPublicDutyVo();
        MailPolicyVo mVo = new MailPolicyVo();
        vo.setMailPolicyVo(mVo);
        if (StringUtils.isNotEmpty((CharSequence)userdetail.getWeb_type()) && userdetail.getWeb_type().contains("PSS")) {
            List actList = this.policyService.getBLBCommunicationDtoByUserID_PSSAPI(userdetail.getWeb_id(), pd.getProduct_code().split("-")[2], userdetail.getWeb_type(), "");
            List roleList = this.policyService.getRoleSubjectVoByUserID_PSSAPI(userdetail.getWeb_id(), userdetail.getWeb_type());
            if (roleList != null) {
                vo.setRoleSubjectList(roleList);
            }
            view.addObject("acts", (Object)actList);
        }
        view.addObject("vo", (Object)vo);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("dto", (Object)dto);
        view.addObject("comTypeList", (Object)IdType.comList());
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
    }

    private void ssbqInit(ProductVo pd, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_1");
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
    }

    private void gctbInit(ProductVo pd, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_bd");
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("dto", (Object)dto);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        view.addObject("otList", (Object)OfficeType.listT((String)(pd.getProduct_code().contains("DB") ? "DB" : "OT")));
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
    }

    private void gclyInit(ProductVo pd, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_1");
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("dto", (Object)dto);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
    }
}

