/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component
@OrderSupplyType(type=OrderSupplyType.OrderSupplyTypeEnum.INSURANCE_CALCULATION)
public class StragegyInsuranceCalculation
implements OrderSupplyStrategy {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        return null;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        return null;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        return null;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        return null;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        String productCode = request.getParameter("productCode");
        if (!(!StringUtils.isEmpty((CharSequence)productCode) && productCode.contains("XYX-DQCK") || !StringUtils.isEmpty((CharSequence)productCode) && productCode.contains("XYX-XWCK") || !StringUtils.isEmpty((CharSequence)productCode) && productCode.contains("BZX-SSBQ") || !StringUtils.isEmpty((CharSequence)productCode) && productCode.contains("GZX") || !StringUtils.isEmpty((CharSequence)productCode) && productCode.contains("TYX"))) {
            if (!StringUtils.isEmpty((CharSequence)productCode) && productCode.contains("GZZRX")) {
                String is_contain_repo = request.getParameter("is_contain_repo");
                String person_num = request.getParameter("person_num");
                String premium = request.getParameter("premium");
                return this.insuranceCalculationGZZRX(productCode, is_contain_repo, person_num, premium);
            }
            if (!StringUtils.isEmpty((CharSequence)productCode) && productCode.contains("ZZX")) {
                String exAcreage = request.getParameter("exAcreage");
                String result = this.policyService.zzx_amount_count(productCode, exAcreage);
                if ("200".equals(result.split("#")[0])) {
                    return new ResultDto(result.split("#")[1], "200", "", "", "");
                }
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
            if (!StringUtils.isEmpty((CharSequence)productCode) && productCode.contains("GCTB")) {
                String insuredAmount = request.getParameter("insuredAmount");
                String provinceCode = request.getParameter("provinceCode");
                String cityCode = request.getParameter("cityCode");
                String aptitudeLevel = request.getParameter("aptitudeLevel");
                String officeType = request.getParameter("officeType");
                return this.insuranceCalculationGCTB(productCode, insuredAmount, provinceCode, cityCode, aptitudeLevel, officeType);
            }
            if (StringUtils.isEmpty((CharSequence)productCode) || productCode.contains("GCLY")) {
                // empty if block
            }
        }
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        return null;
    }

    private ResultDto insuranceCalculationGZZRX(String product_code, String is_contain_repo, String person_num, String premium) {
        if (StringUtils.isNotEmpty((CharSequence)product_code) && StringUtils.isNotEmpty((CharSequence)is_contain_repo) && StringUtils.isNotEmpty((CharSequence)person_num) && StringUtils.isNotEmpty((CharSequence)premium)) {
            String eam;
            String epm;
            BigDecimal prm = BigDecimal.ZERO;
            BigDecimal aom = BigDecimal.ZERO;
            BigDecimal pm = BigDecimal.valueOf(Double.parseDouble(premium));
            String string = "GZZRX-RB-1".equals(product_code) ? "25" : ("GZZRX-RB-2".equals(product_code) ? "35" : ("GZZRX-RB-3".equals(product_code) ? "45" : (epm = "GZZRX-RB-4".equals(product_code) ? "55" : "0")));
            String string2 = "GZZRX-RB-1".equals(product_code) ? "3000000" : ("GZZRX-RB-2".equals(product_code) ? "4000000" : ("GZZRX-RB-3".equals(product_code) ? "5000000" : (eam = "GZZRX-RB-4".equals(product_code) ? "6000000" : "0")));
            if (!"0".equals(eam)) {
                aom = BigDecimal.valueOf(Double.parseDouble(eam)).multiply(BigDecimal.valueOf(Double.parseDouble(person_num))).setScale(2, 4);
            }
            if ("1".equals(is_contain_repo)) {
                pm = pm.add(BigDecimal.valueOf(Double.parseDouble(epm)));
            }
            prm = pm.multiply(BigDecimal.valueOf(Double.parseDouble(person_num))).setScale(2, 4);
            System.out.println(prm + "#" + aom);
            return new ResultDto(prm + "#" + aom, "200", "", "", "");
        }
        return new ResultDto("", "300", "", "", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResultDto insuranceCalculationGCTB(String productCode, String insuredAmount, String provinceCode, String cityCode, String aptitudeLevel, String officeType) {
        if (!StringUtils.isNotEmpty((CharSequence)insuredAmount) || !StringUtils.isNotEmpty((CharSequence)productCode) || !StringUtils.isNotEmpty((CharSequence)provinceCode) || !StringUtils.isNotEmpty((CharSequence)cityCode)) return new ResultDto("", "300", "", "", "");
        BigDecimal premium = BigDecimal.ZERO;
        if ("350200".equals(cityCode)) {
            premium = this.numPremium(insuredAmount, aptitudeLevel, officeType);
        } else if (productCode.contains("BZX-DB")) {
            premium = this.numPremium(insuredAmount, aptitudeLevel, officeType);
        } else {
            if (!productCode.contains("BZX-TB")) return new ResultDto("", "300", "", "", "");
            if (!"350000".equals(provinceCode)) return new ResultDto("", "300", "", "", "");
            premium = this.numPremiumOt(insuredAmount);
        }
        if (premium.compareTo(BigDecimal.ZERO) < 0) return new ResultDto("", "300", "", "", "");
        return new ResultDto(String.valueOf(premium.setScale(2, 4)), "200", "", "", "");
    }

    private BigDecimal numPremiumOt(String insuredAmount) {
        BigDecimal ia = BigDecimal.valueOf(Double.parseDouble(insuredAmount));
        BigDecimal premium = BigDecimal.ZERO;
        if (ia.compareTo(BigDecimal.ZERO) >= 0 && BigDecimal.valueOf(Double.parseDouble("100000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("150"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("100000"))) > 0 && BigDecimal.valueOf(Double.parseDouble("800000")).compareTo(ia) >= 0) {
            premium = ia.multiply(BigDecimal.valueOf(Double.parseDouble("0.0015")));
        }
        return premium;
    }

    private BigDecimal numPremium(String insuredAmount, String aptitudeLevel, String officeType) {
        BigDecimal ia = BigDecimal.valueOf(Double.parseDouble(insuredAmount));
        BigDecimal premium = BigDecimal.ZERO;
        if (ia.compareTo(BigDecimal.ZERO) >= 0 && BigDecimal.valueOf(Double.parseDouble("100000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("300"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("100000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("200000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("350"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("200000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("300000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("400"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("300000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("400000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("450"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("400000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("500000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("500"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("500000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("600000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("550"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("600000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("700000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("600"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("700000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("800000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("650"));
        }
        return premium.multiply(this.alNum(aptitudeLevel)).multiply(this.otNum(officeType));
    }

    private BigDecimal alNum(String aptitudeLevel) {
        if ("1".equals(aptitudeLevel)) {
            return BigDecimal.valueOf(Double.parseDouble("0.7"));
        }
        if ("2".equals(aptitudeLevel)) {
            return BigDecimal.valueOf(Double.parseDouble("0.95"));
        }
        if ("3".equals(aptitudeLevel)) {
            return BigDecimal.ONE;
        }
        if ("4".equals(aptitudeLevel)) {
            return BigDecimal.valueOf(Double.parseDouble("1.3"));
        }
        if ("5".equals(aptitudeLevel)) {
            return BigDecimal.valueOf(Double.parseDouble("1.5"));
        }
        return BigDecimal.ONE;
    }

    private BigDecimal otNum(String officeType) {
        if ("7".equals(officeType) || "0001".equals(officeType)) {
            return BigDecimal.valueOf(Double.parseDouble("0.7"));
        }
        return BigDecimal.ONE;
    }
}

