/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.insurance.zzx;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.third.zzx.changan.ZZX_CARequestService;
import com.bcxin.ins.third.zzx.huatai.ZZX_HTRequestService;
import com.bcxin.ins.third.zzx.pingancai.ZZX_PACRequestService;
import com.bcxin.ins.third.zzx.yongan.ZZX_YARequestService;
import com.bcxin.ins.third.zzx.zhongan.ZARequestService;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/zzx/transaction"})
public class ZZXTransactionController
extends BaseController {
    @Autowired
    private ZARequestService zARequestService;
    @Autowired
    private ZZX_PACRequestService zZX_PACRequestService;
    @Autowired
    private ZZX_CARequestService zZX_CARequestService;
    @Autowired
    private ZZX_YARequestService zZX_YARequestService;
    @Autowired
    private ZZX_HTRequestService zZX_HTRequestService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private InsTransactionAPIService transactionService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipAPIService;

    @LoginRequired
    @RequestMapping(value={"/API_Underwriting"})
    @ResponseBody
    public ResultDto API_Underwriting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getResultDto(request, response, 0);
    }

    private ResultDto getResultDto(HttpServletRequest request, HttpServletResponse response, int is_phone) throws Exception {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        String oid = request.getParameter("policyId");
        String isPayFee = request.getParameter("isPayFee");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
        this.insInsuranceSlipAPIService.updateIsPolicyBeforePayFee(StringUtils.isEmpty((CharSequence)isPayFee) ? 1 : Integer.parseInt(isPayFee), Long.valueOf(Long.parseLong(oid)));
        String result = "";
        if (this.productService.api_request_sign(dto.getProduct_code()) == 1) {
            result = this.zARequestService.requestZA(Long.valueOf(Long.parseLong(oid)), "1", null);
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 2) {
            result = this.zZX_PACRequestService.requestPAC(Long.valueOf(Long.parseLong(oid)), "1", null);
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 3) {
            result = this.zZX_YARequestService.requestYA(Long.valueOf(Long.parseLong(oid)), "1", null, is_phone);
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 4) {
            result = this.zZX_CARequestService.request_ca_zzx(Long.valueOf(Long.parseLong(oid)), "1");
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 5) {
            String hbRet = this.zZX_HTRequestService.request_ht_zzx(Long.valueOf(Long.parseLong(oid)), "1", null);
            if (hbRet.contains("200")) {
                result = this.zZX_HTRequestService.request_ht_zzx(Long.valueOf(Long.parseLong(oid)), "25", null);
            } else {
                return new ResultDto("\uff08APP-GZX-001\uff09" + hbRet.split("#")[1], "300", "", "", "");
            }
        }
        String[] strs = result.split("#");
        if (!"200".equals(strs[0])) {
            return new ResultDto(strs[1], "300", "", "", "");
        }
        if (StringUtils.isEmpty((CharSequence)strs[1])) {
            return new ResultDto("\uff08APP-ZZX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
        }
        PolicyTransactionVo pvo = new PolicyTransactionVo();
        pvo.setPolicy_id(oid);
        pvo.setPolicy_serial_number(strs[1]);
        pvo.setPayment_method("1");
        pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
        pvo.setTransaction_status("2");
        pvo.setPath_sign("1");
        pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
        if (this.productService.api_request_sign(dto.getProduct_code()) == 3) {
            if (strs.length == 4 && StringUtils.isNotEmpty((CharSequence)strs[2])) {
                pvo.setNotice_no(strs[2]);
            }
            if (strs.length == 4 && StringUtils.isNotEmpty((CharSequence)strs[3])) {
                pvo.setDeal_url(strs[3]);
            }
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 4) {
            if (strs.length == 5 && StringUtils.isNotEmpty((CharSequence)strs[2])) {
                pvo.setPay_amount(new BigDecimal(strs[2]));
            }
            if (strs.length == 5 && StringUtils.isNotEmpty((CharSequence)strs[3])) {
                pvo.setOut_of_pocket(new BigDecimal(strs[3]));
            }
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 5) {
            if (strs.length == 6) {
                if (StringUtils.isNotEmpty((CharSequence)strs[4])) {
                    pvo.setNotice_no(strs[1] + "_" + strs[4]);
                }
                if (StringUtils.isNotEmpty((CharSequence)strs[2])) {
                    pvo.setLg_path(strs[2]);
                }
                if (StringUtils.isNotEmpty((CharSequence)strs[3])) {
                    pvo.setInsure_path(strs[3]);
                }
            }
        } else {
            if (strs.length == 5 && StringUtils.isNotEmpty((CharSequence)strs[2])) {
                pvo.setNotice_no(strs[2]);
            }
            if (strs.length == 5 && StringUtils.isNotEmpty((CharSequence)strs[4])) {
                pvo.setPay_amount(new BigDecimal(strs[4]));
            }
            if (strs.length == 5 && StringUtils.isNotEmpty((CharSequence)strs[3])) {
                pvo.setOut_of_pocket(new BigDecimal(strs[3]));
            }
        }
        this.policyService.saveTransaction(pvo);
        return new ResultDto("", "200", "", "", "");
    }

    @RequestMapping(value={"/failMessage"})
    public ModelAndView failMessage(HttpServletRequest request) {
        String msg = request.getParameter("msg");
        ModelAndView view = new ModelAndView("/coninsweb/insurance/zzx/transaction/failMessage");
        view.addObject("msg", (Object)msg);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/syntony-service/{oid}"})
    public ModelAndView syntonyService(@PathVariable(value="oid") String oid, HttpServletRequest request) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail != null && userdetail.getWeb_type().contains("PSS")) {
            ModelAndView view = new ModelAndView("forward:/api/lote/syntony-service/" + oid);
            this.setTokenByApi(view);
            return view;
        }
        this.logger.info("\u5c55\u8d23\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-star");
        this.logger.info("\u5c55\u8d23\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-syntony-service\uff1aoid:" + oid);
        ModelAndView view = new ModelAndView("/coninsweb/insurance/zzx/transaction/finishPay");
        if (StringUtils.isNotEmpty((CharSequence)oid)) {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            this.logger.info("\u5c55\u8d23\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-OrderFormVo\uff1a" + dto.toString());
        }
        view.addObject("oid", (Object)oid);
        this.logger.info("\u5c55\u8d23\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-end");
        this.setTokenByApi(view);
        return view;
    }
}

