/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.insurance.gzzrx;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.third.gzzrx.changan.GZZRX_CARequestService;
import com.bcxin.ins.third.gzzrx.pingancai.GZZRX_PACRequestService;
import com.bcxin.ins.third.gzzrx.qianhai.GZZRX_QHRequestService;
import com.bcxin.ins.third.gzzrx.renbao.GZZRX_RBRequestService;
import com.bcxin.ins.third.gzzrx.taibao.GZZRX_TBRequestService;
import com.bcxin.ins.third.gzzrx.zhonghua.GZZRX_ZHRequestService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.InsureVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/gzzrx/transaction"})
public class GZZRXTransactionController
extends BaseController {
    @Autowired
    private GZZRX_RBRequestService gZZRX_RBRequestService;
    @Autowired
    private GZZRX_ZHRequestService gZZRX_ZHRequestService;
    @Autowired
    private GZZRX_PACRequestService gZZRX_PACRequestService;
    @Autowired
    private GZZRX_CARequestService gZZRX_CARequestService;
    @Autowired
    private GZZRX_QHRequestService gZZRX_QHRequestService;
    @Autowired
    private GZZRX_TBRequestService gZZRX_TBRequestService;
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private InsTransactionAPIService transactionService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipAPIService;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    @LoginRequired
    @RequestMapping(value={"/API_Underwriting"})
    @ResponseBody
    public ResultDto API_Underwriting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String oid = request.getParameter("policyId");
        String isPayFee = request.getParameter("isPayFee");
        if (StringUtils.isEmpty((CharSequence)oid)) {
            return new ResultDto("\uff08APP-GZZRX-008\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
        }
        return this.getResultDto(oid, isPayFee);
    }

    private ResultDto getResultDto(String oid, String isPayFee) throws Exception {
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
        if (dto == null) {
            return new ResultDto("\uff08APP-GZZRX-009\uff09\u672a\u5339\u914d\u5230\u6709\u6548\u8ba2\u5355\uff01", "300", "", "", "");
        }
        this.insInsuranceSlipAPIService.updateIsPolicyBeforePayFee(StringUtils.isEmpty((CharSequence)isPayFee) ? 1 : Integer.parseInt(isPayFee), Long.valueOf(Long.parseLong(oid)));
        if (dto.getProduct_code().contains("GZZRX-QH")) {
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            String result = this.gZZRX_QHRequestService.request_qh_gzzrx(Long.valueOf(Long.parseLong(oid)), "1", null);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return new ResultDto(strs[1], "300", "", "", "");
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return new ResultDto("\uff08APP-GZZRX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
            }
            String payNo = String.valueOf(idWorker.nextId());
            String payPath = strs[2];
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setPolicy_id(oid);
            pvo.setPolicy_serial_number(strs[1]);
            pvo.setDeal_url(payPath);
            pvo.setPayment_method("1");
            pvo.setPay_type("7");
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setTransaction_status("2");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            pvo.setPay_order_number(payNo);
            pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            this.policyService.saveTransaction(pvo);
            return new ResultDto("", "200", "", "", "");
        }
        if (dto.getProduct_code().contains("GZZRX-RB")) {
            String result = this.gZZRX_RBRequestService.request_rb_gzzrx(Long.valueOf(Long.parseLong(oid)), "1", null);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return new ResultDto(strs[1], "300", "", "", "");
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return new ResultDto("\uff08APP-GZZRX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
            }
            String payNo = strs[2].split(",")[0].split("\uff1a")[1];
            String payPath = strs[2].split(",")[1].split("\uff1a")[1];
            if (StringUtils.isNotEmpty((CharSequence)payPath)) {
                payPath = payPath.replace("<![CDATA[", "").replace("]]>", "").replace("&lt;![CDATA[", "").replace("]]&gt;", "");
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setPolicy_id(oid);
            pvo.setPolicy_serial_number(strs[1]);
            pvo.setDeal_url(payPath);
            pvo.setPayment_method("1");
            pvo.setPay_type("2");
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setTransaction_status("2");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            pvo.setPay_order_number(payNo);
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            this.policyService.saveTransaction(pvo);
            return new ResultDto("", "200", "", "", "");
        }
        if (dto.getProduct_code().contains("GZZRX-ZH") || dto.getProduct_code().contains("GZZRX-XZH")) {
            String result = this.gZZRX_ZHRequestService.request_zh_gzzrx(Long.valueOf(Long.parseLong(oid)), "1", null);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return new ResultDto(strs[1], "300", "", "", "");
            }
            if (StringUtils.isNotEmpty((CharSequence)strs[1])) {
                PolicyTransactionVo pvo = new PolicyTransactionVo();
                pvo.setPolicy_id(oid);
                pvo.setPolicy_serial_number(strs[1]);
                this.policyService.saveTransaction(pvo);
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("\uff08APP-GZZRX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
        }
        if (dto.getProduct_code().contains("GZZRX-CA")) {
            String result = this.gZZRX_CARequestService.request_ca_gzzrx(Long.valueOf(Long.parseLong(oid)), TransTypeEnum.HB.getValue(), null);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return new ResultDto(strs[1], "300", "", "", "");
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return new ResultDto("\uff08APP-GZZRX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setPolicy_id(oid);
            pvo.setPolicy_serial_number(strs[1]);
            this.policyService.saveTransaction(pvo);
            return new ResultDto("", "200", "", "", "");
        }
        if (dto.getProduct_code().contains("GZZRX-PAC")) {
            String result = this.gZZRX_PACRequestService.requestPAC(Long.valueOf(Long.parseLong(oid)), "1", null);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return new ResultDto(strs[1], "300", "", "", "");
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return new ResultDto("\uff08APP-GZZRX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
            }
            if ("1".equals(isPayFee)) {
                PolicyTransactionVo pvo = new PolicyTransactionVo();
                pvo.setPolicy_id(oid);
                pvo.setPolicy_serial_number(strs[1]);
                pvo.setNotice_no(strs[5]);
                this.policyService.saveTransaction(pvo);
            } else {
                IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                PolicyTransactionVo pvo = new PolicyTransactionVo();
                pvo.setPolicy_id(oid);
                pvo.setPolicy_serial_number(strs[1]);
                pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
                pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
                pvo.setPayment_method("1");
                pvo.setPay_type("6");
                pvo.setPolicy_id(dto.getOid());
                pvo.setTransaction_status("2");
                pvo.setPath_sign("1");
                pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
                this.policyService.saveTransaction(pvo);
                this.policyService.HTTP_PAC_GZZRX_CB(Long.valueOf(Long.parseLong(oid)), strs[2]);
            }
            return new ResultDto("", "200", "", "", "");
        }
        if (dto.getProduct_code().contains("GZZRX-TB")) {
            String result = this.gZZRX_TBRequestService.request_tb_gzzrx(Long.valueOf(Long.parseLong(oid)), TransTypeEnum.HB.getValue(), null);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return new ResultDto(strs[1], "300", "", "", "");
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return new ResultDto("\uff08APP-GZZRX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setPolicy_id(oid);
            pvo.setPolicy_serial_number(strs[1]);
            pvo.setDeal_url(strs[6]);
            pvo.setPayment_method("1");
            pvo.setPay_type("2");
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setTransaction_status("2");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            pvo.setPay_order_number(strs[5]);
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            this.policyService.saveTransaction(pvo);
            return new ResultDto("", "200", "", "", "");
        }
        return new ResultDto("\uff08APP-GZZRX-010\uff09\u672a\u5339\u914d\u5230\u4ea7\u54c1\u7f16\u7801\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/failMessage"})
    public ModelAndView failMessage(HttpServletRequest request) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/gzzrx/transaction/failMessage");
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/syntony-service/{oid}"})
    public ModelAndView syntonyService(@PathVariable(value="oid") String oid, HttpServletRequest request) {
        this.logger.info("\u96c7\u4e3b\u8d23\u4efb\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-star");
        this.logger.info("\u96c7\u4e3b\u8d23\u4efb\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-syntony-service\uff1aoid:" + oid);
        ModelAndView view = new ModelAndView("/coninsweb/insurance/gzzrx/transaction/finishPay");
        if (StringUtils.isNotEmpty((CharSequence)oid)) {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            this.logger.info("\u96c7\u4e3b\u8d23\u4efb\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-OrderFormVo\uff1a" + dto.toString());
        }
        view.addObject("oid", (Object)oid);
        this.logger.info("\u96c7\u4e3b\u8d23\u4efb\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-end");
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/syntony-service-record/{oid}"})
    public ModelAndView syntonyServiceRecord(@PathVariable(value="oid") String oid, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/gzzrx/transaction/finishPayClose");
        return view;
    }

    @RequestMapping(value={"/isPaySuccess/{oid}"})
    @ResponseBody
    public String isPaySuccess(@PathVariable long oid) {
        InsTransaction it;
        JSONObject json = new JSONObject();
        List tranList = this.transactionService.selectInsTransactionByInsOrderForm(Long.valueOf(oid));
        String status = "300";
        if (tranList.size() > 0 && "1".equals((it = (InsTransaction)tranList.get(0)).getTransaction_status())) {
            status = "200";
        }
        json.put("status", (Object)status);
        return json.toJSONString();
    }

    @RequestMapping(value={"/isPolicyUnderwrite/{oid}"})
    @ResponseBody
    public String isPolicyUnderwrite(@PathVariable long oid) {
        JSONObject json = new JSONObject();
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        String status = "300";
        if (orderVo != null && "6".equals(orderVo.getPolicy_status())) {
            status = "200";
        }
        json.put("status", (Object)status);
        return json.toJSONString();
    }

    @RequestMapping(value={"/policyUnderwrite/{oid}"})
    public ModelAndView policyUnderwrite(@PathVariable(value="oid") String oid, HttpServletRequest request) {
        this.logger.info("\u96c7\u4e3b\u8d23\u4efb\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-star");
        this.logger.info("\u96c7\u4e3b\u8d23\u4efb\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-policyUnderwrite\uff1aoid:" + oid);
        ModelAndView view = new ModelAndView("/coninsweb/insurance/gzzrx/transaction/finishPay");
        if (StringUtils.isNotEmpty((CharSequence)oid)) {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            this.logger.info("\u96c7\u4e3b\u8d23\u4efb\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-OrderFormVo\uff1a" + dto.toString());
        }
        view.addObject("oid", (Object)oid);
        this.logger.info("\u96c7\u4e3b\u8d23\u4efb\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-end");
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/uploadPayMentFile"})
    @ResponseBody
    public ResultDto uploadPayMentFile(HttpServletRequest request) {
        String doPayments = request.getParameter("doPayments");
        String payAmount = request.getParameter("payAmount");
        String oid = request.getParameter("oid");
        String paymentPath = request.getParameter("paymentPath");
        if (StringUtils.isEmpty((CharSequence)doPayments) || StringUtils.isEmpty((CharSequence)payAmount) || StringUtils.isEmpty((CharSequence)oid) || StringUtils.isEmpty((CharSequence)paymentPath)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u64cd\u4f5c\u5931\u8d25\uff01", "300", "", "", "");
        }
        String orderID = this.policyService.uploadPayMentFileToTranction(paymentPath, oid, doPayments, payAmount);
        if (StringUtils.isNotEmpty((CharSequence)orderID)) {
            this.myAsyncExecutor.execute(() -> this.policyService.JFPZ_SendEmail(Long.valueOf(Long.parseLong(oid)), paymentPath));
            return new ResultDto("\u4e0a\u4f20\u6210\u529f\uff01", "200", "true", "", "");
        }
        return new ResultDto("\u6570\u636e\u5b58\u50a8\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/printPolicy/{order_id}"})
    public ModelAndView printPolicy(@PathVariable Long order_id) {
        ModelAndView view = new ModelAndView();
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && dto.getProduct_code().contains("GZZRX")) {
            view.setViewName("/coninsweb/insurance/gzzrx/policy/policyPrint");
            SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
            List natureList = NatureLinkage.doList();
            List typeList = IdType.doList();
            view.addObject("vo", (Object)vo);
            view.addObject("typeList", (Object)typeList);
            view.addObject("natureList", (Object)natureList);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/saveSealInsuranceApplication"})
    @ResponseBody
    public ResultDto saveSealInsuranceApplication(InsureVo insInsuranceSlip) {
        InsInsuranceSlip oldPolicy = this.insInsuranceSlipAPIService.selectById(insInsuranceSlip.getIns_insurance_slip_id());
        if (StringUtils.isNotEmpty((CharSequence)insInsuranceSlip.getUser_insure_path())) {
            oldPolicy.setUser_insure_path(insInsuranceSlip.getUser_insure_path());
            this.insInsuranceSlipAPIService.updateById((Object)oldPolicy);
            JedisUtils.batchDel((String)("BLB:CACHE:POLICY-ID-" + oldPolicy.getIns_insurance_slip_id()));
            return new ResultDto("\u4e0a\u4f20\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
    }
}

