/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.insurance.gyx;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.third.gyx.changan.GYX_CARequestService;
import com.bcxin.ins.third.gyx.taibao.GYX_TBRequestService;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/gyx/transaction"})
public class GYXTransactionController
extends BaseController {
    @Autowired
    private GYX_TBRequestService gYX_TBRequestService;
    @Autowired
    private GYX_CARequestService gYX_CARequestService;
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;

    @LoginRequired
    @RequestMapping(value={"/API_Underwriting"})
    @ResponseBody
    public ResultDto API_Underwriting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String oid = request.getParameter("policyId");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
        String result = "";
        String[] strs = null;
        if (dto.getProduct_code().contains("GYX-TB")) {
            result = this.gYX_TBRequestService.requestTB(Long.valueOf(Long.parseLong(oid)), "1", "");
            strs = result.split("#");
        } else if (dto.getProduct_code().contains("GYX-CA")) {
            result = this.gYX_CARequestService.request_ca_gyx(Long.valueOf(Long.parseLong(oid)), "1");
            strs = result.split("#");
        } else {
            return new ResultDto("\u4ea7\u54c1\u672a\u5339\u914d\u5230\u5bf9\u5e94\u63a5\u53e3\uff01", "300", "", "", "");
        }
        if ("200".equals(strs[0])) {
            if (StringUtils.isNotEmpty((CharSequence)strs[1])) {
                PolicyTransactionVo pvo = new PolicyTransactionVo();
                pvo.setPolicy_id(oid);
                pvo.setPolicy_serial_number(strs[1]);
                this.policyService.saveTransaction(pvo);
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("\uff08APP-GYX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
        }
        return new ResultDto(strs[1], "300", "", "", "");
    }

    @RequestMapping(value={"/getPayUrlByTB"})
    public void getPayUrlByTB(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String result;
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            String result2 = "{\"statusCode\":\"300\",\"message\":\"\u7528\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\"}";
            this.renderString(response, result2, "text/html; charset=UTF-8");
            return;
        }
        String oid = request.getParameter("policyId");
        String payType = request.getParameter("policyPaymentType");
        if (StringUtils.isEmpty((CharSequence)oid) || StringUtils.isEmpty((CharSequence)payType)) {
            String result3 = "{\"statusCode\":\"300\",\"message\":\"\u8bf7\u9009\u62e9\u652f\u4ed8\u65b9\u5f0f\"}";
            this.renderString(response, result3, "text/html; charset=UTF-8");
            return;
        }
        try {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
            PolicyTransactionVo vo = new PolicyTransactionVo();
            String payforURL = "";
            String msg = "";
            vo.setPayment_method("3");
            if (dto.getProduct_code().contains("GYX-TB")) {
                String payResult = this.gYX_TBRequestService.requestTB(Long.valueOf(Long.parseLong(oid)), "2", payType);
                String[] strs = payResult.split("#");
                if (!"200".equals(strs[0])) {
                    msg = strs[1];
                }
                if ("200".equals(strs[0]) && strs.length > 2) {
                    payforURL = strs[2];
                }
            } else if (dto.getProduct_code().contains("GYX-CA")) {
                String payResult = this.gYX_CARequestService.request_ca_gyx(Long.valueOf(Long.parseLong(oid)), "5");
                String[] strs = payResult.split("#");
                if (!"200".equals(strs[0])) {
                    msg = strs[1];
                }
                if ("200".equals(strs[0]) && strs.length > 2) {
                    payforURL = strs[2];
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)payforURL)) {
                vo.setPay_amount(new BigDecimal(dto.getGross_premium()));
                vo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
                vo.setStart_time(new Date());
                vo.setDeal_url(payforURL);
                vo.setPolicy_id(oid);
                vo.setPayment_method("1");
                vo.setPath_sign("1");
                vo.setPay_type(payType);
                vo.setUser_id(Long.valueOf(Long.parseLong(userdetail.getOid())));
                vo.setTrade_serial_number(String.valueOf(IdWorker.getId()));
                this.policyService.saveTransaction(vo);
                result = "{\"statusCode\":\"200\",\"forwardurl\":\"" + payforURL + "\"}";
            } else {
                result = "{\"statusCode\":\"301\",\"message\":\"" + msg + "\"}";
            }
        }
        catch (Exception e) {
            result = "{\"statusCode\":\"300\",\"message\":\"\u652f\u4ed8\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\"}";
        }
        this.renderString(response, result, "text/html; charset=UTF-8");
    }

    @RequestMapping(value={"/finishPay/{oid}"})
    public ModelAndView finishPay(@PathVariable long oid, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/gyx/transaction/finishPay");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        this.setTokenByApi(view);
        return view;
    }
}

