/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.insurance.afr;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.third.gzx.huatai.HtPolicyService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.MD5Util;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/afr/transaction"})
public class AFRTransactionController
extends BaseController {
    @Autowired
    private HtPolicyService htPolicyService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private ProductService productService;
    @Autowired
    private InsTransactionAPIService transactionService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipAPIService;
    private static Logger log = LoggerFactory.getLogger(AFRTransactionController.class);

    @RequestMapping(value={"/payFaid"})
    public ModelAndView payFaid(String tradeNumber) throws IOException {
        return this.getPayPage(tradeNumber);
    }

    @RequestMapping(value={"/paySuccess"})
    public ModelAndView paySuccess(String tradeNumber) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/afr/transaction/pay_fail_noauto");
        view.addObject("tradeNumber", (Object)tradeNumber);
        try {
            return this.getPayPage(tradeNumber);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setTokenByApi(view);
            return view;
        }
    }

    private ModelAndView getPayPage(String tradeNumber) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/afr/transaction/pay_fail_noauto");
        view.addObject("tradeNumber", (Object)tradeNumber);
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.getInsOrderForm(Long.valueOf(Long.parseLong(tradeNumber)));
        List insTransactionList = this.transactionService.selectInsTransactionByInsOrderForm(insInsuranceSlip.getIns_insurance_slip_id());
        InsTransaction transaction = null;
        if (insTransactionList.size() > 0) {
            transaction = (InsTransaction)insTransactionList.get(0);
        }
        if (transaction != null && "1".equals(transaction.getTransaction_status())) {
            view.setViewName("/coninsweb/insurance/afr/transaction/pay_success_noauto");
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(tradeNumber)));
            view.addObject("tradeNumber", (Object)tradeNumber);
            view.addObject("payAmount", (Object)insInsuranceSlip.getPremium());
            view.addObject("orderNo", (Object)transaction.getPay_order_number());
            view.addObject("productName", (Object)dto.getProduct_name());
            view.addObject("policyURL", (Object)insInsuranceSlip.getInsure_path());
            view.addObject("policyNo", (Object)insInsuranceSlip.getIns_insurance_slip_id());
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"saveFileToPDF"})
    public ResultDto saveFileToPDF(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String oid = request.getParameter("oid");
        return null;
    }

    @RequestMapping(value={"/ht/{orderNo}"})
    public ModelAndView payHtPage(@PathVariable String orderNo, ModelMap model, HttpServletResponse response) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/afr/transaction/pay_zhifubao");
        try {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(orderNo)));
            InsInsuranceSlip insInsuranceSlip = (InsInsuranceSlip)this.insInsuranceSlipService.selectById((Serializable)((Object)orderNo));
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setStart_time(new Date());
            pvo.setPayment_method("1");
            pvo.setPolicy_id(orderNo);
            pvo.setPay_type("1");
            pvo.setDeal_url(GlobalResources.WEB_PRO_URL + "/insurance/afr/transaction/ht/" + orderNo);
            pvo.setUser_id(insInsuranceSlip.getRegister_user_id());
            this.policyService.saveTransaction(pvo);
            SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(insInsuranceSlip.getIns_insurance_slip_id());
            String result = this.htPolicyService.htPay(response, insInsuranceSlip, (RoleSubjectVo)vo.getRoleSubjectList().get(0));
            view.addObject("payinfo", (Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/ht/callback/back"})
    public void callbackBack(HttpServletRequest request, ModelMap model, HttpServletResponse response) {
        log.info("\u56de\u8c03\u540e\u53f0");
        String orderNo = request.getParameter("orderNo");
        String status = request.getParameter("payStatus");
        String transactionNo = request.getParameter("transactionNo");
        log.info("\u534e\u6cf0\u652f\u4ed8\u72b6\u6001status" + status);
        String channel = GlobalResources.HT_CHANNELCODE;
        String sign = MD5Util.string2MD5((String)(channel + DateUtil.getCurrentDate()));
        if (status.equals("1")) {
            this.policyService.HTTP_HT_GZX_HBCB(orderNo, transactionNo);
        }
    }

    @RequestMapping(value={"/ht/callback/front"})
    public ModelAndView callbackFront(HttpServletRequest request, ModelMap model, HttpServletResponse response) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/afr/transaction/pay_fail");
        log.info("\u56de\u8c03\u524d\u53f0");
        log.info("\u56de\u8c03\u524d\u53f0");
        String orderNo = request.getParameter("orderNo");
        String status = request.getParameter("payStatus");
        String transactionNo = request.getParameter("transactionNo");
        log.info("\u534e\u6cf0\u652f\u4ed8\u72b6\u6001status" + status);
        log.info("\u534e\u6cf0\u652f\u4ed8\u72b6\u6001status" + status);
        String channel = GlobalResources.HT_CHANNELCODE;
        String sign = MD5Util.string2MD5((String)(channel + DateUtil.getCurrentDate()));
        if (status.equals("1")) {
            view.setViewName("/coninsweb/insurance/afr/transaction/pay_success");
            this.policyService.HTTP_HT_GZX_HBCB(orderNo, transactionNo);
            OrderFormVo dto = this.insInsuranceSlipService.getOrderFormVoByTradeSerialNumber(orderNo);
            view.addObject("dto", (Object)dto);
        }
        this.setTokenByApi(view);
        return view;
    }
}

