/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.api.tyx.qianhai;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.third.tyx.qianhai.TYX_PackageMessageQianHai;
import com.bcxin.ins.third.tyx.qianhai.TYX_QHRequestService;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TYX_QH_API_Controller
extends BaseController {
    @Autowired
    private InsTransactionAPIService insTransactionAPIService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private InsPreservationPayAPIService insPreservationPayAPIService;
    @Autowired
    private TYX_QHRequestService tYX_QHRequestService;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    @RequestMapping(value={"/QH-API/TYX/callback-policy"})
    public void callbackPolicy(@RequestBody String xml) throws UnsupportedEncodingException {
        if (xml.contains("%3C%")) {
            xml = URLDecoder.decode(xml, "UTF-8");
        }
        this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-QH-TYX\uff1a\u8bf7\u6c42\u62a5\u6587-" + xml);
        TYX_PackageMessageQianHai gpm = new TYX_PackageMessageQianHai();
        String result = gpm.returnAnalysisXML(xml, TransTypeEnum.HDCB.getValue());
        this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-QH-TYX\uff1a\u63a5\u53e3\u8fd4\u56de\u6570\u636e-" + result);
        if (StringUtils.isEmpty((CharSequence)result)) {
            this.renderString(this.response, this.returnRet("0001", "\u62a5\u6587\u89e3\u6790\u5931\u8d25"), "application/json");
            this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-QH-TYX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
            return;
        }
        if (!"200".equals(result.split("#")[0])) {
            this.renderString(this.response, this.returnRet("0002", result.split("#")[1]), "application/json");
            this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-QH-TYX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
            return;
        }
        OrderFormVo orderVo = this.policyService.getPolicyDtoByRcptNo(result.split("#")[1]);
        if (orderVo == null) {
            this.renderString(this.response, this.returnRet("0100", "\u8ba2\u5355\u4e0d\u5b58\u5728"), "application/json");
            this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-QH-TYX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)orderVo.getExternal_reference())) {
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(result.split("#")[2]);
            vo.setPolicy_id(orderVo.getOid());
            this.insTransactionAPIService.savePolicyExternalReference(vo);
            if (result.split("#").length == 4) {
                vo.setInsure_path(result.split("#")[3]);
                this.insTransactionAPIService.savePolicyOther(vo);
            }
            this.myAsyncExecutor.execute(() -> {
                try {
                    this.policyService.returnsAnOrderToTheSpecifiedPlatform(orderVo.getOid());
                }
                catch (Exception e) {
                    this.logger.error("------------\u96c7\u4e3b\u8d23\u4efb\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        this.renderString(this.response, this.returnRet("0000", "\u6210\u529f"), "application/json");
        this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-QH-TYX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
    }

    public static void main(String[] args) {
        String xml = "<Packet><Head><UUID>4b07e8b0-0c49-4cf0-a9eb-db3376b2442b</UUID><CRequestType>220005</CRequestType><CBusiChnl>BLB</CBusiChnl><TAcctTm>2023-12-04 13:42:13.0</TAcctTm><CheckCode>440410781dc91e884ab6e136a4c09432</CheckCode></Head><Body><Base><AppNo>0BLB2023120437056318</AppNo><TradeAmount>5292</TradeAmount><TradeDate>2023-12-04 13:42:13.0</TradeDate><TradeState>1</TradeState><TradeMsg>\u6210\u529f</TradeMsg><ResultCode>1</ResultCode><ResultMsg>\u6210\u529f</ResultMsg><PlyNo>1BLB2023120437056318</PlyNo><PlyDocUrl>https://www.qhins.com/webins/epoliy?pNo=1BLB2023120437056318&sign=c726b1b1f6050fcecaf6afcbad1a0b1a</PlyDocUrl></Base></Body></Packet>";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postJsonString(String url, String json) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(url);
            httppost.addHeader("Content-Type", "application/json");
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                StringEntity se = new StringEntity(json, StandardCharsets.UTF_8);
                se.setContentType("text/json");
                se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
                httppost.setEntity((HttpEntity)se);
            }
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity entity = response.getEntity();
                if (entity == null) return "";
                String string = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    @RequestMapping(value={"/QH-API/TYX/PRINT_INVOICE/{oid}"})
    @ResponseBody
    public ResultDto printInvoice(@PathVariable long oid) throws Exception {
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        if (dto == null || !"6".equals(dto.getPolicy_status())) {
            return new ResultDto("\u65e0\u6cd5\u83b7\u53d6\u53d1\u7968\uff01", "300", "", "", "");
        }
        String result = this.tYX_QHRequestService.request_qh_tyx(Long.valueOf(oid), TransTypeEnum.DZFP.getValue(), null);
        if (StringUtils.isEmpty((CharSequence)result)) {
            return new ResultDto("\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u63a5\u53e3\u5f02\u5e38\uff01", "300", "", "", "");
        }
        String[] strs = result.split("#");
        if (!"200".equals(strs[0])) {
            return new ResultDto(strs[1], "300", "", "", "");
        }
        if (StringUtils.isEmpty((CharSequence)strs[1])) {
            return new ResultDto("\uff08APP-TYX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
            this.policyService.updateUrlByExternalreference(strs[2], dto.getExternal_reference());
            return new ResultDto(strs[1], "200", "", "", "");
        }
        return new ResultDto("\u672a\u83b7\u53d6\u5230\u4fdd\u5355\u53f7\uff01", "300", "", "", "");
    }

    private String returnRet(String code, String msg) {
        return "<Packet type=\"RESPONSE\" version=\"1.0\">\n\t<Head>\n\t\t<CRequestType>220005</CRequestType>\n\t\t<CBusiChnl>blb</CBusiChnl>\n\t\t<ResultCode>" + code + "</ResultCode>\n\t\t<ResultMessage>" + msg + "</ResultMessage>\n\t</Head>\n</Packet>";
    }
}

