/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.api.gyx;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.GYXPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/api/gyx"})
public class GYX_Policy_API_Controller
extends BaseController {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u4ea7\u54c1-\u8bbf\u95ee\u6295\u4fdd\u9875")
    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="insurance/policy_init_iframe/{product_id}")
    @RequestMapping(value={"/policyInit/{product_id}"})
    public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String personNum = request.getParameter("personNum");
        int num = 0;
        if (StringUtils.isNotEmpty((CharSequence)personNum)) {
            num = Integer.parseInt(personNum);
        }
        GYXPolicyVo vo = new GYXPolicyVo();
        if (StringUtils.isNotEmpty((CharSequence)userdetail.getWeb_type())) {
            List doList = null;
            if (userdetail.getWeb_type().indexOf("ARS") != -1) {
                doList = this.policyService.getComAndEmpByUserID_BBDAPI(userdetail.getWeb_id(), userdetail.getWeb_type());
            }
            if (userdetail.getWeb_type().contains("SAAS") || userdetail.getWeb_type().contains("PASP")) {
                doList = this.policyService.getComAndEmpByUserID_API(userdetail.getWeb_id(), userdetail.getWeb_type());
            }
            if (doList != null) {
                List<RoleSubjectVo> voList = this.sortRoleList(doList, num, 0);
                vo.setRoleSubjectList(voList);
            }
        }
        ModelAndView view = new ModelAndView();
        view.addObject("vo", (Object)vo);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        this.orderAllotInit(product_id, view);
        this.setTokenByApi(view);
        return view;
    }

    private List<RoleSubjectVo> sortRoleList(List<RoleSubjectVo> doList, int num, int type) {
        ArrayList<RoleSubjectVo> results = new ArrayList<RoleSubjectVo>();
        if (doList == null) {
            if (num > 0) {
                RoleSubjectVo appRole = new RoleSubjectVo();
                appRole.setKind("1");
                results.add(appRole);
                RoleSubjectVo insRole = null;
                for (int i = 0; i < num; ++i) {
                    insRole = new RoleSubjectVo();
                    insRole.setKind("2");
                    results.add(insRole);
                    insRole = null;
                }
                return results;
            }
            return null;
        }
        ArrayList<RoleSubjectVo> insurceRoleList = new ArrayList<RoleSubjectVo>();
        for (RoleSubjectVo vo : doList) {
            if ("1".equals(vo.getKind())) {
                results.add(vo);
                continue;
            }
            insurceRoleList.add(vo);
        }
        if (results.size() == 0) {
            RoleSubjectVo vo = new RoleSubjectVo();
            vo.setKind("1");
            results.add(vo);
        }
        if (type != 0) {
            results.addAll(insurceRoleList);
            return results;
        }
        if (insurceRoleList.size() <= 0) {
            return results;
        }
        int insRoleNum = insurceRoleList.size();
        if (insRoleNum < num) {
            results.addAll(insurceRoleList);
            int lastNum = num - insRoleNum;
            for (int i = 0; i < lastNum; ++i) {
                RoleSubjectVo rvo = new RoleSubjectVo();
                rvo.setKind("2");
                results.add(rvo);
            }
        } else if (insRoleNum == num) {
            results.addAll(insurceRoleList);
        } else if (num == 0) {
            results.addAll(insurceRoleList);
        } else {
            for (int i = 0; i < num; ++i) {
                results.add((RoleSubjectVo)insurceRoleList.get(i));
            }
        }
        return results;
    }

    private String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode, String trade_serial_number) {
        Map map = this.policyService.createOrderFormByProductOid(product_id, user_id, recommendCode, trade_serial_number);
        if (map.get("order_id") != null) {
            return (String)map.get("order_id");
        }
        return "";
    }

    @LoginRequired(methodParamKey={"1#order_id"}, redirectUrl="insurance/gyx/policy/policy_iframe/{order_id}")
    @RequestMapping(value={"/policy/{order_id}"})
    public ModelAndView enterInfo(HttpServletRequest request, @PathVariable Long order_id) {
        ModelAndView view = new ModelAndView();
        this.orderAllot(order_id, view);
        this.setTokenByApi(view);
        return view;
    }

    private void orderAllotInit(Long product_id, ModelAndView view) {
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        dto.setTrade_serial_number(String.valueOf(IdWorker.getId()));
        view.addObject("sigId", (Object)String.valueOf(IdWorker.getId()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        view.addObject("personTypeList", (Object)IdType.personList());
        if (StringUtils.isNotEmpty((CharSequence)pd.getProduct_code()) && "GYX".equals(pd.getProduct_code().split("-")[0])) {
            try {
                view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            view.setViewName("/coninsweb/api/gyx/policy/gyx_enterBasicInfo");
        }
    }

    @RequestMapping(value={"/natureChange"})
    @ResponseBody
    public Map<String, String> natureChange(HttpServletRequest request) {
        String nID = request.getParameter("nID");
        if (StringUtils.isNotEmpty((CharSequence)nID)) {
            Map map = NatureLinkage.getMapByProvince((String)nID);
            return map;
        }
        return null;
    }

    private void orderAllot(Long order_id, ModelAndView view) {
        try {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            view.addObject("personTypeList", (Object)IdType.personList());
            if (StringUtils.isEmpty((CharSequence)dto.getProduct_code()) || !"GYX".equals(dto.getProduct_code().split("-")[0])) {
                return;
            }
            GYXPolicyVo vo = this.policyService.accordingToOrderIDToGetGYXPolicyVo(order_id);
            view.addObject("vo", (Object)vo);
            view.setViewName("/coninsweb/api/gyx/policy/gyx_enterBasicInfo");
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (vo == null) {
                return;
            }
            if (vo.getRoleSubjectList().size() > 0) {
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                    view.addObject("reg_cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                    view.addObject("reg_areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="insurance/gyx/policy/policy_iframe/{order_id}")
    @RequestMapping(value={"/policy/confirmPage/{order_id}"})
    public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && "GYX".equals(dto.getProduct_code().split("-")[0])) {
            view.setViewName("/coninsweb/api/gyx/policy/policyConfirm");
            GYXPolicyVo vo = this.policyService.accordingToOrderIDToGetGYXPolicyVo(order_id);
            List typeList = IdType.doList();
            view.addObject("vo", (Object)vo);
            view.addObject("typeList", (Object)typeList);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
        }
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/policy/pendingGYXPolicyVoPolicy"})
    @ResponseBody
    public ResultDto pendingGYXPolicyVoPolicy(GYXPolicyVo vo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String recommendCode = request.getParameter("recommendCode");
        return this.policyService.pendingGYXPolicyVoPolicy(vo, recommendCode);
    }

    @LoginRequired
    @RequestMapping(value={"/policy/updateOrderFormStatus"})
    @ResponseBody
    public ResultDto updateOrderFormStatus(HttpServletRequest request) throws Exception {
        String order_id = request.getParameter("order_id");
        String status = request.getParameter("status");
        if (StringUtils.isEmpty((CharSequence)order_id) || StringUtils.isEmpty((CharSequence)status)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(order_id));
        vo.setPolicy_status(status);
        String orderID = this.policyService.updateOrderFormStatus(vo);
        if (StringUtils.isNotEmpty((CharSequence)orderID)) {
            return new ResultDto("\u8ba2\u5355\u5f55\u5165\u6210\u529f\u3002", "200", orderID, "300", "");
        }
        return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="insurance/gyx/policy/payment_iframe/{order_id}")
    @RequestMapping(value={"/policy/policyPayment/{order_id}"})
    public ModelAndView savePolicy(@PathVariable long order_id, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        try {
            OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(order_id));
            ProductVo pd = this.productService.getProduct(Long.parseLong(vo.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)vo);
            if (StringUtils.isNotEmpty((CharSequence)vo.getPay_methods())) {
                AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(order_id));
                view.setViewName("/coninsweb/api/gyx/transaction/paymentNotice");
                view.addObject("anVo", (Object)anVo);
                view.addObject("nowTime", (Object)new Date());
                this.setTokenByApi(view);
                return view;
            }
            if (vo.getPolicy_status().equals("4")) {
                if ("GYX".equals(pd.getProduct_code().split("-")[0])) {
                    view.setViewName("/coninsweb/api/gyx/transaction/policyPayment_TB");
                }
            } else if (vo.getPolicy_status().equals("5")) {
                view.setViewName("/coninsweb/api/gyx/transaction/finishPay");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.addObject("nowTime", (Object)new Date());
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/sessionInfo"})
    @ResponseBody
    public ResultDto sessionInfo(HttpServletRequest reqeust, ModelMap model) {
        String name = reqeust.getParameter("name");
        String base64 = reqeust.getParameter("base64");
        model.addAttribute(name, (Object)base64);
        return new ResultDto("", "200", "", "", "");
    }

    @RequestMapping(value={"/policy/deleteRoleInPolicyByOid"})
    @ResponseBody
    public ResultDto deleteRoleInPolicyByOid(HttpServletRequest request) {
        String role_id = request.getParameter("role_id");
        if (StringUtils.isEmpty((CharSequence)role_id)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u5220\u9664\u5931\u8d25\uff01", "300", "", "", "");
        }
        if (this.policyService.deleteRoleInPolicyByOid(role_id)) {
            return new ResultDto("\u5220\u9664\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u5220\u9664\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/policy/uploadRoleFile"})
    public ModelAndView uploadRoleFile(MultipartHttpServletRequest request) throws IOException {
        ModelAndView view = new ModelAndView("/coninsweb/api/gmr/policy/b");
        MultipartFile roleFile = request.getFile("role_file");
        ArrayList list = null;
        if (roleFile == null) {
            view.addObject("list", list);
            this.setTokenByApi(view);
            return view;
        }
        InputStream is = roleFile.getInputStream();
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(is);
        list = Lists.newArrayList();
        for (int numSheet = 0; numSheet < xssfWorkbook.getNumberOfSheets(); ++numSheet) {
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
            if (xssfSheet == null) continue;
            for (int rowNum = 1; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                if (xssfRow == null) continue;
                HashMap map = Maps.newHashMap();
                for (int i = 0; i < 6; ++i) {
                    XSSFCell cell = xssfRow.getCell(i);
                    if (cell == null) {
                        map.put(i + "", "");
                        continue;
                    }
                    map.put(i + "", GYX_Policy_API_Controller.getValue(cell));
                }
                list.add(map);
            }
        }
        view.addObject("list", (Object)list);
        this.setTokenByApi(view);
        return view;
    }

    private static String getValue(XSSFCell xssfRow) {
        if (xssfRow.getCellType() == 4) {
            return String.valueOf(xssfRow.getBooleanCellValue());
        }
        if (xssfRow.getCellType() == 0) {
            return String.valueOf(xssfRow.getNumericCellValue());
        }
        return String.valueOf(xssfRow.getStringCellValue());
    }
}

