/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.api.afr;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.MySysInsCompany;
import com.bcxin.ins.core.service.MySysInsCompanyService;
import com.bcxin.ins.entity.policy_special.SpecialPublicDuty;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.ComRegionAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.order.SpecialPublicDutyAPIService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.third.gzx.huatai.util.Policy_ActivityQuotaC;
import com.bcxin.ins.third.gzx.huatai.util.PremiumCalc;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.BLBCommunicationDto;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SessionAttributes(value={"product", "sysInsCompany", "policyExtra"})
@RequestMapping(value={"/api/afr"})
public class PolicyAction_AFR
extends BaseController {
    @Autowired
    private PolicyService policyService;
    private InsInsuranceSlipAPIService insuranceSlipService;
    @Autowired
    private ComRegionAPIService regionService;
    @Autowired
    private ProductService productService;
    @Autowired
    private InsProductAPIService insProductAPIService;
    @Autowired
    private SpecialPublicDutyAPIService specialPublicDutyAPIService;
    @Autowired
    private MySysInsCompanyService mySysInsCompanyService;

    @LoginRequired(redirectUrl="api/afr/index")
    @RequestMapping(value={"/index"})
    public ModelAndView index(HttpServletRequest request, ModelMap model) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/index");
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="api/afr/productInit/{product_id}")
    @RequestMapping(value={"/productInitIframe"})
    public ModelAndView productInitIframe(String url, String product_id) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/order_afr_enter");
        view.addObject("url", (Object)url);
        view.addObject("product_id", (Object)product_id);
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u4ea7\u54c1-\u8bbf\u95ee\u6295\u4fdd\u9875\u9762")
    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="api/afr/productInit/{product_id}")
    @RequestMapping(value={"/productInit/{product_id}"})
    public ModelAndView productInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) {
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        ModelAndView view = null;
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "GZX-HT-ZL".equals(pd.getProduct_code())) {
            view = new ModelAndView("/coninsweb/api/afr/product/ht_productInfo_type_one");
        }
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "GZX-HT-WY".equals(pd.getProduct_code())) {
            view = new ModelAndView("/coninsweb/api/afr/product/ht_productInfo_type_two");
        }
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "GZX-HT-TY".equals(pd.getProduct_code())) {
            view = new ModelAndView("/coninsweb/api/afr/product/ht_productInfo_type_three");
        }
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "GZX-HT-QT".equals(pd.getProduct_code())) {
            view = new ModelAndView("/coninsweb/api/afr/product/ht_productInfo_type_four");
        }
        view.addObject("productDto", (Object)pd);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="api/afr/policyInit/{product_id}")
    @RequestMapping(value={"/policyInit/{product_id}"})
    public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/policy/afr_enter_basic_info");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        ProPrimary product = this.insProductAPIService.getProduct(product_id);
        MySysInsCompany sysInsCompany = (MySysInsCompany)this.mySysInsCompanyService.selectById((Serializable)product.getSupplier().getSys_ins_company_id());
        SpecialPublicDutyVo vo = new SpecialPublicDutyVo();
        if (StringUtils.isNotEmpty((CharSequence)userdetail.getWeb_type()) && userdetail.getWeb_type().contains("PSS")) {
            List actList = this.policyService.getBLBCommunicationDtoByUserID_PSSAPI(userdetail.getWeb_id(), pd.getProduct_code().split("-")[2], userdetail.getWeb_type(), "");
            List roleList = this.policyService.getRoleSubjectVoByUserID_PSSAPI(userdetail.getWeb_id(), userdetail.getWeb_type());
            if (roleList != null) {
                vo.setRoleSubjectList(roleList);
            }
            view.addObject("acts", (Object)actList);
        }
        view.addObject("vo", (Object)vo);
        view.addObject("pd", (Object)pd);
        view.addObject("product", (Object)product);
        view.addObject("sysInsCompany", (Object)sysInsCompany);
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"1#product_id", "2#order_id"}, redirectUrl="api/afr/policyUpdInit/{product_id}/{order_id}")
    @RequestMapping(value={"/policyUpdInit/{product_id}/{order_id}"})
    public ModelAndView policyUpdInit(HttpServletRequest request, @PathVariable Long product_id, @PathVariable Long order_id, ModelMap model) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/policy/afr_enter_basic_info");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        ProPrimary product = this.insProductAPIService.getProduct(product_id);
        MySysInsCompany sysInsCompany = (MySysInsCompany)this.mySysInsCompanyService.selectById((Serializable)product.getSupplier().getSys_ins_company_id());
        view.addObject("pd", (Object)pd);
        view.addObject("product", (Object)product);
        view.addObject("sysInsCompany", (Object)sysInsCompany);
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && "GZX".equals(dto.getProduct_code().split("-")[0])) {
            SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
            if (StringUtils.isNotEmpty((CharSequence)userdetail.getWeb_type()) && userdetail.getWeb_type().contains("PSS")) {
                List actList = this.policyService.getBLBCommunicationDtoByUserID_PSSAPI(userdetail.getWeb_id(), pd.getProduct_code().split("-")[2], userdetail.getWeb_type(), vo.getThr_order_id());
                view.addObject("acts", (Object)actList);
            }
            view.addObject("vo", (Object)vo);
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (vo.getRoleSubjectList() != null) {
                view.addObject("cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
                view.addObject("areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
                view.addObject("reg_city_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province()));
                view.addObject("reg_area_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city()));
            }
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="api/afr/productInit/productChange")
    @RequestMapping(value={"/productInit/productChange"})
    public ModelAndView policyInit(HttpServletRequest request, ModelMap model) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/product/product_list_change");
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/getActivityByPss/{thr_order_id}"})
    @ResponseBody
    public String getActivityByPss(@PathVariable String thr_order_id) {
        String result = "";
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return result;
        }
        try {
            BLBCommunicationDto dto = this.policyService.getBLBCommunicationDtoByOrderID_PSSAPI(thr_order_id, userdetail.getWeb_type());
            if (dto != null) {
                result = JSONObject.toJSONString((Object)dto);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/premiumCalc"})
    @ResponseBody
    public ResultDto premiumCalc(ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        try {
            String activityLocal = request.getParameter("activity_local");
            String guest = request.getParameter("guest");
            String danger = request.getParameter("danger");
            String activityFireFight = request.getParameter("activity_fire_fight");
            String startDate = request.getParameter("report_begin_date");
            String endDate = request.getParameter("report_end_date");
            String policyAmount = request.getParameter("insured_amount");
            String activityType = request.getParameter("report_active");
            String policyExtrapeopleNum = request.getParameter("people_num");
            ProPrimary product = (ProPrimary)model.get((Object)"product");
            SpecialPublicDuty policyExtra = new SpecialPublicDuty();
            if (StringUtils.isNotEmpty((CharSequence)activityType)) {
                policyExtra.setActivity_type(activityType);
            }
            if (StringUtils.isNotEmpty((CharSequence)policyExtrapeopleNum)) {
                policyExtra.setActivity_scale(policyExtrapeopleNum);
            }
            policyExtra.setPeople_num(policyExtrapeopleNum);
            policyExtra.setActivity_fire_fight(activityFireFight);
            policyExtra.setGuest(guest);
            policyExtra.setDanger(danger);
            policyExtra.setActivity_local(activityLocal);
            policyExtra.setAmount(policyAmount);
            if (StringUtils.isNotEmpty((CharSequence)startDate) && StringUtils.isNotEmpty((CharSequence)endDate)) {
                policyExtra.setInsure_days(DateUtil.getDistDates((Date)DateUtil.convertStringToDate((String)startDate.trim()), (Date)DateUtil.convertStringToDate((String)endDate.trim())) + "");
            }
            PremiumCalc calc = new PremiumCalc();
            model.put((Object)"policyExtra", (Object)policyExtra);
            BigDecimal premium = calc.calc(product, policyExtra, "HT");
            if (premium != null) {
                return new ResultDto("" + premium, "200", "", "", "");
            }
            return new ResultDto("\u83b7\u53d6\u4fdd\u8d39\u5931\u8d25", "300", "", "", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ResultDto("\u83b7\u53d6\u4fdd\u8d39\u5931\u8d25", "300", "", "", "");
        }
    }

    @RequestMapping(value={"/limitAmountCalc"})
    @ResponseBody
    public String limitAmountCalc(ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        String limitStr = "";
        try {
            SpecialPublicDuty policyExtra;
            String policyExtrapeopleNum = request.getParameter("people_num");
            if (StringUtils.isEmpty((CharSequence)policyExtrapeopleNum)) {
                policyExtrapeopleNum = "1000";
            }
            if ((policyExtra = (SpecialPublicDuty)model.get((Object)"policyExtra")) == null) {
                policyExtra = new SpecialPublicDuty();
            }
            policyExtra.setActivity_quota(policyExtrapeopleNum);
            Policy_ActivityQuotaC quota = Policy_ActivityQuotaC.getLevel((String)(policyExtra.getActivity_quota() == null ? "0" : policyExtra.getActivity_quota()));
            Map map = Policy_ActivityQuotaC.calcLimit((Policy_ActivityQuotaC)quota);
            policyExtra.setMin_limit((String)map.get("minLimit"));
            policyExtra.setMax_limit((String)map.get("maxLimit"));
            limitStr = policyExtra.getMin_limit() + "#" + policyExtra.getMax_limit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "500#3500";
        }
        return limitStr.toString();
    }

    @RequestMapping(value={"/policy/a"})
    public ModelAndView a() throws Exception {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/policy/afr_init_page");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/api/afr/policy/a");
        }
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @LoginRequired
    @RequestMapping(value={"/policy/pendingAFRPolicyVoPolicy"})
    @ResponseBody
    public ResultDto pendingAFRPolicyVoPolicy(SpecialPublicDutyVo vo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
            String orderID = "";
            if (StringUtils.isNotEmpty((CharSequence)vo.getProduct_id())) {
                String recommendCode = request.getParameter("recommendCode");
                orderID = this.createOrderAndGetOrderIDByProductID(Long.parseLong(vo.getProduct_id()), Long.parseLong(userdetail.getOid()), recommendCode, "");
            }
            if (StringUtils.isNotEmpty((CharSequence)orderID)) {
                vo.setOid(orderID);
            } else {
                return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
            }
        }
        Map map = null;
        try {
            if (null == vo.getMailPolicyVo().getNeed_receipt()) {
                vo.getMailPolicyVo().setNeed_receipt("0");
            }
            if (null == vo.getMailPolicyVo().getNeed_insur_bill()) {
                vo.getMailPolicyVo().setNeed_insur_bill("1");
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getInsured_amount())) {
                vo.setInsured_amount(String.valueOf(new BigDecimal(vo.getInsured_amount()).multiply(new BigDecimal("10000"))));
            }
            map = this.policyService.obtainSpecialPublicDutyVoSetUp(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (map != null) {
            return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
        }
        return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    private String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode, String trade_serial_number) {
        Map map = this.policyService.createOrderFormByProductOid(product_id, user_id, recommendCode, trade_serial_number);
        if (map.get("order_id") != null) {
            return (String)map.get("order_id");
        }
        return "";
    }

    @LoginRequired(methodParamKey={"1#order_id"}, redirectUrl="api/afr/policy/{order_id}")
    @RequestMapping(value={"/policy/{order_id}"})
    public ModelAndView enterInfo(HttpServletRequest request, @PathVariable Long order_id) {
        ModelAndView view = new ModelAndView("");
        this.orderAllot(order_id, view);
        this.setTokenByApi(view);
        return view;
    }

    private void orderAllot(Long order_id, ModelAndView view) {
        try {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && "GZX".equals(dto.getProduct_code().split("-")[0])) {
                SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
                view.addObject("vo", (Object)vo);
                view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
                view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
                view.setViewName("/coninsweb/api/afr/policy/afr_policy_confirm");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @LoginRequired
    @RequestMapping(value={"/policy/updateOrderFormStatus"})
    @ResponseBody
    public ResultDto updateOrderFormStatus(HttpServletRequest request) throws Exception {
        String order_id = request.getParameter("order_id");
        String status = request.getParameter("status");
        if (StringUtils.isEmpty((CharSequence)order_id) || StringUtils.isEmpty((CharSequence)status)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(order_id));
        vo.setPolicy_status(status);
        String orderID = this.policyService.updateOrderFormStatus(vo);
        if (StringUtils.isNotEmpty((CharSequence)orderID)) {
            return new ResultDto("\u8ba2\u5355\u5f55\u5165\u6210\u529f\u3002", "200", orderID, "", "");
        }
        return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="policy/policyPayment/{order_id}")
    @RequestMapping(value={"/policy/policyPayment/{order_id}"})
    public ModelAndView savePolicy(@PathVariable long order_id, HttpServletRequest request) {
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(order_id));
        ProductVo pd = this.productService.getProduct(Long.parseLong(vo.getProduct_oid()));
        ModelAndView view = null;
        if (!vo.getPolicy_status().equals("4")) {
            return new ModelAndView("/");
        }
        view = new ModelAndView("/coninsweb/api/afr/policy/afr_policy_pay");
        SpecialPublicDutyVo publicDutyVo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(Long.valueOf(order_id));
        view.addObject("vo", (Object)publicDutyVo);
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)vo);
        view.addObject("nowTime", (Object)new Date());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"1#order_id"}, redirectUrl="policy/detail/{order_id}")
    @RequestMapping(value={"/policy/detail/{order_id}"})
    public ModelAndView policyDetail(HttpServletRequest request, @PathVariable Long order_id) {
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/policyDetails/afr_policy_detail");
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
        view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        view.addObject("vo", (Object)vo);
        this.setTokenByApi(view);
        return view;
    }
}

