/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller;

import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStragegyFactory;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/order-handle"})
public class OrderHandleController
extends BaseController {
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u4ea7\u54c1-\u8bbf\u95ee\u6295\u4fdd\u9875")
    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="order-handle/open-policy-init/{product_id}")
    @RequestMapping(value={"/policy-init/{product_id}"})
    public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id) {
        return this.getStrategy(OrderSupplyType.OrderSupplyTypeEnum.POLICY_INIT.getKey()).policyInitService(request, product_id);
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="order-handle/open-get-policy/{order_id}")
    @RequestMapping(value={"/get-policy/{order_id}/{page}"})
    public ModelAndView getPolicy(@PathVariable Long order_id, @PathVariable int page) {
        return this.getStrategy(OrderSupplyType.OrderSupplyTypeEnum.GET_POLICY.getKey()).getPolicyService(order_id, page);
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="order-handle/open-get-policy/{order_id}")
    @RequestMapping(value={"/confirm-policy/{order_id}"})
    public ModelAndView confirmPolicy(@PathVariable Long order_id) throws Exception {
        return this.getStrategy(OrderSupplyType.OrderSupplyTypeEnum.CONFIRM_POLICY.getKey()).confirmPolicyService(order_id);
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/pending-policy"})
    @ResponseBody
    public ResultDto pendingPolicy(Object object, HttpServletRequest request) throws Exception {
        return this.getStrategy(OrderSupplyType.OrderSupplyTypeEnum.PENDING_POLICY.getKey()).pendingPolicyService(object, request);
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="order-handle/open-payment-request/{order_id}")
    @RequestMapping(value={"/payment-request/{order_id}"})
    public ModelAndView paymentRequest(@PathVariable long order_id) {
        return this.getStrategy(OrderSupplyType.OrderSupplyTypeEnum.PAYMENT_REQUEST.getKey()).paymentRequestService(order_id);
    }

    @LoginRequired
    @RequestMapping(value={"/underwriting-request"})
    @ResponseBody
    public ResultDto underwritingRequest(HttpServletRequest request) {
        return this.getStrategy(OrderSupplyType.OrderSupplyTypeEnum.UNDERWRITING_REQUEST.getKey()).underwritingRequestService(request);
    }

    @LoginRequired
    @RequestMapping(value={"/update-policy-status-request"})
    @ResponseBody
    public ResultDto updatePolicyStatusRequest(HttpServletRequest request) {
        return this.policyService.updateOrderFormStatusByRequest(request);
    }

    @RequestMapping(value={"/open-policy-init/{product_id}"})
    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="order-handle/open-policy-init/{product_id}")
    public String openPolicyInit(@PathVariable long product_id) {
        ProductVo pd = this.productService.getProduct(product_id);
        String loadUrl = !StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && (pd.getProduct_code().indexOf("GYX") != -1 || pd.getProduct_code().indexOf("TYX") != -1 || pd.getProduct_code().indexOf("GZX-PAC") != -1 || pd.getProduct_code().indexOf("ZZX") != -1 || pd.getProduct_code().indexOf("GZZRX") != -1) ? "forward:/order-handle/open-iframe-policy-init/" + product_id : "forward:/order-handle/policy-init/" + product_id;
        return loadUrl;
    }

    @RequestMapping(value={"/open-iframe-policy-init/{product_id}"})
    public ModelAndView openIframePolicyInit(@PathVariable long product_id) {
        ModelAndView view = new ModelAndView("/coninsweb/api/order/open_iframe_policy_init");
        view.addObject("product_id", (Object)product_id);
        return view;
    }

    @RequestMapping(value={"/open-get-policy/{order_id}"})
    @LoginRequired(methodParamKey={"1#order_id"}, redirectUrl="order-handle/open-get-policy/{order_id}")
    public String openGetPolicy(@PathVariable long order_id) {
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(order_id));
        String loadUrl = !StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && (vo.getProduct_code().indexOf("GYX") != -1 || vo.getProduct_code().indexOf("TYX") != -1 || vo.getProduct_code().indexOf("GZX-PAC") != -1 || vo.getProduct_code().indexOf("ZZX") != -1 || vo.getProduct_code().indexOf("GZZRX") != -1) ? "forward:/order-handle/open-iframe-get-policy/" + order_id : "forward:/order-handle/get-policy/" + order_id;
        return loadUrl;
    }

    @RequestMapping(value={"/open-iframe-get-policy/{order_id}"})
    public ModelAndView openIframeGetPolicy(@PathVariable long order_id) {
        ModelAndView view = new ModelAndView("/coninsweb/api/order/open_iframe_get_policy");
        view.addObject("order_id", (Object)order_id);
        return view;
    }

    @RequestMapping(value={"/open-payment-request/{order_id}"})
    @LoginRequired(methodParamKey={"1#order_id"}, redirectUrl="order-handle/open-payment-request/{order_id}")
    public String openPaymentRequest(@PathVariable long order_id) {
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(order_id));
        String loadUrl = !StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && (vo.getProduct_code().indexOf("GYX") != -1 || vo.getProduct_code().indexOf("TYX") != -1 || vo.getProduct_code().indexOf("GZX-PAC") != -1 || vo.getProduct_code().indexOf("ZZX") != -1 || vo.getProduct_code().indexOf("GZZRX") != -1) ? "forward:/order-handle/open-iframe-payment-request/" + order_id : "forward:/order-handle/payment-request/" + order_id;
        return loadUrl;
    }

    @RequestMapping(value={"/open-iframe-payment-request/{order_id}"})
    public ModelAndView openIframePaymentRequest(@PathVariable long order_id) {
        ModelAndView view = new ModelAndView("/coninsweb/api/order/open_iframe_payment_request");
        view.addObject("order_id", (Object)order_id);
        return view;
    }

    private OrderSupplyStrategy getStrategy(String type) {
        return OrderSupplyStragegyFactory.getStrategy(type);
    }
}

