/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.common.controller;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.ComRegionAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.GYXPolicyVo;
import com.bcxin.ins.vo.InsOrderSearchVo;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.SpecialLitigationVo_1;
import com.bcxin.ins.vo.SpecialLitigationVo_2;
import com.bcxin.ins.vo.SpecialLitigationVo_3;
import com.bcxin.ins.vo.SpecialPerformanceVo_1;
import com.bcxin.ins.vo.SpecialPerformanceVo_2;
import com.bcxin.ins.vo.SpecialPerformanceVo_3;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/pc/order"})
public class OrderController
extends BaseController {
    @Autowired
    private ComRegionAPIService regionService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipAPIService;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;
    private static String POLICYTOTALS = "policyTotals";
    private static String POLICYSTATUS = "policyStatus";
    private static String TYPELIST = "typeList";
    private static String NATURELIST = "natureList";

    @RequestMapping(value={"myOrder"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355")
    public ModelAndView myOrderListInit(String policyStatus, DwzPage page) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/pc/order/myOrder?policyStatus=" + policyStatus);
        }
        if (GlobalResources.IS_POLICY_TP107001_OPEN.equals("YES")) {
            this.myAsyncExecutor.execute(() -> this.policyService.policyEndStatus(userdetail.getOid()));
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/order/pc_order_list");
        if (StringUtils.isEmpty((CharSequence)policyStatus) || "null".equals(policyStatus)) {
            policyStatus = "1";
        }
        page.setNumPerPage(5);
        String keyword = this.getRequest().getParameter("keyword");
        String starDate = this.getRequest().getParameter("starDate");
        String endDate = this.getRequest().getParameter("endDate");
        InsOrderSearchVo search = InsOrderSearchVo.build((Long)Long.parseLong(userdetail.getOid()), (String)policyStatus, (String)"", (String)keyword, (String)starDate, (String)endDate, (String)"", (DwzPage)page);
        view.addObject("userdetail", (Object)userdetail);
        view.addObject(POLICYTOTALS, (Object)this.policyService.findTotalPolicyNum(search));
        List orderList = this.policyService.findPolicyForPage(search);
        view.addObject("orderList", (Object)orderList);
        view.addObject(POLICYSTATUS, (Object)policyStatus);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"tabTotal"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8ba2\u5355-\u5404\u72b6\u6001\u503c\u6c47\u603b")
    public ModelAndView tabTotal(String policyStatus) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/order/tabTotal");
        if (StringUtils.isEmpty((CharSequence)policyStatus) || "null".equals(policyStatus)) {
            policyStatus = "1";
        }
        if (userdetail == null) {
            return new ModelAndView("redirect:/user/login");
        }
        String keyword = this.getRequest().getParameter("keyword");
        String starDate = this.getRequest().getParameter("starDate");
        String endDate = this.getRequest().getParameter("endDate");
        InsOrderSearchVo search = InsOrderSearchVo.build((Long)Long.parseLong(userdetail.getOid()), (String)policyStatus, (String)"", (String)keyword, (String)starDate, (String)endDate, (String)"", null);
        view.addObject(POLICYTOTALS, (Object)this.policyService.findTotalPolicyNum(search));
        view.addObject(POLICYSTATUS, (Object)policyStatus);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"getPcOrderListForPage"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8ba2\u5355-\u83b7\u53d6\u5404\u6807\u7b7e\u8ba2\u5355\u5217\u8868")
    public ModelAndView getPcOrderListForPage(String policyStatus, DwzPage page) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView("redirect:/synopsis/unSession");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/order/pc_order_list_table");
        String keyword = this.getRequest().getParameter("keyword");
        String starDate = this.getRequest().getParameter("starDate");
        String endDate = this.getRequest().getParameter("endDate");
        try {
            InsOrderSearchVo search = InsOrderSearchVo.build((Long)Long.parseLong(userdetail.getOid()), (String)policyStatus, (String)"", (String)keyword, (String)starDate, (String)endDate, (String)"", (DwzPage)page);
            view.addObject("orderList", (Object)this.policyService.findPolicyForPage(search));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"getOnGoingOrderListForPage"})
    public ModelAndView getOnGoingOrderListForPage(String policyStatus, DwzPage page) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView("redirect:/synopsis/unSession");
        }
        String keyword = this.getRequest().getParameter("keyword");
        String starDate = this.getRequest().getParameter("starDate");
        String endDate = this.getRequest().getParameter("endDate");
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/order/pc_order_list_table");
        InsOrderSearchVo search = InsOrderSearchVo.build((Long)Long.parseLong(userdetail.getOid()), (String)policyStatus, (String)"", (String)keyword, (String)starDate, (String)endDate, (String)"", (DwzPage)page);
        view.addObject("orderList", (Object)this.policyService.findPolicyForPage(search));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"exportDetailByOrderID/{order_id}"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8ba2\u5355-\u51fa\u53e3\u9669\u8ba2\u5355\u8be6\u60c5")
    public ModelAndView exportDetailByOrderID(@PathVariable Long order_id, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/pc/order/exportDetailByOrderID/" + order_id);
        }
        view.addObject("userdetail", (Object)userdetail);
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        if (dto == null) {
            return view;
        }
        view.addObject("dto", (Object)dto);
        if (StringUtils.isEmpty((CharSequence)dto.getProduct_code())) {
            return view;
        }
        if ("XYX-XWCK".equals(dto.getProduct_code())) {
            view.setViewName("/coninsweb/personalCenter/order/policyDetail_mi");
            MicroExportVo vo = this.policyService.accordingToOrderIDToGetMicroExportVo(order_id);
            if (StringUtils.isEmpty((CharSequence)dto.getInsure_path()) && "6".equals(dto.getPolicy_status())) {
                String path = this.policyService.HTTP_TPC_XYX_DZBD(Long.valueOf(Long.parseLong(dto.getOid())));
                dto.setInsure_path(path);
            }
            view.addObject("vo", (Object)vo);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_rule", (Object)(RegionUtils.getRegionNameByALLCode((String)vo.getLawsuit_province(), (String)vo.getLawsuit_city(), (String)vo.getLawsuit_area()) + vo.getLawsuit_address()));
        } else if ("XYX-DQCK".equals(dto.getProduct_code())) {
            view.setViewName("/coninsweb/personalCenter/order/policyDetail_qy");
            CommonExportVo_1 vo1 = this.policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
            CommonExportVo_2 vo2 = this.policyService.accordingToOrderIDToGetCommonExportVo_2(order_id);
            CommonExportVo_3 vo3 = this.policyService.accordingToOrderIDToGetCommonExportVo_3(order_id);
            view.addObject("vo1", (Object)vo1);
            view.addObject("vo2", (Object)vo2);
            view.addObject("vo3", (Object)vo3);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_district()));
        } else if ("BZX-TB-GCTB".equals(dto.getProduct_code()) || "BZX-YG-GCTB".equals(dto.getProduct_code()) || "BZX-DB-GCTB".equals(dto.getProduct_code())) {
            view.setViewName("/coninsweb/personalCenter/order/policyDetail_bd");
            SpecialBidVo vo = this.policyService.accordingToOrderIDToGetSpecialBidVo(order_id);
            view.addObject("otList", (Object)OfficeType.listT((String)(dto.getProduct_code().contains("DB") ? "DB" : "OT")));
            view.addObject("vo", (Object)vo);
            view.addObject("reg_policy", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getProvince(), (String)vo.getCity(), (String)vo.getArea_code()));
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        } else if ("BZX-GCLY".equals(dto.getProduct_code())) {
            view.setViewName("/coninsweb/personalCenter/order/policyDetail_ly");
            SpecialPerformanceVo_1 vo1 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_1(order_id);
            SpecialPerformanceVo_2 vo2 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_2(order_id);
            SpecialPerformanceVo_3 vo3 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_3(order_id);
            view.addObject("vo1", (Object)vo1);
            view.addObject("vo2", (Object)vo2);
            view.addObject("vo3", (Object)vo3);
            view.addObject("reg_policy", (Object)RegionUtils.getRegionNameByALLCode((String)vo1.getProvince(), (String)vo1.getCity(), (String)vo1.getArea_code()));
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_district()));
        } else if ("BZX-SSBQ".equals(dto.getProduct_code())) {
            view.setViewName("/coninsweb/personalCenter/order/policyDetail_ss");
            SpecialLitigationVo_1 vo1 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_1(order_id);
            SpecialLitigationVo_2 vo2 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_2(order_id);
            SpecialLitigationVo_3 vo3 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_3(order_id);
            view.addObject("vo1", (Object)vo1);
            view.addObject("vo2", (Object)vo2);
            view.addObject("vo3", (Object)vo3);
            view.addObject("reg_policy", (Object)RegionUtils.getRegionNameByALLCode((String)vo1.getProvince(), (String)vo1.getCity(), (String)vo1.getArea_code()));
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_district()));
        } else if ("TYX".equals(dto.getProduct_code().split("-")[0])) {
            view.setViewName("/coninsweb/insurance/tyx/policyDetails/gmr_policyDetail");
            GMRPolicyVo vo = this.policyService.accordingToOrderIDToGetGMRPolicyVo(order_id);
            if (vo != null) {
                view.addObject("vo", (Object)vo);
                List typeList = IdType.doList();
                List natureList = NatureLinkage.doList();
                view.addObject(TYPELIST, (Object)typeList);
                view.addObject(NATURELIST, (Object)natureList);
                view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
                if (vo.getSpecialExhibitionVo() != null) {
                    view.addObject("ex_pca", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getSpecialExhibitionVo().getEx_province(), (String)vo.getSpecialExhibitionVo().getEx_city(), (String)vo.getSpecialExhibitionVo().getEx_county()));
                }
            }
        } else if ("GYX".equals(dto.getProduct_code().split("-")[0])) {
            view.setViewName("/coninsweb/insurance/gyx/policyDetails/gyx_policyDetail");
            GYXPolicyVo vo = this.policyService.accordingToOrderIDToGetGYXPolicyVo(order_id);
            if (vo != null) {
                List typeList = IdType.doList();
                view.addObject("vo", (Object)vo);
                view.addObject(TYPELIST, (Object)typeList);
                view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            }
        } else if (dto.getProduct_code().indexOf("GZX-HT") != -1) {
            view.setViewName("/coninsweb/insurance/gzx/policyDetails/gzx_policy_detail");
            SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
            view.addObject("pd", (Object)this.productService.getProduct(Long.parseLong(dto.getProduct_oid())));
            view.addObject("comTypeList", (Object)IdType.comList());
            List natureList = NatureLinkage.doList();
            view.addObject(NATURELIST, (Object)natureList);
            view.addObject("vo", (Object)vo);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        } else if (dto.getProduct_code().indexOf("GZX-PAC") != -1) {
            view.setViewName("/coninsweb/insurance/gzx/policyDetails/gzx_policy_detail");
            SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
            view.addObject("pd", (Object)this.productService.getProduct(Long.parseLong(dto.getProduct_oid())));
            view.addObject("comTypeList", (Object)IdType.comList());
            List natureList = NatureLinkage.doList();
            view.addObject(NATURELIST, (Object)natureList);
            view.addObject("vo", (Object)vo);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        } else if ("ZZX".equals(dto.getProduct_code().split("-")[0])) {
            view.setViewName("/coninsweb/insurance/zzx/policyDetails/lote_policy_detail");
            view.addObject("pd", (Object)this.productService.getProduct(Long.parseLong(dto.getProduct_oid())));
            LOTEPolicyVo vo = this.policyService.accordingToOrderIDToGetLOTEPolicyVo(order_id);
            view.addObject("comTypeList", (Object)IdType.comList());
            List natureList = NatureLinkage.doList();
            view.addObject(NATURELIST, (Object)natureList);
            view.addObject("vo", (Object)vo);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
            view.addObject("ex_pca", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getSpecialExhibitionVo().getEx_province(), (String)vo.getSpecialExhibitionVo().getEx_city(), (String)vo.getSpecialExhibitionVo().getEx_county()));
        } else if (dto.getProduct_code().contains("GZZRX")) {
            view.setViewName("/coninsweb/insurance/gzzrx/policyDetails/gzzrx_policy_detail");
            view.addObject("pd", (Object)this.productService.getProduct(Long.parseLong(dto.getProduct_oid())));
            SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
            List typeList = IdType.doList();
            List natureList = NatureLinkage.doList();
            view.addObject(TYPELIST, (Object)typeList);
            view.addObject(NATURELIST, (Object)natureList);
            view.addObject("vo", (Object)vo);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/orderDetail_iframe/{oid}"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8ba2\u5355-\u8ba2\u5355\u8be6\u60c5")
    public ModelAndView orderDetail_iframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/order_detail");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/pc/order/orderDetail_iframe/" + oid);
        }
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("order_id", (Object)String.valueOf(oid));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"deletePolicy"})
    public JSONObject deletePolicyByOid(long policyId) {
        JSONObject json = new JSONObject();
        String message = "";
        String status = "300";
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(policyId));
        if (!"4".equals(dto.getPolicy_status()) && !"1".equals(dto.getPolicy_status())) {
            message = SysDictUtils.getDictLabel((String)dto.getPolicy_status(), (String)"order_status", (String)"") + "\u65e0\u6cd5\u5220\u9664\uff01";
        } else {
            dto.setPolicy_status("13");
            String orderID = this.policyService.updateOrderFormStatus(dto);
            if (StringUtils.isNotEmpty((CharSequence)orderID)) {
                message = "\u8ba2\u5355\u5220\u9664\u6210\u529f\uff01";
                status = "200";
            } else {
                message = "\u8ba2\u5355\u5220\u9664\u5931\u8d25\uff01";
            }
        }
        json.put((Object)"message", (Object)message);
        json.put((Object)"status", (Object)status);
        return json;
    }

    @RequestMapping(value={"copyOrder"})
    @ResponseBody
    public ResultDto copyOrder(HttpServletRequest request) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ResultDto("\u7528\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01", "300", "", "", "");
        }
        String order_id = request.getParameter("order_id");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return new ResultDto("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", "300", "", "", "");
        }
        if (this.isCopyCount(userdetail.getOid())) {
            return new ResultDto("\u590d\u5236\u529f\u80fd\u4f7f\u7528\u6b21\u6570\u5df2\u8d85\u8fc7\u4e0a\u9650\uff01", "300", "", "", "");
        }
        return this.policyService.copyPolicy(Long.valueOf(Long.parseLong(order_id)));
    }

    private boolean isCopyCount(String uId) {
        String key = "BLB:CACHE:COPY-" + uId;
        String countStr = JedisUtils.get((String)key);
        int count = 1;
        if (StringUtils.isNotEmpty((CharSequence)countStr)) {
            count = Integer.parseInt(countStr);
            if (count == 10) {
                return true;
            }
            ++count;
        }
        JedisUtils.set((String)key, (String)(count + ""), (int)ConstProp.ONE_DAY_TIMEOUT_SECONDS);
        return false;
    }

    @RequestMapping(value={"deleteExportOrder"})
    @ResponseBody
    public JSONObject deleteExportOrder(HttpServletRequest reqeust) {
        JSONObject json = new JSONObject();
        String message = "";
        String status = "300";
        String order_id = reqeust.getParameter("order_id");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(order_id)));
        if (!"4".equals(dto.getPolicy_status()) && !"1".equals(dto.getPolicy_status())) {
            message = "\u72b6\u6001\u4e3a\uff1a" + SysDictUtils.getDictLabel((String)dto.getPolicy_status(), (String)"order_status", (String)"") + " \u8ba2\u5355\u65e0\u6cd5\u5220\u9664\uff01";
        } else {
            dto.setPolicy_status("13");
            String orderID = this.policyService.updateOrderFormStatus(dto);
            if (StringUtils.isNotEmpty((CharSequence)orderID)) {
                message = "\u8ba2\u5355\u5220\u9664\u6210\u529f\uff01";
                status = "200";
            } else {
                message = "\u8ba2\u5355\u5220\u9664\u5931\u8d25\uff01";
            }
        }
        json.put((Object)"message", (Object)message);
        json.put((Object)"status", (Object)status);
        return json;
    }

    @RequestMapping(value={"addRemarksByOrder"})
    @ResponseBody
    public JSONObject addRemarksByOrder(HttpServletRequest reqeust) {
        String message;
        JSONObject json = new JSONObject();
        String status = "300";
        String remarks = reqeust.getParameter("remarks");
        String order_id = reqeust.getParameter("order_id");
        if (StringUtils.isNotEmpty((CharSequence)remarks) && StringUtils.isNotEmpty((CharSequence)order_id)) {
            this.insInsuranceSlipAPIService.addRemarksByOrder(remarks, Long.valueOf(Long.parseLong(order_id)));
            message = "\u8ba2\u5355\u66f4\u65b0\u5907\u6ce8\u6210\u529f\uff01";
            status = "200";
        } else {
            message = "\u8ba2\u5355id\u3001\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        json.put((Object)"message", (Object)message);
        json.put((Object)"status", (Object)status);
        return json;
    }

    @RequestMapping(value={"policyReport"})
    public ModelAndView policyReport() {
        ModelAndView view = new ModelAndView("/coninsweb/api/gmr/gmr_order_report");
        this.setTokenByApi(view);
        return view;
    }
}

