/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.aspect;

import com.bcxin.ins.aspect.LogManager;
import com.bcxin.ins.core.entity.SysLog;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.cache.BaseUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ClientUserVo;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LogAspect {
    private static final Logger logger = LoggerFactory.getLogger(LogAspect.class);
    private static final ThreadLocal<SysLog> sysLogThreadLocal = new NamedThreadLocal("ThreadLocal SysLog");

    public LogAspect() {
        System.out.println("\u521d\u59cb\u5316\u65e5\u5fd7\u5207\u9762 LogAspect=======================");
    }

    private void saveLog(Map<String, Object> map, Throwable e) {
        if (map == null) {
            return;
        }
        String title = map.containsKey("title") ? map.get("title").toString() : "";
        String source = map.containsKey("source") ? map.get("source").toString() : "";
        String methodName = map.containsKey("methodName") ? map.get("methodName").toString() : "";
        String className = map.containsKey("className") ? map.get("className").toString() : "";
        Date startDate = map.containsKey("start") ? (Date)map.get("start") : null;
        Date endDate = map.containsKey("end") ? (Date)map.get("end") : null;
        Long speedTime = map.containsKey("spendTime") ? (Long)map.get("spendTime") : null;
        String ip = BaseUtils.getSubject().getSession().getHost();
        String companyOrUserId = null;
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail != null) {
            companyOrUserId = userdetail.getOid();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        SysLog log = new SysLog();
        if (e == null) {
            log.setType("1");
            log.setStart(startDate);
            log.setEnd(endDate);
            log.setSpeedTime(speedTime);
        } else {
            log.setType("2");
            log.setException(e.toString());
        }
        log.setCompany_id(companyOrUserId);
        log.setClassName(className);
        log.setMethodName(methodName);
        log.setSource(source);
        log.setRemoteAddr(ip);
        log.setRequestUri(request.getRequestURI());
        log.setTitle(title);
        log.setRemoteAddr(StrUtil.getRemoteAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("user-agent"));
        log.setRequestUri(request.getRequestURI());
        Map params = request.getParameterMap();
        if (params.size() < 100) {
            log.setParams(request.getParameterMap());
        }
        log.setMethod(request.getMethod());
        if (e != null) {
            LogManager.addLog(log);
        } else {
            sysLogThreadLocal.set(log);
        }
    }

    @Pointcut(value="@annotation(com.bcxin.ins.spring.annotation.OperationLog)")
    public void controllerAspect() {
    }

    @AfterThrowing(pointcut="controllerAspect()", throwing="e")
    public void doAfterThrowing(JoinPoint point, Throwable e) {
        try {
            Map<String, Object> map = this.getControllerMethodDescription(point);
            this.saveLog(map, e);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Before(value="controllerAspect()")
    public void doBefore(JoinPoint joinPoint) {
        if (logger.isInfoEnabled()) {
            logger.info("before " + joinPoint);
        }
    }

    @Around(value="controllerAspect()")
    public Object doAroundController(ProceedingJoinPoint point) {
        Object result = null;
        String methodName = point.getSignature().getName();
        String className = point.getTarget().getClass().getName();
        Map<String, Object> map = null;
        Long time = 0L;
        try {
            map = this.getControllerMethodDescription((JoinPoint)point);
            Date start = new Date();
            result = point.proceed();
            Date end = new Date();
            time = end.getTime() - start.getTime();
            map.put("start", start);
            map.put("end", end);
            map.put("spendTime", time);
            map.put("methodName", methodName);
            map.put("className", className);
            this.saveLog(map, null);
        }
        catch (Throwable e) {
            logger.error("====\u901a\u77e5\u5f02\u5e38====");
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new ExceptionInInitializerError(e);
        }
        return result;
    }

    @AfterReturning(value="controllerAspect()")
    public void doAfterInServiceLayer(JoinPoint joinPoint) {
        if (sysLogThreadLocal.get() != null) {
            SysLog log = sysLogThreadLocal.get();
            HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
            System.out.print(response.getStatus());
            log.setResponseStatus(response.getStatus() + "");
            LogManager.addLog(log);
        }
    }

    public Map<String, Object> getControllerMethodDescription(JoinPoint joinPoint) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        String params = "";
        for (Method method : methods) {
            Class<?>[] clazzs;
            if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
            map.put("title", method.getAnnotation(OperationLog.class).title());
            map.put("source", method.getAnnotation(OperationLog.class).source().getKey());
            break;
        }
        return map;
    }
}

