package insproduct;

import com.bcxin.ins.core.entity.SysRegion;
import com.bcxin.ins.core.service.SysRegionService;
import com.bcxin.ins.models.product.service.InsProductResponsibilityService;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.google.common.collect.Lists;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/**
 * Created by playboy on 2017/3/16.
 */
@ContextConfiguration(locations = { "/spring/spring-context-mybatis.xml","/spring/spring-context.xml"})
public class InsProductCompanyFeeTest extends AbstractJUnit4SpringContextTests {

    @Autowired
    private InsProductCompanyFeeService insProductCompanyFeeService;

    @Autowired
    private InsProductService insProductService;

    @Autowired
    private SysRegionService sysRegionService;


    @Test
    public  void insProductCompanyFeeTest(){
        List<Map<String,Object>> list = insProductCompanyFeeService.findDistributorProductList(Long.parseLong("831030478646374400"));
        System.out.println(list.toString());
    }

    private POIFSFileSystem fs;
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private HSSFRow row;
    /**
     * 初始化产品(pss )
     */
    @Test
    public void initPorduct(){
        try {
            InputStream is = new FileInputStream("f:\\11.xlsx");
            XSSFWorkbook xssfWorkbook = null;
            xssfWorkbook = new XSSFWorkbook(is);
            // 获取每一个工作薄
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
            List<InsProduct> list = Lists.newArrayList();
            // 获取当前工作薄的每一行
            for (int rowNum = 0; rowNum < 38; rowNum++) {
                InsProduct product = new InsProduct();
                XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                if (xssfRow != null) {
                    String value = getValue(xssfRow.getCell(0));
                    product.setInsuranceName(value+"_风评报告");
                    product.setVenueName(value);
                    value = getValue(xssfRow.getCell(1));
                    String[] temp = value.split(",");
                    String temp1 = temp[0];
                    if (StrUtil.isNotBlank(temp1)) {
                        SysRegion r = sysRegionService.selectOne(new EntityWrapper<SysRegion>().addFilter("province = {0}", temp1));
                        product.setProvince(r.getId().toString());
                    }
                    String temp2 = temp.length >= 2 ? temp[1] : "";
                    if (StrUtil.isNotBlank(temp2)) {
                        SysRegion r = sysRegionService.selectOne(new EntityWrapper<SysRegion>().addFilter("citytype = {0}", temp2));
                        product.setCity(r.getId().toString());
                    }
                    String temp3 = temp.length >= 3 ? temp[2] : "";
                    if (StrUtil.isNotBlank(temp3)) {
                        SysRegion r = sysRegionService.selectOne(new EntityWrapper<SysRegion>().addFilter("city = {0}", temp3));
                        product.setDistrict(r.getId().toString());
                    }
                    String temp4 = temp.length >= 4 ? temp[3] : "";
                    if (StrUtil.isNotBlank(temp4)) {
                        product.setAddress(temp4);
                    }
                    value = getValue(xssfRow.getCell(2));
                    product.setAccommodatingNumber(value);

                }
                product.preInsert();
                list.add(product);
            }
           // insProductService.insertBatch(list);

        } catch (FileNotFoundException e) {
            System.out.println("未找到指定路径的文件!");
            e.printStackTrace();
        } catch (IOException e){
            e.printStackTrace();
        }
    }
    private String getValue(XSSFCell xssfRow) {
        if(null==xssfRow){
            return "";
        }
        if (xssfRow.getCellType() == xssfRow.CELL_TYPE_BOOLEAN) {
            return String.valueOf(xssfRow.getBooleanCellValue());
        } else if (xssfRow.getCellType() == xssfRow.CELL_TYPE_NUMERIC) {
            return String.valueOf(xssfRow.getNumericCellValue());
        } else {
            return String.valueOf(xssfRow.getStringCellValue());
        }
    }



    /**
     * 培训产品初始化数据
     */
    @Test
    public void setTrainTest(){

        InsProduct insProduct = new InsProduct();
        insProduct.setInsuranceName("初级保安员职业技能培训教程");
        insProduct.setTrainingObject("需要参加初级保安员考试或需要相关培训的保安人员");
        insProduct.setCourseObjective("根据《保安员国家职业技能标准（2014年修订）》，由业内权威专家设计和讲解，系统性地对初级保安员职业技能做专业的培训教程，帮助保安员快速而有效地掌握初级保安员的知识和技能。");
        insProduct.setCurriculum("视频学习+考题解答");
        insProduct.setCourseArrangement("24课时");
        insProduct.setProductType("14");
        insProductService.save(insProduct);
        insProduct = new InsProduct();
        insProduct.setInsuranceName("在职保安员继续教育培训教程");
        insProduct.setTrainingObject("在职保安员及相关管理人员");
        insProduct.setCourseObjective("为保证在职保安的素质水平不断得到巩固和提升，学习新时期与时俱进的知识和技能，由业内权威专家设计和讲解，系统性地对在职保安员职业知识和技能做的专业培训教程。");
        insProduct.setCurriculum("视频学习+考题解答");
        insProduct.setCourseArrangement("10课时");
        insProduct.setProductType("14");
        insProductService.save(insProduct);
    }

    @Autowired
    InsProductResponsibilityService insProductResponsibilityService;
    @Test
    public void InsProductResponsibilityService(){
         List<InsProductResponsibility> list = insProductResponsibilityService.selectList(null);
         System.out.println(list.toString());
    }

    @Test
    public void TimeZone(){
        System.out.println(TimeZone.getDefault());
    }
}
