package duty;

import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.models.data.service.InsRiskLevelService;
import com.bcxin.ins.models.order.policy.entity.InsOrderFormRest;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.spring.security.Digests;
import com.bcxin.ins.util.Encodes;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;

import java.io.*;
import java.math.BigDecimal;
import java.net.*;
import java.util.List;
import java.util.Map;

/**
 * 国家等级分类数据初始化
 */
@ContextConfiguration(locations = { "/spring/spring-context-mybatis.xml","/spring/spring-context.xml"})
public class RiskDutyTest extends AbstractJUnit4SpringContextTests {

    @Autowired
    private InsRiskLevelService insRiskLevelService;

    @Autowired
    private InsProductService insProductService;

    @Autowired
    private InsProductCompanyFeeService insProductCompanyFeeService;

    @Autowired
    private InsOrderFormRestDao insOrderFormRestDao;

    @Test
    public void passswordTest(){
        StringBuilder sqlString = new StringBuilder();
        //String a = entryptPassword("123456");
        //System.out.println(a);
        sqlString.append(" AND EXISTS (SELECT 1 FROM SYS_COMAPNY");
        sqlString.append(" WHERE type='2'");
        sqlString.append(" AND (id = '111'");
        sqlString.append(" OR parent_ids LIKE '2222,%')");
        sqlString.append(")");
        System.out.println(sqlString.toString());
    }
    public boolean validatePassword(String plainPassword, String password) {
        String plain = Encodes.unescapeHtml(plainPassword);
        byte[] salt = Encodes.decodeHex(password.substring(0,16));
        byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, 1024);
        return password.equals(Encodes.encodeHex(salt)+Encodes.encodeHex(hashPassword));
    }

    public String entryptPassword(String plainPassword) {
        String plain = Encodes.unescapeHtml(plainPassword);
        byte[] salt = Digests.generateSalt(8);
        byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, 1024);
        return Encodes.encodeHex(salt)+Encodes.encodeHex(hashPassword);
    }

    /**
     * 复制数据   国家等级分类
     *
     * 初始化数据
     *
     * @throws InterruptedException
     */
    @Test
    public void copyData() throws InterruptedException {
        //List<InsProduct> list = insProductService.selectList(new EntityWrapper<InsProduct>().addFilter("id in ({0},{1})","1001011","1001012"));

        List<InsRiskLevel> list2 = insRiskLevelService.selectList(null);

        List<InsRiskLevel> list3 = Lists.newArrayList();

        for(InsRiskLevel insRiskLevel:list2){
            insRiskLevel.setInsProduct(new InsProduct(1001011L));
            list3.add(insRiskLevel);
        }
        //insRiskLevelService.updateBatchById(list3);
        list3.clear();
        for(InsRiskLevel insRiskLevel:list2){
            insRiskLevel.setInsProduct(new InsProduct(1001012L));
            insRiskLevel.setId(null);
            list3.add(insRiskLevel);
        }
       //insRiskLevelService.insertBatch(list3);
    }

    /**
     *  获取国家等级分类
     * @throws InterruptedException
     */
    @Test
    public void getData() throws InterruptedException{
        List<String> list = insRiskLevelService.getCountryGroup(1001011L);

        System.out.println(list);
    }

    @Test
    public  void insProductCompanyFeeTest(){
        InsOrderFormRest pss  =  insOrderFormRestDao.selectById(0L);
        System.out.println(pss);
    }

    @Test
    public  void PSSTest(){
        //对String的时间进行转换为timestamp；
        ReportVo o = new ReportVo();
        //订单结束时间
        o.setEndDate(DateUtil.today());
        //订单编号
        o.setOrderNo("12123156546545322");
        //承办方
        o.setContractor("测试承办方百宝盾");
        //申请时间
        o.setCreateDate(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
        //成交时间
        o.setDealDate(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
        //所属行业
        o.setChannel("测试");
        //活动名称
        o.setName("测试");
        //订单金额
        o.setAmount("2000");
        //省
        o.setProvince("福建省");
        //市
        o.setCity("厦门市");
        //区域
        o.setDistrict("同安区");
        //场地
        o.setVenue("851309406021816320");
        o.setStartDate(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
        o.setEndDate(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
        //活动类型
        o.setType("测试");
        //人数
        o.setNumber("100");
        //设置订单来源标识
        o.setSign("PSS");
        //设置购买人
        o.setPurchaser("刘金炬测试日期1113333");
        //支付日期
        o.setPaymentDate(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
        //支付期数
        o.setPaymentStage("1");
        //支付方式
        o.setPaymentType("线上222");
        //是否购买保险
        o.setBuyPolicy("Y");
        //设置分销金额
        o.setFcy(BigDecimal.valueOf(Double.parseDouble(2100)));

        o.setCompanyId("857766457153536000");

        o.setCreateDate(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
        o.setStartDate(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
        o.setEndDate(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
        Map<String,Object> map = Maps.newHashMap();

        map.put("reportVo",o);
        map.put("webType","PSS");
        String url = "http://127.0.0.1:8080/api/interaction/policy/saveInsOrderFormForRest";
        String pata = MessageUtils.packageMap(map);
        pata = URLEncoder.encode(pata);
        String result = doPost2(url,pata);
        System.out.println(result);
    }

    private static String charset = "UTF-8";
    public static String doPost2(String url, String data) {
        /* Translate parameter map to parameter date string */
        StringBuffer parameterBuffer = new StringBuffer();
        parameterBuffer.append("data").append("=").append(data);
        StringBuffer resultBuffer = new StringBuffer();
        try {
            URL localURL = new URL(url);
            URLConnection connection = openConnection(localURL);
            HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Accept-Charset", charset);
            httpURLConnection.setRequestProperty("contentType", charset);
            httpURLConnection.setConnectTimeout(5 * 1000);
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(parameterBuffer.length()));

            OutputStream outputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader reader = null;
            String tempLine = null;
            try {
                outputStream = httpURLConnection.getOutputStream();
                outputStreamWriter = new OutputStreamWriter(outputStream,charset);
                outputStreamWriter.write(parameterBuffer.toString());
                outputStreamWriter.flush();
                if (httpURLConnection.getResponseCode() >= 300) {
                    throw new Exception("HTTP Request is not success, Response code is " + httpURLConnection.getResponseCode());
                }
                inputStream = httpURLConnection.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream ,charset);
                reader = new BufferedReader(inputStreamReader);
                while ((tempLine = reader.readLine()) != null) {
                    resultBuffer.append(tempLine);
                }
            } finally {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return resultBuffer.toString();
    }
    private static String proxyHost = null;
    private static Integer proxyPort = null;

    private static URLConnection openConnection(URL localURL) throws IOException {
        URLConnection connection;
        if (proxyHost != null && proxyPort != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            connection = localURL.openConnection(proxy);
        } else {
            connection = localURL.openConnection();
        }
        return connection;
    }

}