/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.xyx.taibao;

import com.bcxin.ins.third.build.taibao.SimplePathResultXMLProcesser;
import com.bcxin.ins.third.build.taibao.TransType;
import com.bcxin.ins.third.xyx.yb_enum.YB_City;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.FileBatchUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.XMLUtil;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.RuleXWCKVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XYX_PackageMessageTaiBao {
    private static Logger logger = LoggerFactory.getLogger(XYX_PackageMessageTaiBao.class);
    private static final String PARTNERCODE = "XMBCX";
    private static final String TBUSER = "XMBCX";
    private static final String TBPASS = "+kp0LXaWRRWq2bsb/EJR22O2aqjghfCrGe/OaJJheaJttbKcDxlXiDYfpcxLK1fKm75rGAjtNsTFuxt/v/F+Vw==";

    public static String marshal(MicroExportVo policy, OrderFormVo orderVo, RuleXWCKVo ruleXWCKVo, String tb_code, String transType) throws Exception {
        if (policy == null) {
            return "";
        }
        Document requestDocument = DocumentHelper.createDocument();
        requestDocument.setXMLEncoding("UTF-8");
        Element rootElement = requestDocument.addElement("request");
        try {
            Element entityElement;
            Element headElement = rootElement.addElement("head");
            XYX_PackageMessageTaiBao.marshalHead(headElement, orderVo, transType);
            Element bodyElement = rootElement.addElement("body");
            if (TransType.EPIC_INS_XW.getValue().equals(transType)) {
                entityElement = bodyElement.addElement("proposalRequest");
                RoleSubjectVo applicants = (RoleSubjectVo)policy.getRoleSubjectList().get(0);
                Element projectInfo = entityElement.addElement("projectInfo");
                XYX_PackageMessageTaiBao.marshalProjectInfo(projectInfo, applicants, orderVo);
                Element enterprises = entityElement.addElement("enterprises");
                XYX_PackageMessageTaiBao.marshalEnterprises(enterprises, policy, orderVo, applicants);
                Element proposalMain = entityElement.addElement("proposalMain");
                XYX_PackageMessageTaiBao.marshalProposalMain(proposalMain, policy, orderVo, ruleXWCKVo, tb_code);
                Element proposalCharacterMicro = entityElement.addElement("proposalCharacterMicro");
                XYX_PackageMessageTaiBao.marshalProposalCharacterMicro(proposalCharacterMicro, policy, orderVo, tb_code);
                Element proposalReins = entityElement.addElement("proposalReins");
                XYX_PackageMessageTaiBao.marshalProposalReins(proposalReins, policy, orderVo, tb_code);
                Element proposalParties1 = entityElement.addElement("proposalParties");
                Element proposalParties2 = entityElement.addElement("proposalParties");
                XYX_PackageMessageTaiBao.marshalProposalParties(proposalParties1, policy, applicants, "1");
                XYX_PackageMessageTaiBao.marshalProposalParties(proposalParties2, policy, applicants, "2");
                Element proposalPaymentPlans = entityElement.addElement("proposalPaymentPlans");
                XYX_PackageMessageTaiBao.marshalProposalPaymentPlans(proposalPaymentPlans, policy, ruleXWCKVo, orderVo);
                Element proposalSpecialAgrees1 = entityElement.addElement("proposalSpecialAgrees");
                Element proposalSpecialAgrees2 = entityElement.addElement("proposalSpecialAgrees");
                Element proposalSpecialAgrees3 = entityElement.addElement("proposalSpecialAgrees");
                XYX_PackageMessageTaiBao.marshalProposalSpecialAgrees(proposalSpecialAgrees1, policy, ruleXWCKVo, 1);
                XYX_PackageMessageTaiBao.marshalProposalSpecialAgrees(proposalSpecialAgrees2, policy, ruleXWCKVo, 2);
                XYX_PackageMessageTaiBao.marshalProposalSpecialAgrees(proposalSpecialAgrees3, policy, ruleXWCKVo, 3);
            } else if (TransType.EPIC_YX_XW.getValue().equals(transType)) {
                entityElement = bodyElement.addElement("entity");
                RoleSubjectVo applicants = (RoleSubjectVo)policy.getRoleSubjectList().get(0);
                ArrayList<HashMap> list = new ArrayList<HashMap>();
                HashMap map = Maps.newHashMap();
                map.put("name", "BusinessLicense");
                map.put("url", applicants.getApp_business_path());
                list.add(map);
                HashMap map2 = Maps.newHashMap();
                map2.put("name", "CopyOfLegalPersonIdCard(positive)");
                map2.put("url", applicants.getApp_idcard_path());
                list.add(map2);
                HashMap map3 = Maps.newHashMap();
                map3.put("name", "CopyOfLegalPersonIdCard(reverse)");
                map3.put("url", applicants.getApp_idcard_versa_path());
                list.add(map3);
                entityElement.addElement("businessNo").setText(orderVo.getPolicy_serial_number());
                entityElement.addElement("uploadTime").setText(DateUtil.getCurrentDateTime());
                entityElement.addElement("zipInfo").setText(FileBatchUtil.dealErJinZhiFile((String)String.valueOf(System.currentTimeMillis()), list));
            } else if (TransType.EPIC_CB_XW.getValue().equals(transType)) {
                bodyElement.addElement("proposalNo").setText(orderVo.getPolicy_serial_number());
            } else if (TransType.EPIC_DZBD_XW.getValue().equals(transType)) {
                RoleSubjectVo inst = (RoleSubjectVo)policy.getRoleSubjectList().get(1);
                bodyElement.addElement("epolicyNumber").setText(orderVo.getExternal_reference());
                bodyElement.addElement("idNumber").setText(String.valueOf(inst.getOrganization_code().replace("-", "")));
                bodyElement.addElement("servicesType").setText("1");
            }
            String requestMsg = requestDocument.asXML();
            return requestMsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void marshalHead(Element underwrite, OrderFormVo orderVo, String transType) {
        underwrite.addElement("partnerCode").setText("XMBCX");
        underwrite.addElement("transactionCode").setText(transType);
        underwrite.addElement("messageId").setText(orderVo.getTrade_serial_number());
        SimpleDateFormat dateFormatAll = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        underwrite.addElement("transactionEffectiveDate").setText(dateFormatAll.format(new Date()));
        underwrite.addElement("user").setText("XMBCX");
        underwrite.addElement("password").setText(TBPASS);
    }

    private static void marshalProjectInfo(Element underwrite, RoleSubjectVo applicants, OrderFormVo orderVo) {
        underwrite.addElement("projectNo").setText(String.valueOf(System.currentTimeMillis()));
        underwrite.addElement("area").setText(YB_City.fromCode(applicants.getReg_city()) + YB_City.fromYBCity(applicants.getReg_city()).getValue());
        underwrite.addElement("enterpriseWhiteNo").setText(applicants.getCustoms_code());
        underwrite.addElement("orderNo").setText(orderVo.getTrade_serial_number());
        underwrite.addElement("sourceSys").setText("BAICHUANXIN");
    }

    private static void marshalProposalMain(Element underwrite, MicroExportVo policy, OrderFormVo orderVo, RuleXWCKVo ruleXWCKVo, String tb_code) {
        underwrite.addElement("riskCode").setText("13081500");
        underwrite.addElement("riskName").setText("\u5c0f\u5fae\u4f01\u4e1a\u51fa\u53e3\u4fe1\u7528\u4fdd\u9669");
        underwrite.addElement("underwritingTypeCode").setText("1");
        underwrite.addElement("separateManageFlag").setText("0");
        underwrite.addElement("mainInsurantRelationCode").setText("01");
        underwrite.addElement("remoteUnderwritingFlag").setText("0");
        underwrite.addElement("branchCode").setText(tb_code);
        underwrite.addElement("assessmentManagerCode").setText("1268");
        underwrite.addElement("businessNatureCode").setText("12");
        underwrite.addElement("startDate").setText(orderVo.getInception_date());
        underwrite.addElement("endDate").setText(orderVo.getPlanned_end_date());
        underwrite.addElement("proposalDate").setText(orderVo.getStart_time());
        underwrite.addElement("startHour").setText("0");
        underwrite.addElement("endHour").setText("24");
        underwrite.addElement("signDate").setText(DateUtil.getCurrentDate());
        underwrite.addElement("validDate").setText(orderVo.getInception_date());
        underwrite.addElement("underwritingBasisCode").setText("002");
        underwrite.addElement("jurisdictionCode").setText("002");
        String ds = policy.getDisputes().equals("0") ? "1" : "0";
        underwrite.addElement("disputeResolutionCode").setText(ds);
        if ("0".equals(ds)) {
            String aiCode = XYX_PackageMessageTaiBao.arbitrationInstitutionsCode(policy.getArbitral_institution());
            String aiName = "";
            if (aiCode.equals("100")) {
                aiCode = "99";
            }
            if (aiCode.equals("99")) {
                aiName = "null".equals(policy.getArbitral_institution()) ? "" : (StringUtils.isEmpty((CharSequence)policy.getArbitral_institution()) ? "" : policy.getArbitral_institution());
            }
            underwrite.addElement("arbitrationInstitutionsCode").setText(aiCode);
            underwrite.addElement("arbitrationInstitutionsOther").setText(String.valueOf(aiName));
        } else {
            underwrite.addElement("lawsuitAddress").setText(String.valueOf(RegionUtils.getRegionNameByALLCode((String)policy.getLawsuit_province(), (String)policy.getLawsuit_city(), (String)policy.getLawsuit_area()) + policy.getLawsuit_address()));
            underwrite.addElement("lawsuitInstitutions").setText(String.valueOf(policy.getLawsuit_institution()));
        }
        underwrite.addElement("agricultureFlag").setText("0");
        underwrite.addElement("systemIssueCode").setText("1");
        underwrite.addElement("policyPrintTypeCode").setText("0");
        underwrite.addElement("provideFinancingFlag").setText("0");
        underwrite.addElement("mainClauseName").setText("\u5c0f\u5fae\u4f01\u4e1a\u51fa\u53e3\u8d38\u6613\u77ed\u671f\u4fe1\u7528\u7efc\u5408\u4fdd\u9669");
        underwrite.addElement("mainClauseCode").setText("3");
        underwrite.addElement("quotingBasedCode").setText("01");
        underwrite.addElement("prepayPremiumTypeCode").setText("01");
        underwrite.addElement("estimatedInsuredTurnover").setText(policy.getExport_amount());
        BigDecimal medialRate = BigDecimal.valueOf(Double.parseDouble(ruleXWCKVo.getRate()));
        BigDecimal estimatedPremium = BigDecimal.valueOf(Double.parseDouble(policy.getExport_amount())).multiply(medialRate).setScale(2, 4);
        underwrite.addElement("estimatedPremium").setText(String.valueOf(estimatedPremium));
        BigDecimal minPremium = BigDecimal.valueOf(Double.parseDouble(ruleXWCKVo.getPremium_min())).compareTo(estimatedPremium) >= 0 ? BigDecimal.valueOf(Double.parseDouble(ruleXWCKVo.getPremium_min())) : estimatedPremium;
        underwrite.addElement("minPremium").setText(String.valueOf(minPremium));
        underwrite.addElement("contractAfterPayFlag").setText("0");
        underwrite.addElement("currency").setText(policy.getAnnual_currency().equals("0") ? "02" : "01");
        underwrite.addElement("coinsFlag").setText("0");
    }

    private static String arbitrationInstitutionsCode(String val) {
        if (StringUtils.isNotEmpty((CharSequence)val)) {
            if (val.equals("\u4e2d\u56fd\u56fd\u9645\u7ecf\u6d4e\u8d38\u6613\u4ef2\u88c1\u59d4\u5458\u4f1a\u5317\u4eac\u5206\u4f1a")) {
                return "01";
            }
            if (val.equals("\u4e2d\u56fd\u56fd\u9645\u7ecf\u6d4e\u8d38\u6613\u4ef2\u88c1\u59d4\u5458\u4f1a\u4e0a\u6d77\u5206\u4f1a")) {
                return "02";
            }
            if (val.equals("\u4e2d\u56fd\u56fd\u9645\u7ecf\u6d4e\u8d38\u6613\u4ef2\u88c1\u59d4\u5458\u4f1a\u534e\u5357\u5206\u4f1a")) {
                return "03";
            }
            return "99";
        }
        return "100";
    }

    private static void marshalProposalCharacterMicro(Element underwrite, MicroExportVo policy, OrderFormVo orderVo, String tb_code) {
        underwrite.addElement("addedTaxFlag").setText("0");
        underwrite.addElement("overdueDeadlineTypeCode").setText("01");
        underwrite.addElement("overdueDeadlineDays").setText("30");
        underwrite.addElement("excludingInsuredDesc").setText("\u5411\u53e4\u5df4\u3001\u4f0a\u6717\u3001\u5317\u671d\u9c9c\u3001\u82cf\u4e39\u3001\u5229\u6bd4\u4e9a\u3001\u4e5f\u95e8\u3001\u53d9\u5229\u4e9a\u3001\u963f\u5bcc\u6c57\u3001\u4f0a\u62c9\u514b\u3001\u7d22\u9a6c\u91cc\u3001\u5e03\u9686\u8fea\u3001\u79d1\u6469\u7f57\u3001\u521a\u679c\u6c11\u4e3b\u5171\u548c\u56fd\u3001\u4fc4\u7f57\u65af\u3001\u5229\u6bd4\u91cc\u4e9a\u3001\u585e\u62c9\u5229\u6602\u3001\u6d25\u5df4\u5e03\u97e6\u3001\u5df4\u52d2\u65af\u5766\u3001\u963f\u5c14\u5df4\u5c3c\u4e9a\u7b49\u56fd\u5bb6\u6216\u5730\u533a\u51fa\u53e3\u7684\u4e1a\u52a1\u9664\u5916");
        underwrite.addElement("customCurrency").setText(policy.getAnnual_currency().equals("0") ? "02" : "01");
        underwrite.addElement("customAmount").setText(String.valueOf(policy.getExport_amount()));
        underwrite.addElement("majorExportCommodities").setText("\u672c\u4fdd\u9669\u5355\u6709\u6548\u671f\u5185\u88ab\u4fdd\u9669\u4eba\u4e0e\u4e70\u65b9\u7b7e\u8ba2\u9500\u552e\u5408\u540c\u5e76\u4ee5\u88ab\u4fdd\u9669\u4eba\u540d\u4e49\u62a5\u5173\u51fa\u53e3\u7684\u5168\u90e8\u51fa\u53e3\u4e1a\u52a1");
        underwrite.addElement("exchangeCurrency").setText(policy.getAnnual_currency().equals("0") ? "02" : "01");
        underwrite.addElement("exchangeAmount").setText(String.valueOf(policy.getUncollected_amount()));
        underwrite.addElement("exDividendReason").setText(String.valueOf(policy.getUncollected_cause()));
        underwrite.addElement("maxLiabilityCode").setText("01");
        underwrite.addElement("maxLiability").setText(String.valueOf(policy.getInsured_amount()));
        underwrite.addElement("maxPaymentCode").setText("01");
        underwrite.addElement("maxPayment").setText(String.valueOf(policy.getPay_limit()));
        underwrite.addElement("custCreditLimitInsRatio").setText(String.valueOf(BigDecimal.valueOf(Double.parseDouble(policy.getPro_rata())).multiply(BigDecimal.valueOf(Double.parseDouble("100"))).setScale(0, 4)));
    }

    private static void marshalProposalReins(Element underwrite, MicroExportVo policy, OrderFormVo orderVo, String tb_code) {
        underwrite.addElement("returnFlag").setText("0");
    }

    private static void marshalProposalParties(Element underwrite, MicroExportVo policy, RoleSubjectVo applicants, String tc) {
        underwrite.addElement("serialNo").setText("1");
        underwrite.addElement("partyName").setText(String.valueOf(applicants.getName_cn()));
        underwrite.addElement("partyTypeCode").setText(tc);
        underwrite.addElement("mainInsurantFlag").setText("1");
        underwrite.addElement("businessAddress").setText(RegionUtils.getRegionNameByALLCode((String)applicants.getReg_province(), (String)applicants.getReg_city(), (String)applicants.getReg_district()) + applicants.getReg_address());
    }

    private static void marshalProposalPaymentPlans(Element underwrite, MicroExportVo policy, RuleXWCKVo ruleXWCKVo, OrderFormVo orderVo) {
        underwrite.addElement("payNo").setText("1");
        underwrite.addElement("currency").setText(policy.getAnnual_currency().equals("0") ? "02" : "01");
        underwrite.addElement("plandate").setText(DateUtil.getThisYearLastDay());
        String planFeeRatio = "100";
        underwrite.addElement("planFeeRatio").setText(planFeeRatio);
        BigDecimal medialRate = BigDecimal.valueOf(Double.parseDouble(ruleXWCKVo.getRate()));
        BigDecimal estimatedPremium = BigDecimal.valueOf(Double.parseDouble(policy.getExport_amount())).multiply(medialRate).setScale(2, 4);
        BigDecimal planFee = estimatedPremium.multiply(BigDecimal.valueOf(Double.parseDouble(planFeeRatio))).divide(BigDecimal.valueOf(Double.parseDouble("100"))).setScale(2, 4);
        underwrite.addElement("planFee").setText(String.valueOf(planFee));
    }

    private static void marshalProposalSpecialAgrees(Element underwrite, MicroExportVo policy, RuleXWCKVo ruleXWCKVo, int type) {
        if (type == 1) {
            underwrite.addElement("specialClauseName").setText("\u5355\u4e00\u4e70\u65b9/\u5f00\u8bc1\u884c\u6700\u9ad8\u8d54\u4ed8\u4e0a\u9650");
            underwrite.addElement("specialClauseDesc").setText(Integer.parseInt(policy.getPay_limit()) / 10000 + "\u4e07\u7f8e\u5143\uff0c\u4e0d\u652f\u6301\u5355\u72ec\u7533\u8bf7\u9650\u989d\uff1b\u8d54\u4ed8\u6bd4\u4f8b\uff1a" + BigDecimal.valueOf(Double.parseDouble(policy.getPro_rata())).multiply(BigDecimal.valueOf(Double.parseDouble("100"))).setScale(0, 4) + "%");
        } else if (type == 2) {
            underwrite.addElement("specialClauseName").setText("\u4fdd\u5355\u6700\u9ad8\u8d54\u507f\u9650\u989d");
            underwrite.addElement("specialClauseDesc").setText("\u5e74\u5ea6\u4fdd\u9669\u8d39\u7684" + BigDecimal.valueOf(Double.parseDouble(ruleXWCKVo.getCompensation_multiple())).setScale(0, 4) + "\u500d");
        } else if (type == 3) {
            underwrite.addElement("specialClauseName").setText("\u5176\u4ed6");
            underwrite.addElement("specialClauseDesc").setText("\u4f9d\u636e\u53a6\u95e8\u5e02\u5c0f\u89c4\u6a21\u51fa\u53e3\u4f01\u4e1a\u7edf\u4fdd\u76f8\u5173\u89c4\u5b9a\uff0c \u672c\u4fdd\u5355\u9879\u4e0b\u6295\u4fdd\u8425\u4e1a\u989d\u4e3a\u4e0a\u5e74\u62a5\u5173\u51fa\u53e3\u603b\u91d1\u989d\u3002");
        }
    }

    private static void marshalEnterprises(Element underwrite, MicroExportVo policy, OrderFormVo orderVo, RoleSubjectVo applicants) {
        underwrite.addElement("serialNo").setText("1");
        underwrite.addElement("countryCode").setText("CN");
        underwrite.addElement("customerName").setText(String.valueOf(applicants.getName_cn()));
        underwrite.addElement("province").setText(YB_City.fromCode(applicants.getReg_city()));
        underwrite.addElement("city").setText(YB_City.fromYBCity(applicants.getReg_city()).getValue());
        underwrite.addElement("street").setText(applicants.getReg_address());
        underwrite.addElement("idTypeCode").setText("1".equals(applicants.getId_type()) ? "CN_OCCN" : ("2".equals(applicants.getId_type()) ? "CN_USCC" : ""));
        underwrite.addElement("idNumber").setText(String.valueOf(applicants.getOrganization_code().replace("-", "")));
        underwrite.addElement("industryType").setText("0000");
        underwrite.addElement("customesUnitId").setText(String.valueOf(applicants.getCustoms_code()));
        underwrite.addElement("registeredAddress").setText(RegionUtils.getRegionNameByALLCode((String)applicants.getReg_province(), (String)applicants.getReg_city(), (String)applicants.getReg_district()) + applicants.getReg_address());
        underwrite.addElement("legalRepresent").setText(applicants.getLegal_name());
        underwrite.addElement("telephone").setText(applicants.getLegal_phone());
        underwrite.addElement("enterpriseTurnover").setText(policy.getExport_amount());
        underwrite.addElement("postCode").setText(YB_City.fromYBCity(applicants.getReg_city()).getValue());
        underwrite.addElement("email").setText(applicants.getLink_email());
        underwrite.addElement("employeesNum").setText(policy.getPerson_num());
    }

    public static String returnAnalysisXML(String returnXML, String transType) throws Exception {
        SimplePathResultXMLProcesser xmlProcesser = new SimplePathResultXMLProcesser();
        if (!xmlProcesser.isTBSuccess(returnXML)) {
            return "300#\uff08APP-XWCK-005\uff09" + xmlProcesser.isTBFailMessage(returnXML);
        }
        if (TransType.EPIC_INS_XW.getValue().equals(transType)) {
            String result = xmlProcesser.getXYXPolicyMsg(returnXML);
            String[] arr = result.split("#");
            if (!"0000".equals(arr[0])) {
                return "300#\uff08APP-XWCK-" + arr[0] + "\uff09" + arr[1];
            }
            logger.info(XMLUtil.formatXML((String)returnXML));
            return "200#" + arr[2];
        }
        if (TransType.EPIC_YX_XW.getValue().equals(transType)) {
            logger.info(XMLUtil.formatXML((String)returnXML));
            return "200#\u4e0a\u4f20\u6210\u529f";
        }
        if (TransType.EPIC_CB_XW.getValue().equals(transType)) {
            String result = xmlProcesser.getXYXPolicyMsgCB(returnXML);
            String[] arr = result.split("#");
            if (!"000000".equals(arr[0])) {
                return "300#\uff08APP-XWCK-" + arr[0] + "\uff09" + arr[1];
            }
            logger.info(XMLUtil.formatXML((String)returnXML));
            return "200#" + arr[2];
        }
        if (TransType.EPIC_DZBD_XW.getValue().equals(transType)) {
            String result = xmlProcesser.getXYXPolicyDZBD(returnXML);
            String[] arr = result.split("#");
            if (!"0".equals(arr[0])) {
                return "300#\uff08APP-XWCK-12004601\uff09" + arr[1];
            }
            logger.info(XMLUtil.formatXML((String)returnXML));
            return "200#" + arr[2];
        }
        return "300#\uff08APP-XWCK-002.1\uff09\u83b7\u53d6\u4e1a\u52a1\u7f16\u7801\u51fa\u73b0\u5f02\u5e38";
    }
}

