/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzzrx.pingancai;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.InsCommonReportAPIService;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.third.gzzrx.pingancai.GZZRX_PackageMessagePAC;
import com.bcxin.ins.third.gzzrx.pingancai.OpenApiPost;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.google.common.collect.Maps;
import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.service.IobsService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="gZZRX_PACRequestService")
@Transactional
public class GZZRX_PACRequestService {
    private static Logger communicatorLog = LoggerFactory.getLogger(GZZRX_PACRequestService.class);
    @Autowired
    private PolicyService policyService;
    @Autowired
    private LogBusinessrequestService logBusinessrequestService;
    @Autowired
    private InsCommonReportAPIService insCommonReportAPIService;
    private static final String PARTNERCODE = "P_BCXZR_GP";

    public String requestPAC(Long order_id, String transType, InsPreservationRecordVo iprVo) throws Exception {
        communicatorLog.info("requestPAC-GZZRX\uff1astar-----------------------");
        communicatorLog.info("requestPAC-GZZRX\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + order_id + ",iprVo-" + (iprVo != null ? iprVo.toString() : "null"));
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(Long.parseLong(dto.getOid()));
        String result = "300#\uff08APP-PAC-GZZRX-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String json = GZZRX_PackageMessagePAC.marshal(vo, dto, transType, iprVo);
            communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
            String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/openapi/" + PARTNERCODE + "/" + GZZRX_PACRequestService.getUrlByTransType(dto.getIs_policy_before_pay_fee(), transType) + "?access_token=" + this.policyService.pnc_access_token();
            communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
            Date bTime = new Date();
            String ret = RequestUtil.initHttp().doPostByAccept(url, json, "application/json", "UTF-8");
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id), transType, url, json, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            result = GZZRX_PackageMessagePAC.returnAnalysisJson(ret, transType);
            communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            ex.printStackTrace();
        }
        communicatorLog.info("requestPAC-GZZRX\uff1aend-----------------------");
        return result;
    }

    private static String getUrlByTransType(String isPayFee, String type) {
        if (TransTypeEnum.HB.getValue().equals(type)) {
            return "1".equals(isPayFee) ? "applyForFee" : "applyForNoFee";
        }
        if (TransTypeEnum.CBXX.getValue().equals(type)) {
            return "acceptForFee";
        }
        if (TransTypeEnum.DZBD.getValue().equals(type)) {
            return "printGP";
        }
        if (TransTypeEnum.DZPD.getValue().equals(type)) {
            return "printGP";
        }
        if (TransTypeEnum.ZFDZ.getValue().equals(type)) {
            return "prePayFinance";
        }
        if (TransTypeEnum.DZFP.getValue().equals(type)) {
            return "printInvoice";
        }
        if (TransTypeEnum.PD.getValue().equals(type)) {
            return "endorse";
        }
        if (TransTypeEnum.BASL.getValue().equals(type)) {
            return "interface/commonOpenApi/saveReportInfo";
        }
        if (TransTypeEnum.AJCX.getValue().equals(type)) {
            return "interface/commonOpenApi/queryCaseInfoList";
        }
        if (TransTypeEnum.CLSC.getValue().equals(type)) {
            return "interface/uploadFileOpenApi/fileUpload";
        }
        if (TransTypeEnum.XXAJCX.getValue().equals(type)) {
            return "interface/commonEsg/queryBCXCaseList";
        }
        return "";
    }

    public String pdqr(String transType, String pdResult) {
        communicatorLog.info("pdqr-GZZRX\uff1astar-----------------------");
        communicatorLog.info("pdqr-GZZRX\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",pdResult-" + pdResult);
        if (StringUtils.isNotEmpty((String)pdResult)) {
            String[] arr = pdResult.split("#");
            String result = "300#\uff08APP-PAC-GZZRX-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
            LogBusinessrequest lb = null;
            try {
                String json = GZZRX_PackageMessagePAC.pdqr_marshal(arr[1], transType, arr[4], arr[3], arr[5]);
                communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
                String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/openapi/" + PARTNERCODE + "/" + GZZRX_PACRequestService.getUrlByTransType("", transType) + "?access_token=" + this.policyService.pnc_access_token();
                communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
                Date bTime = new Date();
                String ret = RequestUtil.initHttp().doPostByAccept(url, json, "application/json", "UTF-8");
                lb = this.logBusinessrequestService.initLogBusinessrequest("", transType, url, json, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
                communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
                result = GZZRX_PackageMessagePAC.returnAnalysisJson(ret, transType);
                communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
                this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
            }
            catch (Exception ex) {
                this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
                ex.printStackTrace();
            }
            communicatorLog.info("pdqr-GZZRX\uff1aend-----------------------");
            return result;
        }
        return "300#\u65e0\u6279\u6539\u4fe1\u606f\uff01";
    }

    public String requestReportPAC(Long report_id, String transType) throws Exception {
        communicatorLog.info("requestReportPAC-GZZRX\uff1astar-----------------------");
        communicatorLog.info("requestReportPAC-GZZRX\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + report_id);
        InsCommonReportVo vo = this.insCommonReportAPIService.getInsCommonReportVoInfoById(report_id, 1);
        String result = "300#\uff08APP-PAC-GZZRX-REPORT-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String json = GZZRX_PackageMessagePAC.marshalReport(vo, transType);
            communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
            String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/" + GZZRX_PACRequestService.getUrlByTransType("", transType) + "?access_token=" + this.policyService.pnc_access_token();
            if (TransTypeEnum.CLSC.equals((Object)transType)) {
                url = url + "&request_id=fileUpload" + System.currentTimeMillis();
            }
            communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
            Date bTime = new Date();
            String ret = OpenApiPost.post(url, json);
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(report_id), transType, url, json, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            result = GZZRX_PackageMessagePAC.returnAnalysisJson_LP(ret, transType);
            communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            ex.printStackTrace();
        }
        communicatorLog.info("requestReportPAC-GZZRX\uff1aend-----------------------");
        return result;
    }

    public String requestXXReportPAC(String policyNos, Integer pageSize, Integer pageNum, String transType) throws Exception {
        communicatorLog.info("requestXXReportPAC-GZZRX\uff1astar-----------------------");
        communicatorLog.info("requestXXReportPAC-GZZRX\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u4fdd\u5355\u53f7\u5217-" + policyNos);
        String result = "300#\uff08APP-PAC-GZZRX-XXREPORT-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        try {
            JSONObject body = new JSONObject();
            body.put("policyNos", (Object)policyNos);
            body.put("pageNum", (Object)pageNum);
            body.put("pageSize", (Object)pageSize);
            String json = body.toString();
            communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
            String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/" + GZZRX_PACRequestService.getUrlByTransType("", transType) + "?access_token=" + this.policyService.pnc_access_token();
            communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
            String ret = OpenApiPost.post(url, json);
            communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            result = GZZRX_PackageMessagePAC.returnAnalysisJson_LP(ret, transType);
            communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        communicatorLog.info("requestXXReportPAC-GZZRX\uff1aend-----------------------");
        return result;
    }

    public String submitReportPAC(InsCommonReportVo vo, String transType) throws Exception {
        communicatorLog.info("submitReportPAC-GZZRX\uff1astar-----------------------");
        String result = "300#\uff08APP-PAC-GZZRX-REPORT-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String json = GZZRX_PackageMessagePAC.marshalReport(vo, transType);
            communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
            String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/" + GZZRX_PACRequestService.getUrlByTransType("", transType) + "?access_token=" + this.policyService.pnc_access_token();
            if (TransTypeEnum.CLSC.equals((Object)transType)) {
                url = url + "&request_id=fileUpload" + System.currentTimeMillis();
            }
            communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
            Date bTime = new Date();
            String ret = OpenApiPost.post(url, json);
            lb = this.logBusinessrequestService.initLogBusinessrequest(vo.getIns_common_report_id(), transType, url, json, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            result = GZZRX_PackageMessagePAC.returnAnalysisJson_LP(ret, transType);
            communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            ex.printStackTrace();
        }
        communicatorLog.info("submitReportPAC-GZZRX\uff1aend-----------------------");
        return result;
    }

    private Map<String, String> getIobsParam() {
        String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/interface/uploadFileOpenApi/fileUploadToken?access_token=" + this.policyService.pnc_access_token() + "&request_id=fileUploadToken" + System.currentTimeMillis();
        communicatorLog.info("===========================PNC_GET_UPLOAD_ACCESS_TOKEN_URL-START======================");
        try {
            communicatorLog.info("\u5e73\u5b89\u8d22\u62a5\u6848\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u7684token\u83b7\u53d6,\u5730\u5740\uff1a" + url);
            String result = OpenApiPost.post(url, "");
            communicatorLog.info("\u5e73\u5b89\u8d22\u62a5\u6848\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u7684token\u83b7\u53d6,\u8fd4\u56de\u62a5\u6587\uff1a" + result);
            if (StringUtils.isNotEmpty((String)result)) {
                return GZZRX_PACRequestService.jxToken(result);
            }
        }
        catch (Exception ex) {
            communicatorLog.error("PNC_GET_UPLOAD_ACCESS_TOKEN_URL-ERROR", (Throwable)ex);
        }
        return null;
    }

    private static Map<String, String> jxToken(String apiResult) {
        HashMap iobsMap = null;
        JSONObject apiJson = JSON.parseObject((String)apiResult);
        if ("0".equals(apiJson.getString("ret"))) {
            iobsMap = Maps.newHashMap();
            iobsMap.put("token", apiJson.getJSONObject("data").getJSONObject("data").getString("fileUploadToken"));
            iobsMap.put("bucket", apiJson.getJSONObject("data").getJSONObject("data").getString("bucket"));
            communicatorLog.info("\u5e73\u5b89\u8d22\u62a5\u6848\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u7684token\u83b7\u53d6,token\u503c\uff1a" + (String)iobsMap.get("token") + ",bucket\u503c\uff1a" + (String)iobsMap.get("bucket"));
            communicatorLog.info("===========================PNC_GET_UPLOAD_ACCESS_TOKEN_URL-END======================");
        }
        return iobsMap;
    }

    public boolean isUploadPA(InputStream inputStream, String fileId, String originalName) throws IOException {
        Map<String, String> iobsParamMap = this.getIobsParam();
        if (iobsParamMap != null) {
            long length = inputStream.available();
            Config.HOST = GlobalResources.PN_IOBS_URL;
            communicatorLog.info("\u62a5\u6848\u9644\u4ef6\u4e0a\u4f20Iobs\u63a5\u53e3,\u8bf7\u6c42\u53c2\u6570\uff1afileId\u503c\uff1a" + fileId + ",host\u503c\uff1a" + Config.HOST + ",bucket\u503c\uff1a" + iobsParamMap.get("bucket") + ",fileName\u503c\uff1a" + originalName + ",token\u503c\uff1a" + iobsParamMap.get("token") + ",length\u503c\uff1a" + length);
            Response response = new IobsService().uploadStream(iobsParamMap.get("bucket"), fileId, inputStream, originalName, iobsParamMap.get("token"), length);
            communicatorLog.info("\u5e73\u5b89\u8d22\u62a5\u6848\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u7528\u4e8e\u6fc0\u6d3bfileId,\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)response));
            if (response.isOK()) {
                communicatorLog.info("\u5e73\u5b89\u8d22\u62a5\u6848\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3fileId\u5df2\u6fc0\u6d3b,fileId\uff1a" + fileId);
                return true;
            }
            communicatorLog.error("\u5e73\u5b89\u8d22\u62a5\u6848\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3fileId\u6fc0\u6d3b\u5931\u8d25,ERROR:", (Object)response.error());
        }
        return false;
    }
}

