/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzx.taibao;

import com.bcxin.ins.third.build.taibao.CommunicateType;
import com.bcxin.ins.third.build.taibao.SimplePathResultXMLProcesser;
import com.bcxin.ins.third.build.taibao.TransType;
import com.bcxin.ins.third.gzx.taibao.PackageMessageTaiBao;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.XMLUtil;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="tbRequestService")
@Transactional
public class TBRequestService {
    private Logger communicatorLog = LoggerFactory.getLogger((String)"TBRequestService");
    private SimplePathResultXMLProcesser xmlProcesser = new SimplePathResultXMLProcesser();
    private static final String MESSAGEROUTER = "3";
    private static final String PARTNERCODE = "XMBCX";
    private static final String DOCUMENTPROTOCOL = "CPIC_ECOM";

    public String sendAndReturn(String tsNumber, SpecialPublicDutyVo vo, OrderFormVo dto, String tb_code, CommunicateType communicateType, String paymentType, TransType transType, String sign) {
        try {
            String returnXML = "";
            String xml = PackageMessageTaiBao.marshal(tsNumber, vo, dto, tb_code, paymentType, transType);
            this.communicatorLog.info(DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "\u8bf7\u6c42\u62a5\u6587\uff1a");
            this.communicatorLog.info(XMLUtil.formatXML((String)xml));
            if (!CommunicateType.TAIBAO.equals((Object)communicateType)) {
                return "";
            }
            for (int i = 0; i < 3 && !StringUtils.isNotEmpty((CharSequence)(returnXML = this.syncTB(xml))); ++i) {
            }
            this.communicatorLog.info(DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "\u8fd4\u56de\u62a5\u6587\uff1a");
            if (StringUtils.isEmpty((CharSequence)returnXML)) {
                return "300#\u94fe\u63a5\u8d85\u65f6\u6216\u6570\u636e\u4e22\u5931\uff01";
            }
            if (!this.xmlProcesser.isTBSuccess(returnXML)) {
                return "300#" + this.xmlProcesser.isTBFailMessage(returnXML);
            }
            if (TransType.EPIC_INS.equals((Object)transType)) {
                this.communicatorLog.info(XMLUtil.formatXML((String)returnXML));
                return "200#" + this.xmlProcesser.getTBPolicyNumber(returnXML);
            }
            if (TransType.EPIC_QUERY.equals((Object)transType)) {
                this.communicatorLog.info(XMLUtil.formatXML((String)returnXML));
                return "200#" + this.xmlProcesser.getTBPolicyEx(returnXML);
            }
            if (TransType.EPIC_EPOLICY.equals((Object)transType)) {
                this.communicatorLog.info("107003\u4e1a\u52a1\uff0c\u6587\u4ef6\u6d41\u8fc7\u5927\uff0c\u5728\u6b64\u7701\u7565...");
                return "200#" + this.xmlProcesser.getTBPolicyPDF(returnXML, dto.getExternal_reference(), sign);
            }
            return "";
        }
        catch (Exception e) {
            this.communicatorLog.info(e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    private String syncTB(String requestMeg) {
        String result = "";
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("messageRouter", MESSAGEROUTER));
            params.add(new BasicNameValuePair("tradingPartner", PARTNERCODE));
            params.add(new BasicNameValuePair("documentProtocol", DOCUMENTPROTOCOL));
            params.add(new BasicNameValuePair("requestMessage", requestMeg));
            DefaultHttpClient client = new DefaultHttpClient();
            this.registerSSLSocketFactory((HttpClient)client);
            this.communicatorLog.info("request url:" + GlobalResources.CPIC_INS_URL);
            HttpPost post = new HttpPost(GlobalResources.CPIC_INS_URL);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception e) {
            this.communicatorLog.info(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSSLSocketFactory(HttpClient httpclient) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        GlobalResources res = new GlobalResources();
        FileInputStream instream = null;
        HttpServletRequest request = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        String fileUrl = "";
        if (request != null) {
            fileUrl = request.getSession().getServletContext().getRealPath("/WEB-INF/cpic_jttp.keystore");
            instream = new FileInputStream(new File(fileUrl));
        }
        try {
            trustStore.load(instream, "cpicJttp".toCharArray());
        }
        finally {
            instream.close();
        }
        SSLSocketFactory socketFactory = new SSLSocketFactory(trustStore);
        Scheme sch = new Scheme("https", (SocketFactory)socketFactory, 443);
        httpclient.getConnectionManager().getSchemeRegistry().register(sch);
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(plainText.getBytes("UTF-8"));
        byte[] b = md.digest();
        StringBuffer buf = new StringBuffer("");
        for (int offset = 0; offset < b.length; ++offset) {
            int i = b[offset];
            if (i < 0) {
                i += 256;
            }
            if (i < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(i));
        }
        return buf.toString();
    }
}

