/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzx.taibao;

import com.bcxin.ins.third.build.taibao.TransType;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PackageMessageTaiBao {
    private static final String APPLICANT = "Applicant";
    private static final String INSURED = "Insured";
    private static final String BLANK_CHAR = "";
    private static final String PARTNERCODE = "XMBCX";
    private static final String TBUSER = "XMBCX";
    private static final String TBPASS = "+kp0LXaWRRWq2bsb/EJR22O2aqjghfCrGe/OaJJheaJttbKcDxlXiDYfpcxLK1fKm75rGAjtNsTFuxt/v/F+Vw==";

    public static String marshal(String tsNumber, SpecialPublicDutyVo policy, OrderFormVo orderVo, String tb_code, String paymentType, TransType transType) throws Exception {
        if (policy == null) {
            return BLANK_CHAR;
        }
        Document requestDocument = DocumentHelper.createDocument();
        requestDocument.setXMLEncoding("UTF-8");
        Element rootElement = requestDocument.addElement("request");
        try {
            Element headElement = rootElement.addElement("head");
            PackageMessageTaiBao.marshalHead(tsNumber, headElement, transType);
            Element bodyElement = rootElement.addElement("body");
            Element entityElement = bodyElement.addElement("entity");
            if (TransType.EPIC_INS.equals((Object)transType)) {
                Element plcBase = entityElement.addElement("plcBase");
                Element applicant = entityElement.addElement("applicant");
                Element insuredList = entityElement.addElement("insuredList");
                Element pconstruct = entityElement.addElement("pconstruct");
                Element elcPolicy = entityElement.addElement("elcPolicy");
                RoleSubjectVo applicants = (RoleSubjectVo)policy.getRoleSubjectList().get(0);
                RoleSubjectVo insureds = (RoleSubjectVo)policy.getRoleSubjectList().get(1);
                PackageMessageTaiBao.marshalPolicy(policy, tb_code, paymentType, plcBase);
                PackageMessageTaiBao.marshalPconstruct(policy, pconstruct);
                PackageMessageTaiBao.marshalApplicant(applicants, applicant);
                PackageMessageTaiBao.marshalInsured(policy, insureds, insuredList);
                PackageMessageTaiBao.marshalElcPolicy(applicants, elcPolicy);
            } else if (TransType.EPIC_QUERY.equals((Object)transType)) {
                entityElement.addElement("queryType").setText(String.valueOf("0"));
                entityElement.addElement("plcApplyNo").setText(String.valueOf(orderVo.getPolicy_serial_number()));
            } else if (TransType.EPIC_EPOLICY.equals((Object)transType)) {
                RoleSubjectVo applicants = (RoleSubjectVo)policy.getRoleSubjectList().get(0);
                entityElement.addElement("plcNo").setText(String.valueOf(orderVo.getExternal_reference()));
                entityElement.addElement("elcMsgFlag").setText(String.valueOf("0"));
                entityElement.addElement("elcMobile").setText(String.valueOf(applicants.getLink_tel()));
                entityElement.addElement("elcEmlFlag").setText(String.valueOf("0"));
                entityElement.addElement("elcEmail").setText(String.valueOf(BLANK_CHAR));
                entityElement.addElement("returnPDF").setText(String.valueOf("1"));
            }
            String requestMsg = requestDocument.asXML();
            return requestMsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void marshalPconstruct(SpecialPublicDutyVo policy, Element underwrite) {
    }

    private static void marshalHead(String tsNumber, Element underwrite, TransType transType) {
        underwrite.addElement("partnerCode").setText("XMBCX");
        underwrite.addElement("transactionCode").setText(transType.getValue());
        underwrite.addElement("messageId").setText(tsNumber);
        SimpleDateFormat dateFormatAll = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        underwrite.addElement("transactionEffectiveDate").setText(dateFormatAll.format(new Date()));
        underwrite.addElement("user").setText("XMBCX");
        underwrite.addElement("password").setText(TBPASS);
    }

    private static void marshalPolicy(SpecialPublicDutyVo policy, String tb_code, String paymentType, Element underwrite) {
        underwrite.addElement("plcTerminalNo").setText(tb_code);
        underwrite.addElement("plcBusinessNo").setText(policy.getTrade_serial_number());
        underwrite.addElement("plcPlanCode").setText("PN130932001600000006");
        SimpleDateFormat dateFormatH = new SimpleDateFormat("yyyyMMddHH");
        underwrite.addElement("plcStartDate").setText(dateFormatH.format(DateUtil.convertStringToDate((String)policy.getInception_date())));
        String dateEnd = dateFormatH.format(DateUtil.convertStringToDate((String)policy.getPlanned_end_date()));
        dateEnd = dateEnd.substring(0, dateEnd.length() - 2) + "24";
        underwrite.addElement("plcEndDate").setText(dateEnd);
        underwrite.addElement("plcAmount").setText(String.valueOf(policy.getInsured_amount()));
        underwrite.addElement("plcCopies").setText(String.valueOf(1));
        underwrite.addElement("plcElcFlag").setText("0");
        underwrite.addElement("paymentWay").setText(paymentType);
        underwrite.addElement("wxUrl").setText("0");
    }

    private static void marshalPayinfo(SpecialBidVo policy, Element underwrite) {
        underwrite.addElement("payType").setText("4");
        underwrite.addElement("payNo").setText("Test201521");
        underwrite.addElement("payMerchantNo").setText("Test20150129");
        SimpleDateFormat dateFormatAny = new SimpleDateFormat("yyyyMMddHHmmss");
        underwrite.addElement("payConfirmDate").setText(dateFormatAny.format(new Date()));
    }

    private static void marshalApplicant(RoleSubjectVo applicant, Element underwrite) {
        underwrite.addElement("apltCretCode").setText(String.valueOf(applicant.getOrganization_code()));
        underwrite.addElement("apltCretType").setText("4");
        underwrite.addElement("apltName").setText(String.valueOf(applicant.getName_cn()));
        underwrite.addElement("apltEmail").setText(String.valueOf(applicant.getLink_email()));
        underwrite.addElement("apltTelephone").setText(String.valueOf(applicant.getPhone()));
        underwrite.addElement("apltMobile").setText(String.valueOf(applicant.getLink_tel()));
        String address = RegionUtils.getRegionNameByALLCode((String)applicant.getReg_province(), (String)applicant.getReg_city(), (String)applicant.getReg_district()) + applicant.getReg_address();
        underwrite.addElement("apltAddress").setText(address);
        underwrite.addElement("apltPost").setText(String.valueOf(applicant.getZip_code()));
        underwrite.addElement("apltCntactName").setText(String.valueOf(applicant.getLink_name()));
    }

    private static void marshalInsured(SpecialPublicDutyVo policy, RoleSubjectVo insured, Element underwrite) {
        Element insuredElement = underwrite.addElement("insured");
        insuredElement.addElement("isrdCretCode").setText(String.valueOf(insured.getOrganization_code()));
        insuredElement.addElement("isrdCretType").setText("4");
        insuredElement.addElement("isrdName").setText(String.valueOf(insured.getName_cn()));
        insuredElement.addElement("isrdTelephone").setText(String.valueOf(insured.getPhone()));
        insuredElement.addElement("isrdMobile").setText(String.valueOf(insured.getLink_tel()));
        String address = RegionUtils.getRegionNameByALLCode((String)insured.getReg_province(), (String)insured.getReg_city(), (String)insured.getReg_district()) + insured.getReg_address();
        insuredElement.addElement("isrdAddress").setText(address);
        insuredElement.addElement("isrPost").setText(String.valueOf(insured.getZip_code()));
        insuredElement.addElement("isrCntactName").setText(String.valueOf(insured.getLink_name()));
    }

    private static void marshalElcPolicy(RoleSubjectVo applicants, Element underwrite) {
        underwrite.addElement("elcMsgFlag").setText("1");
        underwrite.addElement("elcMobile").setText(String.valueOf(applicants.getTel()));
        underwrite.addElement("elcEmlFlag").setText("1");
        underwrite.addElement("elcEmail").setText(String.valueOf(applicants.getLink_email()));
    }

    private static void marshalAddressMsg(SpecialBidVo policy, RoleSubjectVo insureds, Element underwrite) {
        Element address = underwrite.addElement("address");
        address.addElement("adsPostCode").setText(String.valueOf("363900"));
        address.addElement("insurcode").setText(String.valueOf(insureds.getName_cn()));
        address.addElement("adsAddress").setText(String.valueOf("\u6f33\u5dde"));
        address.addElement("adsCity").setText(String.valueOf("150300"));
    }
}

