/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gyx.taibao;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.third.build.taibao.SimplePathResultXMLProcesser;
import com.bcxin.ins.third.gyx.taibao.util.TbRsaUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.XMLUtil;
import com.bcxin.ins.vo.GYXPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GYX_PackageMessageTaiBao {
    private static Logger logger = LoggerFactory.getLogger(GYX_PackageMessageTaiBao.class);
    private static final String AGENCYCODE = "BCX";
    private static final String FUNCTION = "person";
    private static final String PRODUCTCODE = "0200006";

    public static String marshal(GYXPolicyVo policy, OrderFormVo orderVo, String transType, String payType) throws Exception {
        if (policy == null) {
            return "";
        }
        Document requestDocument = DocumentHelper.createDocument();
        requestDocument.setXMLEncoding("UTF-8");
        Element rootElement = requestDocument.addElement("request");
        try {
            Element headElement = rootElement.addElement("head");
            GYX_PackageMessageTaiBao.marshalHead(headElement, orderVo, transType);
            Element bodyElement = rootElement.addElement("body");
            if ("1".equals(transType)) {
                RoleSubjectVo applicants = (RoleSubjectVo)policy.getRoleSubjectList().get(0);
                RoleSubjectVo insureds = (RoleSubjectVo)policy.getRoleSubjectList().get(1);
                Element projectInfo = bodyElement.addElement("project");
                GYX_PackageMessageTaiBao.marshalProjectInfo(projectInfo, orderVo);
                Element applicant = bodyElement.addElement("applicant");
                GYX_PackageMessageTaiBao.marshalApplicants(applicant, applicants);
                Element insuredsE = bodyElement.addElement("insureds");
                Element insured = insuredsE.addElement("insured");
                GYX_PackageMessageTaiBao.marshalInsureds(insured, insureds);
            } else if ("2".equals(transType)) {
                Element payment = bodyElement.addElement("payment");
                GYX_PackageMessageTaiBao.marshalPayment(payment, orderVo, payType);
            } else if ("5".equals(transType)) {
                Element endor = bodyElement.addElement("endor");
                GYX_PackageMessageTaiBao.marshalEndor(endor, orderVo);
            }
            String requestMsg = requestDocument.asXML();
            return requestMsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String marshalResult(OrderFormVo orderVo, JSONObject msgJson) throws Exception {
        if (orderVo == null) {
            return "";
        }
        Document requestDocument = DocumentHelper.createDocument();
        requestDocument.setXMLEncoding("UTF-8");
        Element rootElement = requestDocument.addElement("response");
        try {
            Element headElement = rootElement.addElement("head");
            headElement.addElement("productCode").setText(PRODUCTCODE);
            headElement.addElement("orderNo").setText(orderVo.getTrade_serial_number());
            SimpleDateFormat dateFormatAll = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            headElement.addElement("transTime").setText(dateFormatAll.format(new Date()));
            headElement.addElement("agencyCode").setText(AGENCYCODE);
            headElement.addElement("businessType").setText("payResult");
            Element bodyElement = rootElement.addElement("body");
            bodyElement.addElement("successInd").setText(String.valueOf(msgJson.get((Object)"successInd")));
            bodyElement.addElement("errorCode").setText(String.valueOf(msgJson.get((Object)"errorCode")));
            bodyElement.addElement("errorMessage").setText(String.valueOf(msgJson.get((Object)"errorMessage")));
            String requestMsg = requestDocument.asXML();
            return requestMsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void marshalHead(Element underwrite, OrderFormVo orderVo, String transType) {
        underwrite.addElement("productCode").setText(PRODUCTCODE);
        underwrite.addElement("orderNo").setText(orderVo.getTrade_serial_number());
        SimpleDateFormat dateFormatAll = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        underwrite.addElement("transTime").setText(dateFormatAll.format(new Date()));
        underwrite.addElement("agencyCode").setText(AGENCYCODE);
        String bt = "";
        if ("1".equals(transType)) {
            underwrite.addElement("function").setText(FUNCTION);
            bt = "proposal";
        } else if ("2".equals(transType)) {
            bt = "payRegist";
        } else if ("5".equals(transType)) {
            bt = "endor";
        }
        underwrite.addElement("businessType").setText(bt);
    }

    private static void marshalProjectInfo(Element underwrite, OrderFormVo orderVo) {
        int days = DateUtil.getDistDates((Date)DateUtil.convertString2Date((String)(orderVo.getInception_date() + " 00:00:00")), (Date)DateUtil.convertString2Date((String)(orderVo.getPlanned_end_date() + " 23:59:59")));
        underwrite.addElement("projectCode").setText(GYX_PackageMessageTaiBao.getPCode(days + 1));
        underwrite.addElement("projectName").setText(GYX_PackageMessageTaiBao.getPName(days + 1));
        underwrite.addElement("geographicalArea").setText("00001");
        underwrite.addElement("operateDate").setText(orderVo.getStart_time());
        underwrite.addElement("startDate").setText(orderVo.getInception_date() + " 00:00:00");
        underwrite.addElement("endDate").setText(orderVo.getPlanned_end_date() + " 23:59:59");
        underwrite.addElement("currency").setText("CNY");
        underwrite.addElement("uwCount").setText("1");
        underwrite.addElement("sumInsured").setText(orderVo.getInsured_amount());
        underwrite.addElement("sumPremium").setText(orderVo.getGross_premium());
    }

    private static String getPCode(int days) {
        if (days == 1) {
            return "0001";
        }
        if (days > 1 && days < 8) {
            return "0002";
        }
        if (days > 7 && days < 16) {
            return "0003";
        }
        if (days > 15 && days < 31) {
            return "0004";
        }
        return "";
    }

    private static String getPName(int days) {
        if (days == 1) {
            return "\u4fdd\u5b89\u4eba\u5458\u6781\u77ed\u671f\u4e2a\u4eba\u610f\u9669-\uff081\u5929\uff09";
        }
        if (days > 1 && days < 8) {
            return "\u4fdd\u5b89\u4eba\u5458\u6781\u77ed\u671f\u4e2a\u4eba\u610f\u9669-\uff082-7\u5929\uff09";
        }
        if (days > 7 && days < 16) {
            return "\u4fdd\u5b89\u4eba\u5458\u6781\u77ed\u671f\u4e2a\u4eba\u610f\u9669-\uff088-15\u5929\uff09";
        }
        if (days > 15 && days < 31) {
            return "\u4fdd\u5b89\u4eba\u5458\u6781\u77ed\u671f\u4e2a\u4eba\u610f\u9669-\uff0816-30\u5929\uff09";
        }
        return "";
    }

    private static void marshalApplicants(Element underwrite, RoleSubjectVo applicants) {
        underwrite.addElement("appliType").setText("1");
        underwrite.addElement("appliName").setText(applicants.getName_cn());
        underwrite.addElement("sex").setText("1".equals(applicants.getSex()) ? "1" : "2");
        underwrite.addElement("identifyType").setText(GYX_PackageMessageTaiBao.getCard(applicants.getId_type()));
        underwrite.addElement("identifyNumber").setText(String.valueOf(applicants.getOrganization_code()));
        underwrite.addElement("birthDate").setText(String.valueOf(applicants.getBirth_date()));
        underwrite.addElement("mobilephone").setText(String.valueOf(applicants.getMobile()));
    }

    private static void marshalPayment(Element underwrite, OrderFormVo orderVo, String payType) {
        underwrite.addElement("proposalNo").setText(orderVo.getPolicy_serial_number());
        underwrite.addElement("payMathod").setText(GYX_PackageMessageTaiBao.getPayMathod(payType));
        underwrite.addElement("payModelNo").setText(GYX_PackageMessageTaiBao.getPayModelNo(payType));
        underwrite.addElement("amount").setText(String.valueOf(new BigDecimal(orderVo.getGross_premium()).multiply(new BigDecimal("100"))));
        String returnUrl = GlobalResources.DONOW_PATH + "/TBAPI/GYX/syntony-service/" + orderVo.getOid();
        if ("BLB".equals(orderVo.getWeb_type())) {
            returnUrl = GlobalResources.WEB_URL + "/insurance/gyx/transaction/syntony-service/" + orderVo.getOid();
        }
        underwrite.addElement("pageURL").setText(returnUrl);
    }

    private static String getPayMathod(String pm) {
        String result = "";
        result = "2".equals(pm) ? "0102" : "0101";
        return result;
    }

    private static String getPayModelNo(String pm) {
        String result = "";
        result = "2".equals(pm) ? "01020002" : "01010001";
        return result;
    }

    private static void marshalPaymentResult(Element underwrite) {
        underwrite.addElement("successInd").setText("");
        underwrite.addElement("errorCode").setText("");
        underwrite.addElement("errorMessage").setText("");
    }

    private static void marshalCB(Element underwrite, OrderFormVo orderVo) {
        underwrite.addElement("proposalNo").setText(orderVo.getPolicy_serial_number());
        underwrite.addElement("policyNo").setText(orderVo.getExternal_reference());
        underwrite.addElement("policyUrl").setText("");
    }

    private static void marshalEndor(Element underwrite, OrderFormVo orderVo) {
        underwrite.addElement("policyNo").setText(orderVo.getExternal_reference());
        underwrite.addElement("applyNo").setText("");
        underwrite.addElement("endorType").setText("0201");
    }

    private static void marshalInsureds(Element underwrite, RoleSubjectVo insureds) {
        underwrite.addElement("insuredType").setText("1");
        underwrite.addElement("insuredName").setText(insureds.getName_cn());
        underwrite.addElement("sex").setText("1".equals(insureds.getSex()) ? "1" : "2");
        underwrite.addElement("identifyType").setText(GYX_PackageMessageTaiBao.getCard(insureds.getId_type()));
        underwrite.addElement("identifyNumber").setText(String.valueOf(insureds.getOrganization_code()));
        underwrite.addElement("appliRelation").setText("01");
        underwrite.addElement("birthDate").setText(String.valueOf(insureds.getBirth_date()));
        underwrite.addElement("mobilephone").setText(String.valueOf(insureds.getMobile()));
    }

    private static String getCard(String cardType) {
        if ("0".equals(cardType)) {
            return "01";
        }
        if ("3".equals(cardType)) {
            return "02";
        }
        if ("4".equals(cardType)) {
            return "05";
        }
        return "99";
    }

    public static String returnAnalysisXML(String returnXML, String transType) throws Exception {
        SimplePathResultXMLProcesser xmlProcesser = new SimplePathResultXMLProcesser();
        if (TbRsaUtils.verifySign(returnXML)) {
            String result = xmlProcesser.isGYXSuccess(returnXML);
            logger.info("\u8fd4\u56de\u62a5\u6587\u89e3\u6790\uff1a" + result);
            String[] resultArr = result.split("#");
            if ("0000".equals(resultArr[0])) {
                if ("1".equals(transType)) {
                    logger.info(XMLUtil.formatXML((String)returnXML));
                    return "200#" + resultArr[2];
                }
                if ("2".equals(transType)) {
                    logger.info(XMLUtil.formatXML((String)returnXML));
                    return "200#" + resultArr[2] + "#" + resultArr[3];
                }
                return "300#\uff08APP-TB-002.1\uff09\u83b7\u53d6\u4e1a\u52a1\u7f16\u7801\u51fa\u73b0\u5f02\u5e38";
            }
            return "300#\uff08APP-GYX-" + resultArr[0] + "\uff09" + resultArr[1];
        }
        return "300#\uff08APP-GYX-001\uff09\u62a5\u6587\u7b7e\u540d\u4e0d\u5339\u914d";
    }

    public static String resultAnalysisXML(String returnXML, String transType) throws Exception {
        SimplePathResultXMLProcesser xmlProcesser = new SimplePathResultXMLProcesser();
        if (TbRsaUtils.verifyResultSign(returnXML)) {
            String result = xmlProcesser.isGYXResultSuccess(returnXML);
            logger.info("\u8fd4\u56de\u62a5\u6587\u89e3\u6790\uff1a" + result);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                logger.info(XMLUtil.formatXML((String)returnXML));
                String[] resultArr = result.split("#");
                if ("1".equals(transType)) {
                    return "200#" + resultArr[0] + "#" + resultArr[3];
                }
                if ("2".equals(transType)) {
                    return "200#" + resultArr[0] + "#" + resultArr[1] + "#" + resultArr[2];
                }
                return "300#\uff08APP-TB-002.1\uff09\u83b7\u53d6\u4e1a\u52a1\u7f16\u7801\u51fa\u73b0\u5f02\u5e38";
            }
            return "300#\uff08APP-GYX-003\uff09\u62a5\u6587\u89e3\u6790\u5931\u8d25";
        }
        return "300#\uff08APP-GYX-001\uff09\u62a5\u6587\u7b7e\u540d\u4e0d\u5339\u914d";
    }
}

