/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.preservation.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.dao.preservation.InsPreservationRecordAPIDao;
import com.bcxin.ins.entity.policy_core.InsOrderReconciliation;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.common.ModelSendService;
import com.bcxin.ins.service.order.ComTaskResidualAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.third.gzzrx.changan.GZZRX_CARequestService;
import com.bcxin.ins.third.gzzrx.pingancai.GZZRX_PACRequestService;
import com.bcxin.ins.third.gzzrx.qianhai.GZZRX_QHRequestService;
import com.bcxin.ins.third.gzzrx.renbao.GZZRX_RBRequestService;
import com.bcxin.ins.third.gzzrx.taibao.GZZRX_TBRequestService;
import com.bcxin.ins.third.gzzrx.zhonghua.GZZRX_ZHRequestService;
import com.bcxin.ins.third.tyx.changan.TYX_CARequestService;
import com.bcxin.ins.third.tyx.huatai.TYX_HTRequestService;
import com.bcxin.ins.third.tyx.pingancai.PACRequestService;
import com.bcxin.ins.third.tyx.qianhai.TYX_QHRequestService;
import com.bcxin.ins.third.tyx.renbao.PackageMessageRB;
import com.bcxin.ins.third.tyx.renbao.RBRequestService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IdNumberValidator;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.EmailMsgRecordType;
import com.bcxin.ins.util.email.EmailMsgType;
import com.bcxin.ins.util.email.MessageModel;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.http.HuaWeiSmsContent;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class InsPreservationRecordAPIServiceImpl
extends ServiceImpl<InsPreservationRecordAPIDao, InsPreservationRecord>
implements InsPreservationRecordAPIService {
    private Logger log = LoggerFactory.getLogger(InsPreservationRecordAPIServiceImpl.class);
    @Autowired
    private InsPreservationRecordAPIDao insPreservationRecordAPIDao;
    @Autowired
    private InsPreservationDetailAPIService insPreservationDetailAPIService;
    @Autowired
    private InsPreservationResultSetAPIService insPreservationResultSetAPIService;
    @Autowired
    private InsPreservationPayAPIService insPreservationPayAPIService;
    @Autowired
    private InsRoleInpolicyAPIService insRoleInpolicyService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ComDeployConfigService comDeployConfigService;
    @Autowired
    private GZZRX_RBRequestService gZZRX_RBRequestService;
    @Autowired
    private RBRequestService rBRequestService;
    @Autowired
    private GZZRX_ZHRequestService gZZRX_ZHRequestService;
    @Autowired
    private GZZRX_PACRequestService gZZRX_PACRequestService;
    @Autowired
    private GZZRX_CARequestService gZZRX_CARequestService;
    @Autowired
    private TYX_CARequestService tYX_CARequestService;
    @Autowired
    private GZZRX_QHRequestService gZZRX_QHRequestService;
    @Autowired
    private GZZRX_TBRequestService gZZRX_TBRequestService;
    @Autowired
    private TYX_QHRequestService tYX_QHRequestService;
    @Autowired
    private PACRequestService pACRequestService;
    @Autowired
    private TYX_HTRequestService tYX_HTRequestService;
    @Autowired
    private ModelSendService mss;
    @Autowired
    private ComTaskResidualAPIService comTaskResidualAPIService;
    private static ConcurrentHashMap<String, Integer> plyNoMap = new ConcurrentHashMap();

    @Override
    public List<InsPreservationRecord> findInsPreservationRecordByKeyword(DwzPage page, Long userId, String revise_status, String start_time, String end_time, String keyword) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsPreservationRecord> list = this.insPreservationRecordAPIDao.findInsPreservationRecordByKeyword((Page<InsPreservationRecord>)pageHelper, userId, revise_status, start_time, end_time, keyword);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public boolean countDSHByPolicyNo(String policyNo) {
        int count = this.insPreservationRecordAPIDao.countDSHByPolicyNo(policyNo);
        return count > 0;
    }

    @Override
    public InsPreservationRecordVo findInsPreservationRecordVoById(Long oid) {
        InsPreservationRecordVo vo = this.insPreservationRecordAPIDao.findInsPreservationRecordVoById(oid);
        if (vo == null) {
            return vo;
        }
        List<InsPreservationDetailVo> ipdVolist = this.insPreservationDetailAPIService.findInsPreservationDetailVoByPreservationId("", oid);
        if ("1".equals(vo.getRevise_type())) {
            vo.setInsPreservationDetailVoList(ipdVolist);
            return vo;
        }
        for (InsPreservationDetailVo ipdVo : ipdVolist) {
            if (!StringUtils.isNotBlank((String)ipdVo.getBusiness_str())) continue;
            String[] arr = ipdVo.getBusiness_str().split("#");
            InsPreservationDetailVo detailVo = new InsPreservationDetailVo();
            detailVo.setName(arr[0]);
            detailVo.setId_card(arr[1]);
            detailVo.setId_type(arr[2]);
            detailVo.setTel(arr[3]);
            detailVo.setBirthday(arr[4]);
            detailVo.setSex(arr[5]);
            detailVo.setCareer(arr[6]);
            ipdVo.setBusiness_vo(detailVo);
        }
        vo.setInsPreservationDetailVoList(ipdVolist);
        return vo;
    }

    private void compensateRecord(Long policyId) {
        List<String> list = this.selectRecordIdByPolicyIdAndStatus(policyId, "2", "");
        for (String record_id : list) {
            this.addFindPDTask(record_id);
        }
    }

    @Override
    public boolean getDZPD(Long preservationId) {
        InsPreservationRecord record = (InsPreservationRecord)this.insPreservationRecordAPIDao.selectById(preservationId);
        String path = this.printDZPD(record.getIns_preservation_record_id(), record.getRevise_serial_num_ins());
        return !StringUtils.isEmpty((String)path);
    }

    @Override
    public InsPreservationRecordVo findIPRVoById(Long oid) {
        return this.insPreservationRecordAPIDao.findInsPreservationRecordVoById(oid);
    }

    @Override
    public InsPreservationRecord findInsPreservationRecordByBySerialNum(String serial_num) {
        HashMap columnMap = Maps.newHashMap();
        columnMap.put("revise_serial_num_ins", serial_num);
        List list = this.insPreservationRecordAPIDao.selectByMap(columnMap);
        return list.size() > 0 ? (InsPreservationRecord)list.get(0) : null;
    }

    @Override
    public InsPreservationRecord findInsPreservationRecordBySerialNumber(String serial_number) {
        HashMap columnMap = Maps.newHashMap();
        columnMap.put("revise_serial_number", serial_number);
        List list = this.insPreservationRecordAPIDao.selectByMap(columnMap);
        return list.size() > 0 ? (InsPreservationRecord)list.get(0) : null;
    }

    @Override
    public InsPreservationRecord findInsPreservationRecordByPolicyID(Long policyID) {
        InsPreservationRecord ipr = null;
        List<InsPreservationRecord> list = this.insPreservationRecordAPIDao.findInsPreservationRecordByPolicyID(policyID);
        if (list != null && !list.isEmpty()) {
            ipr = list.get(ConstProp.INT_NUMBER_ZERO);
        }
        return ipr;
    }

    @Override
    public List<InsPreservationRecordVo> findInsPreservationRecordVoByPayId(DwzPage page, Long payId, String keyword) {
        if (page == null) {
            page = new DwzPage();
        }
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsPreservationRecordVo> list = this.insPreservationRecordAPIDao.findInsPreservationRecordVoByPayId((Page<InsPreservationRecordVo>)pageHelper, payId, keyword);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    private InsPreservationRecord initInsPreservationRecord(OrderFormVo vo, String revise_type, int AddNum, Date inception_date, Long policyID, String status, String revise_serial_number) {
        InsPreservationRecord ipr = new InsPreservationRecord();
        ipr.setInception_date(inception_date);
        ipr.setStart_time(new Date());
        ipr.setIns_insurance_slip_id(policyID);
        if (StringUtils.isEmpty((String)revise_serial_number)) {
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            revise_serial_number = String.valueOf(idWorker.nextId());
        }
        ipr.setRevise_serial_number(revise_serial_number);
        ipr.setRevise_status(status);
        ipr.setRevise_type(revise_type);
        if ("1".equals(revise_type)) {
            ipr.setAdd_count(AddNum);
        } else if ("2".equals(revise_type)) {
            ipr.setMinus_count(AddNum);
        } else if ("3".equals(revise_type)) {
            ipr.setReplace_count(AddNum);
        }
        ipr.setApp_role_name(vo.getApplicant_name());
        ipr.setPlanned_end_date(DateUtil.convertStringToDate((String)vo.getPlanned_end_date()));
        ipr.setExternal_reference(vo.getExternal_reference());
        ipr.setSys_client_user_id(Long.valueOf(Long.parseLong(vo.getUser_oid())));
        ipr.setSys_ins_company_id(Long.valueOf(Long.parseLong(vo.getInsurance_oid())));
        this.insert(ipr);
        return ipr;
    }

    private InsPreservationRecord updateInsPreservationRecord(Long preservationID, int AddNum, Date inception_date, String status) {
        InsPreservationRecord ipr = (InsPreservationRecord)this.selectById(preservationID);
        ipr.setInception_date(inception_date);
        ipr.setUpdate_time(new Date());
        if ("1".equals(ipr.getRevise_type())) {
            ipr.setAdd_count(AddNum);
        } else if ("2".equals(ipr.getRevise_type())) {
            ipr.setMinus_count(AddNum);
        } else if ("3".equals(ipr.getRevise_type())) {
            ipr.setReplace_count(AddNum);
        }
        ipr.setRevise_status(status);
        this.updateById(ipr);
        return ipr;
    }

    @Override
    public boolean createInsPreservationRecord(int sign, InsPreservationRecordVo iprVo, List<InsPreservationDetailVo> ipdVoList) {
        boolean flag = false;
        try {
            OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
            if (vo == null || ipdVoList == null || ipdVoList.isEmpty()) {
                return flag;
            }
            InsPreservationRecord ipr = null;
            String revise_status = "1";
            Date inception_date = null;
            if (StringUtils.isNotBlank((String)iprVo.getInception_date())) {
                inception_date = DateUtil.convertStringToDate((String)iprVo.getInception_date());
            }
            int count = ipdVoList.size();
            if (sign == 1) {
                revise_status = "2";
            }
            ipr = StringUtils.isNotBlank((String)iprVo.getOid()) ? this.updateInsPreservationRecord(Long.parseLong(iprVo.getOid()), count, inception_date, revise_status) : this.initInsPreservationRecord(vo, iprVo.getRevise_type(), count, inception_date, Long.parseLong(iprVo.getIns_insurance_slip_id()), revise_status, iprVo.getRevise_serial_number());
            if (NumberUtils.isNumber((String)iprVo.getTotal_premium())) {
                ipr.setTotal_premium(new BigDecimal(iprVo.getTotal_premium()));
                this.updateById(ipr);
            }
            this.insPreservationDetailAPIService.saveOrUpdateInsPreservationDetail(ipr.getRevise_type(), ipr.getIns_preservation_record_id(), ipdVoList);
            Long oid = ipr.getIns_preservation_record_id();
            iprVo.setOid(String.valueOf(oid));
            String ind = iprVo.getInception_date();
            if ("2".equals(revise_status)) {
                new Thread(() -> {
                    try {
                        this.sendPreservationEmail(vo.getProduct_code(), "", this.htmlContentByPreservationRecord(vo, ipdVoList, ind));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
            }
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u521b\u5efa\u4fdd\u5168\u7533\u8bf7\u5355\uff0c\u505a\u589e\u5458\uff0c\u51cf\u5458\uff0c\u66ff\u6362\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public void updateRecordStatus(String record_id, Map<String, String> map) {
        try {
            if (map == null) {
                return;
            }
            InsPreservationRecord record = (InsPreservationRecord)this.insPreservationRecordAPIDao.selectById(Long.valueOf(Long.parseLong(record_id)));
            if ("4".equals(record.getRevise_status()) || "5".equals(record.getRevise_status())) {
                return;
            }
            OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(record.getIns_insurance_slip_id());
            int sign = 0;
            if (StringUtils.isNotEmpty((String)vo.getProduct_code())) {
                sign = this.getSignAndSetRecord(map, record, vo, sign);
            }
            if (sign == 1) {
                record.setRevise_status("4");
                record.setUpdate_time(new Date());
                this.insPreservationPayAPIService.setIPPay(record, map);
                this.policyService.pushRecordInfo(record_id);
                new Thread(() -> this.printDZPD(Long.parseLong(record_id), record.getRevise_serial_num_ins())).start();
                if (!"1".equals(GlobalResources.IS_CLOSE_RECORD_SYNC)) {
                    new Thread(() -> this.policyService.recordSyncZC(record_id)).start();
                }
                new Thread(() -> this.sendEmailAndTelByRecord(record)).start();
            }
        }
        catch (Exception e) {
            this.log.error("\u4fee\u6539\u4fdd\u5168\u5355\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public String updateHTRecordStatus(String revise_serial_number, String revise_serial_num_ins, String eurl, String edrResult, String edrInfo) {
        try {
            InsPreservationRecord record = this.findInsPreservationRecordBySerialNumber(revise_serial_number);
            if ("4".equals(record.getRevise_status()) || "3".equals(record.getRevise_status()) || "5".equals(record.getRevise_status())) {
                return "";
            }
            if (!"01".equals(edrResult)) {
                record.setRevise_status("3");
                record.setUpdate_time(new Date());
                this.insPreservationRecordAPIDao.updateRecordFail(record.getIns_preservation_record_id() + "", "3", edrInfo);
                return "";
            }
            record.setRevise_status("4");
            record.setRevise_serial_num_ins(revise_serial_num_ins);
            record.setRevise_path(eurl);
            record.setUpdate_time(new Date());
            this.insPreservationPayAPIService.setIPPay(record, null);
            this.policyService.pushRecordInfo(record.getIns_preservation_record_id() + "");
            new Thread(() -> this.printDZPD(record.getIns_preservation_record_id(), record.getRevise_serial_num_ins())).start();
            if (!"1".equals(GlobalResources.IS_CLOSE_RECORD_SYNC)) {
                new Thread(() -> this.policyService.recordSyncZC(record.getIns_preservation_record_id() + "")).start();
            }
            new Thread(() -> this.sendEmailAndTelByRecord(record)).start();
        }
        catch (Exception e) {
            this.log.error("\u4fee\u6539\u4fdd\u5168\u5355\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return e.getMessage();
        }
        return "";
    }

    @Override
    public void pushRecordToShop() {
        String yesterday = DateUtil.getYesterday();
        List<String> list = this.insPreservationRecordAPIDao.findRecordIdsByPayTime(yesterday);
        for (String record_id : list) {
            new Thread(() -> this.policyService.createSendOrderTask(Long.parseLong(record_id), 1, "")).start();
        }
    }

    private int getSignAndSetRecord(Map<String, String> map, InsPreservationRecord record, OrderFormVo vo, int sign) {
        if (vo.getProduct_code().contains("GZZRX-RB") || vo.getProduct_code().contains("TYX-RB") || vo.getProduct_code().contains("TYX-PAC") || vo.getProduct_code().contains("GZZRX-PAC")) {
            if (map.get("batchNumber").contains("\u672a\u67e5\u8be2\u5230\u8be5\u6279\u5355\u7533\u8bf7\u53f7")) {
                String batch_number = map.get("batchNumber").replace("\u672a\u67e5\u8be2\u5230\u8be5\u6279\u5355\u7533\u8bf7\u53f7", "").replace("\u7684\u6279\u5355\u53f7\uff01", "");
                new Thread(() -> {
                    HashMap parems = Maps.newHashMap();
                    parems.put("record_id", String.valueOf(record.getIns_preservation_record_id()));
                    parems.put("batch_number", batch_number);
                    this.comTaskResidualAPIService.saveComTaskResidual("updateBatchNumber", "\u4fee\u6539\u4eba\u4fdd\u4fdd\u5168\u6279\u5355\u53f7", "com.bcxin.ins.service.preservation.InsPreservationRecordAPIService", 1, "String", JSONObject.toJSONString((Object)parems));
                }).start();
            }
            record.setRevise_serial_num_ins(map.get("batchNumber"));
            if (StringUtils.isNotEmpty((String)map.get("premium"))) {
                record.setTotal_premium(BigDecimal.valueOf(Double.parseDouble(map.get("premium"))));
            }
            sign = 1;
        } else if (vo.getProduct_code().contains("GZZRX-TB")) {
            if (StringUtils.isEmpty((String)map.get("batchNumber")) && "1".equals(record.getRevise_type())) {
                record.setRevise_pay(map.get("payurl"));
                record.setRevise_status("2");
            } else {
                record.setRevise_serial_num_ins(map.get("batchNumber"));
                record.setRevise_path(map.get("eurl"));
                sign = 1;
            }
            this.insPreservationRecordAPIDao.updateById(record);
        } else if (vo.getProduct_code().contains("GZZRX-ZH")) {
            record.setRevise_serial_num_ins(map.get("batchNumber"));
            if (StringUtils.isNotEmpty((String)map.get("premium"))) {
                record.setTotal_premium(BigDecimal.valueOf(Double.parseDouble(map.get("premium"))));
            }
            record.setRevise_path(map.get("eurl"));
            if (StringUtils.isNotEmpty((String)map.get("tbsxsj"))) {
                record.setInception_date(DateUtil.parseDate((String)map.get("tbsxsj")));
            }
            sign = 1;
        } else if (vo.getProduct_code().contains("GZZRX-CA")) {
            record.setRevise_serial_number(map.get("batchNumber"));
            if (StringUtils.isNotEmpty((String)map.get("premium"))) {
                record.setTotal_premium(BigDecimal.valueOf(Double.parseDouble(map.get("premium"))));
            }
            if (map.get("eurl") != null) {
                record.setRevise_path(map.get("eurl"));
            }
            this.insPreservationRecordAPIDao.updateById(record);
        } else if (vo.getProduct_code().contains("TYX-CA")) {
            record.setRevise_serial_num_ins(map.get("batchNumber"));
            if (StringUtils.isNotEmpty((String)map.get("premium"))) {
                record.setTotal_premium(BigDecimal.valueOf(Double.parseDouble(map.get("premium"))));
            }
            if (map.get("eurl") != null) {
                record.setRevise_path(map.get("eurl"));
            }
            sign = 1;
        } else if (vo.getProduct_code().contains("TYX-HT")) {
            record.setRevise_serial_number(map.get("batchNumber"));
            if (StringUtils.isNotEmpty((String)map.get("premium"))) {
                record.setTotal_premium(BigDecimal.valueOf(Double.parseDouble(map.get("premium"))));
            }
            record.setRevise_status("2");
            this.insPreservationRecordAPIDao.updateById(record);
        } else if (vo.getProduct_code().contains("GZZRX-QH")) {
            record.setRevise_serial_num_ins(map.get("batchNumber"));
            if (StringUtils.isNotEmpty((String)map.get("premium"))) {
                record.setTotal_premium(BigDecimal.valueOf(Double.parseDouble(map.get("premium"))));
            }
            if (map.get("eurl") != null) {
                record.setRevise_path(map.get("eurl"));
            }
            sign = 1;
        }
        return sign;
    }

    private void sendEmailAndTelByRecord(InsPreservationRecord record) {
        String personNum;
        String reviseType;
        String status = record.getRevise_status();
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(record.getIns_insurance_slip_id());
        List<InsRoleInpolicy> iriList = this.insRoleInpolicyService.getInsRoleInpolicyListByIDAndKind(record.getIns_insurance_slip_id(), "1");
        String email = "";
        String tel = "";
        if (iriList.size() > 0) {
            email = iriList.get(0).getLink_email();
            tel = iriList.get(0).getLink_tel();
        }
        String string = "1".equals(record.getRevise_type()) ? "\u589e\u5458" : ("2".equals(record.getRevise_type()) ? "\u51cf\u5458" : (reviseType = "3".equals(record.getRevise_type()) ? "\u66ff\u6362" : ""));
        String string2 = "1".equals(record.getRevise_type()) ? String.valueOf(record.getAdd_count()) : ("2".equals(record.getRevise_type()) ? String.valueOf(record.getMinus_count()) : (personNum = "3".equals(record.getRevise_type()) ? String.valueOf(record.getReplace_count()) : ""));
        if (StringUtils.isNotBlank((String)email)) {
            EmailMsgRecordType emr = null;
            if ("3".equals(status)) {
                emr = EmailMsgRecordType.RECORD_SEND_BACK;
            } else if ("4".equals(status)) {
                emr = EmailMsgRecordType.RECORD_CHECKED;
            }
            EmailModel emailModel = new EmailModel(emr, DateUtil.convertDateToString((Date)record.getStart_time(), (String)"yyyy-MM-dd HH:mm"), reviseType, personNum, vo.getTrade_serial_number(), record.getExternal_reference(), record.getRevise_serial_number());
            this.log.info(emr.getName() + "\u90ae\u4ef6\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + emailModel.getContent());
            ArrayList<String> emailList = new ArrayList<String>();
            emailList.add(email.trim());
            this.log.info(emr.getName() + "\u90ae\u4ef6\u53d1\u9001\uff08\u6536\u4ef6\u4ebaEmail-1\uff09:" + email);
            emailModel.setTo(emailList);
            SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
        }
        if (StringUtils.isNotBlank((String)tel)) {
            String content = "";
            if ("3".equals(status)) {
                content = new MessageModel(DateUtil.convertDateToString((Date)record.getStart_time(), (String)"yyyy-MM-dd HH:mm"), reviseType, personNum, record.getRevise_serial_number(), "", EmailMsgType.BQTH).getContent();
                this.log.info("\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u9000\u56de\u77ed\u4fe1\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + content);
                this.mss.sendHuaWeiSMS(new HuaWeiSmsContent("BLB", "B7", tel, JSON.toJSONString((Object)new String[]{DateUtil.convertDateToString((Date)record.getStart_time(), (String)"yyyy-MM-dd HH:mm"), reviseType, personNum, record.getRevise_serial_number()})));
            } else if ("4".equals(status)) {
                // empty if block
            }
            this.log.info("\u4fdd\u5168\u7533\u8bf7\u77ed\u4fe1\u53d1\u9001\uff08\u6536\u4ef6\u4ebaModle-1\uff09:" + tel);
        }
    }

    @Override
    public boolean minusInsPreservationRecord(int sign, InsPreservationRecordVo iprVo, List<InsPreservationDetailVo> ipdVoList) {
        boolean flag = false;
        try {
            Object inception_date;
            OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
            if (vo == null || ipdVoList == null || ipdVoList.isEmpty()) {
                return flag;
            }
            String revise_status = "1";
            int count = ipdVoList.size();
            if ("1".equals(String.valueOf(sign))) {
                revise_status = "2";
            }
            if (StringUtils.isNotBlank((String)iprVo.getOid())) {
                inception_date = null;
                if (StringUtils.isNotBlank((String)iprVo.getInception_date())) {
                    inception_date = DateUtil.convertStringToDate((String)iprVo.getInception_date());
                }
                this.updateInsPreservationRecord(Long.parseLong(iprVo.getOid()), count, (Date)inception_date, revise_status);
                flag = true;
            }
            inception_date = iprVo.getInception_date();
            if ("2".equals(revise_status)) {
                new Thread(() -> this.lambda$minusInsPreservationRecord$9(vo, ipdVoList, (String)inception_date)).start();
            }
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5168\u7533\u8bf7\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public boolean againRecord(Long oid) {
        Map<String, String> map;
        boolean flag = true;
        InsPreservationRecord ipr = (InsPreservationRecord)this.selectById(oid);
        if (ipr == null) {
            return false;
        }
        InsPreservationRecordVo vo = this.findInsPreservationRecordVoById(oid);
        OrderFormVo ovo = this.policyService.accordingToOrderIDToGetPolicyDto(ipr.getIns_insurance_slip_id());
        if ("1".equals(ipr.getRevise_type())) {
            ipr.setAdd_count(vo.getInsPreservationDetailVoList().size());
        } else if ("2".equals(ipr.getRevise_type())) {
            ipr.setMinus_count(vo.getInsPreservationDetailVoList().size());
        } else {
            ipr.setReplace_count(vo.getInsPreservationDetailVoList().size());
        }
        if (StringUtils.isEmpty((String)ipr.getRevise_serial_number())) {
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            ipr.setRevise_serial_number(String.valueOf(idWorker.nextId()));
        }
        ipr.setRevise_status("2");
        if (StringUtils.isNotEmpty((String)ovo.getProduct_code()) && ovo.getProduct_code().contains("GZZRX-CA")) {
            map = this.recordRestToRB(vo, "1");
            if (map != null) {
                if ("300".equals(map.get("ret"))) {
                    return false;
                }
            } else {
                return false;
            }
            this.updateRecordStatus(String.valueOf(ipr.getIns_preservation_record_id()), map);
            return true;
        }
        if (StringUtils.isNotEmpty((String)ovo.getProduct_code()) && ovo.getProduct_code().contains("GZZRX-TB")) {
            map = this.recordRestToRB(vo, "1");
            if (map != null) {
                if ("300".equals(map.get("ret"))) {
                    throw new RuntimeException(map.get("msg"));
                }
            } else {
                return false;
            }
            this.updateRecordStatus(String.valueOf(ipr.getIns_preservation_record_id()), map);
            return true;
        }
        if (StringUtils.isNotEmpty((String)ovo.getProduct_code()) && ovo.getProduct_code().contains("GZZRX-QH")) {
            map = this.recordRestToRB(vo, "1");
            if (map != null) {
                if ("300".equals(map.get("ret"))) {
                    throw new RuntimeException(map.get("msg"));
                }
            } else {
                return false;
            }
            this.updateRecordStatus(String.valueOf(ipr.getIns_preservation_record_id()), map);
            return true;
        }
        try {
            this.updateById(ipr);
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5168\u7533\u8bf7\u5355\u518d\u6b21\u63d0\u4ea4\u5ba1\u6838\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        if (!"2".equals(ipr.getRevise_status())) {
            return flag;
        }
        new Thread(() -> {
            try {
                this.sendPreservationEmail(ovo.getProduct_code(), "", this.htmlContentByPreservationRecord(ovo, vo.getInsPreservationDetailVoList(), vo.getInception_date()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
        return flag;
    }

    @Override
    public boolean addAgainRecord(Long oid, List<InsPreservationDetailVo> ipdVoList) {
        try {
            this.insPreservationDetailAPIService.saveOrUpdateInsPreservationDetail("1", oid, ipdVoList);
            this.againRecord(oid);
            return true;
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5168\u7533\u8bf7\u5355\u589e\u5458\u518d\u6b21\u5ba1\u6838\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
    }

    @Override
    public String printDZPD(Long record_id, String batchNumber) {
        OrderFormVo orderVo;
        String path = "";
        InsPreservationRecordVo recordVo = this.insPreservationRecordAPIDao.findInsPreservationRecordVoById(record_id);
        if (recordVo == null) {
            return path;
        }
        if (StringUtils.isNotEmpty((String)recordVo.getRevise_path())) {
            return recordVo.getRevise_path();
        }
        if (StringUtils.isEmpty((String)recordVo.getRevise_serial_num_ins())) {
            recordVo.setRevise_serial_num_ins(batchNumber);
        }
        if ((orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(recordVo.getIns_insurance_slip_id()))) == null) {
            return path;
        }
        try {
            String result;
            if (orderVo.getProduct_code().contains("GZZRX-PAC") && StringUtils.isNotEmpty((String)(result = this.gZZRX_PACRequestService.requestPAC(Long.parseLong(recordVo.getIns_insurance_slip_id()), TransTypeEnum.DZPD.getValue(), recordVo))) && result.contains("200#")) {
                path = result.replace("200#", "");
            }
            if (StringUtils.isNotEmpty((String)path)) {
                this.saveRevisePath(record_id, path);
            }
        }
        catch (Exception e) {
            this.log.error("\u7535\u5b50\u6279\u5355\u83b7\u53d6\u5f02\u5e38\uff0cERROR:", (Object)e.getMessage());
        }
        return path;
    }

    @Override
    public void saveRevisePath(Long record_id, String path) {
        this.insPreservationRecordAPIDao.saveRevisePath(record_id, path);
    }

    @Override
    public boolean deleteInsPreservationRecord(Long oid) {
        boolean flag = true;
        InsPreservationRecord ipr = (InsPreservationRecord)this.selectById(oid);
        if (ipr != null) {
            ipr.setRevise_status("0");
            try {
                this.updateById(ipr);
            }
            catch (Exception e) {
                this.log.error("\u5220\u9664\u4fdd\u5168\u7533\u8bf7\u5355\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        } else {
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean revokeInsPreservationRecord(Long oid) {
        boolean flag;
        block5: {
            flag = true;
            InsPreservationRecordVo iprVo = this.findInsPreservationRecordVoById(oid);
            if (iprVo != null) {
                try {
                    String result = this.gZZRX_TBRequestService.request_tb_gzzrx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PDZFCX.getValue(), iprVo);
                    if (StringUtils.isNotEmpty((String)result) && result.startsWith("200")) {
                        InsPreservationRecord ipr = (InsPreservationRecord)this.selectById(oid);
                        ipr.setRevise_status("3");
                        this.updateById(ipr);
                        break block5;
                    }
                    flag = false;
                }
                catch (Exception e) {
                    this.log.error("\u64a4\u9500\u4fdd\u5168\u7533\u8bf7\u5355\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                }
            } else {
                flag = false;
            }
        }
        return flag;
    }

    @Override
    public List<InsPreservationDetailVo> saveOrderPreservation(Map<String, Object> map) {
        try {
            String webType = "";
            if (map.get("webType") != null) {
                webType = (String)map.get("webType");
            }
            String oid = "";
            if (map.get("orderNo") != null) {
                oid = (String)map.get("orderNo");
            }
            String inception_date = "";
            if (map.get("inceptionDate") != null) {
                inception_date = (String)map.get("inceptionDate");
            }
            String reviseType = "";
            if (map.get("reviseType") != null) {
                reviseType = (String)map.get("reviseType");
            }
            String externalReference = "";
            if (map.get("externalReference") != null) {
                externalReference = (String)map.get("externalReference");
            }
            String productName = "";
            if (map.get("productName") != null) {
                productName = (String)map.get("productName");
            }
            String applicantName = "";
            if (map.get("applicantName") != null) {
                applicantName = (String)map.get("applicantName");
            }
            String responsibilityVo1 = "";
            if (map.get("responsibilityVo1") != null) {
                responsibilityVo1 = (String)map.get("responsibilityVo1");
            }
            String responsibilityVo2 = "";
            if (map.get("responsibilityVo2") != null) {
                responsibilityVo2 = (String)map.get("responsibilityVo2");
            }
            String responsibilityVo3 = "";
            if (map.get("responsibilityVo3") != null) {
                responsibilityVo3 = (String)map.get("responsibilityVo3");
            }
            List list = null;
            if (map.get("vo") != null) {
                list = (List)map.get("vo");
            }
            String htmlContent = "<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>\u4fdd\u5168\u7533\u8bf7\u4e66</title><style type=\"text/css\">.wrap{width:500px;margin:30px auto}.wrap h1{text-align:center}.shenqing-con p strong,.shenqing-con p span{display:block;font-size:14px;line-height:24px}.shenqing-con p strong{float:left;margin-right:8px}.shenqing-con div{float:left}.shenqing-con p.mg-r{width:200px;margin-left:78px}table{width:680px}table th,table td{padding:5px}</style></head><body><div class=\"wrap\"><h1>\u4fdd\u5168\u7533\u8bf7\u4e66</h1><div class=\"shenqing-con\"><p><strong>\u4fdd\u9669\u8ba2\u5355\u53f7\uff1a</strong><span>#ORDERNUM#</span></br><strong>\u751f\u6548\u65e5\u671f\uff1a</strong><span>#INCEPTIONDATE#</span></br><strong>\u4fdd\u9669\u516c\u53f8\uff1a</strong><span>\u6cf0\u5eb7\u5728\u7ebf\u8d22\u4ea7\u4fdd\u9669\u80a1\u4efd\u6709\u9650\u516c\u53f8</span></br><strong>\u4fdd\u5355\u53f7\uff1a</strong><span>#EXTERNALREFERENCE#</span></br><strong>\u6295\u4fdd\u4eba\uff1a</strong><span>#APPLICANTNAME#</span></br><strong>\u4fdd\u9669\u4ea7\u54c1\uff1a</strong><span>[\u4ea7\u54c1\u540d\u79f0\uff1a#PRODUCTNAME#]</span></br><strong>\u4fdd\u969c\u5185\u5bb9\uff1a</strong></br><span class=\"mg-r\">#RESPONSIBILITYVO1#</span></br><span class=\"mg-r\">#RESPONSIBILITYVO2#</span></br><span class=\"mg-r\">#RESPONSIBILITYVO3#</span></br></p><h2>\u7533\u8bf7\u8be5\u4fdd\u5355\u9879\u4e0b[#TYPE#]\u4ee5\u4e0b\u88ab\u4fdd\u9669\u4eba\uff1a</h2><table border=\"1\"cellspacing=\"0\"cellpadding=\"0\"><thead><tr><th>\u5e8f\u53f7</th><th>\u59d3\u540d</th><th>\u8eab\u4efd\u8bc1\u53f7</th><th>\u6027\u522b</th><th>\u51fa\u751f\u65e5\u671f</th><th>\u804c\u4e1a</th></tr></thead><tbody>#TRCONTENT#</tbody></table></div></div></body></html>";
            htmlContent = htmlContent.replace("#ORDERNUM#", oid);
            htmlContent = htmlContent.replace("#EXTERNALREFERENCE#", "" + externalReference);
            htmlContent = htmlContent.replace("#INCEPTIONDATE#", inception_date);
            htmlContent = htmlContent.replace("#PRODUCTNAME#", productName);
            htmlContent = htmlContent.replace("#APPLICANTNAME#", applicantName);
            htmlContent = htmlContent.replace("#RESPONSIBILITYVO1#", responsibilityVo1);
            htmlContent = htmlContent.replace("#RESPONSIBILITYVO2#", responsibilityVo2);
            htmlContent = htmlContent.replace("#RESPONSIBILITYVO3#", responsibilityVo3);
            ArrayList<InsPreservationDetailVo> rightList = new ArrayList<InsPreservationDetailVo>();
            this.removeErrorList(list, oid, webType, rightList);
            if (rightList == null || rightList.size() <= 0) {
                return null;
            }
            InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
            iprVo.setIns_insurance_slip_id(oid);
            iprVo.setInception_date(inception_date);
            iprVo.setRevise_type(reviseType);
            StringBuffer trContent = new StringBuffer();
            int count = 0;
            for (InsPreservationDetailVo detailVo : rightList) {
                if (count == 0) {
                    String tty = "";
                    if ("1".equals(detailVo.getRevise_type())) {
                        tty = "\u589e\u5458";
                    } else if ("2".equals(detailVo.getRevise_type())) {
                        tty = "\u51cf\u5458";
                    } else if ("3".equals(detailVo.getRevise_type())) {
                        tty = "\u66ff\u6362";
                    }
                    htmlContent = htmlContent.replace("#TYPE#", tty);
                }
                trContent.append("<tr><td>" + (count + 1) + "</td><td>" + detailVo.getName() + "</td><td>" + detailVo.getId_card() + "</td><td>");
                if ("2".equals(IdNumberValidator.getSexFromCard((String)detailVo.getId_card()))) {
                    trContent.append("\u5973");
                } else {
                    trContent.append("\u7537");
                }
                trContent.append("</td><td>" + detailVo.getBirthday());
                String career = "1".equals(detailVo.getCareer()) ? "\u5185\u52e4\u4eba\u5458" : ("2".equals(detailVo.getCareer()) ? "\u4fdd\u5b89\u4eba\u5458" : ("3".equals(detailVo.getCareer()) ? "\u6b66\u88c5\u62bc\u8fd0\u4eba\u5458" : ("4".equals(detailVo.getCareer()) ? "\u4fdd\u6d01\u4eba\u5458" : "")));
                trContent.append("</td><td>" + career + "</td></tr>");
                ++count;
            }
            htmlContent = htmlContent.replace("#TRCONTENT#", trContent.toString());
            OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(oid));
            this.sendPreservationEmail(vo.getProduct_code(), "0", htmlContent);
            if (this.createInsPreservationRecord(1, iprVo, rightList)) {
                return rightList;
            }
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5168\u4eba\u5458\u90ae\u4ef6\u7ec4\u88c5\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
        }
        return null;
    }

    private String htmlContentByPreservationRecord(OrderFormVo orderVo, List<InsPreservationDetailVo> ipdVoList, String inception_date) {
        StringBuffer htmlContent = new StringBuffer();
        try {
            if (ipdVoList == null || ipdVoList.size() < 1) {
                return null;
            }
            if (orderVo == null) {
                this.log.info("\u4fdd\u5168\u4eba\u5458\u90ae\u4ef6\u5185\u5bb9\u6570\u636e\u7ec4\u88c5-\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728----------------");
                return htmlContent.toString();
            }
            String tty = "";
            String revise_type = "";
            int sign = 0;
            StringBuffer oldRole = new StringBuffer();
            StringBuffer newRole = new StringBuffer();
            oldRole.append("<table border=\"1\"cellspacing=\"0\"cellpadding=\"0\"><thead><tr><th>\u5e8f\u53f7</th><th>\u59d3\u540d</th><th>\u8bc1\u4ef6\u53f7\u7801</th><th>\u6027\u522b</th><th>\u51fa\u751f\u65e5\u671f</th><th>\u804c\u4e1a</th></tr></thead><tbody>");
            newRole.append("<table border=\"1\"cellspacing=\"0\"cellpadding=\"0\"><thead><tr><th>\u5e8f\u53f7</th><th>\u59d3\u540d</th><th>\u8bc1\u4ef6\u53f7\u7801</th><th>\u6027\u522b</th><th>\u51fa\u751f\u65e5\u671f</th><th>\u804c\u4e1a</th></tr></thead><tbody>");
            for (InsPreservationDetailVo detailVo : ipdVoList) {
                if (sign == 0) {
                    revise_type = detailVo.getRevise_type();
                    if ("1".equals(detailVo.getRevise_type())) {
                        tty = "\u589e\u5458";
                    } else if ("2".equals(detailVo.getRevise_type())) {
                        tty = "\u51cf\u5458";
                    } else if ("3".equals(detailVo.getRevise_type())) {
                        tty = "\u66ff\u6362";
                    }
                }
                if ("3".equals(detailVo.getRevise_type())) {
                    InsPreservationResultSetVo resultSet = this.insPreservationResultSetAPIService.getInsPreservationResultSetVoByOidAndSign(detailVo.getBusiness_id(), detailVo.getBusiness_type());
                    InsPreservationDetailVo dvo = this.insPreservationDetailAPIService.detailConvertToResultSet(resultSet);
                    this.getTableRole(oldRole, dvo, sign);
                }
                this.getTableRole(newRole, detailVo, sign);
                ++sign;
            }
            oldRole.append("</tbody></table>");
            newRole.append("</tbody></table>");
            String stro = "";
            if (StringUtils.isNotEmpty((String)inception_date)) {
                stro = "<strong>\u751f\u6548\u65e5\u671f\uff1a</strong><span>" + inception_date + "</span></br>";
            }
            htmlContent.append("<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>\u4fdd\u5168\u7533\u8bf7\u4e66</title><style type=\"text/css\">.wrap{width:500px;margin:30px auto}.wrap h1{text-align:center}.shenqing-con p strong,.shenqing-con p span{display:block;font-size:14px;line-height:24px}.shenqing-con p strong{float:left;margin-right:8px}.shenqing-con div{float:left}.shenqing-con p.mg-r{width:200px;margin-left:78px}table{width:680px}table th,table td{padding:5px}</style></head><body><div class=\"wrap\"><h1>\u4fdd\u5168\u7533\u8bf7\u4e66</h1><div class=\"shenqing-con\"><p>");
            htmlContent.append("<strong>\u4fdd\u9669\u8ba2\u5355\u53f7\uff1a</strong><span>" + orderVo.getTrade_serial_number() + "</span></br>");
            htmlContent.append("<strong>\u4fdd\u9669\u516c\u53f8\uff1a</strong><span>" + orderVo.getInsurance_name() + "</span></br><strong>\u4fdd\u5355\u53f7\uff1a</strong><span>" + orderVo.getExternal_reference() + "</span></br>" + stro + "<strong>\u6295\u4fdd\u4eba\uff1a</strong><span>" + orderVo.getApplicant_name() + "</span></br><strong>\u4fdd\u9669\u4ea7\u54c1\uff1a</strong><span>[\u4ea7\u54c1\u540d\u79f0\uff1a" + orderVo.getProduct_name() + "]</span></br><strong>\u4fdd\u969c\u5185\u5bb9\uff1a</strong></br>");
            for (ResponsibilityVo rvo : orderVo.getResponsibilityVoList()) {
                htmlContent.append("<span class=\"mg-r\">" + rvo.getShow_name() + rvo.getFcy() + "</span></br>");
            }
            htmlContent.append("</p><h2>\u7533\u8bf7\u8be5\u4fdd\u5355\u9879\u4e0b[" + tty + "]\u4ee5\u4e0b\u88ab\u4fdd\u9669\u4eba\uff1a</h2>");
            if ("3".equals(revise_type)) {
                htmlContent.append("<span class=\"mg-r\">\uff08\u539f\u88ab\u4fdd\u9669\u4eba\uff09</span></br>");
                htmlContent.append(oldRole);
                htmlContent.append("<span class=\"mg-r\">\uff08\u73b0\u88ab\u4fdd\u9669\u4eba\uff09</span></br>");
            }
            htmlContent.append(newRole);
            htmlContent.append("</div></div></body></html>");
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5168\u4eba\u5458\u90ae\u4ef6\u5185\u5bb9\u6570\u636e\u7ec4\u88c5\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            e.printStackTrace();
        }
        return htmlContent.toString();
    }

    private void getTableRole(StringBuffer role, InsPreservationDetailVo detailVo, int sign) {
        role.append("<tr><td>" + (sign + 1) + "</td><td>" + detailVo.getName() + "</td><td>" + detailVo.getId_card() + "</td><td>");
        if ("2".equals(detailVo.getSex())) {
            role.append("\u5973");
        } else {
            role.append("\u7537");
        }
        role.append("</td><td>" + detailVo.getBirthday());
        String career = "1".equals(detailVo.getCareer()) ? "\u5185\u52e4\u4eba\u5458" : ("2".equals(detailVo.getCareer()) ? "\u4fdd\u5b89\u4eba\u5458" : ("3".equals(detailVo.getCareer()) ? "\u6b66\u88c5\u62bc\u8fd0\u4eba\u5458" : ("4".equals(detailVo.getCareer()) ? "\u4fdd\u6d01\u4eba\u5458" : "")));
        role.append("</td><td>" + career + "</td></tr>");
    }

    @Override
    public void sendPreservationEmail(String product_code, String type, String htmlContent) {
        this.log.info("\u4fdd\u5168\u90ae\u4ef6\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + htmlContent);
        String[] arrs = this.comDeployConfigService.getValueByKey("RECORD_EMAIL").split(";");
        EmailModel emailModel = new EmailModel("\u4fdd\u5355\u4fdd\u5168\u4fe1\u606f", htmlContent);
        ArrayList<String> emailList = new ArrayList<String>();
        for (int i = 0; i < arrs.length; ++i) {
            if (StringUtils.isBlank((String)arrs[i])) continue;
            String em = "";
            if (arrs[i].contains(":")) {
                String[] sigs = arrs[i].split(":");
                if (StringUtils.isNotEmpty((String)product_code) && product_code.contains(sigs[1])) {
                    em = sigs[0].trim();
                }
            } else {
                em = arrs[i].trim();
            }
            if (!StringUtils.isNotEmpty((String)em)) continue;
            emailList.add(em);
            this.log.info("\u4fdd\u5168\u90ae\u4ef6\u53d1\u9001\uff08\u6536\u4ef6\u4ebaEmail-" + (i + 1) + "\uff09:" + em);
        }
        if (emailList.size() > 0) {
            emailModel.setTo(emailList);
            SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
        }
    }

    private void removeErrorList(List<InsPreservationDetailVo> list, String oid, String webType, List<InsPreservationDetailVo> rightList) {
        for (InsPreservationDetailVo vo : list) {
            boolean flag = false;
            if (!flag) continue;
            rightList.add(vo);
        }
    }

    @Override
    public String getEffectiveByPolicyId(Long policyId) {
        String result = "";
        OrderFormVo order = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        ProductVo productVo = this.productService.getProduct(Long.parseLong(order.getProduct_oid()));
        try {
            if (order.getProduct_code().contains("GZZRX") || order.getProduct_code().contains("TYX-RB")) {
                return DateUtil.getTomorrow() + "," + DateUtil.getTomorrow();
            }
            if (StringUtils.isNotBlank((String)productVo.getEffective_date())) {
                String end_time;
                String sta_time;
                String nowDate_str = DateUtil.getCurrentDateTime((String)"yyyy-MM-dd");
                if ("1".equals(productVo.getEffective_date())) {
                    sta_time = DateUtil.getTomorrow();
                    end_time = DateUtil.getTomorrow();
                } else if ("2".equals(productVo.getEffective_date())) {
                    sta_time = DateUtil.dateAdd((int)0, (String)nowDate_str, (int)(-Integer.parseInt(productVo.getEffective_date_before_n())));
                    end_time = DateUtil.dateAdd((int)0, (String)nowDate_str, (int)-1);
                } else if ("3".equals(productVo.getEffective_date())) {
                    sta_time = DateUtil.dateAdd((int)0, (String)nowDate_str, (int)1);
                    end_time = DateUtil.dateAdd((int)0, (String)nowDate_str, (int)Integer.parseInt(productVo.getEffective_date_after_n()));
                } else {
                    sta_time = DateUtil.dateAdd((int)0, (String)nowDate_str, (int)(-Integer.parseInt(productVo.getEffective_date_before_n())));
                    end_time = DateUtil.dateAdd((int)0, (String)nowDate_str, (int)Integer.parseInt(productVo.getEffective_date_after_n()));
                }
                result = sta_time + "," + end_time;
            } else {
                result = "1900-01-01,2099-12-31";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void setInsPreservationRecordStatus() {
        List<String> idList = this.insPreservationRecordAPIDao.findInsPreservationRecordIdsByStatusAndTime();
        if (idList.size() > 0) {
            this.insPreservationRecordAPIDao.updateStatusById("5", idList);
        }
    }

    @Override
    public List<String> selectRecordIdByPolicyIdAndStatus(Long policyId, String status, String resType) {
        return this.insPreservationRecordAPIDao.selectRecordIdByPolicyIdAndStatus(policyId, status, resType);
    }

    @Override
    public List<String> selectRecordIdByWebType(String type) {
        return this.insPreservationRecordAPIDao.selectRecordIdByWebType(type);
    }

    @Override
    public boolean updateRecordByIsPush(String recordId) {
        boolean flag = true;
        try {
            this.insPreservationRecordAPIDao.updateIsPushById(Long.parseLong(recordId), ConstProp.INT_NUMBER_ONE);
        }
        catch (Exception e) {
            flag = false;
            this.log.error("\u6807\u8bb0\u4fdd\u5168\u7533\u8bf7\u5355\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public Map<String, String> recordRestToRB(InsPreservationRecordVo iprVo, String sign) {
        HashMap map = null;
        if (!"1".equals(sign)) {
            return map;
        }
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
        if (StringUtils.isEmpty((String)vo.getPremium())) {
            JedisUtils.batchDel((String)("BLB:CACHE:POLICY-ID-" + vo.getOid()));
            vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
        }
        if (StringUtils.isEmpty((String)vo.getProduct_code())) {
            return map;
        }
        if (!(vo.getProduct_code().contains("GZZRX-RB") || vo.getProduct_code().contains("GZZRX-ZH") || vo.getProduct_code().contains("GZZRX-PAC") || vo.getProduct_code().contains("GZZRX-CA") || vo.getProduct_code().contains("GZZRX-QH") || vo.getProduct_code().contains("GZZRX-TB") || vo.getProduct_code().contains("TYX-CA") || vo.getProduct_code().contains("TYX-RB") || vo.getProduct_code().contains("TYX-HT") || vo.getProduct_code().contains("TYX-PAC"))) {
            return map;
        }
        try {
            BigDecimal tolP;
            String premium;
            IdWorker idWorker;
            iprVo.setStart_time(DateUtil.getCurrentDateTime());
            List dList = iprVo.getInsPreservationDetailVoList();
            ArrayList idList = Lists.newArrayList();
            if ("1".equals(iprVo.getRevise_type())) {
                for (InsPreservationDetailVo dvo : dList) {
                    dvo.setRevise_type("1");
                    idList.add(dvo);
                }
            } else if ("2".equals(iprVo.getRevise_type())) {
                for (InsPreservationDetailVo dvo : dList) {
                    dvo.setRevise_type("2");
                    if (StringUtils.isEmpty((String)dvo.getBusiness_id())) {
                        Long setId = this.insPreservationResultSetAPIService.getIdByIdCardAndOrderId(dvo.getId_card(), Long.parseLong(iprVo.getIns_insurance_slip_id()));
                        dvo.setBusiness_id(setId != null ? String.valueOf(setId) : "");
                        dvo.setBusiness_type("PRESERVE");
                    }
                    if (vo.getProduct_code().contains("GZZRX-TB")) {
                        String business_inception_date = this.insPreservationResultSetAPIService.getBusinessInceptionDateByBusinessId(dvo.getBusiness_id());
                        if (StringUtils.isEmpty((String)business_inception_date)) {
                            business_inception_date = vo.getInception_date();
                        }
                        dvo.setBusiness_inception_date(business_inception_date);
                    }
                    idList.add(dvo);
                }
            } else if ("3".equals(iprVo.getRevise_type())) {
                for (InsPreservationDetailVo dvo : dList) {
                    InsPreservationDetailVo ipdVo = new InsPreservationDetailVo();
                    InsPreservationResultSet resultSet = (InsPreservationResultSet)this.insPreservationResultSetAPIService.selectById(Long.valueOf(Long.parseLong(dvo.getBusiness_id())));
                    MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)resultSet), (Object)ipdVo);
                    ipdVo.setRevise_type("2");
                    dvo.setRevise_type("1");
                    dvo.setBusiness_vo(ipdVo);
                    idList.add(dvo);
                }
            }
            iprVo.setInsPreservationDetailVoList((List)idList);
            String result = "";
            if (vo.getProduct_code().contains("GZZRX-RB")) {
                result = this.gZZRX_RBRequestService.request_rb_gzzrx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
            } else if (vo.getProduct_code().contains("TYX-RB")) {
                result = this.rBRequestService.request_rb_tyx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
            } else if (vo.getProduct_code().contains("GZZRX-TB")) {
                if (StringUtils.isEmpty((String)iprVo.getRevise_serial_number())) {
                    idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                    iprVo.setRevise_serial_number(String.valueOf(idWorker.nextId()));
                }
                premium = "0.00";
                if (!"3".equals(iprVo.getRevise_type())) {
                    int syDay = DateUtil.getDistDates((Date)DateUtil.convertStringToDate((String)iprVo.getInception_date()), (Date)DateUtil.convertStringToDate((String)vo.getPlanned_end_date())) + 1;
                    tolP = BigDecimal.valueOf(syDay).divide(BigDecimal.valueOf(Double.parseDouble("365")), 9, 1).multiply(BigDecimal.valueOf(Double.parseDouble(vo.getPremium()))).setScale(2, 1).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(iprVo.getInsPreservationDetailVoList().size())))).setScale(2, 4);
                    premium = "2".equals(iprVo.getRevise_type()) ? "-" + tolP : String.valueOf(tolP);
                }
                iprVo.setTotal_premium(premium);
                this.changeAP(iprVo, vo);
                result = this.gZZRX_TBRequestService.request_tb_gzzrx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
            } else if (vo.getProduct_code().contains("TYX-PAC")) {
                if (StringUtils.isEmpty((String)iprVo.getRevise_serial_number())) {
                    idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                    iprVo.setRevise_serial_number(String.valueOf(idWorker.nextId()));
                }
                result = this.pACRequestService.requestPAC(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
                if (("1".equals(iprVo.getRevise_type()) || "2".equals(iprVo.getRevise_type())) && result.startsWith("200#")) {
                    result = result + "#" + iprVo.getRevise_serial_number();
                    result = this.pACRequestService.pdqr(TransTypeEnum.PDQR.getValue(), result);
                }
            } else if (vo.getProduct_code().contains("TYX-HT")) {
                iprVo.setRelease_time(DateUtil.getCurrentDateTime());
                result = this.tYX_HTRequestService.request_ht_tyx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
                if (result.startsWith("200#")) {
                    iprVo.setRevise_serial_number(result.split("#")[2]);
                    iprVo.setTotal_premium(result.split("#")[3]);
                }
            } else if (vo.getProduct_code().contains("GZZRX-PAC")) {
                if (StringUtils.isEmpty((String)iprVo.getRevise_serial_number())) {
                    idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                    iprVo.setRevise_serial_number(String.valueOf(idWorker.nextId()));
                }
                result = this.gZZRX_PACRequestService.requestPAC(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
            } else if (vo.getProduct_code().contains("GZZRX-CA")) {
                if (StringUtils.isEmpty((String)iprVo.getRevise_serial_number()) || iprVo.getRevise_serial_number().startsWith("315162")) {
                    idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                    iprVo.setRevise_serial_number(String.valueOf(idWorker.nextId()));
                }
                iprVo.setExternal_reference(vo.getExternal_reference());
                iprVo.setSerialNo(this.insPreservationRecordAPIDao.countRecordByEx(iprVo.getExternal_reference()));
                premium = "0.00";
                if (!"3".equals(iprVo.getRevise_type())) {
                    int syDay = DateUtil.getDistDates((Date)DateUtil.convertStringToDate((String)iprVo.getInception_date()), (Date)DateUtil.convertStringToDate((String)vo.getPlanned_end_date())) + 1;
                    tolP = BigDecimal.valueOf(syDay).divide(BigDecimal.valueOf(Double.parseDouble("365")), 9, 1).multiply(BigDecimal.valueOf(Double.parseDouble(vo.getPremium()))).setScale(2, 1).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(iprVo.getInsPreservationDetailVoList().size())))).setScale(2, 4);
                    premium = "2".equals(iprVo.getRevise_type()) ? "-" + tolP : String.valueOf(tolP);
                }
                iprVo.setTotal_premium(premium);
                result = this.gZZRX_CARequestService.request_ca_gzzrx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
                if (result.contains("200#")) {
                    String[] arr = result.split("#");
                    map = Maps.newHashMap();
                    map.put("ret", arr[0]);
                    map.put("proposalNo", vo.getExternal_reference());
                    map.put("batchNumber", arr[1]);
                    map.put("premium", premium);
                    return map;
                }
            } else if (vo.getProduct_code().contains("TYX-CA")) {
                if (StringUtils.isEmpty((String)iprVo.getRevise_serial_number()) || iprVo.getRevise_serial_number().startsWith("315162")) {
                    idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                    iprVo.setRevise_serial_number(String.valueOf(idWorker.nextId()));
                }
                iprVo.setExternal_reference(vo.getExternal_reference());
                premium = "0.00";
                if (!"3".equals(iprVo.getRevise_type())) {
                    int syDay = DateUtil.getDistDates((Date)DateUtil.convertStringToDate((String)iprVo.getInception_date()), (Date)DateUtil.convertStringToDate((String)vo.getPlanned_end_date())) + 1;
                    tolP = BigDecimal.valueOf(syDay).divide(BigDecimal.valueOf(Double.parseDouble("365")), 9, 1).multiply(BigDecimal.valueOf(Double.parseDouble(vo.getPremium()))).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(iprVo.getInsPreservationDetailVoList().size())))).setScale(2, 4);
                    premium = "2".equals(iprVo.getRevise_type()) ? "-" + tolP : String.valueOf(tolP);
                }
                iprVo.setTotal_premium(premium);
                result = this.tYX_CARequestService.request_ca_tyx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
                if (!"3".equals(iprVo.getRevise_type()) && result.contains("200#")) {
                    String[] arr = result.split("#");
                    iprVo.setRevise_serial_number(arr[1]);
                    result = this.tYX_CARequestService.request_ca_tyx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PDJG.getValue(), iprVo);
                }
                if (result.contains("200#")) {
                    String[] arr = result.split("#");
                    map = Maps.newHashMap();
                    map.put("ret", arr[0]);
                    map.put("proposalNo", vo.getExternal_reference());
                    map.put("batchNumber", arr[2]);
                    map.put("eurl", arr[4]);
                    map.put("premium", premium);
                    return map;
                }
            } else if (vo.getProduct_code().contains("GZZRX-QH")) {
                BigDecimal tolP2;
                this.compensateRecord(Long.parseLong(iprVo.getIns_insurance_slip_id()));
                if (StringUtils.isEmpty((String)iprVo.getRevise_serial_number())) {
                    idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                    iprVo.setRevise_serial_number(String.valueOf(idWorker.nextId()));
                }
                iprVo.setExternal_reference(vo.getExternal_reference());
                String numPer = String.valueOf(iprVo.getInsPreservationDetailVoList().size());
                if ("1".equals(vo.getInception_type())) {
                    int syDay = DateUtil.getDistDates((Date)DateUtil.convertStringToDate((String)vo.getInception_date()), (Date)DateUtil.getTodayStart()) + 1;
                    int tolDay = DateUtil.getDistDates((Date)DateUtil.convertStringToDate((String)vo.getInception_date()), (Date)DateUtil.convertStringToDate((String)vo.getPlanned_end_date())) + 1;
                    BigDecimal liDay = BigDecimal.valueOf(1L).subtract(BigDecimal.valueOf(syDay).divide(BigDecimal.valueOf(tolDay), 10, 4).setScale(6, 4));
                    tolP2 = BigDecimal.valueOf(Double.parseDouble(vo.getPremium())).multiply(new BigDecimal(numPer)).multiply(liDay).setScale(2, 4);
                    System.out.println("=====> syDay:" + syDay + ",tolDay:" + tolDay + ",liDay:" + liDay + ",tolP:" + tolP2);
                } else {
                    tolP2 = BigDecimal.valueOf(Double.parseDouble(vo.getPremium())).multiply(new BigDecimal(numPer)).setScale(2, 4);
                }
                String premium2 = "2".equals(iprVo.getRevise_type()) ? "-" + tolP2 : String.valueOf(tolP2);
                iprVo.setTotal_premium(premium2);
                result = this.gZZRX_QHRequestService.request_qh_gzzrx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
                if (StringUtils.isNotEmpty((String)result) && result.contains("\u8ba1\u7b97\u53d8\u5316\u4fdd\u8d39\u4e3a:")) {
                    String aomStr = result.split("\u8ba1\u7b97\u53d8\u5316\u4fdd\u8d39\u4e3a:")[1];
                    tolP2 = new BigDecimal(numPer).multiply(new BigDecimal(aomStr));
                    premium2 = "2".equals(iprVo.getRevise_type()) ? "-" + tolP2 : String.valueOf(tolP2);
                    iprVo.setTotal_premium(premium2);
                    result = this.gZZRX_QHRequestService.request_qh_gzzrx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.PD.getValue(), iprVo);
                }
                if ("3".equals(iprVo.getRevise_type())) {
                    iprVo.setTotal_premium("0.00");
                }
                if (StringUtils.isNotEmpty((String)result)) {
                    String[] arr = result.split("#");
                    map = Maps.newHashMap();
                    if (result.contains("300#")) {
                        map.put("ret", arr[0]);
                        map.put("msg", arr[1]);
                    } else if (result.contains("200#")) {
                        map.put("ret", arr[0]);
                        map.put("proposalNo", vo.getExternal_reference());
                        map.put("batchNumber", arr[2]);
                        map.put("eurl", arr[3]);
                        map.put("premium", iprVo.getTotal_premium());
                    }
                    return map;
                }
            } else if (vo.getProduct_code().contains("GZZRX-ZH")) {
                premium = "0.00";
                if (!"3".equals(iprVo.getRevise_type())) {
                    int syDay = DateUtil.getDistDates((Date)DateUtil.convertStringToDate((String)iprVo.getInception_date()), (Date)DateUtil.convertStringToDate((String)vo.getPlanned_end_date())) + 1;
                    BigDecimal perPremium = BigDecimal.valueOf(Double.parseDouble(vo.getPremium())).divide(BigDecimal.valueOf(Double.parseDouble("365")), 9, 1).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(syDay)))).setScale(2, 4);
                    BigDecimal tolP3 = perPremium.multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(iprVo.getInsPreservationDetailVoList().size()))));
                    premium = "2".equals(iprVo.getRevise_type()) ? "-" + tolP3 : String.valueOf(tolP3);
                }
                result = "200#" + iprVo.getExternal_reference() + "##" + premium + "#" + iprVo.getInception_date() + "#";
            }
            if (StringUtils.isNotEmpty((String)result)) {
                String[] arr = result.split("#");
                map = Maps.newHashMap();
                if (arr.length == 2) {
                    map.put("ret", arr[0]);
                    map.put("msg", arr[1]);
                } else if (arr.length == 4 || arr.length == 5) {
                    map.put("ret", arr[0]);
                    map.put("proposalNo", arr[1]);
                    map.put("batchNumber", arr[2]);
                    map.put("premium", arr[3]);
                } else if (arr.length == 6) {
                    map.put("ret", arr[0]);
                    map.put("proposalNo", arr[1]);
                    map.put("batchNumber", arr[2]);
                    if (!NumberUtils.isDigits((String)arr[3]) && NumberUtils.isDigits((String)iprVo.getTotal_premium())) {
                        map.put("premium", iprVo.getTotal_premium());
                    } else {
                        map.put("premium", "3".equals(iprVo.getRevise_type()) ? "0.00" : arr[3]);
                    }
                    map.put("tbsxsj", arr[4]);
                    map.put("eurl", arr[5]);
                } else if (arr.length == 7) {
                    map.put("ret", arr[0]);
                    map.put("proposalNo", arr[1]);
                    map.put("batchNumber", arr[2]);
                    map.put("batchApplyNumber", arr[4]);
                    if (!NumberUtils.isDigits((String)arr[3]) && NumberUtils.isDigits((String)iprVo.getTotal_premium())) {
                        map.put("premium", iprVo.getTotal_premium());
                    } else {
                        map.put("premium", "3".equals(iprVo.getRevise_type()) ? "0.00" : arr[3]);
                    }
                    map.put("eurl", arr[5]);
                    map.put("payurl", arr[6]);
                }
                if (vo.getProduct_code().contains("TYX-HT") || vo.getProduct_code().contains("GZZRX-TB")) {
                    map.put("isPendingApproval", "1");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private void changeAP(InsPreservationRecordVo iprVo, OrderFormVo vo) {
        if ("3".equals(iprVo.getRevise_type())) {
            iprVo.setAmount_change("0");
            iprVo.setPremium_change("0");
            iprVo.setTotal_amount("0.00");
        }
        Map<String, String> sumMap = this.insPreservationRecordAPIDao.sumRecordNumAndPremiumByEx(vo.getExternal_reference());
        iprVo.setBankMap(this.insRoleInpolicyService.getTBBankByOrderId(Long.parseLong(vo.getOid())));
        String perNum = sumMap.get("perNum");
        String ljPremium = sumMap.get("premium");
        String product_code = vo.getProduct_code();
        String eam = "GZZRX-TB-1".equals(product_code) ? "400000" : ("GZZRX-TB-2".equals(product_code) ? "500000" : ("GZZRX-TB-3".equals(product_code) ? "600000" : ("GZZRX-TB-4".equals(product_code) ? "700000" : ("GZZRX-TB-5".equals(product_code) ? "800000" : "0"))));
        BigDecimal sypremium = BigDecimal.valueOf(Double.parseDouble(vo.getGross_premium())).add(BigDecimal.valueOf(Double.parseDouble(ljPremium))).add(BigDecimal.valueOf(Double.parseDouble(iprVo.getTotal_premium())));
        BigDecimal aom = BigDecimal.valueOf(Double.parseDouble(eam)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum)));
        String type = "2".equals(iprVo.getRevise_type()) ? "-" : "";
        BigDecimal aom2 = BigDecimal.valueOf(Double.parseDouble(eam)).multiply(BigDecimal.valueOf(Double.parseDouble(type + iprVo.getInsPreservationDetailVoList().size())));
        BigDecimal syaom = BigDecimal.valueOf(Double.parseDouble(vo.getInsured_amount())).add(aom).add(aom2);
        iprVo.setAmount_change(syaom.toPlainString());
        iprVo.setPremium_change(sypremium.toPlainString());
        iprVo.setTotal_amount(aom2.toPlainString());
        System.out.println("\u4fdd\u5355\u4fdd\u8d39\uff1a" + vo.getGross_premium() + "\uff0c\u5386\u53f2\u4fdd\u8d39\uff1a" + ljPremium + "\uff0c\u5f53\u6b21\u4fdd\u8d39\uff1a" + iprVo.getTotal_premium() + "\uff0c\u5269\u4f59\u4fdd\u8d39\uff1a" + iprVo.getPremium_change());
        System.out.println("\u4fdd\u5355\u4fdd\u989d\uff1a" + vo.getInsured_amount() + "\uff0c\u5386\u53f2\u4fdd\u989d\uff1a" + aom + "\uff0c\u5f53\u6b21\u4fdd\u989d\uff1a" + aom2 + "\uff0c\u5269\u4f59\u4fdd\u989d\uff1a" + iprVo.getAmount_change());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addFindPDTask(String record_id) {
        this.log.info("====================> \u8fdb\u5165 \u6700\u65b0\u6279\u5355\u6f0f\u5355\u60c5\u51b5\uff0c\u6bd4\u5bf9\u8865\u507f --------------------------------");
        String result = "";
        InsPreservationRecordVo iprVo = this.findInsPreservationRecordVoById(Long.parseLong(record_id));
        if ("3".equals(iprVo.getRevise_status()) || "0".equals(iprVo.getRevise_status()) || "4".equals(iprVo.getRevise_status()) || "5".equals(iprVo.getRevise_status())) {
            return true;
        }
        OrderFormVo orderFormVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
        if (!orderFormVo.getProduct_code().contains("GZZRX-QH") && !orderFormVo.getProduct_code().contains("TYX-QH")) {
            return true;
        }
        try {
            if (DateUtil.compareDates((Date)DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)5, (String)iprVo.getStart_time(), (int)30)), (Date)new Date())) {
                this.insPreservationRecordAPIDao.updateRecordFail(iprVo.getOid(), "3", "\u6279\u6539\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff01");
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String pdNo = this.insPreservationRecordAPIDao.getLastPDNoByPolicyNo(iprVo.getExternal_reference());
            String newPDNo = "";
            newPDNo = StringUtils.isEmpty((String)pdNo) ? iprVo.getExternal_reference() + "-1" : iprVo.getExternal_reference() + "-" + (Integer.parseInt(pdNo.split("-")[1]) + 1);
            iprVo.setRevise_serial_num_ins(newPDNo);
            if (orderFormVo.getProduct_code().contains("GZZRX-QH")) {
                result = this.gZZRX_QHRequestService.request_qh_gzzrx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.ZXPG.getValue(), iprVo);
            } else if (orderFormVo.getProduct_code().contains("TYX-QH")) {
                result = this.tYX_QHRequestService.request_qh_tyx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.ZXPG.getValue(), iprVo);
            }
            if (StringUtils.isNotEmpty((String)result)) {
                String[] arr = result.split("#");
                if (result.contains("200#")) {
                    String idcards = arr[4];
                    boolean sign = false;
                    for (InsPreservationDetailVo vo : iprVo.getInsPreservationDetailVoList()) {
                        if (idcards.contains(vo.getId_card())) continue;
                        sign = true;
                        break;
                    }
                    if (!sign) {
                        HashMap map = Maps.newHashMap();
                        map.put("proposalNo", iprVo.getExternal_reference());
                        map.put("batchNumber", arr[1]);
                        map.put("eurl", arr[3]);
                        map.put("premium", arr[2]);
                        if (plyNoMap.getOrDefault(arr[1], 0) > 0) {
                            boolean bl = true;
                            return bl;
                        }
                        plyNoMap.put(arr[1], 1);
                        this.updateRecordStatus(iprVo.getOid(), map);
                        boolean bl = true;
                        return bl;
                    }
                    String resultN = result;
                    new Thread(() -> this.otherCheckRecord(Long.parseLong(iprVo.getIns_insurance_slip_id()), resultN)).start();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u6700\u65b0\u6279\u5355\u6f0f\u5355\u60c5\u51b5\uff0c\u6bd4\u5bf9\u8865\u507f,ERR:" + e.getMessage());
        }
        finally {
            try {
                iprVo.setRevise_serial_num_ins("");
                if (orderFormVo.getProduct_code().contains("GZZRX-QH")) {
                    this.gZZRX_QHRequestService.request_qh_gzzrx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.ZXPG.getValue(), iprVo);
                } else if (orderFormVo.getProduct_code().contains("TYX-QH")) {
                    this.tYX_QHRequestService.request_qh_tyx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.ZXPG.getValue(), iprVo);
                }
            }
            catch (Exception e) {
                this.log.error("\u6700\u65b0\u6279\u5355\u6f0f\u5355\u60c5\u51b5\uff0c\u6bd4\u5bf9\u8865\u507f,\u6700\u540e3\u4e2a\u6279\u6539\u67e5\u8be2\uff0cERR:" + e.getMessage());
            }
        }
        this.comTaskResidualAPIService.saveComTaskResidual("addFindPDTask", "\u6279\u6539\u8d85\u65f6\u8865\u507f", "com.bcxin.ins.service.preservation.InsPreservationRecordAPIService", 1, "String", record_id);
        return false;
    }

    @Override
    public String last3Record(String record_id, String reNo) {
        InsPreservationRecordVo iprVo = this.findInsPreservationRecordVoById(Long.parseLong(record_id));
        OrderFormVo orderFormVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
        try {
            if ("0".equals(reNo)) {
                reNo = "";
            }
            iprVo.setRevise_serial_num_ins(reNo);
            if (orderFormVo.getProduct_code().contains("GZZRX-QH")) {
                return this.gZZRX_QHRequestService.request_qh_gzzrx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.ZXPG.getValue(), iprVo);
            }
            if (orderFormVo.getProduct_code().contains("TYX-QH")) {
                return this.tYX_QHRequestService.request_qh_tyx(Long.parseLong(iprVo.getIns_insurance_slip_id()), TransTypeEnum.ZXPG.getValue(), iprVo);
            }
            return "";
        }
        catch (Exception e) {
            return "\u6700\u65b0\u6279\u5355\u67e5\u8be2\uff0cERR:" + e.getMessage();
        }
    }

    private void otherCheckRecord(Long policyId, String result) {
        List<String> list = this.selectRecordIdByPolicyIdAndStatus(policyId, "2", "");
        for (String str : list) {
            InsPreservationRecordVo iprVo = this.findInsPreservationRecordVoById(Long.parseLong(str));
            String[] arr = result.split("#");
            String idcards = arr[4];
            boolean sign = false;
            for (InsPreservationDetailVo vo : iprVo.getInsPreservationDetailVoList()) {
                if (idcards.contains(vo.getId_card())) continue;
                sign = true;
                break;
            }
            if (sign) continue;
            int count = this.insPreservationRecordAPIDao.selectRecordByPdNo(arr[1]);
            if (count > 0) {
                this.insPreservationRecordAPIDao.deleteRecord(iprVo.getOid());
                return;
            }
            HashMap map = Maps.newHashMap();
            map.put("proposalNo", iprVo.getExternal_reference());
            map.put("batchNumber", arr[1]);
            map.put("eurl", arr[3]);
            map.put("premium", arr[2]);
            if (plyNoMap.getOrDefault(arr[1], 0) > 0) {
                return;
            }
            plyNoMap.put(arr[1], 1);
            this.updateRecordStatus(iprVo.getOid(), map);
            return;
        }
    }

    public void modifyPlyNo(String plyNo, Integer countNo) {
        plyNoMap.compute(plyNo, (key, oldValue) -> {
            if (oldValue == null) {
                return 0;
            }
            return countNo;
        });
    }

    public static void main(String[] args) {
        String start_time = "2023-09-18 14:39:11";
        try {
            Date d = new Date();
            if (DateUtil.compareDates((Date)DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)5, (String)start_time, (int)30)), (Date)new Date())) {
                System.out.println("=====> \u5f53\u524d\u5927\u4e8e\u5f00\u59cb+30");
            } else {
                System.out.println("=====> \u5f53\u524d\u5c0f\u4e8e\u5f00\u59cb+30");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean recordRest(InsPreservationRecordVo vo) {
        InsPreservationRecordVo initVo = vo;
        try {
            if (this.createInsPreservationRecord(1, vo, vo.getInsPreservationDetailVoList())) {
                this.updateRecordStatus(vo.getOid(), vo.getRecordRest());
                return true;
            }
            throw new RuntimeException("\u521b\u5efa\u4fdd\u5168\u7533\u8bf7\u5355\u53d1\u751f\u5f02\u5e38");
        }
        catch (Exception e) {
            this.log.info("===========[recordRest](\u5f02\u5e38)\uff1a" + e);
            this.log.info("===========[recordRest](RecordRest)\uff1a" + vo.getRecordRest());
            if (vo.getRecordRest() != null) {
                String val = JSONObject.toJSONString((Object)initVo);
                HashMap map = Maps.newHashMap();
                map.put("method_name", "recordRest");
                map.put("param_value_arr", val);
                this.comTaskResidualAPIService.deleteByMap(map);
                this.comTaskResidualAPIService.saveComTaskResidual("recordRest", "SASS\u505a\u51cf\u5458\u4e1a\u52a1", "com.bcxin.ins.service.preservation.InsPreservationRecordAPIService", 1, "InsPreservationRecordVo", val);
            }
            return false;
        }
    }

    @Override
    public boolean recordRestPAC(InsPreservationRecordVo iprvo) {
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprvo.getIns_insurance_slip_id()));
        if (vo.getProduct_code().contains("GZZRX-PAC") || vo.getProduct_code().contains("GZZRX-QH")) {
            return this.recordRest(iprvo);
        }
        return false;
    }

    @Override
    public boolean updateBatchNumber(String json) {
        if (StringUtils.isEmpty((String)json)) {
            return false;
        }
        Map map = (Map)JSON.parseObject((String)json, Map.class);
        if (map == null) {
            return false;
        }
        String batch_number = PackageMessageRB.getPdh((String)map.get("batch_number"));
        if (StringUtils.isNotEmpty((String)batch_number)) {
            this.insPreservationRecordAPIDao.updateBatchNumber((String)map.get("record_id"), batch_number);
            return true;
        }
        return false;
    }

    @Override
    public void saveYWZCId(String record_id, String record_zc_id) {
        this.insPreservationRecordAPIDao.saveYWZCId(record_id, record_zc_id);
    }

    @Override
    public String getRecordByResultId(String result_id) {
        return this.insPreservationRecordAPIDao.getRecordByResultId(result_id);
    }

    @Override
    public void loadReconciliation() throws Exception {
        List<InsOrderReconciliation> list = GZZRX_TBRequestService.loadReconciliation("20240510");
        if (list.size() > 0) {
            this.insPreservationRecordAPIDao.batchOrderReconciliation(list);
        }
    }

    private /* synthetic */ void lambda$minusInsPreservationRecord$9(OrderFormVo vo, List ipdVoList, String inception_date) {
        try {
            this.sendPreservationEmail(vo.getProduct_code(), "", this.htmlContentByPreservationRecord(vo, ipdVoList, inception_date));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

