/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.zzx.zhongan.dto;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class CashierMD5Util {
    public static String Md5(String plainText) {
        StringBuffer buf = new StringBuffer("");
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public static Map<String, String> buildRequestPara(Map<String, String> sParaTemp, String key) {
        Map<String, String> sPara = CashierMD5Util.paraFilter(sParaTemp);
        String mysign = CashierMD5Util.buildRequestMysign(sPara, key);
        sPara.put("sign", mysign);
        sPara.put("sign_type", "MD5");
        return sPara;
    }

    private static String buildRequestMysign(Map<String, String> sPara, String key) {
        String prestr = CashierMD5Util.createLinkString(sPara);
        String mysign = CashierMD5Util.sign(prestr, key, "utf-8");
        return mysign;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String sign(String text, String key, String input_charset) {
        text = text + key;
        return DigestUtils.md5Hex((byte[])CashierMD5Util.getContentBytes(text, input_charset));
    }

    public static boolean verify(String text, String sign, String key) {
        String mysign = DigestUtils.md5Hex((byte[])CashierMD5Util.getContentBytes(text = text + key, "utf-8"));
        return mysign.equals(sign);
    }

    public static boolean verify(Map<String, String> map, String key) {
        String sign = "";
        if (map.get("sign") != null) {
            sign = map.get("sign");
        }
        String text = CashierMD5Util.createLinkString(CashierMD5Util.paraFilter(map));
        String mysign = DigestUtils.md5Hex((byte[])CashierMD5Util.getContentBytes(text = text + key, "utf-8"));
        return mysign.equals(sign);
    }

    public static boolean verify(Map<String, String> map, String sign, String key, String charset) {
        String text = CashierMD5Util.createLinkString(CashierMD5Util.paraFilter(map));
        String mysign = DigestUtils.md5Hex((byte[])CashierMD5Util.getContentBytes(text = text + key, charset));
        return mysign.equals(sign);
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static boolean verify(Map<String, String> map, String key, String signMsg) {
        String sign = "";
        if (map.get(signMsg) != null) {
            sign = map.get(signMsg);
        }
        String text = CashierMD5Util.createLinkString(CashierMD5Util.paraFilter(map, signMsg));
        String mysign = DigestUtils.md5Hex((byte[])CashierMD5Util.getContentBytes(text = text + key, "utf-8"));
        return mysign.equals(sign);
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray, String signMsg) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase(signMsg)) continue;
            result.put(key, value);
        }
        return result;
    }
}

