/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzzrx.taibao.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AesEcbPKCS7PaddingUtils {
    public static final String ALG_NAME = "AES/ECB/PKCS7Padding";
    public static final String KEY_ALGO_NAME = "AES";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static String ivString = "0123456789ABCDEF";

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int var5 = 0;
        for (int i = 0; i < l; ++i) {
            out[var5++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[var5++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static byte[] encrypt(byte[] data, byte[] key, String algorithm) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, AesEcbPKCS7PaddingUtils.recovertKey(key));
            return cipher.doFinal(data);
        }
        catch (Exception var4) {
            throw new RuntimeException("\u52a0\u5bc6\u51fa\u9519[AES", var4);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key, String algorithm) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, AesEcbPKCS7PaddingUtils.recovertKey(key));
            return cipher.doFinal(data);
        }
        catch (Exception var4) {
            throw new RuntimeException("\u89e3\u5bc6\u51fa\u9519[AES", var4);
        }
    }

    private static SecretKey recovertKey(byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, KEY_ALGO_NAME);
            return secretKey;
        }
        catch (Exception var2) {
            throw new RuntimeException("\u8f6c\u6362\u79d8\u94a5\u51fa\u9519[AES", var2);
        }
    }

    public static String decrypt(String key, String dataEn) throws Exception {
        MessageDigest mDigestMD5 = MessageDigest.getInstance("MD5");
        byte[] md5Key = mDigestMD5.digest(key.getBytes("UTF-8"));
        SecretKeySpec secretKey = new SecretKeySpec(md5Key, KEY_ALGO_NAME);
        Cipher cipher = Cipher.getInstance(KEY_ALGO_NAME);
        cipher.init(2, secretKey);
        byte[] hexBytes = AesEcbPKCS7PaddingUtils.hexStringToBytes(dataEn);
        byte[] plainBytes = cipher.doFinal(hexBytes);
        return new String(plainBytes);
    }

    public static String getAESStr(String str, String source_key) throws NoSuchAlgorithmException, UnsupportedEncodingException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        MessageDigest mDigestMD5 = MessageDigest.getInstance("MD5");
        byte[] md5Key = mDigestMD5.digest(source_key.getBytes("UTF-8"));
        Cipher clipher = Cipher.getInstance(KEY_ALGO_NAME);
        SecretKeySpec secretKey = new SecretKeySpec(md5Key, KEY_ALGO_NAME);
        clipher.init(1, secretKey);
        byte[] dateEnByte = clipher.doFinal(str.getBytes("UTF-8"));
        String dataEn = new String(AesEcbPKCS7PaddingUtils.encodeHex(dateEnByte, DIGITS_LOWER));
        return dataEn;
    }

    public static byte[] hexStringToBytes(String hexString) {
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            b[i] = (byte)(AesEcbPKCS7PaddingUtils.charToByte(hexChars[pos]) << 4 | AesEcbPKCS7PaddingUtils.charToByte(hexChars[pos + 1]));
        }
        return b;
    }

    public static byte charToByte(char c) {
        return (byte)ivString.indexOf(c);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

