/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzzrx.pingancai;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.util.BASE64Util;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.FileHelp;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.PAC_MD5Util;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.report_pac.InsClaimInformationVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.ins.vo.report_pac.InsPaymentInfoVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZZRX_PackageMessagePAC {
    private static Logger logger = LoggerFactory.getLogger(GZZRX_PackageMessagePAC.class);
    private static final String FORMAT = "json";
    private static final String SIGNTYPE = "md5";
    private static final String CHARSET = "utf-8";
    private static String DEPARTMENTCODE = GlobalResources.IS_TEST_ENVI != false ? "20162" : "20126";
    private static final String PARTNERCODE = "P_BCXZR_GP";

    public static String pdqr_marshal(String policyNo, String transType, String endorseApplyNo, String actualPremiumChange, String transSerialNo) throws Exception {
        JSONObject jsonHead = new JSONObject();
        if (TransTypeEnum.PDQR.getValue().equals(transType)) {
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            jsonHead.put((Object)"requestId", (Object)String.valueOf(idWorker.nextId()));
            JSONObject moreInfo = new JSONObject();
            moreInfo.put((Object)"partnerCode", (Object)PARTNERCODE);
            moreInfo.put((Object)"edrSceneCode", (Object)"18002");
            moreInfo.put((Object)"policyNo", (Object)policyNo);
            moreInfo.put((Object)"endorseApplyNo", (Object)endorseApplyNo);
            moreInfo.put((Object)"actualPremiumChange", (Object)actualPremiumChange);
            moreInfo.put((Object)"confirmEndorse", (Object)"Y");
            moreInfo.put((Object)"transSerialNo", (Object)transSerialNo);
            moreInfo.put((Object)"isSendElectronicEndorse", (Object)"N");
            jsonHead.put((Object)"endorseInfo", (Object)moreInfo);
        }
        return jsonHead.toString();
    }

    public static String marshalReport(InsCommonReportVo vo, String transType) throws Exception {
        JSONObject jsonHead = new JSONObject();
        if (TransTypeEnum.BASL.getValue().equals(transType)) {
            jsonHead.put((Object)"policyNo", (Object)vo.getPolicy_no());
            jsonHead.put((Object)"reporterName", (Object)vo.getReporter_name());
            jsonHead.put((Object)"reporterTel", (Object)vo.getReporter_tel());
            jsonHead.put((Object)"accidentDate", (Object)vo.getAccident_date());
            jsonHead.put((Object)"isOverseasAccident", (Object)"N");
            jsonHead.put((Object)"accidentProvinceCode", (Object)vo.getAccident_province_code());
            jsonHead.put((Object)"accidentCityCode", (Object)vo.getAccident_city_code());
            jsonHead.put((Object)"accidentCountyCode", (Object)vo.getAccident_county_code());
            jsonHead.put((Object)"accidentPlace", (Object)vo.getAccident_place());
            jsonHead.put((Object)"accidentProcess", (Object)vo.getAccident_process());
            jsonHead.put((Object)"accidentCauseLevel1", (Object)vo.getAccident_cause_level_1());
            jsonHead.put((Object)"accidentCauseLevel2", (Object)vo.getAccident_cause_level_2());
            jsonHead.put((Object)"isCargoLoss", (Object)vo.getIs_cargo_loss());
            jsonHead.put((Object)"isInjured", (Object)vo.getIs_injured());
            jsonHead.put((Object)"isCarLoss", (Object)vo.getIs_carloss());
            jsonHead.put((Object)"lossType", (Object)vo.getLoss_type());
            jsonHead.put((Object)"injuredDetail", (Object)vo.getInjured_detail());
            jsonHead.put((Object)"outpatientList", (Object)vo.getOutpatient_list());
            jsonHead.put((Object)"maimList", (Object)vo.getMaim_list());
            jsonHead.put((Object)"demiseList", (Object)vo.getDemise_list());
            jsonHead.put((Object)"reportLossSum", (Object)vo.getReport_loss_sum());
            jsonHead.put((Object)"isSelfClaim", (Object)"Y");
            jsonHead.put((Object)"userId", (Object)"BCX00001");
            jsonHead.put((Object)"lossCurrencyCode", (Object)"01");
            jsonHead.put((Object)"reportMode", (Object)"F");
            JSONArray claimInformationList = new JSONArray();
            GZZRX_PackageMessagePAC.doClaimInformationList(vo.getClaimInformationVoList(), claimInformationList);
            jsonHead.put((Object)"claimInformationList", (Object)claimInformationList);
            HashMap paymentInfoMap = Maps.newHashMap();
            GZZRX_PackageMessagePAC.doPaymentInfo(vo.getInsPaymentInfoVo(), paymentInfoMap);
            jsonHead.put((Object)"paymentInfo", (Object)paymentInfoMap);
        } else if (TransTypeEnum.AJCX.getValue().equals(transType)) {
            jsonHead.put((Object)"reportNo", (Object)vo.getReport_no());
            jsonHead.put((Object)"policyNo", (Object)vo.getPolicy_no());
        } else if (TransTypeEnum.CLSC.getValue().equals(transType)) {
            jsonHead.put((Object)"userId", (Object)"BCX00001");
            jsonHead.put((Object)"reportNo", (Object)vo.getReport_no());
            jsonHead.put((Object)"policyNo", (Object)vo.getPolicy_no());
            jsonHead.put((Object)"uploadSource", (Object)"10");
            jsonHead.put((Object)"uploadPersonType", (Object)"02");
            JSONArray claimInformationList = new JSONArray();
            GZZRX_PackageMessagePAC.doClaimInformationList(vo.getClaimInformationVoList(), claimInformationList);
            jsonHead.put((Object)"claimInformationList", (Object)claimInformationList);
        }
        return jsonHead.toString();
    }

    private static void doClaimInformationList(List<InsClaimInformationVo> list, JSONArray arr) {
        HashMap map = null;
        for (InsClaimInformationVo vo : list) {
            if (!"0".equals(vo.getStatus())) continue;
            map = Maps.newHashMap();
            map.put("fileId", vo.getFile_key());
            map.put("fileName", vo.getFile_name());
            map.put("bigGroupCode", vo.getBig_group_code());
            map.put("shortGroupCode", vo.getShort_group_code());
            arr.add((Object)map);
        }
    }

    private static void doPaymentInfo(InsPaymentInfoVo vo, Map<String, String> map) {
        map.put("dataSource", "F");
        map.put("clientName", vo.getClient_name());
        map.put("clientType", vo.getClient_type());
        map.put("clientBankAccount", vo.getClient_bank_account());
        map.put("clientBankCode", vo.getClient_bank_code());
        map.put("clientBankName", vo.getClient_bank_name());
        map.put("collectPayApproach", vo.getCollect_pay_approach());
        map.put("bankAccountAttribute", vo.getBank_account_attribute());
        String clientCertificateType = "0".equals(vo.getBank_account_attribute()) ? GZZRX_PackageMessagePAC.idTypeSet(vo.getClient_certificate_type()) : ("1".equals(vo.getBank_account_attribute()) ? GZZRX_PackageMessagePAC.getCard(vo.getClient_certificate_type()) : "");
        map.put("clientCertificateType", clientCertificateType);
        map.put("clientCertificateNo", vo.getClient_certificate_no());
        map.put("remark", vo.getRemark());
        map.put("provinceName", vo.getProvince_name());
        map.put("cityName", vo.getCity_name());
        map.put("regionCode", vo.getRegion_code());
    }

    public static String marshal(SpecialHirelingVo vo, OrderFormVo dto, String transType, InsPreservationRecordVo iprVo) throws Exception {
        JSONObject jsonHead = new JSONObject();
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        if (TransTypeEnum.HB.getValue().equals(transType)) {
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"transSerialNo", (Object)dto.getTrade_serial_number());
            jsonHead.put((Object)"departmentCode", (Object)DEPARTMENTCODE);
            jsonHead.put((Object)"transferCode", (Object)"APPLY");
            jsonHead.put((Object)"quoteMark", (Object)("1".equals(vo.getIs_contain_repo()) ? GZZRX_PackageMessagePAC.getQuoteMark1(dto.getProduct_code()) : ("2".equals(vo.getIs_contain_repo()) ? GZZRX_PackageMessagePAC.getQuoteMark2(dto.getProduct_code()) : GZZRX_PackageMessagePAC.getQuoteMark(dto.getProduct_code()))));
            jsonHead.put((Object)"schemeName", (Object)GZZRX_PackageMessagePAC.getSchemeName(dto.getProduct_code()));
            JSONObject jsonContract = new JSONObject();
            JSONArray jsonApplicantArray = new JSONArray();
            JSONObject jsonApplicant = new JSONObject();
            GZZRX_PackageMessagePAC.doApplicantInfo(vo, dto, jsonApplicant);
            jsonApplicantArray.add((Object)jsonApplicant);
            jsonContract.put((Object)"applicantInfoList", (Object)jsonApplicantArray);
            JSONArray jsonInsurantArray = new JSONArray();
            JSONObject jsonInsurant = new JSONObject();
            GZZRX_PackageMessagePAC.doInsurantInfo(vo, dto, jsonInsurant);
            jsonInsurantArray.add((Object)jsonInsurant);
            jsonContract.put((Object)"insurantInfoList", (Object)jsonInsurantArray);
            JSONArray jsonBeneficaryArray = new JSONArray();
            JSONObject jsonBeneficary = new JSONObject();
            GZZRX_PackageMessagePAC.doBeneficaryInfo(vo, dto, jsonBeneficary);
            jsonBeneficaryArray.add((Object)jsonBeneficary);
            jsonContract.put((Object)"beneficaryInfoList", (Object)jsonBeneficaryArray);
            JSONObject jsonBase = new JSONObject();
            GZZRX_PackageMessagePAC.doBaseInfo(vo, dto, jsonBase);
            jsonContract.put((Object)"baseInfo", (Object)jsonBase);
            JSONObject jsonExtend = new JSONObject();
            jsonExtend.put((Object)"isPolicyBeforePayfee", (Object)dto.getIs_policy_before_pay_fee());
            jsonContract.put((Object)"extendInfo", (Object)jsonExtend);
            HashMap extendGroup = Maps.newHashMap();
            extendGroup.put("employeesNum", vo.getHirelingVoList().size());
            jsonContract.put((Object)"extendGroupInfo", (Object)extendGroup);
            JSONArray jsonRiskPropertyArray = new JSONArray();
            GZZRX_PackageMessagePAC.doRiskGroupInfo(vo, dto, jsonRiskPropertyArray);
            jsonContract.put((Object)"riskGroupInfoList", (Object)jsonRiskPropertyArray);
            jsonHead.put((Object)"contract", (Object)jsonContract);
        } else if (TransTypeEnum.CBXX.getValue().equals(transType)) {
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"transSerialNo", (Object)String.valueOf(idWorker.nextId()));
            jsonHead.put((Object)"transferCode", (Object)"ACCEPT");
            jsonHead.put((Object)"tradeSubdivision", (Object)"MP07110009");
            JSONObject jsonContract = new JSONObject();
            JSONObject baseInfo = new JSONObject();
            baseInfo.put((Object)"applyPolicyNo", (Object)dto.getPolicy_serial_number());
            jsonContract.put((Object)"baseInfo", (Object)baseInfo);
            jsonHead.put((Object)"contract", (Object)jsonContract);
        } else if (TransTypeEnum.DZBD.getValue().equals(transType)) {
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"transferCode", (Object)"PRINT");
            jsonHead.put((Object)"applyPolicyNo", (Object)dto.getPolicy_serial_number());
            jsonHead.put((Object)"policyNo", (Object)dto.getExternal_reference());
            jsonHead.put((Object)"electronicType", (Object)"4");
            jsonHead.put((Object)"isElectronic", (Object)"1");
            jsonHead.put((Object)"languagePrint", (Object)"0");
            jsonHead.put((Object)"isPrintCross", (Object)"1");
        } else if (TransTypeEnum.ZFDZ.getValue().equals(transType)) {
            String productCode = "MP07110009";
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"partnerName", (Object)PARTNERCODE);
            jsonHead.put((Object)"tradeNo", (Object)String.valueOf(idWorker.nextId()));
            jsonHead.put((Object)"productCode", (Object)productCode);
            jsonHead.put((Object)"applyPolicyNo", (Object)dto.getPolicy_serial_number());
            jsonHead.put((Object)"noticeNo", (Object)dto.getNotice_no());
            jsonHead.put((Object)"amount", (Object)dto.getGross_premium());
            jsonHead.put((Object)"customerName", (Object)dto.getApplicant_name());
            jsonHead.put((Object)"productName", (Object)dto.getProduct_name());
            jsonHead.put((Object)"productType", (Object)"0A");
            jsonHead.put((Object)"systemType", (Object)"EBCS");
            jsonHead.put((Object)"signMsg", (Object)GZZRX_PackageMessagePAC.signMsg_sha256(dto, productCode));
            jsonHead.put((Object)"returnUrl", (Object)GlobalResources.WEB_URL);
            String returnUrl = GlobalResources.WEB_URL + "api/gzzrx/syntony-service/" + dto.getOid();
            if ("BLB".equals(dto.getWeb_type())) {
                returnUrl = GlobalResources.WEB_URL + "/insurance/gzzrx/transaction/syntony-service/" + dto.getOid();
            }
            jsonHead.put((Object)"frontNotifyUrl", (Object)returnUrl);
        } else if (TransTypeEnum.DZFP.getValue().equals(transType)) {
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            JSONArray invoiceArray = new JSONArray();
            JSONObject jsonInvoice = new JSONObject();
            GZZRX_PackageMessagePAC.doInvoice(vo, dto, jsonInvoice);
            invoiceArray.add((Object)jsonInvoice);
            jsonHead.put((Object)"invoiceList", (Object)invoiceArray);
        } else if (TransTypeEnum.PD.getValue().equals(transType)) {
            jsonHead.put((Object)"edrSceneCode", (Object)"70001");
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"updatedBy", (Object)"BCX00001");
            jsonHead.put((Object)"dataSource", (Object)"ICORE-PTS");
            jsonHead.put((Object)"effectiveDate", (Object)(iprVo.getInception_date() + " 00:00:00"));
            HashMap contract = Maps.newHashMap();
            HashMap baseInfo = Maps.newHashMap();
            baseInfo.put("policyNo", dto.getExternal_reference());
            contract.put("baseInfo", baseInfo);
            jsonHead.put((Object)"contract", (Object)contract);
            JSONArray riskPersonArray = new JSONArray();
            GZZRX_PackageMessagePAC.doRiskPersonList(iprVo, dto, riskPersonArray);
            jsonHead.put((Object)"applyRiskPropsubDTOs", (Object)riskPersonArray);
        } else if (TransTypeEnum.DZPD.getValue().equals(transType)) {
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"transferCode", (Object)"PRINT");
            jsonHead.put((Object)"applyPolicyNo", (Object)dto.getPolicy_serial_number());
            jsonHead.put((Object)"policyNo", (Object)dto.getExternal_reference());
            jsonHead.put((Object)"endorseNo", (Object)iprVo.getRevise_serial_num_ins());
            jsonHead.put((Object)"electronicType", (Object)"7");
            jsonHead.put((Object)"isElectronic", (Object)"1");
            jsonHead.put((Object)"languagePrint", (Object)"0");
            jsonHead.put((Object)"isPrintCross", (Object)"1");
        }
        return jsonHead.toString();
    }

    private static String signInfo_sha256(String policyNo, String productCode, String printTime) {
        return PAC_MD5Util.sha256Hex((String)(policyNo + productCode + printTime));
    }

    private static String signMsg_sha256(OrderFormVo dto, String productCode) {
        return PAC_MD5Util.sha256Hex((String)(PARTNERCODE + productCode + dto.getApplicant_name() + dto.getGross_premium() + dto.getNotice_no()));
    }

    private static void doBaseInfo(SpecialHirelingVo vo, OrderFormVo dto, JSONObject json) {
        json.put((Object)"productCode", (Object)"MP07110009");
        json.put((Object)"inputNetworkFlag", (Object)"internet");
        json.put((Object)"dataSource", (Object)"openApi");
        json.put((Object)"inputBy", (Object)PARTNERCODE);
        json.put((Object)"insuranceBeginDate", (Object)(dto.getInception_date() + " 00:00:00"));
    }

    private static void doInvoice(SpecialHirelingVo vo, OrderFormVo dto, JSONObject json) {
        JSONArray policyArray = new JSONArray();
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if (!"1".equals(roleSubjectVo.getKind())) continue;
            String organizationCode = roleSubjectVo.getOrganization_code();
            if (StringUtils.isNotEmpty((CharSequence)organizationCode) && "1".equals(roleSubjectVo.getId_type())) {
                organizationCode = organizationCode.split("-")[0] + organizationCode.split("-")[1];
            }
            json.put((Object)"transactionNo", (Object)dto.getTrade_serial_number());
            json.put((Object)"invoiceCreater", (Object)PARTNERCODE);
            if (vo.getMailPolicyVo() != null && StringUtils.isNotEmpty((CharSequence)vo.getMailPolicyVo().getReceipt_head())) {
                json.put((Object)"invoiceEmail", (Object)roleSubjectVo.getLink_email());
                json.put((Object)"invoicePhone", (Object)vo.getMailPolicyVo().getTaker_mobile());
                json.put((Object)"invoiceOwner", (Object)vo.getMailPolicyVo().getReceipt_head());
                json.put((Object)"taxPayerNO", (Object)vo.getMailPolicyVo().getTaxpayer_number_invoice());
            } else {
                json.put((Object)"invoiceEmail", (Object)roleSubjectVo.getLink_email());
                json.put((Object)"invoicePhone", (Object)roleSubjectVo.getLink_tel());
                json.put((Object)"invoiceOwner", (Object)roleSubjectVo.getName_cn());
                json.put((Object)"taxPayerNO", (Object)organizationCode);
            }
            if (vo.getMailPolicyVo() != null && "1".equals(vo.getMailPolicyVo().getNeed_receipt())) {
                json.put((Object)"taxPayerTel", (Object)vo.getMailPolicyVo().getTaker_mobile());
                json.put((Object)"taxPayerAddress", (Object)vo.getMailPolicyVo().getRegister_address_invoice());
                json.put((Object)"taxPayerBankName", (Object)vo.getMailPolicyVo().getBank_invoice());
                json.put((Object)"taxPayerBankAccount", (Object)vo.getMailPolicyVo().getBank_account_invoice());
            }
            JSONObject policyInfo = new JSONObject();
            policyInfo.put((Object)"policyNo", (Object)dto.getExternal_reference());
            policyInfo.put((Object)"personnelName", (Object)roleSubjectVo.getName_cn());
            policyInfo.put((Object)"certificateType", (Object)GZZRX_PackageMessagePAC.idTypeSet(roleSubjectVo.getId_type()));
            policyInfo.put((Object)"certificateNo", (Object)organizationCode);
            policyArray.add((Object)policyInfo);
        }
        json.put((Object)"policyList", (Object)policyArray);
    }

    private static void doRiskPersonList(InsPreservationRecordVo vo, OrderFormVo dto, JSONArray arr) {
        for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
            JSONObject riskPerson = new JSONObject();
            String type = GZZRX_PackageMessagePAC.conventPType(vo.getRevise_type());
            riskPerson.put((Object)"status", (Object)type);
            riskPerson.put((Object)"fullName", (Object)ipdVo.getName());
            riskPerson.put((Object)"certificateNo", (Object)ipdVo.getId_card());
            riskPerson.put((Object)"certificateType", (Object)GZZRX_PackageMessagePAC.getCard(ipdVo.getId_type()));
            riskPerson.put((Object)"professionType", (Object)GZZRX_PackageMessagePAC.getCareerClass(ipdVo.getCareer()));
            riskPerson.put((Object)"position", (Object)GZZRX_PackageMessagePAC.getCareerName(ipdVo.getCareer()));
            if ("U".equals(type) && ipdVo.getBusiness_vo() != null) {
                riskPerson.put((Object)"oldFullName", (Object)ipdVo.getBusiness_vo().getName());
                riskPerson.put((Object)"oldCertificateType", (Object)GZZRX_PackageMessagePAC.getCard(ipdVo.getBusiness_vo().getId_type()));
                riskPerson.put((Object)"oldCertificateNo", (Object)ipdVo.getBusiness_vo().getId_card());
                riskPerson.put((Object)"oldProfessionType", (Object)GZZRX_PackageMessagePAC.getCareerClass(ipdVo.getBusiness_vo().getCareer()));
                riskPerson.put((Object)"oldPosition", (Object)GZZRX_PackageMessagePAC.getCareerName(ipdVo.getBusiness_vo().getCareer()));
            }
            if ("D".equals(type)) {
                riskPerson.put((Object)"oldFullName", (Object)ipdVo.getName());
                riskPerson.put((Object)"oldCertificateType", (Object)GZZRX_PackageMessagePAC.getCard(ipdVo.getId_type()));
                riskPerson.put((Object)"oldCertificateNo", (Object)ipdVo.getId_card());
                riskPerson.put((Object)"oldProfessionType", (Object)GZZRX_PackageMessagePAC.getCareerClass(ipdVo.getCareer()));
                riskPerson.put((Object)"oldPosition", (Object)GZZRX_PackageMessagePAC.getCareerName(ipdVo.getCareer()));
            }
            arr.add((Object)riskPerson);
        }
    }

    private static String conventPType(String revise_type) {
        String rt = "";
        if ("1".equals(revise_type)) {
            rt = "A";
        } else if ("2".equals(revise_type)) {
            rt = "D";
        } else if ("3".equals(revise_type)) {
            rt = "U";
        }
        return rt;
    }

    private static String getCareerName(String career) {
        String name = "";
        if ("1".equals(career)) {
            name = "\u5185\u52e4\u4eba\u5458";
        } else if ("2".equals(career)) {
            name = "\u4fdd\u5b89\u4eba\u5458";
        } else if ("4".equals(career)) {
            name = "\u4fdd\u6d01\u4eba\u5458";
        }
        return name;
    }

    private static String getCareerClass(String career) {
        String cla = "";
        if ("1".equals(career)) {
            cla = "52";
        } else if ("2".equals(career)) {
            cla = "53";
        } else if ("4".equals(career)) {
            cla = "51";
        }
        return cla;
    }

    private static void doRiskGroupInfo(SpecialHirelingVo gvo, OrderFormVo dto, JSONArray arr) {
        JSONObject riskPropertyInfoList = new JSONObject();
        JSONArray riskPropertyInfoArray = new JSONArray();
        JSONObject riskPropertyInfoMap = new JSONObject();
        HashMap map = Maps.newHashMap();
        JSONObject liabilityExtend = new JSONObject();
        liabilityExtend.put((Object)"isRegistered", (Object)"1");
        liabilityExtend.put((Object)"isInductrialInjury", (Object)"0");
        map.put("liabilityExtend", liabilityExtend);
        JSONArray personnelList = new JSONArray();
        List hirelingList = gvo.getHirelingVoList();
        for (HirelingVo vo : hirelingList) {
            JSONObject personnel = new JSONObject();
            personnel.put((Object)"fullName", (Object)vo.getName());
            personnel.put((Object)"certificateNo", (Object)vo.getId_card());
            personnel.put((Object)"certificateType", (Object)GZZRX_PackageMessagePAC.getCard(vo.getId_type()));
            personnel.put((Object)"professionType", (Object)GZZRX_PackageMessagePAC.getCareerClass(vo.getCareer()));
            personnel.put((Object)"position", (Object)GZZRX_PackageMessagePAC.getCareerName(vo.getCareer()));
            personnelList.add((Object)personnel);
        }
        map.put("personnelList", personnelList);
        JSONArray riskEmployeeList = new JSONArray();
        JSONObject riskEmployee = new JSONObject();
        riskEmployee.put((Object)"deathLimitAmount", (Object)GZZRX_PackageMessagePAC.getPlanAmount("deathLimitAmount", dto.getProduct_code()));
        riskEmployee.put((Object)"maimLimitAmount", (Object)GZZRX_PackageMessagePAC.getPlanAmount("maimLimitAmount", dto.getProduct_code()));
        riskEmployee.put((Object)"medicalLimitAmount", (Object)GZZRX_PackageMessagePAC.getPlanAmount("medicalLimitAmount", dto.getProduct_code()));
        riskEmployeeList.add((Object)riskEmployee);
        map.put("riskEmployeeList", riskEmployeeList);
        riskPropertyInfoMap.put((Object)"riskPropertyMap", (Object)map);
        riskPropertyInfoArray.add((Object)riskPropertyInfoMap);
        riskPropertyInfoList.put((Object)"riskPropertyInfoList", (Object)riskPropertyInfoArray);
        arr.add((Object)riskPropertyInfoList);
    }

    private static String getProfessionCode(String major_group) {
        if (!GlobalResources.IS_TEST_ENVI.booleanValue()) {
            return "3".equals(major_group) ? "N010404" : "N010401";
        }
        return "3".equals(major_group) ? "0201002" : "0201002";
    }

    private static String getCard(String cardType) {
        if ("0".equals(cardType)) {
            return "01";
        }
        if ("3".equals(cardType)) {
            return "02";
        }
        if ("4".equals(cardType)) {
            return "06";
        }
        return "";
    }

    private static String getPlanCode(String product_code) {
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-1".equals(product_code)) {
            return "MP07110001";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-2".equals(product_code)) {
            return "MP07110002";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-3".equals(product_code)) {
            return "MP07110003";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-4".equals(product_code)) {
            return "MP07110004";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-5".equals(product_code)) {
            return "MP07110005";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-6".equals(product_code)) {
            return "MP07110006";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-7".equals(product_code)) {
            return "MP07110007";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-8".equals(product_code)) {
            return "MP07110008";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-9".equals(product_code)) {
            return "MP07110009";
        }
        return "";
    }

    private static String getSchemeName(String product_code) {
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-1".equals(product_code)) {
            return "\u8ba1\u5212\u4e00";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-2".equals(product_code)) {
            return "\u8ba1\u5212\u4e8c";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-3".equals(product_code)) {
            return "\u8ba1\u5212\u4e09";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-4".equals(product_code)) {
            return "\u8ba1\u5212\u56db";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-5".equals(product_code)) {
            return "\u8ba1\u5212\u4e94";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-6".equals(product_code)) {
            return "\u8ba1\u5212\u516d";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-7".equals(product_code)) {
            return "\u8ba1\u5212\u4e03";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-8".equals(product_code)) {
            return "\u8ba1\u5212\u516b";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-9".equals(product_code)) {
            return "\u8ba1\u5212\u4e5d";
        }
        return "";
    }

    private static String getPlanAmount(String name, String product_code) {
        String planAmount = "";
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-1".equals(product_code)) {
            planAmount = "deathLimitAmount".equals(name) ? "300000" : ("maimLimitAmount".equals(name) ? "300000" : ("medicalLimitAmount".equals(name) ? "30000" : ""));
        } else if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-2".equals(product_code)) {
            planAmount = "deathLimitAmount".equals(name) ? "400000" : ("maimLimitAmount".equals(name) ? "400000" : ("medicalLimitAmount".equals(name) ? "40000" : ""));
        } else if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-3".equals(product_code)) {
            planAmount = "deathLimitAmount".equals(name) ? "500000" : ("maimLimitAmount".equals(name) ? "500000" : ("medicalLimitAmount".equals(name) ? "50000" : ""));
        } else if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-4".equals(product_code)) {
            planAmount = "deathLimitAmount".equals(name) ? "600000" : ("maimLimitAmount".equals(name) ? "600000" : ("medicalLimitAmount".equals(name) ? "60000" : ""));
        } else if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-5".equals(product_code)) {
            planAmount = "deathLimitAmount".equals(name) ? "700000" : ("maimLimitAmount".equals(name) ? "700000" : ("medicalLimitAmount".equals(name) ? "70000" : ""));
        } else if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-6".equals(product_code)) {
            planAmount = "deathLimitAmount".equals(name) ? "800000" : ("maimLimitAmount".equals(name) ? "800000" : ("medicalLimitAmount".equals(name) ? "80000" : ""));
        } else if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-7".equals(product_code)) {
            planAmount = "deathLimitAmount".equals(name) ? "900000" : ("maimLimitAmount".equals(name) ? "900000" : ("medicalLimitAmount".equals(name) ? "90000" : ""));
        } else if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-8".equals(product_code)) {
            planAmount = "deathLimitAmount".equals(name) ? "1000000" : ("maimLimitAmount".equals(name) ? "1000000" : ("medicalLimitAmount".equals(name) ? "100000" : ""));
        } else if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-9".equals(product_code)) {
            planAmount = "deathLimitAmount".equals(name) ? "1200000" : ("maimLimitAmount".equals(name) ? "1200000" : ("medicalLimitAmount".equals(name) ? "120000" : ""));
        }
        return planAmount;
    }

    private static String getQuoteMark(String product_code) {
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-1".equals(product_code)) {
            return "quotation1";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-2".equals(product_code)) {
            return "quotation1";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-3".equals(product_code)) {
            return "quotation1";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-4".equals(product_code)) {
            return "quotation1";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-5".equals(product_code)) {
            return "quotation1";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-6".equals(product_code)) {
            return "quotation2";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-7".equals(product_code)) {
            return "quotation2";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-8".equals(product_code)) {
            return "quotation2";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-9".equals(product_code)) {
            return "quotation2";
        }
        return "";
    }

    private static String getQuoteMark1(String product_code) {
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-1".equals(product_code)) {
            return "quotation3";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-2".equals(product_code)) {
            return "quotation3";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-3".equals(product_code)) {
            return "quotation3";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-4".equals(product_code)) {
            return "quotation3";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-5".equals(product_code)) {
            return "quotation3";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-6".equals(product_code)) {
            return "quotation4";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-7".equals(product_code)) {
            return "quotation4";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-8".equals(product_code)) {
            return "quotation4";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-9".equals(product_code)) {
            return "quotation4";
        }
        return "";
    }

    private static String getQuoteMark2(String product_code) {
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-1".equals(product_code)) {
            return "quotation5";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-2".equals(product_code)) {
            return "quotation5";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-3".equals(product_code)) {
            return "quotation5";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-4".equals(product_code)) {
            return "quotation5";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-5".equals(product_code)) {
            return "quotation5";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-6".equals(product_code)) {
            return "quotation6";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-7".equals(product_code)) {
            return "quotation6";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-8".equals(product_code)) {
            return "quotation6";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "GZZRX-PAC-9".equals(product_code)) {
            return "quotation6";
        }
        return "";
    }

    private static void doApplicantInfo(SpecialHirelingVo vo, OrderFormVo dto, JSONObject json) {
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if (!"1".equals(roleSubjectVo.getKind())) continue;
            String organizationCode = roleSubjectVo.getOrganization_code();
            if (StringUtils.isNotEmpty((CharSequence)organizationCode) && "1".equals(roleSubjectVo.getId_type())) {
                organizationCode = organizationCode.split("-")[0] + organizationCode.split("-")[1];
            }
            json.put((Object)"name", (Object)roleSubjectVo.getName_cn().replace("\uff08", "(").replace("\uff09", ")"));
            json.put((Object)"personnelType", (Object)"0");
            json.put((Object)"certificateType", (Object)GZZRX_PackageMessagePAC.idTypeSet(roleSubjectVo.getId_type()));
            json.put((Object)"certificateNo", (Object)organizationCode);
            json.put((Object)"linkManName", (Object)roleSubjectVo.getLink_name());
            String address = RegionUtils.getRegionNameByALLCode((String)roleSubjectVo.getReg_province(), (String)roleSubjectVo.getReg_city(), (String)roleSubjectVo.getReg_district()) + roleSubjectVo.getReg_address();
            json.put((Object)"address", (Object)address);
            json.put((Object)"mobileTelephone", (Object)roleSubjectVo.getLink_tel());
            json.put((Object)"email", (Object)roleSubjectVo.getLink_email());
            if (vo.getMailPolicyVo() != null && "1".equals(vo.getMailPolicyVo().getNeed_receipt())) {
                json.put((Object)"invoicePrintType", (Object)("0".equals(vo.getMailPolicyVo().getInvoice_type()) ? "01" : "02"));
                json.put((Object)"billingAddress", (Object)vo.getMailPolicyVo().getRegister_address_invoice());
                json.put((Object)"billingPhone", (Object)vo.getMailPolicyVo().getTaker_mobile());
                json.put((Object)"billingDepositBank", (Object)vo.getMailPolicyVo().getBank_invoice());
                json.put((Object)"billingDepositBankAccount", (Object)vo.getMailPolicyVo().getBank_account_invoice());
                json.put((Object)"taxpayerCertificateType", (Object)"02");
                json.put((Object)"taxpayerCertificateNo", (Object)vo.getMailPolicyVo().getTaxpayer_number_invoice());
                continue;
            }
            json.put((Object)"invoicePrintType", (Object)"03");
        }
    }

    private static void doInsurantInfo(SpecialHirelingVo vo, OrderFormVo dto, JSONObject json) {
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if (!"2".equals(roleSubjectVo.getKind())) continue;
            String organizationCode = roleSubjectVo.getOrganization_code();
            if (StringUtils.isNotEmpty((CharSequence)organizationCode) && "1".equals(roleSubjectVo.getId_type())) {
                organizationCode = organizationCode.split("-")[0] + organizationCode.split("-")[1];
            }
            json.put((Object)"name", (Object)roleSubjectVo.getName_cn().replace("\uff08", "(").replace("\uff09", ")"));
            json.put((Object)"personnelType", (Object)"0");
            json.put((Object)"certificateType", (Object)GZZRX_PackageMessagePAC.idTypeSet(roleSubjectVo.getId_type()));
            json.put((Object)"certificateNo", (Object)organizationCode);
            json.put((Object)"linkManName", (Object)roleSubjectVo.getLink_name());
            String address = RegionUtils.getRegionNameByALLCode((String)roleSubjectVo.getReg_province(), (String)roleSubjectVo.getReg_city(), (String)roleSubjectVo.getReg_district()) + roleSubjectVo.getReg_address();
            json.put((Object)"address", (Object)address);
            json.put((Object)"mobileTelephone", (Object)roleSubjectVo.getLink_tel());
            json.put((Object)"email", (Object)roleSubjectVo.getLink_email());
        }
    }

    private static void doBeneficaryInfo(SpecialHirelingVo vo, OrderFormVo dto, JSONObject json) {
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if (!"2".equals(roleSubjectVo.getKind())) continue;
            String organizationCode = roleSubjectVo.getOrganization_code();
            if (StringUtils.isNotEmpty((CharSequence)organizationCode) && "1".equals(roleSubjectVo.getId_type())) {
                organizationCode = organizationCode.split("-")[0] + organizationCode.split("-")[1];
            }
            json.put((Object)"name", (Object)roleSubjectVo.getName_cn().replace("\uff08", "(").replace("\uff09", ")"));
            json.put((Object)"personnelType", (Object)"0");
            json.put((Object)"certificateType", (Object)GZZRX_PackageMessagePAC.idTypeSet(roleSubjectVo.getId_type()));
            json.put((Object)"certificateNo", (Object)organizationCode);
            json.put((Object)"linkManName", (Object)roleSubjectVo.getLink_name());
            String address = RegionUtils.getRegionNameByALLCode((String)roleSubjectVo.getReg_province(), (String)roleSubjectVo.getReg_city(), (String)roleSubjectVo.getReg_district()) + roleSubjectVo.getReg_address();
            json.put((Object)"address", (Object)address);
            json.put((Object)"mobileTelephone", (Object)roleSubjectVo.getLink_tel());
            json.put((Object)"email", (Object)roleSubjectVo.getLink_email());
        }
    }

    private static String idTypeSet(String value) {
        if ("1".equals(value)) {
            return "01";
        }
        if ("2".equals(value)) {
            return "03";
        }
        if ("6".equals(value)) {
            return "02";
        }
        if ("7".equals(value)) {
            return "04";
        }
        return "";
    }

    public static String returnAnalysisJson(String json, String transType) {
        if (TransTypeEnum.DZFP.getValue().equals(transType)) {
            Map map = (Map)JSON.parseObject((String)json, Map.class);
            if (!"0".equals(map.get("ret"))) {
                return "300#\uff08APP-PAC-" + map.get("ret") + "\uff09" + map.get("msg");
            }
            List list = JSONArray.parseArray((String)map.get("data").toString(), Map.class);
            if (list.size() <= 0) {
                return "300#\uff08APP-PAC-003\uff09\u7535\u5b50\u53d1\u7968\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\uff01";
            }
            Map m = (Map)list.get(0);
            if (!"999999".equals(m.get("responseCode").toString())) {
                return "300#\uff08APP-PAC-" + m.get("responseCode") + "\uff09" + m.get("responseMsg");
            }
            String filePath = GZZRX_PackageMessagePAC.uploadFile(String.valueOf(m.get("invoiceValue")), "pdf", "/policy/");
            if (StringUtils.isNotEmpty((CharSequence)filePath)) {
                return "200#" + filePath;
            }
            return "300#\uff08APP-PAC-002\uff09\u7535\u5b50\u53d1\u7968\u6253\u5370\u6587\u4ef6\u6d41\u89e3\u6790\u5931\u8d25\uff01";
        }
        JSONObject jsonHead = JSONObject.fromObject((Object)json);
        if (jsonHead == null) {
            return "300#\uff08APP-PAC-001\uff09\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u6570\u636e\uff01";
        }
        if (!"0".equals(jsonHead.get("ret"))) {
            return "300#\uff08APP-PAC-" + jsonHead.get("ret") + "\uff09" + jsonHead.get("msg");
        }
        JSONObject jsonDate = JSONObject.fromObject((Object)jsonHead.get("data"));
        JSONObject resultJson = JSONObject.fromObject((Object)jsonDate.get("result"));
        if (TransTypeEnum.HB.getValue().equals(transType)) {
            if ("999999".equals(jsonDate.get("responseCode"))) {
                return "200#" + resultJson.get("applyPolicyNo") + "#" + resultJson.get("policyNo") + "#" + resultJson.get("totalActualPremium") + "#" + resultJson.get("totalInsuredAmount") + "#" + resultJson.get("noticeNo");
            }
            return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
        }
        if (TransTypeEnum.CBXX.getValue().equals(transType)) {
            if ("999999".equals(jsonDate.get("responseCode")) || "888888".equals(jsonDate.get("responseCode"))) {
                return "200#" + resultJson.get("policyNo") + "#" + resultJson.get("applyPolicyNo") + "#" + resultJson.get("totalActualPremium");
            }
            return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
        }
        if (TransTypeEnum.DZBD.getValue().equals(transType)) {
            if (!"999999".equals(jsonDate.get("responseCode"))) {
                return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
            }
            String filePath = GZZRX_PackageMessagePAC.uploadFile(String.valueOf(jsonDate.get("returnPdfValue")), "pdf", "/policy/");
            if (StringUtils.isNotEmpty((CharSequence)filePath)) {
                return "200#" + filePath;
            }
            return "300#\uff08APP-PAC-002\uff09\u7535\u5b50\u4fdd\u5355\u6253\u5370\u6587\u4ef6\u6d41\u89e3\u6790\u5931\u8d25\uff01";
        }
        if (TransTypeEnum.DZPD.getValue().equals(transType)) {
            if (!"999999".equals(jsonDate.get("responseCode"))) {
                return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
            }
            String filePath = GZZRX_PackageMessagePAC.uploadFile(String.valueOf(jsonDate.get("returnPdfValue")), "pdf", "/policy/");
            if (StringUtils.isNotEmpty((CharSequence)filePath)) {
                return "200#" + filePath;
            }
            return "300#\uff08APP-PAC-002\uff09\u7535\u5b50\u6279\u5355\u6253\u5370\u6587\u4ef6\u6d41\u89e3\u6790\u5931\u8d25\uff01";
        }
        if (TransTypeEnum.ZFDZ.getValue().equals(transType)) {
            if ("SUCCESS".equals(jsonDate.get("resultCode"))) {
                return "200#" + jsonDate.get("tradeNo") + "#" + jsonDate.get("payUrl");
            }
            return "300#\uff08APP-PAC-" + jsonDate.get("resultCode") + "\uff09" + jsonDate.get("resultMsg");
        }
        if (TransTypeEnum.PD.getValue().equals(transType)) {
            if ("9999".equals(jsonDate.get("responseCode"))) {
                return "200#" + resultJson.get("policyNo") + "#" + resultJson.get("endorseNo") + "#" + resultJson.get("actualPremiumChange") + "#" + resultJson.get("endorseApplyNo");
            }
            return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
        }
        return "300#\uff08APP-PAC-001.1\uff09\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
    }

    public static String returnAnalysisJson_LP(String json, String transType) {
        JSONObject jsonHead = JSONObject.fromObject((Object)json);
        if (jsonHead == null) {
            return "300#\uff08APP-PAC-001\uff09\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u6570\u636e\uff01";
        }
        if (!"0".equals(jsonHead.get("ret"))) {
            return "300#\uff08APP-PAC-" + jsonHead.get("ret") + "\uff09" + jsonHead.get("msg");
        }
        JSONObject jsonData1 = JSONObject.fromObject((Object)jsonHead.get("data").toString());
        if (TransTypeEnum.CLSC.getValue().equals(transType)) {
            if ("888".equals(jsonData1.get("code").toString())) {
                return "200#" + jsonData1.get("msg");
            }
            return "300#" + jsonData1.get("msg");
        }
        JSONObject jsonResult = JSONObject.fromObject((Object)jsonData1.get("result").toString());
        if (!"Y".equals(jsonResult.get("resultCode"))) {
            return "300#" + jsonResult.get("resultMessage");
        }
        if (TransTypeEnum.BASL.getValue().equals(transType)) {
            JSONObject jsonData = JSONObject.fromObject((Object)jsonData1.get("data").toString());
            return "200#" + jsonData.get("reportNo") + "#" + jsonData.get("channelCode") + "#" + jsonData.get("reportDate");
        }
        if (TransTypeEnum.AJCX.getValue().equals(transType)) {
            String data = jsonData1.get("data").toString();
            return "200#" + data;
        }
        if (TransTypeEnum.XXAJCX.getValue().equals(transType)) {
            JSONObject jsonData = JSONObject.fromObject((Object)jsonData1.get("data").toString());
            String total = jsonData.get("total") == null ? "0" : jsonData.get("total").toString();
            String pageCount = jsonData.get("pageCount") == null ? "0" : jsonData.get("pageCount").toString();
            String data = jsonData.get("reportInfos").toString();
            return "200#" + total + "#" + pageCount + "#" + data;
        }
        return "200#" + jsonResult.get("resultMessage");
    }

    public static void main(String[] args) {
        String n = "\u767e\u5ddd\u4fe1\uff08\u5317\u4eac\uff09\u4fe1\u606f\u670d\u52a1\u6709\u9650\u516c\u53f8";
        System.out.println(n.replace("\uff08", "(").replace("\uff09", ")"));
    }

    public static String uploadFile(String fileStr, String fileType, String savePath) {
        String result = "";
        if (StringUtils.isEmpty((CharSequence)fileStr)) {
            return result;
        }
        try {
            if (StringUtils.isEmpty((CharSequence)fileType)) {
                fileType = "pdf";
            }
            byte[] bytes = BASE64Util.decryptBASE64Byte((String)fileStr);
            String files = DateUtil.generatorRadomNumber() + "." + fileType;
            result = savePath + files;
            String path = GlobalResources.COM_IMG_RE + savePath;
            FileHelp.byteFile((byte[])bytes, (String)path, (String)files);
            result = "/getResource?path=" + result;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "";
        }
        return result;
    }
}

