/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzx.changan;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.InsCommonReportAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.third.gzx.changan.GZX_PackageMessageChangAn;
import com.bcxin.ins.third.gzx.changan.http.CAHttpUtils;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="gZX_CARequestService")
@Transactional
public class GZX_CARequestService {
    private Logger communicatorLog = LoggerFactory.getLogger(GZX_CARequestService.class);
    @Autowired
    private PolicyService policyService;
    @Autowired
    private InsTransactionAPIService insTransactionAPIService;
    @Autowired
    private LogBusinessrequestService logBusinessrequestService;
    @Autowired
    private InsCommonReportAPIService insCommonReportAPIService;

    public String request_ca_gzx(Long order_id, String transType) throws Exception {
        List<InsTransaction> itranList;
        this.communicatorLog.info("request_rb_gzx\uff1astar-----------------------");
        this.communicatorLog.info("request_rb_gzx\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + order_id);
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(Long.parseLong(dto.getOid()));
        InsTransaction itran = null;
        if (TransTypeEnum.CBQR.getValue().equals(transType) && (itranList = this.insTransactionAPIService.selectInsTransactionByInsOrderForm(Long.parseLong(dto.getOid()))).size() > 0) {
            itran = itranList.get(0);
        }
        String result = "300#\uff08APP-CA-GZX-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String json = GZX_PackageMessageChangAn.marshal(vo, dto, transType, itran);
            this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
            String url = this.getPath(transType);
            this.communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
            HashMap<String, String> sslConfig = new HashMap<String, String>();
            GlobalResources.CA_GZ_KEY_STORE_PATH = "F:/\u9879\u76ee\u8d44\u6599\u6536\u85cf\u5939/--\u5386\u53f2\u9879\u76ee\u8bb0\u5f55--/\u767e\u8054\u4fdd\u9700\u6c42\u5bf9\u63a5\u76f8\u5173\u8d44\u6599/2021_02-24(\u957f\u5b89\u96c7\u4e3b\u8d23\u4efb\u9669)/04_\u7b2c\u4e09\u65b9\u5bf9\u63a5\u6587\u6863/https/\u6d4b\u8bd5\u65b0\u8bc1\u4e66/testjks/test_keystore.jks";
            GlobalResources.CA_GZ_TRUST_STORE_PATH = "F:/\u9879\u76ee\u8d44\u6599\u6536\u85cf\u5939/--\u5386\u53f2\u9879\u76ee\u8bb0\u5f55--/\u767e\u8054\u4fdd\u9700\u6c42\u5bf9\u63a5\u76f8\u5173\u8d44\u6599/2021_02-24(\u957f\u5b89\u96c7\u4e3b\u8d23\u4efb\u9669)/04_\u7b2c\u4e09\u65b9\u5bf9\u63a5\u6587\u6863/https/\u6d4b\u8bd5\u65b0\u8bc1\u4e66/testjks/test_truststore.jks";
            sslConfig.put("IgnoreVerifySSL", "false");
            sslConfig.put("keyStorePath", GlobalResources.CA_GZ_KEY_STORE_PATH);
            sslConfig.put("keyStorepass", GlobalResources.CA_GZ_KEY_STORE_PASS);
            sslConfig.put("trustStorePath", GlobalResources.CA_GZ_TRUST_STORE_PATH);
            sslConfig.put("trustStorepass", GlobalResources.CA_GZ_TRUST_STORE_PASS);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "text/xml;charset=gbk");
            Date bTime = new Date();
            CloseableHttpResponse httpResponse = CAHttpUtils.doPost(url, null, null, headers, null, json, sslConfig);
            String body = "";
            System.out.println("\u8fd4\u56de\u54cd\u5e94\u72b6\u6001\u4fe1\u606f:" + httpResponse.getStatusLine());
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                body = EntityUtils.toString((HttpEntity)entity, (String)"GBK");
            }
            EntityUtils.consume((HttpEntity)entity);
            httpResponse.close();
            String ret = StringUtils.replaceEach((String)body, (String[])new String[]{"\n", "\t", "\r"}, (String[])new String[]{"", "", ""});
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id), transType, url, json, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            GZX_PackageMessageChangAn gpm = new GZX_PackageMessageChangAn();
            result = gpm.returnAnalysisXML(ret, transType);
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            ex.printStackTrace();
        }
        this.communicatorLog.info("request_rb_gzx\uff1aend-----------------------");
        return result;
    }

    public String request_ca_dzfp(Long order_id, String transType, String certino, String kpStar, String kpEnd) {
        this.communicatorLog.info("request_ca_dzfp\uff1astar-----------------------");
        this.communicatorLog.info("request_ca_dzfp\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + order_id + ",certino-" + certino + ",kpStar-" + kpStar + ",kpEnd-" + kpEnd);
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(Long.parseLong(dto.getOid()));
        String result = "300#\uff08APP-CA-GZX-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String json = GZX_PackageMessageChangAn.mail(vo, dto, transType, certino, kpStar, kpEnd);
            this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
            String url = this.getPath(transType);
            this.communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
            HashMap<String, String> sslConfig = new HashMap<String, String>();
            sslConfig.put("IgnoreVerifySSL", "false");
            sslConfig.put("keyStorePath", GlobalResources.CA_GZ_KEY_STORE_PATH);
            sslConfig.put("keyStorepass", GlobalResources.CA_GZ_KEY_STORE_PASS);
            sslConfig.put("trustStorePath", GlobalResources.CA_GZ_TRUST_STORE_PATH);
            sslConfig.put("trustStorepass", GlobalResources.CA_GZ_TRUST_STORE_PASS);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "text/xml;charset=gbk");
            Date bTime = new Date();
            CloseableHttpResponse httpResponse = CAHttpUtils.doPost(url, null, null, headers, null, json, sslConfig);
            String body = "";
            System.out.println("\u8fd4\u56de\u54cd\u5e94\u72b6\u6001\u4fe1\u606f:" + httpResponse.getStatusLine());
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                body = EntityUtils.toString((HttpEntity)entity, (String)"GBK");
            }
            EntityUtils.consume((HttpEntity)entity);
            httpResponse.close();
            String ret = StringUtils.replaceEach((String)body, (String[])new String[]{"\n", "\t", "\r"}, (String[])new String[]{"", "", ""});
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id), transType, url, json, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            GZX_PackageMessageChangAn gpm = new GZX_PackageMessageChangAn();
            result = gpm.returnAnalysisXML(ret, transType);
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            ex.printStackTrace();
        }
        this.communicatorLog.info("request_ca_dzfp\uff1aend-----------------------");
        return result;
    }

    private String getPath(String tt) {
        if (TransTypeEnum.HB.getValue().equals(tt)) {
            return GlobalResources.CA_GZ_API_URL;
        }
        if (TransTypeEnum.PD.getValue().equals(tt)) {
            return GlobalResources.CA_GZ_PD_API_URL;
        }
        if (TransTypeEnum.ZFDZ.getValue().equals(tt)) {
            return GlobalResources.CA_GZ_PAY_API_URL;
        }
        if (TransTypeEnum.CBQR.getValue().equals(tt)) {
            return GlobalResources.CA_GZ_API_URL;
        }
        if (TransTypeEnum.BASL.getValue().equals(tt)) {
            return GlobalResources.CA_GZ_BASL_API_URL;
        }
        if (TransTypeEnum.CLSC.getValue().equals(tt)) {
            return GlobalResources.CA_GZ_BASL_API_URL;
        }
        if (TransTypeEnum.AJCX.getValue().equals(tt)) {
            return GlobalResources.CA_GZ_BASL_API_URL;
        }
        if (TransTypeEnum.DZFP.getValue().equals(tt)) {
            return GlobalResources.CA_FP_API_URL;
        }
        if (TransTypeEnum.PDDZFP.getValue().equals(tt)) {
            return GlobalResources.CA_FP_API_URL;
        }
        return "";
    }
}

