/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.LnAccusedAPIDao;
import com.bcxin.ins.entity.policy_special.LnAccused;
import com.bcxin.ins.entity.policy_special.SpecialLitigation;
import com.bcxin.ins.service.order.LnAccusedAPIService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.LnAccusedVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LnAccusedAPIServiceImpl
extends ServiceImpl<LnAccusedAPIDao, LnAccused>
implements LnAccusedAPIService {
    @Autowired
    private LnAccusedAPIDao dao;

    @Override
    public List<LnAccused> selectLnAccusedBySpecialLitigation(Long oid) {
        return this.dao.selectLnAccusedBySpecialLitigation(oid);
    }

    @Override
    public void setLnAccusedByLnAccusedVo(List<LnAccusedVo> voList, Long special_litigation_id) {
        if (voList != null && voList.size() > ConstProp.INT_NUMBER_ZERO) {
            this.ruleOutDoesNotExist(voList, special_litigation_id);
            for (LnAccusedVo vo : voList) {
                this.accordingToTheLnAccusedVoSetUpLnAccused(vo, special_litigation_id);
            }
        }
    }

    private void ruleOutDoesNotExist(List<LnAccusedVo> voList, Long special_litigation_id) {
        List<LnAccused> fdList = this.selectLnAccusedBySpecialLitigation(special_litigation_id);
        for (LnAccused ifd : fdList) {
            int i = ConstProp.INT_NUMBER_ZERO;
            for (LnAccusedVo vo : voList) {
                if (!StrUtil.isNotBlank((CharSequence)vo.getOid()) || ifd.getLn_accused_id() != Long.parseLong(vo.getOid())) continue;
                i = ConstProp.INT_NUMBER_ONE;
            }
            if (i != ConstProp.INT_NUMBER_ZERO) continue;
            this.dao.deleteById(ifd.getLn_accused_id());
        }
    }

    @Override
    public void accordingToTheLnAccusedVoSetUpLnAccused(LnAccusedVo vo, Long special_litigation_id) {
        LnAccused lnAccused = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            lnAccused = this.dao.selectById(Long.parseLong(vo.getOid()));
        } else {
            lnAccused = new LnAccused();
            SpecialLitigation sl = new SpecialLitigation();
            sl.setSpecial_litigation_id(special_litigation_id);
            lnAccused.setSpecial_litigation(sl);
            this.dao.insert(lnAccused);
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)lnAccused);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        lnAccused.setPar_business_path(StringUtils.isNotEmpty((CharSequence)vo.getPar_business_path()) ? vo.getPar_business_path() : "0");
        lnAccused.setPar_address_path(StringUtils.isNotEmpty((CharSequence)vo.getPar_address_path()) ? vo.getPar_address_path() : "0");
        lnAccused.setPar_idcard_path(StringUtils.isNotEmpty((CharSequence)vo.getPar_idcard_path()) ? vo.getPar_idcard_path() : "0");
        lnAccused.setPar_organizing_code(StringUtils.isNotEmpty((CharSequence)vo.getPar_organizing_code()) ? vo.getPar_organizing_code() : "0");
        lnAccused.setPar_spouse_card_path(StringUtils.isNotEmpty((CharSequence)vo.getPar_spouse_card_path()) ? vo.getPar_spouse_card_path() : "0");
        lnAccused.setPar_trauschein_path(StringUtils.isNotEmpty((CharSequence)vo.getPar_trauschein_path()) ? vo.getPar_trauschein_path() : "0");
        this.dao.updateById(lnAccused);
    }

    @Override
    public List<LnAccusedVo> packagingLnAccusedVoListByLnAccusedList(List<LnAccused> fdList) {
        ArrayList<LnAccusedVo> voList = new ArrayList<LnAccusedVo>();
        if (fdList != null) {
            for (LnAccused ifd : fdList) {
                voList.add(this.accordingToLnAccusedIntoLnAccusedVo(ifd));
            }
        }
        return voList;
    }

    @Override
    public LnAccusedVo accordingToLnAccusedIntoLnAccusedVo(LnAccused lnAccused) {
        LnAccusedVo vo = new LnAccusedVo();
        vo.setOid(String.valueOf(lnAccused.getLn_accused_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)lnAccused), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setPar_business_path("0".equals(lnAccused.getPar_business_path()) ? "" : lnAccused.getPar_business_path());
        vo.setPar_address_path("0".equals(lnAccused.getPar_address_path()) ? "" : lnAccused.getPar_address_path());
        vo.setPar_idcard_path("0".equals(lnAccused.getPar_idcard_path()) ? "" : lnAccused.getPar_idcard_path());
        vo.setPar_organizing_code("0".equals(lnAccused.getPar_organizing_code()) ? "" : lnAccused.getPar_organizing_code());
        vo.setPar_spouse_card_path("0".equals(lnAccused.getPar_spouse_card_path()) ? "" : lnAccused.getPar_spouse_card_path());
        vo.setPar_trauschein_path("0".equals(lnAccused.getPar_trauschein_path()) ? "" : lnAccused.getPar_trauschein_path());
        return vo;
    }
}

