/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsMailPolicy;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.entity.policy_special.LnAccused;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.service.order.InsCommonExportAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsMailPolicyAPIService;
import com.bcxin.ins.service.order.InsMicroExportAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.InsUnderwriteAPIService;
import com.bcxin.ins.service.order.InsuranceOperationAPIService;
import com.bcxin.ins.service.order.LnAccusedAPIService;
import com.bcxin.ins.service.order.SpecialBidAPIService;
import com.bcxin.ins.service.order.SpecialExhibitionAPIService;
import com.bcxin.ins.service.order.SpecialLitigationAPIService;
import com.bcxin.ins.service.order.SpecialPerformanceAPIService;
import com.bcxin.ins.service.order.SpecialPublicDutyAPIService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.OrderSupportUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.GYXPolicyVo;
import com.bcxin.ins.vo.InsOrderSearchVo;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.OrderStatusCountVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.ins.vo.SpecialExhibitionVo;
import com.bcxin.ins.vo.SpecialLitigationVo_1;
import com.bcxin.ins.vo.SpecialLitigationVo_2;
import com.bcxin.ins.vo.SpecialLitigationVo_3;
import com.bcxin.ins.vo.SpecialPerformanceVo_1;
import com.bcxin.ins.vo.SpecialPerformanceVo_2;
import com.bcxin.ins.vo.SpecialPerformanceVo_3;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.ins.vo.UnderwriteVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class InsuranceOperationAPIServiceImpl
implements InsuranceOperationAPIService {
    private Logger log = LoggerFactory.getLogger(InsuranceOperationAPIServiceImpl.class);
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private InsMicroExportAPIService insMicroExportService;
    @Autowired
    private InsRoleInpolicyAPIService insRoleInpolicyService;
    @Autowired
    private InsCommonExportAPIService insCommonExportService;
    @Autowired
    private SpecialBidAPIService insSpecialBidService;
    @Autowired
    private SpecialExhibitionAPIService specialExhibitionAPIService;
    @Autowired
    private SpecialPerformanceAPIService insSpecialPerformanceService;
    @Autowired
    private InsProductAPIService insProductService;
    @Autowired
    private InsMailPolicyAPIService insMailPolicyService;
    @Autowired
    private InsTransactionAPIService insTransactionService;
    @Autowired
    private InsUnderwriteAPIService insUnderwriteAPIService;
    @Autowired
    private SpecialLitigationAPIService specialLitigationService;
    @Autowired
    private SpecialPublicDutyAPIService specialPublicDutyService;
    @Autowired
    private ClientUserService clientUserService;
    @Autowired
    private LnAccusedAPIService lnAccusedAPIService;
    @Autowired
    private InsProductResponsibilityAPIService insProductResponsibilityAPIService;

    @Override
    public InsInsuranceSlip initOrderCorrelation(Long poductID, Long user_id, String recommendCode, String trade_serial_number) {
        InsInsuranceSlip insOrderForm = this.insInsuranceSlipService.initOrderForm(poductID, user_id, recommendCode, trade_serial_number);
        return insOrderForm;
    }

    @Override
    public void setMicroExportByMicroExportVo(MicroExportVo vo) {
        try {
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
            }
            insInsuranceSlip.setPremium(BigDecimal.valueOf(Double.parseDouble(vo.getGross_premium())));
            insInsuranceSlip.setInsured_amount(BigDecimal.valueOf(Double.parseDouble(vo.getInsured_amount())));
            if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
                insInsuranceSlip.setInception_date(DateUtil.convertStringToDate((String)(vo.getInception_date() + " 00:00:00")));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
                insInsuranceSlip.setPlanned_end_date(DateUtil.convertStringToDate((String)(vo.getPlanned_end_date() + " 23:59:59")));
            }
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
            vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
            vo.setOrder_status(insInsuranceSlip.getOrder_status());
            this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
            this.insMicroExportService.accordingToTheMicroExportVoSetUpInsMicroExport(vo, insInsuranceSlip.getSpecial_id());
            this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public MicroExportVo getMicroExportVoByOrderID(Long orderID) {
        MicroExportVo vo = new MicroExportVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        if (insInsuranceSlip.getPremium() != null) {
            vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
        }
        if (insInsuranceSlip.getInsured_amount() != null) {
            vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
        }
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        if (insInsuranceSlip.getPlanned_end_date() != null) {
            vo.setPlanned_end_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getPlanned_end_date(), (String)"yyyy-MM-dd"));
        }
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        this.insMicroExportService.getMicroExportVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public void setCommonExportByCommonExportVo_1(CommonExportVo_1 vo) {
        try {
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
                this.insInsuranceSlipService.updateById(insInsuranceSlip);
            }
            this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
            this.insCommonExportService.accordingToTheCommonExportVo_1SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
            if (vo.getRoleSubjectList().size() > 0 && StrUtil.isNotBlank((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export())) {
                this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export())), insInsuranceSlip);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setCommonExportByCommonExportVo_2(CommonExportVo_2 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        this.insCommonExportService.accordingToTheCommonExportVo_2SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
    }

    @Override
    public void setCommonExportByCommonExportVo_3(CommonExportVo_3 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        this.insCommonExportService.accordingToTheCommonExportVo_3SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
    }

    @Override
    public CommonExportVo_1 getCommonExportVo_1ByOrderID(Long orderID) {
        CommonExportVo_1 vo = new CommonExportVo_1();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        this.insCommonExportService.getCommonExportVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public CommonExportVo_2 getCommonExportVo_2ByOrderID(Long orderID) {
        CommonExportVo_2 vo = new CommonExportVo_2();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        this.insCommonExportService.getCommonExportVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public CommonExportVo_3 getCommonExportVo_3ByOrderID(Long orderID) {
        CommonExportVo_3 vo = new CommonExportVo_3();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        this.insCommonExportService.getCommonExportVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, String productType, String keyword, String starDate, String endDate, DwzPage page) {
        InsOrderSearchVo search = InsOrderSearchVo.build((Long)user_id, (String)status, (String)"", (String)keyword, (String)starDate, (String)endDate, (String)"", (DwzPage)page);
        return this.insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(search);
    }

    @Override
    public OrderStatusCountVo selectOrderStatusCountVoByUserID(Long user_id, String pType, String keyword, String starDate, String endDate) {
        InsOrderSearchVo search = InsOrderSearchVo.build((Long)user_id, (String)"", (String)pType, (String)keyword, (String)starDate, (String)endDate, (String)"", null);
        return this.insInsuranceSlipService.selectOrderStatusCountVoByUserID(search);
    }

    @Override
    public List<ProductVo> selectProductVoList(ProPrimary insProduct) {
        return this.insProductService.selectProductVoList(insProduct);
    }

    @Override
    public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID) {
        return this.insProductService.accordingToInsProductIDToGetInsProductInProductVo(insProductID);
    }

    @Override
    public OrderFormVo accordingToOrderIDToGetOrderFormVo(Long order_id) {
        return this.insInsuranceSlipService.findOrderFormVoByID(order_id);
    }

    @Override
    public AdviceNoteVo accordingToOrderIDToGetAdviceNoteVo(Long order_id) {
        InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
        return this.insInsuranceSlipService.willInsOrderFormSetUpAdviceNoteVo(order);
    }

    @Override
    public String updateOrderFormStatus(OrderFormVo vo) {
        return this.insInsuranceSlipService.updateOrderFormStatus(vo);
    }

    @Override
    public void orderSyncZC(String oid) {
        SysClientUser user;
        String sup_order_id;
        InsInsuranceSlip policy = this.insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(oid));
        OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(policy.getIns_insurance_slip_id());
        InsTransaction it = null;
        if (policy.getInsTransaction() != null && !policy.getInsTransaction().isEmpty()) {
            it = (InsTransaction)policy.getInsTransaction().get(0);
        }
        if (StringUtils.isNotEmpty((CharSequence)(sup_order_id = OrderSupportUtil.receiveOrderFormData((String)String.valueOf((user = (SysClientUser)this.clientUserService.selectById(policy.getRegister_user_id())).getBusiness_support_id()), (OrderFormVo)orderVo, (InsInsuranceSlip)policy, (InsTransaction)it, (String)"")))) {
            policy.setOrder_zc_id(Long.valueOf(Long.parseLong(sup_order_id)));
            this.insInsuranceSlipService.updateById(policy);
        }
        if (it != null && !"6".equals(it.getPay_type())) {
            OrderSupportUtil.receiveTrancetionData((InsInsuranceSlip)policy, (InsTransaction)it);
        }
    }

    @Override
    public String uploadPayMentFileToTranction(String path_url, String order_id, String path_sign, String payAmount, String paymentMethod) {
        InsInsuranceSlip order = this.insInsuranceSlipService.selectById(Long.parseLong(order_id));
        if (order == null) {
            return "";
        }
        this.insTransactionService.uploadPayMentFileToTranction(path_url, order, path_sign, payAmount, paymentMethod);
        return String.valueOf(order.getIns_insurance_slip_id());
    }

    @Override
    public String accordingToOrderIDGainPathSign(String order_id) {
        return this.insTransactionService.accordingToOrderIDGainPathSign(order_id);
    }

    @Override
    public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id) {
        this.insInsuranceSlipService.accordingToInsTopBuyersListGainInsRiskDuty(order_id);
    }

    @Override
    public void accordingToOrderIDCreatePolicySerialNumber(Long order_id) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        this.insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
    }

    @Override
    public boolean deleteRoleInPolicyByOid(Long role_id) {
        boolean flag = false;
        try {
            InsRoleInpolicy insRoleInpolicy = (InsRoleInpolicy)this.insRoleInpolicyService.selectById(role_id);
            if (insRoleInpolicy != null) {
                this.insRoleInpolicyService.deleteById(role_id);
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public UnderwriteVo accordingToOrderIDGainInsUnderwrite(Long order_id) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.packagingInsOrderForm(order_id);
        UnderwriteVo underwriteVo = this.insUnderwriteAPIService.accordingToInsUnderwriteIntoUnderwriteVo(insInsuranceSlip.getUnderwrite());
        return underwriteVo;
    }

    @Override
    public OrderFormVo findPolicyByExternalAndRoleName(String externalRefernce, String roleName) {
        return this.insInsuranceSlipService.findPolicyByExternalAndRoleName(externalRefernce, roleName);
    }

    @Override
    public void setSpecialBidBySpecialBidVo(SpecialBidVo vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
            insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date() + " 23:59:59");
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        this.insSpecialBidService.accordingToTheSpecialBidVoSetUpInsSpecialBid(vo, insInsuranceSlip.getSpecial_id());
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        if (StrUtil.isNotBlank((CharSequence)vo.getInsured_amount())) {
            this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(vo.getInsured_amount())), insInsuranceSlip);
        }
    }

    @Override
    public SpecialBidVo getSpecialBidVoByOrderID(Long orderID) {
        SpecialBidVo vo = new SpecialBidVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        this.insSpecialBidService.getSpecialBidVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        if (StringUtils.isNotEmpty((CharSequence)vo.getBid_time())) {
            vo.setBid_time(vo.getBid_time().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date().replace(" 23:59:59", ""));
        }
        return vo;
    }

    @Override
    public void setSpecialPerformanceBySpecialPerformanceVo_1(SpecialPerformanceVo_1 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
            insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_1SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
    }

    @Override
    public void setSpecialPerformanceBySpecialPerformanceVo_2(SpecialPerformanceVo_2 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date() + " 23:59:59");
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        this.insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_2SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
        if (vo.getRoleSubjectList().size() > 0 && StrUtil.isNotBlank((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export())) {
            this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export())), insInsuranceSlip);
        }
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
    }

    @Override
    public void setSpecialPerformanceBySpecialPerformanceVo_3(SpecialPerformanceVo_3 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        this.insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_3SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
    }

    @Override
    public SpecialPerformanceVo_1 getSpecialPerformanceVo_1ByOrderID(Long orderID) {
        SpecialPerformanceVo_1 vo = new SpecialPerformanceVo_1();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        this.insSpecialPerformanceService.getSpecialPerformanceVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public SpecialPerformanceVo_2 getSpecialPerformanceVo_2ByOrderID(Long orderID) {
        SpecialPerformanceVo_2 vo = new SpecialPerformanceVo_2();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insSpecialPerformanceService.getSpecialPerformanceVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date().replace(" 23:59:59", ""));
        }
        return vo;
    }

    @Override
    public SpecialPerformanceVo_3 getSpecialPerformanceVo_3ByOrderID(Long orderID) {
        SpecialPerformanceVo_3 vo = new SpecialPerformanceVo_3();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        this.insSpecialPerformanceService.getSpecialPerformanceVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public void setSpecialLitigationBySpecialLitigationVo_1(SpecialLitigationVo_1 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        this.specialLitigationService.accordingToTheSpecialLitigationVo_1SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
        if (vo.getRoleSubjectList().size() > 0 && StrUtil.isNotBlank((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export())) {
            this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export())), insInsuranceSlip);
        }
    }

    @Override
    public void setSpecialLitigationBySpecialLitigationVo_2(SpecialLitigationVo_2 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date() + " 23:59:59");
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.specialLitigationService.accordingToTheSpecialLitigationVo_2SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
    }

    @Override
    public void setSpecialLitigationBySpecialLitigationVo_3(SpecialLitigationVo_3 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        this.specialLitigationService.accordingToTheSpecialLitigationVo_3SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
    }

    @Override
    public SpecialLitigationVo_1 getSpecialLitigationVo_1ByOrderID(Long orderID) {
        SpecialLitigationVo_1 vo = new SpecialLitigationVo_1();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        this.specialLitigationService.getSpecialLitigationVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public SpecialLitigationVo_2 getSpecialLitigationVo_2ByOrderID(Long orderID) {
        SpecialLitigationVo_2 vo = new SpecialLitigationVo_2();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.specialLitigationService.getSpecialLitigationVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        MailPolicyVo voMP = new MailPolicyVo();
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date().replace(" 23:59:59", ""));
        }
        return vo;
    }

    @Override
    public SpecialLitigationVo_3 getSpecialLitigationVo_3ByOrderID(Long orderID) {
        SpecialLitigationVo_3 vo = new SpecialLitigationVo_3();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        this.specialLitigationService.getSpecialLitigationVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public boolean deleteLnAccusedByOid(Long lna_id) {
        boolean flag = false;
        try {
            LnAccused lnAccused = (LnAccused)this.lnAccusedAPIService.selectById(lna_id);
            if (lnAccused != null) {
                this.lnAccusedAPIService.deleteById(lna_id);
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public void setGMRPolicyByGMRPolicyVo(GMRPolicyVo vo) {
        try {
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u6570\u636e\u5904\u7406\u5f00\u59cb---------------------");
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
                insInsuranceSlip.setInception_date(DateUtil.convertString2Date((String)(vo.getInception_date() + " 00:00:00")));
            }
            insInsuranceSlip.setAccredit_path(vo.getAccredit_path());
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
            vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u8fc7\u6ee4\u5f00\u59cb---------------------");
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u521d\u59cb\u6570\u636e,vo.getRoleSubjectList():" + vo.getRoleSubjectList().size());
            ArrayList voList = Lists.newArrayList();
            for (RoleSubjectVo rvo : vo.getRoleSubjectList()) {
                if ("1".equals(rvo.getKind())) {
                    voList.add(rvo);
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)rvo.getOrganization_code()) && !StringUtils.isNotEmpty((CharSequence)rvo.getName_cn()) && !StringUtils.isNotEmpty((CharSequence)rvo.getMobile()) && !StringUtils.isNotEmpty((CharSequence)rvo.getBirth_date())) continue;
                voList.add(rvo);
            }
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u8fc7\u6ee4\u540e\u6570\u636e,voList:" + voList);
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u8fc7\u6ee4\u7ed3\u675f---------------------");
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u66f4\u65b0\u6570\u636e\u5e93\u5f00\u59cb---------------------");
            this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(voList, insInsuranceSlip.getIns_insurance_slip_id());
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u66f4\u65b0\u6570\u636e\u5e93\u7ed3\u675f---------------------");
            this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
            this.insInsuranceSlipService.setPremiumAndCoverageByOrderID(insInsuranceSlip);
        }
        catch (Exception e) {
            this.log.error("\u56e2\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public GMRPolicyVo getGMRPolicyVoByOrderID(Long orderID) {
        GMRPolicyVo vo = new GMRPolicyVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        vo.setAccredit_path(insInsuranceSlip.getAccredit_path());
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        List<RoleSubjectVo> list = this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id());
        if (list.size() < 4) {
            int v = 4 - list.size();
            RoleSubjectVo rvo = new RoleSubjectVo();
            rvo.setKind("2");
            rvo.setMajor_group("1");
            for (int i = 0; i < v; ++i) {
                list.add(rvo);
            }
        }
        vo.setRoleSubjectList(list);
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public void setSpecialPublicDutyBySpecialPublicDutyVo(SpecialPublicDutyVo vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date()) && !vo.getInception_date().contains(" 00:00:00")) {
            vo.setInception_date(vo.getInception_date() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date()) && !vo.getPlanned_end_date().contains(" 23:59:59")) {
            vo.setPlanned_end_date(vo.getPlanned_end_date() + " 23:59:59");
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        this.specialPublicDutyService.accordingToTheSpecialPublicDutyVoSetUpSpecialPublicDuty(vo, insInsuranceSlip.getSpecial_id());
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
    }

    @Override
    public SpecialPublicDutyVo getSpecialPublicDutyVoByOrderID(Long orderID) {
        SpecialPublicDutyVo vo = new SpecialPublicDutyVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        this.specialPublicDutyService.getSpecialPublicDutyVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public void setLOTEPolicyByLOTEPolicyVo(LOTEPolicyVo vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
            insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
            if (insInsuranceSlip.getInsured_amount() == null || insInsuranceSlip.getInsured_amount().compareTo(BigDecimal.ONE) < 0) {
                insInsuranceSlip.setInsured_amount(this.setInsuredAmountByProductId(insInsuranceSlip.getPro_primary().getPro_primary_id()));
            }
            if (vo.getSpecialExhibitionVo() != null) {
                if (StringUtils.isNotEmpty((CharSequence)vo.getSpecialExhibitionVo().getStar_time())) {
                    insInsuranceSlip.setInception_date(DateUtil.convertString2Date((String)(vo.getSpecialExhibitionVo().getStar_time() + " 00:00:00")));
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getSpecialExhibitionVo().getEnd_time())) {
                    insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date((String)(vo.getSpecialExhibitionVo().getEnd_time() + " 23:59:59")));
                }
            }
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        if (insInsuranceSlip.getSpecial_id() != null) {
            if ("0".equals(vo.getSpecialExhibitionVo().getContains())) {
                vo.getSpecialExhibitionVo().setBuild_com_name(" ");
                vo.getSpecialExhibitionVo().setSubcontracting_units(" ");
            }
            this.specialExhibitionAPIService.accordingToTheSpecialExhibitionVoSetUpSpecialExhibition(vo.getSpecialExhibitionVo(), insInsuranceSlip.getSpecial_id());
        }
        if (insInsuranceSlip.getMailPolicy() != null) {
            this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        }
    }

    @Override
    public BigDecimal setInsuredAmountByProductId(Long pId) {
        BigDecimal result = BigDecimal.ZERO;
        List<ResponsibilityVo> irpVoList = this.insProductResponsibilityAPIService.findResponsibilityVoList(String.valueOf(pId));
        if (irpVoList.size() <= 0) {
            return result;
        }
        for (ResponsibilityVo vo : irpVoList) {
            if ("1".equals(vo.getType())) {
                if (StringUtils.isEmpty((CharSequence)vo.getFcy())) continue;
                if (StringUtils.isNotEmpty((CharSequence)vo.getCompensation_days())) {
                    result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())).multiply(BigDecimal.valueOf(Double.parseDouble("180"))));
                    continue;
                }
                result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())));
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo.getInsurance_amount_max())) continue;
            result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getInsurance_amount_max())));
        }
        return result;
    }

    @Override
    public LOTEPolicyVo getLOTEPolicyVoByOrderID(Long orderID) {
        LOTEPolicyVo vo = new LOTEPolicyVo();
        MailPolicyVo voMP = new MailPolicyVo();
        SpecialExhibitionVo seVo = new SpecialExhibitionVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        if (insInsuranceSlip.getSpecial_id() != null) {
            this.specialExhibitionAPIService.getSpecialExhibitionVoByPolicyID(seVo, insInsuranceSlip.getSpecial_id());
        }
        vo.setSpecialExhibitionVo(seVo);
        if (insInsuranceSlip.getMailPolicy() != null) {
            InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
            this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        }
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public void setGYXPolicyByGYXPolicyVo(GYXPolicyVo vo) {
        try {
            this.log.info("\u4e2a\u610f\u9669\u8ba2\u5355\u6570\u636e\u5904\u7406\u5f00\u59cb---------------------");
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
                insInsuranceSlip.setInception_date(DateUtil.convertString2Date((String)(vo.getInception_date() + " 00:00:00")));
                insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date((String)(vo.getPlanned_end_date() + " 23:59:59")));
            }
            vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
            this.log.info("\u4e2a\u610f\u9669\u8ba2\u5355\u4eba\u5458\u8fc7\u6ee4\u5f00\u59cb---------------------");
            this.log.info("\u4e2a\u610f\u9669\u8ba2\u5355\u4eba\u5458\u521d\u59cb\u6570\u636e,vo.getRoleSubjectList():" + vo.getRoleSubjectList().size());
            ArrayList voList = Lists.newArrayList();
            for (RoleSubjectVo rvo : vo.getRoleSubjectList()) {
                if ("1".equals(rvo.getKind())) {
                    voList.add(rvo);
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)rvo.getOrganization_code()) && !StringUtils.isNotEmpty((CharSequence)rvo.getName_cn()) && !StringUtils.isNotEmpty((CharSequence)rvo.getMobile()) && !StringUtils.isNotEmpty((CharSequence)rvo.getBirth_date())) continue;
                voList.add(rvo);
            }
            int perNum = voList.size() - 1;
            insInsuranceSlip.setInsured_amount(this.setInsuredAmountByProductId(insInsuranceSlip.getPro_primary().getPro_primary_id()).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(perNum)))));
            int days = DateUtil.getDistDates((Date)insInsuranceSlip.getInception_date(), (Date)insInsuranceSlip.getPlanned_end_date());
            if (days > 0 || days == 0) {
                insInsuranceSlip.setPremium(this.getPremiumByGYX(days).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(perNum)))));
            }
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
            this.log.info("\u4e2a\u610f\u9669\u8ba2\u5355\u4eba\u5458\u8fc7\u6ee4\u540e\u6570\u636e,voList:" + voList);
            this.log.info("\u4e2a\u610f\u9669\u8ba2\u5355\u4eba\u5458\u8fc7\u6ee4\u7ed3\u675f---------------------");
            this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(voList, insInsuranceSlip.getIns_insurance_slip_id());
            this.log.info("\u4e2a\u610f\u9669\u8ba2\u5355\u4eba\u5458\u66f4\u65b0\u6570\u636e\u5e93\u7ed3\u675f---------------------");
        }
        catch (Exception e) {
            this.log.error("\u4e2a\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    private BigDecimal getPremiumByGYX(int day) {
        BigDecimal allPr = BigDecimal.ZERO;
        if (day < 2) {
            allPr = BigDecimal.valueOf(Double.parseDouble("10"));
        } else if (day > 1 && day < 8) {
            allPr = BigDecimal.valueOf(Double.parseDouble("20"));
        } else if (day > 7 && day < 16) {
            allPr = BigDecimal.valueOf(Double.parseDouble("30"));
        } else if (day > 15 && day < 31) {
            allPr = BigDecimal.valueOf(Double.parseDouble("50"));
        }
        return allPr;
    }

    @Override
    public GYXPolicyVo getGYXPolicyVoByOrderID(Long orderID) {
        GYXPolicyVo vo = new GYXPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
            vo.setPlanned_end_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getPlanned_end_date(), (String)"yyyy-MM-dd"));
        }
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        return vo;
    }
}

