/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsCommonExportAPIDao;
import com.bcxin.ins.entity.policy_special.SpecialCreditSt;
import com.bcxin.ins.entity.policy_special.StArDebtors;
import com.bcxin.ins.entity.policy_special.StBadDebt;
import com.bcxin.ins.entity.policy_special.StCreditManagement;
import com.bcxin.ins.entity.policy_special.StServiceDescription;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.entity.policy_special.StTurnover;
import com.bcxin.ins.service.order.InsArDebtorsAPIService;
import com.bcxin.ins.service.order.InsBadAnalysisAPIService;
import com.bcxin.ins.service.order.InsBadDebtAPIService;
import com.bcxin.ins.service.order.InsCommonExportAPIService;
import com.bcxin.ins.service.order.InsCreditManagementAPIService;
import com.bcxin.ins.service.order.InsDebtAgesAPIService;
import com.bcxin.ins.service.order.InsForecastedDetailAPIService;
import com.bcxin.ins.service.order.InsManagerDetailAPIService;
import com.bcxin.ins.service.order.InsOverdueDetailAPIService;
import com.bcxin.ins.service.order.InsPastBadDetailAPIService;
import com.bcxin.ins.service.order.InsRecentYearsSellAPIService;
import com.bcxin.ins.service.order.InsServiceDescriptionAPIService;
import com.bcxin.ins.service.order.InsTopBuyersAPIService;
import com.bcxin.ins.service.order.InsTurnoverAPIService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsCommonExportAPIServiceImpl
extends ServiceImpl<InsCommonExportAPIDao, SpecialCreditSt>
implements InsCommonExportAPIService {
    private static final Log logger = LogFactory.getLog(InsCommonExportAPIServiceImpl.class);
    @Autowired
    private InsCommonExportAPIDao dao;
    @Autowired
    private InsServiceDescriptionAPIService insServiceDescriptionService;
    @Autowired
    private InsTurnoverAPIService insTurnoverService;
    @Autowired
    private InsBadDebtAPIService insBadDebtService;
    @Autowired
    private InsTopBuyersAPIService insTopBuyersService;
    @Autowired
    private InsArDebtorsAPIService insArDebtorsService;
    @Autowired
    private InsCreditManagementAPIService insCreditManagementService;
    @Autowired
    private InsForecastedDetailAPIService insForecastedDetailService;
    @Autowired
    private InsRecentYearsSellAPIService insRecentYearsSellService;
    @Autowired
    private InsPastBadDetailAPIService insPastBadDetailService;
    @Autowired
    private InsBadAnalysisAPIService insBadAnalysisService;
    @Autowired
    private InsOverdueDetailAPIService insOverdueDetailService;
    @Autowired
    private InsDebtAgesAPIService insDebtAgesService;
    @Autowired
    private InsManagerDetailAPIService insManagerDetailService;

    @Override
    public SpecialCreditSt getInsCommonExportBusiness(Long oid) {
        SpecialCreditSt insCommonExport = this.dao.selectById(oid);
        try {
            if (insCommonExport != null) {
                this.setServiceDescription(insCommonExport);
                this.setInsTurnover(insCommonExport);
                this.setInsBadDebt(insCommonExport);
                this.setInsCreditManagement(insCommonExport);
                this.setTopBuyers(insCommonExport);
                this.setInsArDebtors(insCommonExport);
            }
        }
        catch (Exception ex) {
            logger.error("\u4f01\u4e1a\u77ed\u671f\u51fa\u53e3\u7279\u6b8a\u5b57\u6bb5\u8868\u4fe1\u606f", (Throwable)ex);
            ex.printStackTrace();
        }
        return insCommonExport;
    }

    @Override
    public SpecialCreditSt initInsCommonExport() {
        SpecialCreditSt insCommonExport = new SpecialCreditSt();
        try {
            insCommonExport.setService_description(this.insServiceDescriptionService.initInsServiceDescription());
            insCommonExport.setTurnover(this.insTurnoverService.initInsTurnover());
            insCommonExport.setBad_debt(this.insBadDebtService.initInsBadDebt());
            insCommonExport.setCredit_management(this.insCreditManagementService.initInsCreditManagement());
            this.dao.insert(insCommonExport);
        }
        catch (Exception ex) {
            logger.error("\u521d\u59cb\u5316\u4f01\u4e1a\u77ed\u671f\u51fa\u53e3\u7279\u6b8a\u5b57\u6bb5\u8868\u4fe1\u606f", (Throwable)ex);
        }
        return insCommonExport;
    }

    private void setServiceDescription(SpecialCreditSt insCommonExport) {
        StServiceDescription result = insCommonExport.getService_description();
        if (result != null) {
            insCommonExport.setService_description((StServiceDescription)this.insServiceDescriptionService.selectById(result.getSt_service_description_id()));
        }
    }

    private void setInsTurnover(SpecialCreditSt insCommonExport) {
        StTurnover result = insCommonExport.getTurnover();
        if (result != null) {
            insCommonExport.setTurnover(this.insTurnoverService.packagingInsTurnover(result.getSt_turnover_id()));
        }
    }

    private void setInsBadDebt(SpecialCreditSt insCommonExport) {
        StBadDebt result = insCommonExport.getBad_debt();
        if (result != null) {
            insCommonExport.setBad_debt(this.insBadDebtService.packagingInsBadDebt(result.getSt_bad_debt_id()));
        }
    }

    private void setInsCreditManagement(SpecialCreditSt insCommonExport) {
        StCreditManagement result = insCommonExport.getCredit_management();
        if (result != null) {
            insCommonExport.setCredit_management(this.insCreditManagementService.packagingInsCreditManagement(result.getSt_credit_management_id()));
        }
    }

    private void setTopBuyers(SpecialCreditSt insCommonExport) {
        try {
            List<StTopBuyers> insTopBuyersList = this.insTopBuyersService.selectInsTopBuyersBySpecialID(insCommonExport.getSpecial_credit_st_id());
            if (insTopBuyersList.size() > ConstProp.INT_NUMBER_ZERO) {
                insCommonExport.setTopBuyers(insTopBuyersList);
            }
        }
        catch (Exception ex) {
            logger.error("\u524d\u5341\u5927\u4e70\u5bb6\u96c6\u5408", (Throwable)ex);
        }
    }

    private void setInsArDebtors(SpecialCreditSt insCommonExport) {
        List<StArDebtors> insArDebtorsList = this.insArDebtorsService.selectInsArDebtorsByInsCommonExport(insCommonExport.getSpecial_credit_st_id());
        if (insArDebtorsList.size() > ConstProp.INT_NUMBER_ZERO) {
            insCommonExport.setInsArDebtors(insArDebtorsList);
        }
    }

    @Override
    public void getCommonExportVo_1BySpecial_id(CommonExportVo_1 vo, Long ceID) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(ceID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insCommonExport), (Object)vo);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6CommonExportVo_1\u6839\u636e\u4f01\u4e1a\u77ed\u671f\u51fa\u53e3id\u67e5\u8be2\u4f01\u4e1a\u77ed\u671f\u4fe1\u606f\u63d2\u5165\u5230CommonExportVo_1", (Throwable)e);
        }
        this.insServiceDescriptionService.accordingToInsServiceDescriptionIntoCommonExportVo_1(vo, insCommonExport.getService_description());
        StTurnover turnover = insCommonExport.getTurnover();
        this.insTurnoverService.accordingToInsTurnoverIntoCommonExportVo_1(vo, turnover);
        vo.setForecastedDetailList(this.insForecastedDetailService.packagingForecastedDetailVoListByInsForecastedDetailList(turnover.getForecastedDetailList()));
        vo.setRecentYearsSellList(this.insRecentYearsSellService.packagingRecentYearsSellVoListByInsRecentYearsSellList(turnover.getRecentYearsSellList()));
    }

    @Override
    public void getCommonExportVo_2BySpecial_id(CommonExportVo_2 vo, Long ceID) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(ceID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insCommonExport), (Object)vo);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6CommonExportVo_2\u6839\u636e\u4f01\u4e1a\u77ed\u671f\u51fa\u53e3id\u67e5\u8be2\u4f01\u4e1a\u77ed\u671f\u4fe1\u606f\u63d2\u5165\u5230CommonExportVo_2", (Throwable)e);
        }
        vo.setDebtAgesList(this.insDebtAgesService.getDebtAgesVoListByInsDebtAgesList(insCommonExport.getBad_debt().getInsDebtAges()));
        vo.setOverdueDetailList(this.insOverdueDetailService.getOverdueDetailVoListByInsOverdueDetailList(insCommonExport.getBad_debt().getInsOverdueDetail()));
        vo.setBadAnalysisList(this.insBadAnalysisService.getBadAnalysisVoListByInsBadAnalysisList(insCommonExport.getBad_debt().getInsBadAnalysis()));
        this.insBadDebtService.accordingToInsBadDebtIntoBadDebtVo(vo, insCommonExport.getBad_debt());
        vo.setPastBadDetailList(this.insPastBadDetailService.getPastBadDetailVoListByInsPastBadDetailList(insCommonExport.getBad_debt().getInsPastBadDetail()));
        vo.setTopBuyersList(this.insTopBuyersService.getTopBuyersVoListBySpecialID(insCommonExport.getSpecial_credit_st_id()));
        vo.setArDebtorsList(this.insArDebtorsService.getArDebtorsVoListByCommon_export_id(insCommonExport.getSpecial_credit_st_id()));
    }

    @Override
    public void getCommonExportVo_3BySpecial_id(CommonExportVo_3 vo, Long ceID) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(ceID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insCommonExport), (Object)vo);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6CommonExportVo_3\u6839\u636e\u4f01\u4e1a\u77ed\u671f\u51fa\u53e3id\u67e5\u8be2\u4f01\u4e1a\u77ed\u671f\u4fe1\u606f\u63d2\u5165\u5230CommonExportVo_3", (Throwable)e);
        }
        this.insCreditManagementService.accordingToInsCreditManagementIntoCommonExportVo_3(vo, insCommonExport.getCredit_management());
        vo.setManagerDetailList(this.insManagerDetailService.getManagerDetailVoListByInsManagerDetailList(insCommonExport.getCredit_management().getInsManagerDetail()));
    }

    @Override
    public void accordingToTheCommonExportVo_1SetUpInsCommonExport(CommonExportVo_1 vo, Long special_id) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(special_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insCommonExport);
            this.insServiceDescriptionService.accordingToTheCommonExportVo_1SetUpInsServiceDescription(vo, insCommonExport.getService_description().getSt_service_description_id());
            this.insTurnoverService.accordingToTheCommonExportVo_1SetUpInsTurnover(vo, insCommonExport.getTurnover().getSt_turnover_id());
            this.insForecastedDetailService.setForecastedDetailByForecastedDetailVo(vo.getForecastedDetailList(), insCommonExport.getTurnover().getSt_turnover_id());
            this.insRecentYearsSellService.setRecentYearsSellByRecentYearsSellVo(vo.getRecentYearsSellList(), insCommonExport.getTurnover().getSt_turnover_id());
            this.dao.updateById(insCommonExport);
        }
        catch (Exception e) {
            logger.error("\u4f01\u4e1a\u77ed\u671f\u51fa\u53e3id", (Throwable)e);
        }
    }

    @Override
    public void accordingToTheCommonExportVo_2SetUpInsCommonExport(CommonExportVo_2 vo, Long special_id) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(special_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insCommonExport);
        }
        catch (Exception e) {
            logger.error("\u4f01\u4e1a\u77ed\u671f\u51fa\u53e3id", (Throwable)e);
        }
        this.insDebtAgesService.setDebtAgesByDebtAgesVo(vo.getDebtAgesList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
        if (vo.getIs_overdue_buyers() != 0) {
            this.insOverdueDetailService.setOverdueDetailByOverdueDetailVo(vo.getOverdueDetailList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
        }
        this.insBadAnalysisService.setBadAnalysisByBadAnalysisVo(vo.getBadAnalysisList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
        this.insBadDebtService.accordingToTheCommonExportVo_2SetUpInsBadDebt(vo, insCommonExport.getBad_debt().getSt_bad_debt_id());
        this.insPastBadDetailService.setPastBadDetailByPastBadDetailVo(vo.getPastBadDetailList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
        this.insTopBuyersService.setTopBuyersByTopBuyersVo(vo.getTopBuyersList(), insCommonExport.getSpecial_credit_st_id());
        this.insArDebtorsService.setArDebtorsByArDebtorsVo(vo.getArDebtorsList(), insCommonExport.getSpecial_credit_st_id());
        this.dao.updateById(insCommonExport);
    }

    @Override
    public void accordingToTheCommonExportVo_3SetUpInsCommonExport(CommonExportVo_3 vo, Long special_id) {
        SpecialCreditSt insCommonExport = this.getInsCommonExportBusiness(special_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insCommonExport);
        }
        catch (Exception e) {
            logger.error("\u6839\u636eVo\u53ca\u4f01\u4e1a\u77ed\u671f\u51fa\u53e3ID\u66f4\u65b0CommonExportVo_3\u6570\u636e", (Throwable)e);
        }
        this.insCreditManagementService.accordingToTheCommonExportVo_3SetUpInsCreditManagement(vo, insCommonExport.getCredit_management().getSt_credit_management_id());
        this.insManagerDetailService.setManagerDetailByManagerDetailVo(vo.getManagerDetailList(), insCommonExport.getCredit_management().getSt_credit_management_id());
        this.dao.updateById(insCommonExport);
    }
}

