/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsAgreementAPIDao;
import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.service.order.InsAgreementAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.InsurePolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsAgreementAPIServiceImpl
extends ServiceImpl<InsAgreementAPIDao, InsAgreement>
implements InsAgreementAPIService {
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private InsProductResponsibilityAPIService insProductResponsibilityAPIService;
    @Autowired
    private InsAgreementAPIDao dao;

    @Override
    public InsAgreement initAgreement() {
        InsAgreement insAgreement = new InsAgreement();
        this.dao.insert(insAgreement);
        return insAgreement;
    }

    @Override
    public InsAgreement selectById(Long oid) {
        return this.dao.selectById(oid);
    }

    @Override
    public InsAgreement selectInsAgreementByInsInsuranceSlip(Long insurance_slip_id) {
        return this.dao.selectInsAgreementByInsInsuranceSlip(insurance_slip_id);
    }

    @Override
    public void willInsurePolicyVoChangeIntoInsAgreement(Long insurance_slip_id, String externalReference) {
        InsAgreement insAgreement = this.selectInsAgreementByInsInsuranceSlip(insurance_slip_id);
        if (insAgreement == null) {
            insAgreement = this.initAgreement();
        }
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(insurance_slip_id);
        InsurePolicyVo vo = this.insInsuranceSlipService.willInsInsuranceSlipChangeIntoInsurePolicyVo(insurance_slip_id);
        String responsibility_ids = this.insProductResponsibilityAPIService.findResponsibilityIdsByProductID(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()), insInsuranceSlip.getIs_contain_repo());
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insAgreement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        insAgreement.setResponsibility_ids(responsibility_ids);
        insAgreement.setExternal_reference(externalReference);
        insAgreement.setPro_primary(insInsuranceSlip.getPro_primary());
        insAgreement.setIns_insurance_slip(insInsuranceSlip);
        this.dao.updateById(insAgreement);
    }

    @Override
    public void updateResponsibilityIds(String productCode, String orderId) {
        List<Object> forms = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)orderId)) {
            OrderFormVo orderFormVo = this.insInsuranceSlipService.findOrderFormVoByID(Long.parseLong(orderId));
            forms.add(orderFormVo);
        } else {
            if (StringUtils.isEmpty((CharSequence)productCode)) {
                throw new RuntimeException("productCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            forms = this.insInsuranceSlipService.selectInsOrderFormByStatusAndProductCode("6", productCode);
        }
        for (OrderFormVo orderFormVo : forms) {
            InsAgreement insAgreement = this.selectInsAgreementByInsInsuranceSlip(Long.parseLong(orderFormVo.getOid()));
            if (insAgreement == null) continue;
            insAgreement.setResponsibility_ids(this.insProductResponsibilityAPIService.findResponsibilityIdsByProductID(orderFormVo.getProduct_oid(), orderFormVo.getIs_contain_repo()));
            this.dao.updateById(insAgreement);
        }
    }
}

