/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2016 abel533@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package tk.mybatis.springboot.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.rabbitmq.client.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.springboot.model.HuaWeiSmsContent;
import tk.mybatis.springboot.model.SmsContent;
import tk.mybatis.springboot.model.SmsRecord;
import tk.mybatis.springboot.service.HuaWeiSMSSendService;
import tk.mybatis.springboot.service.SmsRecordService;
import tk.mybatis.springboot.util.GetRequestJsonUtils;
import tk.mybatis.springboot.util.MD5Gen;
import tk.mybatis.springboot.util.MD5Util;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/**
 * @author liuzh
 * @since 2015-12-19 11:10
 */
@RestController
@RequestMapping("/sms")
@Transactional
public class SMSController {

    private final static String QUEUE_NAME = "sms-send";

    /**
     * 有效手机号长度
     */
    private final static int VALIDATE_PHONE_LENGTH = 11;

    private static Pattern NUMBER_PATTERN = Pattern.compile("^[-\\+]?[\\d]*$");

    @Autowired
    private HuaWeiSMSSendService huaWeiSMSSendService;

    @Autowired
    private SmsRecordService smsRecordService;


    @RequestMapping
    public ModelMap AllMessage1(){
        ModelMap result = new ModelMap();
        result.put("status", "300");
        result.put("msg", "调用成功");
        return result;
    }

    /**
     * 暂未使用
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/sendMessagemq")
    public ModelMap AllMessage() throws Exception{

        // 创建连接工厂
        ConnectionFactory factory = new ConnectionFactory();
        //设置RabbitMQ地址
        factory.setHost("localhost");
        factory.setUsername("guest");
        factory.setPassword("guest");
        factory.setPort(5672);
        //创建一个新的连接
        Connection connection = factory.newConnection();
        //创建一个通道
        Channel channel = connection.createChannel();
        //声明要关注的队列
        channel.queueDeclare(QUEUE_NAME, false, false, true, null);

        System.out.println("获取到消息通知的队列");

        //DefaultConsumer类实现了Consumer接口，通过传入一个频道，
        // 告诉服务器我们需要那个频道的消息，如果频道中有消息，就会执行回调函数handleDelivery
        Consumer consumer = new DefaultConsumer(channel) {
            @Override
            public void handleDelivery(String consumerTag, Envelope envelope,
                                       AMQP.BasicProperties properties, byte[] body)
                    throws IOException {
                String message = new String(body, "UTF-8");
                System.out.println("Customer Received '" + message + "'");
            }
        };
        //自动回复队列应答 -- RabbitMQ中的消息确认机制
        channel.basicConsume(QUEUE_NAME, true, consumer);



        ModelMap result = new ModelMap();
        result.put("status", "200");
        result.put("msg", "调用成功");
        return result;
    }

    @RequestMapping(value = "/sendMessage")
    public ModelMap sendMessage(HttpServletRequest request, SmsContent smsContent) {
        ModelMap result = new ModelMap();
        try {
            Gson g = new Gson();
            smsContent = g.fromJson(GetRequestJsonUtils.getRequestJsonString(request), SmsContent.class);
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        if (StringUtils.isEmpty(smsContent.getType())) {
            result.put("status", "300");
            result.put("msg", "网站来源信息不能为空");
            return result;
        }
        if (StringUtils.isEmpty(smsContent.getContent())) {
            result.put("status", "300");
            result.put("msg", "内容不能为空");
            return result;

        }
        if (StringUtils.isEmpty(smsContent.getMobile())) {
            result.put("status", "300");
            result.put("msg", "手机号码不能为空");
            return result;
        }
        if (StringUtils.isEmpty(smsContent.getToken())) {
            result.put("status", "300");
            result.put("msg", "秘钥不能为空");
            return result;
        }

        //token码  md532（requestId+type+key）   key:bcxinABCXIN$1012  md5 32 位  小写
        String token = "";
        try {
            token = MD5Gen.getMD5(smsContent.getRequestId() + smsContent.getType() + "bcxinABCXIN$1012");
        } catch (Exception e) {
            result.put("status", "300");
            result.put("msg", "时间参数和 来源类型不能为空");
            return result;
        }

        if (token.equals(smsContent.getToken())) {
            result.put("status", "300");
            result.put("msg", "秘钥错误");
            return result;
        }

        SmsRecord smsRecord = new SmsRecord();
        smsRecord.setContent(smsContent.getContent());
        smsRecord.setMobile(smsContent.getMobile());
        smsRecordService.save(smsRecord);

        smsRecordService.sendSMS(smsRecord);
        result.put("status", "200");
        result.put("msg", "调用成功");
        return result;
    }


    @RequestMapping(value = "/huawei/sendSMS")
    public ModelMap sendHuaWeiSms(HttpServletRequest request){
        ModelMap result = new ModelMap();
        try{
        String token = "";
        HuaWeiSmsContent smsContent = JSON.parseObject(request.getParameter("data"), HuaWeiSmsContent.class);
        if (StringUtils.isEmpty(smsContent.getPlatform())) {
            result.put("status", "300");
            result.put("msg", "网站来源信息不能为空");
            System.out.println("============>sendHuaWeiSms == 网站来源信息不能为空 ,data:"+request.getParameter("data"));
            return result;
        }
        if (StringUtils.isEmpty(smsContent.getSmsCode())) {
            result.put("status", "300");
            result.put("msg", "短信编号不能为空");
            System.out.println("============>sendHuaWeiSms == 短信编号不能为空 ,data:"+request.getParameter("data"));
            return result;
        }
        if (StringUtils.isEmpty(smsContent.getMobile())) {
            result.put("status", "300");
            result.put("msg", "手机号码不能为空");
            System.out.println("============>sendHuaWeiSms == 手机号码不能为空 ,data:"+request.getParameter("data"));
            return result;
        }
        if (StringUtils.isEmpty(request.getParameter("token"))) {
            result.put("status", "300");
            result.put("msg", "秘钥不能为空");
            System.out.println("============>sendHuaWeiSms == 秘钥不能为空 ,data:"+request.getParameter("data"));
            return result;
        }
        if (smsContent.getMobile().length() != VALIDATE_PHONE_LENGTH) {
            result.put("status", "300");
            result.put("msg", "手机号不正确");
            System.out.println("============>sendHuaWeiSms == 手机号不正确1 ,data:"+request.getParameter("data"));
            return result;
        }
        if (!isInteger(smsContent.getMobile())) {
            result.put("status", "300");
            result.put("msg", "手机号不正确");
            System.out.println("============>sendHuaWeiSms == 手机号不正确2 ,data:"+request.getParameter("data"));
            return result;
        }
        String randomKey = request.getParameter("randomKey");
        if (StrUtil.isNotEmpty(randomKey)) {
            token = MD5Util.string2MD5("BCXIN" + smsContent.getMobile() + DateUtil.today() + randomKey);
        } else {
            token = MD5Util.string2MD5("BCXIN" + smsContent.getMobile() + DateUtil.today());
        }
        if (token.equals(smsContent.getToken())) {
            result.put("status", "300");
            result.put("msg", "秘钥错误");
            System.out.println("============>sendHuaWeiSms == 秘钥错误 ,data:"+request.getParameter("data"));
            System.out.println("============>sendHuaWeiSms == Mobile:"+smsContent.getMobile()+"today:"+DateUtil.today()+"randomKey:"+randomKey);
            return result;
        }
        smsContent.setEnvi(request.getParameter("envi"));
        huaWeiSMSSendService.sendZhuTongSMS(smsContent);
        result.put("status", "200");
        result.put("msg", "调用成功");
        } catch (Exception e){
            System.out.println("huawei/sendSMS-ERR："+e.getMessage());
            e.printStackTrace();
        }
        return result;
    }



    @RequestMapping(value = "/huawei/resent")
    public ModelMap resent(HttpServletRequest request) throws Exception{
        ModelMap result = new ModelMap();
        result.put("status", "200");
        result.put("msg", "调用成功");
        huaWeiSMSSendService.resent();
        return result;
    }

    public static boolean isInteger(String str) {
        return NUMBER_PATTERN.matcher(str).matches();
    }
}
