package com.bcxin.statistics.service.v5;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.statistics.common.utils.StringUtils;
import com.bcxin.statistics.dao.mapper.TlkEventTeamMapper;
import com.bcxin.statistics.entity.TlkEventProjectEntity;
import com.bcxin.statistics.entity.TlkEventTeamEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description：智能人事-项目表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TlkEventTeamService extends ServiceImpl<TlkEventTeamMapper, TlkEventTeamEntity> {


    @Autowired
    private TlkEventProjectService tlkEventProjectService;

    /**
     * description：通过项目id、团队id，获取参与项目的团队
     * author：linchunpeng
     * date：2025/4/3
     */
    public List<TlkEventTeamEntity> getTeamByProjectIdOrTeamIdList(String projectId, List<String> teamIdList) {
        LambdaQueryChainWrapper<TlkEventTeamEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkEventTeamEntity::getItemProjectId, projectId);
        if (CollectionUtil.isNotEmpty(teamIdList)) {
            lqw.in(TlkEventTeamEntity::getItemTeamId, teamIdList);
        }
        List<TlkEventTeamEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            return list;
        }
        return new ArrayList<>();
    }


    /**
     * description：通过组织id，查询参与的项目列表
     * author：linchunpeng
     * date：2025/4/27
     */
    public List<TlkEventProjectEntity> getProjectListByOrgId(String teamId) {
        LambdaQueryChainWrapper<TlkEventTeamEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkEventTeamEntity::getItemTeamId, teamId);
        lqw.isNotNull(TlkEventTeamEntity::getItemProjectId);
        List<TlkEventTeamEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            List<String> projectIdList = list.stream().map(TlkEventTeamEntity::getItemProjectId).collect(Collectors.toList());
            List<TlkEventProjectEntity> projectList = tlkEventProjectService.listByIds(projectIdList);
            if (CollectionUtil.isNotEmpty(projectList)) {
                return projectList;
            }
        }
        return new ArrayList<>();
    }

}