package com.bcxin.statistics.dtos.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;


@Data
@ApiModel(value = "SaiYanStatisticsSiteRequest对象", description = "赛演考勤统计考勤组（岗点）request对象")
public class SaiYanStatisticsSiteRequest {

    @ApiModelProperty(value = "项目id", required = true)
    @NotBlank(message = "项目id不能为空")
    private String projectId;
    @ApiModelProperty(value = "团队组织id列表，数组（是用获取团队列表接口的itemTeamId字段，不要用id）", required = true)
    @NotEmpty(message = "团队组织id不能为空")
    private List<String> teamIdList;

    @ApiModelProperty(hidden = true)
    private String userId;
    @ApiModelProperty(hidden = true)
    private String orgId;
    @ApiModelProperty(hidden = true)
    private String empId;

}
