/*
 * Decompiled with CFR 0.152.
 */
package com.wlsk.plugin.exception;

import com.wlsk.plugin.domain.enums.CommonCode;
import com.wlsk.plugin.domain.vo.Result;
import com.wlsk.plugin.exception.BaseExceptionHandler;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
@Order(value=-2147483648)
public class GlobalExceptionHandler
extends BaseExceptionHandler {
    @Override
    public Result handlerMethodArgumentNotValidException(MethodArgumentNotValidException ex) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        if (request != null && request instanceof ContentCachingRequestWrapper) {
            ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)request;
            this.log.error("handlerMethodArgumentNotValidException.request_body:{}", (Object)StringUtils.toEncodedString((byte[])wrapper.getContentAsByteArray(), (Charset)Charset.forName(wrapper.getCharacterEncoding())));
        }
        this.log.error("\u7a0b\u5e8f\u65b9\u6cd5\u53c2\u6570\u65e0\u6548\u5f02\u5e38:{}", (Object)ex.getMessage(), (Object)ex);
        StringBuilder message = new StringBuilder();
        for (FieldError error : ex.getBindingResult().getFieldErrors()) {
            message.append(error.getDefaultMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return Result.FAIL(CommonCode.INVALID_PARAM.code(), message.toString());
    }
}

