/*
 * Decompiled with CFR 0.152.
 */
package com.wlsk.plugin.api;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.wlsk.plugin.domain.anno.PluginApi;
import com.wlsk.plugin.domain.anno.PluginParam;
import com.wlsk.plugin.domain.anno.PluginResource;
import com.wlsk.plugin.domain.anno.PluginResourceReq;
import com.wlsk.plugin.domain.anno.PluginResourceResp;
import com.wlsk.plugin.domain.enums.DefaultValueEnum;
import com.wlsk.plugin.domain.vo.PluginReourceDetailVo;
import com.wlsk.plugin.domain.vo.PluginReourceVo;
import com.wlsk.plugin.domain.vo.PluginResourceScanVo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ScanResourceApi {
    public static final Logger log = LoggerFactory.getLogger(ScanResourceApi.class);

    default public PluginResourceScanVo scanResource(String groupId, String pluginId) {
        log.info("\u63d2\u4ef6\u8d44\u6e90\u626b\u63cf\u5f00\u59cb\uff0c\u63d2\u4ef6ID\uff1a{}", (Object)pluginId);
        PluginResourceScanVo vo = new PluginResourceScanVo();
        List<Class<?>> clazzList = this.getClassesWithAnnotationInPackage(groupId, PluginApi.class);
        List<Class<?>> screenVo = this.screenByAnno(clazzList, pluginId);
        List<PluginReourceVo> data = this.analysisObj(screenVo);
        vo.setResourceCount(data.size());
        vo.setData(data);
        log.info("\u63d2\u4ef6\u8d44\u6e90\u626b\u63cf\u7ed3\u675f\uff0c\u63d2\u4ef6ID\uff1a{}---\u7ed3\u679c\u7edf\u8ba1-\u8d44\u6e90\u6570\uff1a{}", (Object)pluginId, (Object)JSON.toJSONString((Object)data.size()));
        return vo;
    }

    private List<PluginReourceVo> analysisObj(List<Class<?>> clazzList) {
        ArrayList<PluginReourceVo> vo = new ArrayList<PluginReourceVo>();
        for (Class<?> clazz : clazzList) {
            Method[] methods;
            PluginApi annotation = clazz.getAnnotation(PluginApi.class);
            String name = clazz.getName();
            for (Method method : methods = clazz.getMethods()) {
                List<PluginReourceDetailVo> subParamList;
                String methodName = method.getName();
                PluginResource pluginResourceAnno = method.getAnnotation(PluginResource.class);
                if (ObjectUtil.isNull((Object)pluginResourceAnno)) continue;
                String value = pluginResourceAnno.value();
                String description = pluginResourceAnno.description();
                ArrayList<PluginReourceDetailVo> pluginReourceDetail = new ArrayList<PluginReourceDetailVo>();
                PluginResourceReq[] req = pluginResourceAnno.req();
                Parameter[] parameters = method.getParameters();
                for (int i = 0; i < req.length; ++i) {
                    if (Void.class == req[i].clazz()) continue;
                    String paramName = req[i].value();
                    String paramDescription = req[i].description();
                    Class<Object> paramClazz = req[i].clazz();
                    String paramKey = parameters[i].getName();
                    String paramClazzName = paramClazz.getName();
                    if (!(paramClazz.isAssignableFrom(Integer.class) || paramClazz.isAssignableFrom(Long.class) || paramClazz.isAssignableFrom(Double.class) || paramClazz.isAssignableFrom(String.class) || paramClazz.isAssignableFrom(Map.class))) {
                        subParamList = this.analysisSubObj(paramKey, paramClazz, DefaultValueEnum.YES.getValue(), new ArrayList<PluginReourceDetailVo>());
                        pluginReourceDetail.addAll(subParamList);
                    }
                    PluginReourceDetailVo reourceDetailVo = PluginReourceDetailVo.builder().paramName(paramName).paramKey(paramKey).description(paramDescription).paramType(paramClazzName).type(DefaultValueEnum.YES.getValue()).parentParamKey("gen").description(paramDescription).build();
                    pluginReourceDetail.add(reourceDetailVo);
                }
                PluginResourceResp resp = pluginResourceAnno.resp();
                String respParamName = resp.value();
                String respParamDescription = resp.description();
                Class<Object> respParamClazz = resp.clazz();
                String respParamKey = "vo";
                PluginReourceDetailVo reourceDetailVo = PluginReourceDetailVo.builder().paramName(respParamName).paramKey(respParamKey).description(respParamDescription).paramType(respParamClazz.getName()).type(DefaultValueEnum.NO.getValue()).parentParamKey("gen").description(respParamDescription).build();
                if (!(respParamClazz.isAssignableFrom(Integer.class) || respParamClazz.isAssignableFrom(Long.class) || respParamClazz.isAssignableFrom(Double.class) || respParamClazz.isAssignableFrom(String.class) || respParamClazz.isAssignableFrom(Map.class))) {
                    subParamList = this.analysisSubObj(respParamKey, respParamClazz, DefaultValueEnum.NO.getValue(), new ArrayList<PluginReourceDetailVo>());
                    pluginReourceDetail.addAll(subParamList);
                }
                pluginReourceDetail.add(reourceDetailVo);
                PluginReourceVo data = PluginReourceVo.builder().className(name).methodName(methodName).name(value).description(description).pluginReourceDetail(pluginReourceDetail).build();
                vo.add(data);
            }
        }
        return vo;
    }

    private List<PluginReourceDetailVo> analysisSubObj(String parentParamKey, Class<?> clazz, Integer typeParam, List<PluginReourceDetailVo> vo) {
        Field[] fields;
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        Type[] typeArray;
        int n;
        int n2;
        Type type;
        for (PluginReourceDetailVo item : vo) {
            if (!parentParamKey.equals(item.getParentParamKey()) || !clazz.getName().equals(item.getParamType())) continue;
            log.info("\u53c2\u6570\u5df2\u5b58\u5728\u8df3\u8fc7\uff1a {}", (Object)item.getParamType());
            return vo;
        }
        if ((clazz.isAssignableFrom(List.class) || clazz.isAssignableFrom(Set.class)) && (type = clazz.getGenericSuperclass()) instanceof ParameterizedType && (n2 = 0) < (n = (typeArray = (typeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments())).length)) {
            Class<Object> paradigmsClazz;
            Type typeArgument = typeArray[n2];
            System.out.println("Type argument: " + typeArgument.getTypeName());
            try {
                paradigmsClazz = Class.forName(typeArgument.getTypeName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("\u63d2\u4ef6\u8d44\u6e90\u626b\u63cf\u5f02\u5e38");
            }
            if (!(paradigmsClazz.isAssignableFrom(Integer.class) || paradigmsClazz.isAssignableFrom(Long.class) || paradigmsClazz.isAssignableFrom(Double.class) || paradigmsClazz.isAssignableFrom(String.class) || paradigmsClazz.isAssignableFrom(Map.class))) {
                this.analysisSubObj(parentParamKey, paradigmsClazz, typeParam, vo);
            }
            return vo;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            PluginParam pluginParamAnno = field.getAnnotation(PluginParam.class);
            if (ObjectUtil.isNull((Object)pluginParamAnno)) continue;
            String paramName = pluginParamAnno.value();
            String paramDescription = pluginParamAnno.description();
            Class<Object> paramClazz = pluginParamAnno.clazz();
            String paramClazzName = paramClazz.getName();
            String paramKey = field.getName();
            PluginReourceDetailVo reourceDetailVo = PluginReourceDetailVo.builder().paramName(paramName).paramKey(paramKey).description(paramDescription).paramType(paramClazzName).type(typeParam).parentParamKey(parentParamKey).description(paramDescription).build();
            vo.add(reourceDetailVo);
            if (paramClazz.isAssignableFrom(Integer.class) || paramClazz.isAssignableFrom(Long.class) || paramClazz.isAssignableFrom(Double.class) || paramClazz.isAssignableFrom(String.class) || paramClazz.isAssignableFrom(Map.class)) continue;
            this.analysisSubObj(paramKey, paramClazz, typeParam, vo);
        }
        return vo;
    }

    private List<Class<?>> screenByAnno(List<Class<?>> clazzList, String condition) {
        ArrayList vo = new ArrayList();
        for (Class<?> clazz : clazzList) {
            PluginApi annotation = clazz.getAnnotation(PluginApi.class);
            if (null == annotation || !condition.equals(annotation.pluginId())) continue;
            vo.add(clazz);
        }
        return vo;
    }

    private List<Class<?>> getClassesWithAnnotationInPackage(String packageName, Class<? extends Annotation> annotationClass) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set classSet = reflections.getTypesAnnotatedWith(annotationClass);
        return classSet.stream().toList();
    }
}

