/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.bcxin.platform.common.utils.DES3;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.servlet.http.HttpServletRequest;

public class Result {
    private String api;
    private String v;
    private String retType = "0";
    private Object data;
    private String msg = "\u64cd\u4f5c\u6210\u529f\uff01";
    public static final String SUCCESS = "0";
    public static final String ERROR = "-1";
    public static final String BUSINESS_ERROR = "-2";
    public static final String TOKEN_EXPIRED = "1";
    public static final String SERVICE_UPGRADE = "2";
    public static final String SUCCESS_MSG = "\u64cd\u4f5c\u6210\u529f\uff01";
    public static final String SUCCESS_QUERY_MSG = "";
    public static final String ERROR_MSG = "\u64cd\u4f5c\u5931\u8d25:";

    public Result() {
    }

    private Result(String v, String api, String retType, String message, Object data) {
        this.v = v;
        this.api = api;
        this.retType = retType;
        this.msg = message;
        this.data = data;
    }

    public static Result success(HttpServletRequest request, String successMsg, Object data) {
        return new Result(request.getParameter("v"), request.getParameter("api"), SUCCESS, successMsg == null ? SUCCESS_QUERY_MSG : successMsg, data);
    }

    public static Result fail(HttpServletRequest request, String errorMsg, Object data) {
        return new Result(request.getParameter("v"), request.getParameter("api"), ERROR, errorMsg == null ? SUCCESS_QUERY_MSG : errorMsg, data);
    }

    public static Result success(String successMsg, Object data) {
        return new Result(SUCCESS_QUERY_MSG, SUCCESS_QUERY_MSG, SUCCESS, successMsg, data);
    }

    public static Result fail(String errorMsg, Object data) {
        return new Result(SUCCESS_QUERY_MSG, SUCCESS_QUERY_MSG, ERROR, errorMsg == null || errorMsg.equals(SUCCESS_QUERY_MSG) ? ERROR_MSG : errorMsg, data);
    }

    public static Result success(String successMsg) {
        return new Result(SUCCESS_QUERY_MSG, SUCCESS_QUERY_MSG, SUCCESS, successMsg == null || successMsg.equals(SUCCESS_QUERY_MSG) ? SUCCESS_QUERY_MSG : successMsg, null);
    }

    public static Result fail(String errorMsg) {
        return new Result(SUCCESS_QUERY_MSG, SUCCESS_QUERY_MSG, ERROR, errorMsg == null || errorMsg.equals(SUCCESS_QUERY_MSG) ? ERROR_MSG : errorMsg, null);
    }

    public static Result tokenExpired(String errorMsg) {
        return new Result(SUCCESS_QUERY_MSG, SUCCESS_QUERY_MSG, TOKEN_EXPIRED, errorMsg == null || errorMsg.equals(SUCCESS_QUERY_MSG) ? ERROR_MSG : errorMsg, null);
    }

    public Result setBack(HttpServletRequest request) {
        this.setApi(request.getParameter("api"));
        this.setV(request.getParameter("v"));
        return this;
    }

    public String getRetType() {
        return this.retType;
    }

    public void setRetType(String retType) {
        this.retType = retType;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public String getV() {
        return this.v;
    }

    public void setV(String v) {
        this.v = v;
    }

    @JsonIgnore
    public static String getDecodeData(String data) {
        try {
            return data == null ? null : DES3.decode(data.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JsonIgnore
    public static <T> T getDecodeData(String data, Class<T> clazz) {
        return (T)JSON.parseObject((String)Result.getDecodeData(data), clazz);
    }

    public static Object setEncodeData(Object data) {
        try {
            SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);
            filter.getExcludes().add("isDelete");
            filter.getExcludes().add("pageNumber");
            filter.getExcludes().add("pageSize");
            filter.getExcludes().add("appData");
            filter.getExcludes().add("t");
            filter.getExcludes().add("sign");
            filter.getExcludes().add("api");
            filter.getExcludes().add("v");
            JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
            return DES3.encode(JSON.toJSONString((Object)data, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue}));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

