package com.bcxin.platform.common.utils.blb;

/**
* 类名称：AjaxResult   
* 类描述：百联保对接返回的实体类
* @apiNote  作者 陈堂君
* @since 创建于 2018/3/28 9:22
*
*/
public class AjaxResult {
	
	/** 返回结果 */
	private boolean success;

	private boolean successful;

	private String code;

	/** 返回信息 */
	private String msg;
	/** 返回数据 */
	private Object data;

	public AjaxResult(boolean successful, String code, String msg, Object data) {
		this.successful = successful;
		this.code = code;
		this.msg = msg;
		this.data = data;
	}

	public static AjaxResult success( String msg, Object data){
		return new AjaxResult(true,"CODE-0000",msg,data);
	}
	public static AjaxResult fail(String code, String msg, Object data){
		return new AjaxResult(false,code,msg,data);
	}

	public boolean isSuccess() {
		return success;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public boolean isSuccessful() {
		return successful;
	}
	public void setSuccessful(boolean successful) {
		this.successful = successful;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public AjaxResult() {
		super();
	}
	public AjaxResult(boolean success) {
		super();
		this.success = success;
	}

	public AjaxResult(boolean success, String msg) {
		super();
		this.success = success;
		this.msg = msg;
	}
	
	public AjaxResult(boolean success, Object data) {
		super();
		this.success = success;
		this.data = data;
	}

	public AjaxResult(boolean success, String msg, Object data) {
		super();
		this.success = success;
		this.msg = msg;
		this.data = data;
	}
}
