package com.bcxin.platform.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class DateUtil {

	private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);

	public static String[] weekDays = { "周日", "周一", "周二", "周三", "周四", "周五", "周六" };

	public static final String FORMAT1 = "yyyy-MM-dd HH:mm:ss";
	public static final String FORMAT2 = "yyyy-MM-dd";
	public static final String FORMAT3 = "MM/dd/yyyy HH:mm:ss";
	public static final String FORMAT4 = "MM/dd/yyyy";
	public static final String FORMAT5 = "HH:mm:ss";
	public static final String FORMAT6 = "yyyy/MM/dd";
	public static final String FORMAT7 = "yyyy-MM-dd HH:mm";
	public static final String FORMAT8 = "yyyyMMddHHmmss";
	public static final String FORMAT9 = "yyyy-MM";
	public static final String FORMAT10 = "yyyy";
	public static final String FORMAT11 = "yyyyMMdd";
	public static final String FORMAT12 = "yyyyMMddHHmmssSSS";
	public static final String FORMAT13 = "yyyyMM";
	public static final String DATEFORMAT = "yyyy-MM-dd";
	/**
	 * 年
	 */
	public static final int DATATYPE_YEAR = 1;

	/**
	 * 月
	 */
	public static final int DATATYPE_MONTH = 2;

	/**
	 * 日
	 */
	public static final int DATATYPE_DAY = 3;

	/**
	 * 小时
	 */
	public static final int DATATYPE_HOUR = 4;

	/**
	 * 分钟
	 */
	public static final int DATATYPE_MINUTE = 5;

	/**
	 * 秒
	 */
	public static final int DATATYPE_SECOND = 6;


	public static void main(String[] args) {

		// System.out.println(getWeekOfDate("2017-03-01"));
		// List<String> thisweeks = getThisWeekDates();
		// for (String thisweek : thisweeks) {
		// System.out.println("本 "+getWeekOfDate(thisweek)+" 是:"+thisweek);
		// }
		// List<String> nextweeks = getNextWeekDates();
		// for (String nextweek : nextweeks) {
		//
		// System.out.println("下 "+getWeekOfDate(nextweek)+" 是:"+nextweek);
		// }
		// String now = DateUtil.systemDate.format(new Date());
		// System.out.println(now);
		// try {
		// Date currentDate = systemDate.parse(now);
		// System.out.println(currentDate);
		// } catch (ParseException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
//		System.out.println(DateUtil.getCurrentDateTime(DateUtil.FORMAT8));
//		System.out.println(getDayBegin());
//		System.out.println(getDayEnd());
//		System.out.println(getBeginDayOfYesterday());
//		System.out.println(getEndDayOfYesterDay());
//		System.out.println(getBeginDayOfWeek());
//		System.out.println(getEndDayOfWeek());
//		System.out.println(getBeginDayOfLastWeek());
//		System.out.println(getEndDayOfLastWeek());
//		System.out.println(getBeginDayOfMonth());
//		System.out.println(getEndDayOfMonth());
//		System.out.println(getBeginDayOfLastMonth());
//		System.out.println(getEndDayOfLastMonth());
//		System.out.println(getBeginDayOfYear());
//		System.out.println(getEndDayOfYear());
//		System.out.println(getBeginDayOfLastYear());
//		System.out.println(getEndDayOfLastYear());
		System.out.println(dateCompare("2018-07-10","2018-07-09"));

		/*
		 * System.out.println(getDaysOfMonth(convertStringToDate("2017-08"+"-01"
		 * )));
		 * 
		 * getWeekDatesByYearMouth("2017-08");
		 */
	}

	public static List<String> getDatesBetweenDate(String startDate, String endDate) {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		List<String> dates = new ArrayList<String>();
		try {
			Date dateOne = dateFormat.parse(startDate);
			Date dateTwo = dateFormat.parse(dateAdd(DATATYPE_HOUR, endDate, 24));
			Calendar calendar = Calendar.getInstance();

			calendar.setTime(dateOne);

			while (calendar.getTime().before(dateTwo)) {
				dates.add(dateFormat.format(calendar.getTime()));
				calendar.add(Calendar.DAY_OF_MONTH, 1);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return dates;
	}

	public static List<String> getThisWeekDates() {
		List<String> dates = new ArrayList<String>();
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Calendar c = Calendar.getInstance();
			// 今天是一周中的第几天
			int dayOfWeek = c.get(Calendar.DAY_OF_WEEK);
			if (c.getFirstDayOfWeek() == Calendar.SUNDAY) {
				c.add(Calendar.DAY_OF_MONTH, 1);
			}
			// 计算一周开始的日期
			c.add(Calendar.DAY_OF_MONTH, -dayOfWeek);

			for (int i = 1; i <= 7; i++) {
				c.add(Calendar.DAY_OF_MONTH, 1);
				dates.add(sdf.format(c.getTime()));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return dates;
	}

	public static List<String> getNextWeekDates() {
		List<String> dates = new ArrayList<String>();
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Calendar c = Calendar.getInstance();
			// 今天是一周中的第几天
			int dayOfWeek = c.get(Calendar.DAY_OF_WEEK);
			if (c.getFirstDayOfWeek() == Calendar.SUNDAY) {
				c.add(Calendar.DAY_OF_MONTH, 1);
			}
			// 计算一周开始的日期
			c.add(Calendar.DAY_OF_MONTH, -dayOfWeek + 7);

			for (int i = 1; i <= 7; i++) {
				c.add(Calendar.DAY_OF_MONTH, 1);
				dates.add(sdf.format(c.getTime()));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return dates;
	}

	public static int getDaysOfMonth(Date date) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		return calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
	}

	/**
	 * 根据日期 找到对应日期的 星期
	 */
	public static String getDayOfWeekByDate(String date) {
		String dayOfweek = "-1";
		try {
			SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
			Date myDate = myFormatter.parse(date);
			SimpleDateFormat formatter = new SimpleDateFormat("E");
			String str = formatter.format(myDate);
			dayOfweek = str;

		} catch (Exception e) {
			System.out.println("错误!");
		}
		return dayOfweek;
	}

	public static String getWeek(Date date) {
		String[] weeks = { "星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六" };
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		int week_index = cal.get(Calendar.DAY_OF_WEEK) - 1;
		if (week_index < 0) {
			week_index = 0;
		}
		return weeks[week_index];
	}

	public static Map<String, List<String>> getWeekDatesByYearMouth(String yearMouth) {
		Map<String, List<String>> weekDatesMap = new LinkedHashMap<String, List<String>>();

		List<String> oneList = new ArrayList<String>();
		List<String> twoList = new ArrayList<String>();
		List<String> threeList = new ArrayList<String>();
		List<String> fourList = new ArrayList<String>();
		List<String> fiveList = new ArrayList<String>();
		List<String> sixList = new ArrayList<String>();
		List<String> sevenList = new ArrayList<String>();

		int dayCount = getDaysOfMonth(convertStringToDate(yearMouth + "-01"));
		for (int day = 1; day <= dayCount; day++) {
			String weekDay = yearMouth + "-" + (day > 9 ? day : ("0" + day));
			String week = getWeek(convertStringToDate(weekDay));
			if (week.equals("星期一")) {
				oneList.add(weekDay);
			} else if (week.equals("星期二")) {
				twoList.add(weekDay);
			} else if (week.equals("星期三")) {
				threeList.add(weekDay);
			} else if (week.equals("星期四")) {
				fourList.add(weekDay);
			} else if (week.equals("星期五")) {
				fiveList.add(weekDay);
			} else if (week.equals("星期六")) {
				sixList.add(weekDay);
			} else if (week.equals("星期日")) {
				sevenList.add(weekDay);
			}
		}

		weekDatesMap.put("周一", oneList);
		weekDatesMap.put("周二", twoList);
		weekDatesMap.put("周三", threeList);
		weekDatesMap.put("周四", fourList);
		weekDatesMap.put("周七", fiveList);
		weekDatesMap.put("周六", sixList);
		weekDatesMap.put("周天", sevenList);
		return weekDatesMap;
	}

	/**
	 * 计算两个日期之间相差的天数
	 * 
	 * @param smdate
	 *            较小的时间
	 * @param bdate
	 *            较大的时间
	 * @return 相差天数
	 * @throws ParseException
	 */
	public static int dateDiff(Date smdate, Date bdate) {
		if (smdate == null || bdate == null) {
			return 0;
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		try {
			smdate = sdf.parse(sdf.format(smdate));
			bdate = sdf.parse(sdf.format(bdate));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		Calendar cal = Calendar.getInstance();
		cal.setTime(smdate);
		long time1 = cal.getTimeInMillis();
		cal.setTime(bdate);
		long time2 = cal.getTimeInMillis();
		long between_days = (time2 - time1) / (1000 * 3600 * 24);
		return Integer.parseInt(String.valueOf(between_days));
	}

	/**
	 * 计算两个日期之间相差的小时
	 * 
	 * @param smdate
	 *            较小的时间
	 * @param bdate
	 *            较大的时间
	 * @return 相差小时
	 * @throws ParseException
	 */
	public static String hourDiff(Date smdate, Date bdate) {
		String hour = "";
		String minute = "";
		if (smdate == null || bdate == null) {
			return "";
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try {
			smdate = sdf.parse(sdf.format(smdate));
			bdate = sdf.parse(sdf.format(bdate));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		Calendar cal = Calendar.getInstance();
		cal.setTime(smdate);
		double time1 = cal.getTimeInMillis();
		cal.setTime(bdate);
		double time2 = cal.getTimeInMillis();
		double between_hour = (time2 - time1) / (1000 * 3600);
		double between_minu = (time2 - time1) / (1000 * 60);

		if (between_hour >= 1) {
			hour = (int) between_hour + "小时";
		} else {
			hour = "";
		}
		if (between_minu % 60 > 0.0) {
			minute = (int) between_minu % 60 + "分钟";
		}
		return hour + minute;
	}

	/**
	 * 计算两个日期之间相差的小时
	 * 
	 * @param smdate
	 *            较小的时间
	 * @param bdate
	 *            较大的时间
	 * @return 相差小时
	 * @throws ParseException
	 */
	public static double hourDiff1(Date smdate, Date bdate, String pattern) {
		if (smdate == null || bdate == null) {
			return 0;
		}
		SimpleDateFormat sdf = new SimpleDateFormat(pattern);
		try {
			smdate = sdf.parse(sdf.format(smdate));
			bdate = sdf.parse(sdf.format(bdate));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		Calendar cal = Calendar.getInstance();
		cal.setTime(smdate);
		double time1 = cal.getTimeInMillis();
		cal.setTime(bdate);
		double time2 = cal.getTimeInMillis();
		double between_hour = (time2 - time1) / (1000 * 3600);

		return between_hour;
	}

	/**
	 * 计算两个日期之间相差的分钟数
	 * 
	 * @param smdate
	 *            较小的时间
	 * @param bdate
	 *            较大的时间
	 * @return 相差分钟数
	 * @throws ParseException
	 */
	public static int dateDiffForMinutes(Date smdate, Date bdate) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try {
			smdate = sdf.parse(sdf.format(smdate));
			bdate = sdf.parse(sdf.format(bdate));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		Calendar cal = Calendar.getInstance();
		cal.setTime(smdate);
		long time1 = cal.getTimeInMillis();
		cal.setTime(bdate);
		long time2 = cal.getTimeInMillis();
		long between_days = (time2 - time1) / (1000 * 60);
		return Integer.parseInt(String.valueOf(between_days));
	}

	/**
	 * 日期加法
	 *
	 * @param type
	 * @param date
	 * @param num
	 * @return 日期
	 * @throws Exception
	 */
	public static Date dateAdd2(int type, Date date, int num) throws Exception {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		if (type == DATATYPE_YEAR) {
			cal.add(Calendar.YEAR, num);
		} else if (type == DATATYPE_MONTH) {
			cal.add(Calendar.MONTH, num);
		} else if (type == DATATYPE_HOUR) {
			cal.add(Calendar.HOUR, num);
		} else if (type == DATATYPE_MINUTE) {
			cal.add(Calendar.MINUTE, num);
		} else if (type == DATATYPE_SECOND) {
			cal.add(Calendar.SECOND, num);
		} else {
			cal.add(Calendar.DATE, num);
		}
		return cal.getTime();
	}

	/**
	 * 日期加法
	 * 
	 * @param type
	 * @param sdate
	 * @param num
	 * @return 字符型日期
	 * @throws Exception
	 */
	public static String dateAdd(int type, String sdate, int num) throws Exception {
		SimpleDateFormat df = new SimpleDateFormat(getFormat(sdate));
		Date date = df.parse(sdate);
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		if (type == DATATYPE_YEAR) {
			cal.add(Calendar.YEAR, num);
		} else if (type == DATATYPE_MONTH) {
			cal.add(Calendar.MONTH, num);
		} else if (type == DATATYPE_HOUR) {
			cal.add(Calendar.HOUR, num);
		} else if (type == DATATYPE_MINUTE) {
			cal.add(Calendar.MINUTE, num);
		} else if (type == DATATYPE_SECOND) {
			cal.add(Calendar.SECOND, num);
		} else {
			cal.add(Calendar.DATE, num);
		}
		return df.format(cal.getTime());
	}


	/**
	 * 日期加法
	 *
	 * @param type
	 * @param date
	 * @param num
	 * @return 日期
	 * @throws Exception
	 */
	public static Date dateAdd(int type, Date date, int num) throws Exception {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		if (type == DATATYPE_YEAR) {
			cal.add(Calendar.YEAR, num);
		} else if (type == DATATYPE_MONTH) {
			cal.add(Calendar.MONTH, num);
		} else if (type == DATATYPE_HOUR) {
			cal.add(Calendar.HOUR, num);
		} else if (type == DATATYPE_MINUTE) {
			cal.add(Calendar.MINUTE, num);
		} else if (type == DATATYPE_SECOND) {
			cal.add(Calendar.SECOND, num);
		} else {
			cal.add(Calendar.DATE, num);
		}
		return cal.getTime();
	}

	/**
	 * 获取当月的 天数
	 */
	public static int getCurrentMonthDay() {

		Calendar a = Calendar.getInstance();
		a.set(Calendar.DATE, 1);
		a.roll(Calendar.DATE, -1);
		int maxDate = a.get(Calendar.DATE);
		return maxDate;
	}

	/**
	 * 获取当前日期
	 * 
	 * @return
	 */
	public static String getCurrentDate() {
		return getCurrentDateTime(FORMAT2);
	}

	/**
	 * 获取昨天日期
	 * 
	 * @return yyyy-MM-dd
	 */
	public static String getYesterday() {
		SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, -1);
		return df.format(c.getTime());
	}

	/**
	 * 获取明天日期
	 * 
	 * @return yyyy-MM-dd
	 */
	public static String getTomorrow() {
		SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, 1);
		return df.format(c.getTime());
	}
	/**
	 * 获取当前日期之后几天
	 *
	 * @return yyyy-MM-dd
	 */
	public static String getDateStrAfterToday(int day) {
		SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, day);
		return df.format(c.getTime());
	}

	/**
	 * 获取当前日期
	 * 
	 * @return
	 */
	public static String getCurrentDate(String format) {
		return getCurrentDateTime(format);
	}

	/**
	 * 获取当前时间
	 * 
	 * @return 时分秒
	 */
	public static String getCurrentTime() {
		return getCurrentDateTime(FORMAT5);
	}

	/**
	 * 获取当前日期时间
	 * 
	 * @return
	 */
	public static String getCurrentDateTime() {
		return getCurrentDateTime(FORMAT1);
	}

	/**
	 * 根据特定格式获取当前时间
	 * 
	 * @param format
	 * @return
	 */
	public static String getCurrentDateTime(String format) {
		SimpleDateFormat df = new SimpleDateFormat(format);
		return df.format(new Date());
	}

	/**
	 * 根据年 月 获取对应的月份 天数
	 */
	public static int getDaysByYearMonth(int year, int month) {

		Calendar a = Calendar.getInstance();
		a.set(Calendar.YEAR, year);
		a.set(Calendar.MONTH, month - 1);
		a.set(Calendar.DATE, 1);
		a.roll(Calendar.DATE, -1);
		int maxDate = a.get(Calendar.DATE);
		return maxDate;
	}

	/**
	 * 根据string日期获取其格式
	 * 
	 * @param date
	 * @return
	 * @throws Exception
	 */
	public static String getFormat(String date) throws Exception {
		String reg1 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
		String reg2 = "\\d{4}-\\d{1,2}-\\d{1,2}";
		String reg3 = "\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
		String reg4 = "\\d{1,2}/\\d{1,2}/\\d{4}";
		String reg5 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}";
		if (date.matches(reg1)) {
			return FORMAT1;
		} else if (date.matches(reg2)) {
			return FORMAT2;
		} else if (date.matches(reg3)) {
			return FORMAT3;
		} else if (date.matches(reg4)) {
			return FORMAT4;
		} else if (date.matches(reg5)) {
			return FORMAT7;
		} else {
			throw new Exception("不支持的日期格式：" + date);
		}
	}

	public static String convertDateToString(Date date, String format) {
		SimpleDateFormat df = new SimpleDateFormat(format);
		return df.format(date);
	}

	/**
	 * String转换date
	 * 
	 * @param date
	 * @return
	 * @throws Exception
	 */
	public static Date convertStringToDate(String date) {

	SimpleDateFormat df;
		try {
		df = new SimpleDateFormat(getFormat(date));
		return df.parse(date);
	} catch (Exception e) {
		e.printStackTrace();
	}
		return new Date();

	}



	public static long parseDate(String date) {
		SimpleDateFormat df;
		try {
			df = new SimpleDateFormat("yyyy年MM月dd日 HH:mm");
			return df.parse(date).getTime();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return 0;
	}

	public static String getLastYear() {
		SimpleDateFormat format = new SimpleDateFormat("yyyy");
		Calendar c = Calendar.getInstance();
		// 过去一年
		c.setTime(new Date());
		c.add(Calendar.YEAR, -1);
		Date y = c.getTime();
		String year = format.format(y);
		System.out.println("过去一年：" + year);
		return year;
	}

	public static String getLastMonth() {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
		Calendar c = Calendar.getInstance();
		// 上个月
		c.setTime(new Date());
		c.add(Calendar.MONTH, -1);
		Date y = c.getTime();
		String month = format.format(y);
		return month;
	}

	/**
	 * 获取当天的开始时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getDayBegin() {
		/*
		 * Calendar cal = new GregorianCalendar(); cal.set(Calendar.HOUR_OF_DAY,
		 * 0); cal.set(Calendar.MINUTE, 0); cal.set(Calendar.SECOND, 0);
		 * cal.set(Calendar.MILLISECOND, 0); return cal.getTime();
		 */
		Date date = new Date();
		return getDayStartTime(date);
	}

	/**
	 * 获取当天的结束时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getDayEnd() {
		/*
		 * Calendar cal = new GregorianCalendar(); cal.set(Calendar.HOUR_OF_DAY,
		 * 23); cal.set(Calendar.MINUTE, 59); cal.set(Calendar.SECOND, 59);
		 * return cal.getTime();
		 */
		Date date = new Date();
		return getDayEndTime(date);
	}

	/**
	 * 获取昨天的开始时间
	 * 
	 * @return 默认格式 Wed May 31 14:47:18 CST 2017
	 */
	public static Date getBeginDayOfYesterday() {
		Calendar cal = new GregorianCalendar();
		cal.setTime(getDayBegin());
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return getDayStartTime(cal.getTime());
	}

	/**
	 * 获取昨天的结束时间
	 * 
	 * @return 默认格式 Wed May 31 14:47:18 CST 2017
	 */
	public static Date getEndDayOfYesterDay() {
		Calendar cal = new GregorianCalendar();
		cal.setTime(getDayEnd());
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return getDayEndTime(cal.getTime());
	}

	/**
	 * 获取本周的开始时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getBeginDayOfWeek() {
		Date date = new Date();
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
		if (dayofweek == 1) {
			dayofweek += 7;
		}
		cal.add(Calendar.DATE, 1 - dayofweek);
		return getDayStartTime(cal.getTime());
	}

	/**
	 * 获取本周的结束时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getEndDayOfWeek() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(getBeginDayOfWeek());
		cal.add(Calendar.DAY_OF_WEEK, 6);
		Date weekEndSta = cal.getTime();
		return getDayEndTime(weekEndSta);
	}
	

	/**
	 * 获取上周的开始时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getBeginDayOfLastWeek() {
		Date date = new Date();
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_MONTH, -7);
		int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
		if (dayofweek == 1) {
			dayofweek += 7;
		}
		cal.add(Calendar.DATE, 1 - dayofweek);
		return getDayStartTime(cal.getTime());
	}

	/**
	 * 获取上周的结束时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getEndDayOfLastWeek() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(getBeginDayOfLastWeek());
		cal.add(Calendar.DAY_OF_WEEK, 6);
		Date weekEndSta = cal.getTime();
		return getDayEndTime(weekEndSta);
	}
	
	/**
	 * 获取本月的开始时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getBeginDayOfMonth() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(getNowYear(), getNowMonth() - 1, 1);
		return getDayStartTime(calendar.getTime());
	}

	/**
	 * 获取本月的结束时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getEndDayOfMonth() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(getNowYear(), getNowMonth() - 1, 1);
		int day = calendar.getActualMaximum(5);
		calendar.set(getNowYear(), getNowMonth() - 1, day);
		return getDayEndTime(calendar.getTime());
	}
	

	/**
	 * 获取上月的开始时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getBeginDayOfLastMonth() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(getNowYear(), getNowMonth() - 2, 1);
		return getDayStartTime(calendar.getTime());
	}

	/**
	 * 获取上月的结束时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getEndDayOfLastMonth() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(getNowYear(), getNowMonth() - 2, 1);
		int day = calendar.getActualMaximum(5);
		calendar.set(getNowYear(), getNowMonth() - 2, day);
		return getDayEndTime(calendar.getTime());
	}

	/**
	 * 获取本年的开始时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getBeginDayOfYear() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, getNowYear());
		// cal.set
		cal.set(Calendar.MONTH, Calendar.JANUARY);
		cal.set(Calendar.DATE, 1);

		return getDayStartTime(cal.getTime());
	}

	/**
	 * 获取本年的结束时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getEndDayOfYear() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, getNowYear());
		cal.set(Calendar.MONTH, Calendar.DECEMBER);
		cal.set(Calendar.DATE, 31);
		return getDayEndTime(cal.getTime());
	}
	
	/**
	 * 获取去年的开始时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getBeginDayOfLastYear() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, getNowYear()-1);
		// cal.set
		cal.set(Calendar.MONTH, Calendar.JANUARY);
		cal.set(Calendar.DATE, 1);

		return getDayStartTime(cal.getTime());
	}

	/**
	 * 获取去年的结束时间
	 * 
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Date getEndDayOfLastYear() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, getNowYear()-1);
		cal.set(Calendar.MONTH, Calendar.DECEMBER);
		cal.set(Calendar.DATE, 31);
		return getDayEndTime(cal.getTime());
	}
	
	/**
	 * 获取某个日期的开始时间
	 * 
	 * @param d
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Timestamp getDayStartTime(Date d) {
		Calendar calendar = Calendar.getInstance();
		if (null != d) {
			calendar.setTime(d);
		}
		calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		return new Timestamp(calendar.getTimeInMillis());
	}

	/**
	 * 获取某个日期的结束时间
	 * 
	 * @param d
	 * @return yyyy-MM-dd HH:mm:ss 格式
	 */
	public static Timestamp getDayEndTime(Date d) {
		Calendar calendar = Calendar.getInstance();
		if (null != d) {
			calendar.setTime(d);
		}
		calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 23, 59, 59);
		calendar.set(Calendar.MILLISECOND, 999);
		return new Timestamp(calendar.getTimeInMillis());
	}

	/**
	 * 获取某年某月的第一天
	 * 
	 * @param year
	 * @param month
	 * @return
	 */
	public static Date getStartMonthDate(int year, int month) {
		Calendar calendar = Calendar.getInstance();
		calendar.set(year, month - 1, 1);
		return calendar.getTime();
	}

	/**
	 * 获取某年某月的最后一天
	 * 
	 * @param year
	 * @param month
	 * @return
	 */
	public static Date getEndMonthDate(int year, int month) {
		Calendar calendar = Calendar.getInstance();
		calendar.set(year, month - 1, 1);
		int day = calendar.getActualMaximum(5);
		calendar.set(year, month - 1, day);
		return calendar.getTime();
	}

	/**
	 * 获取今年是哪一年
	 * 
	 * @return
	 */
	public static Integer getNowYear() {
		Date date = new Date();
		GregorianCalendar gc = (GregorianCalendar) Calendar.getInstance();
		gc.setTime(date);
		return Integer.valueOf(gc.get(1));
	}

	/**
	 * 获取本月是哪一月
	 * 
	 * @return
	 */
	public static int getNowMonth() {
		Date date = new Date();
		GregorianCalendar gc = (GregorianCalendar) Calendar.getInstance();
		gc.setTime(date);
		return gc.get(2) + 1;
	}

	/**
	 * 获取两个日期之间的日期
	 * @param start 开始日期
	 * @param end 结束日期
	 * @return 日期集合
	 */
	public static List<Date> getBetweenDates(Date start, Date end) {
		List<Date> result = new ArrayList<Date>();
		result.add(start);
		if(start.getTime() == end.getTime()){
			return result;
		}
		Calendar tempStart = Calendar.getInstance();
		tempStart.setTime(start);
		tempStart.add(Calendar.DAY_OF_YEAR, 1);

		Calendar tempEnd = Calendar.getInstance();
		tempEnd.setTime(end);
		while (tempStart.before(tempEnd)) {
			result.add(tempStart.getTime());
			tempStart.add(Calendar.DAY_OF_YEAR, 1);
		}
		result.add(end);
		return result;
	}

	/**
	 * 获取两个日期之间的日期
	 * @param startDate 开始日期
	 * @param endDate 结束日期
	 * @return 日期集合
	 */
	public static List<Date> getBetweenDates(String startDate, String endDate) {
		Date start = DateUtil.convertStringToDate(startDate);
		Date end = DateUtil.convertStringToDate(endDate);
		List<Date> result = new ArrayList<Date>();
		result.add(start);
		if(start.getTime() == end.getTime()){
			return result;
		}
		Calendar tempStart = Calendar.getInstance();
		tempStart.setTime(start);
		tempStart.add(Calendar.DAY_OF_YEAR, 1);

		Calendar tempEnd = Calendar.getInstance();
		tempEnd.setTime(end);
		while (tempStart.before(tempEnd)) {
			result.add(tempStart.getTime());
			tempStart.add(Calendar.DAY_OF_YEAR, 1);
		}
		result.add(end);
		return result;
	}

	/**
	 * 获取两个日期之间的日期
	 * @param startDate 开始日期
	 * @param endDate 结束日期
	 * @return 日期集合
	 */
	public static List<Date> getBetweenDatesByWeeks(String startDate, String endDate,List<Integer> weeks) {
		Date start = DateUtil.convertStringToDate(startDate);
		Date end = DateUtil.convertStringToDate(endDate);
		List<Date> result = new ArrayList<Date>();
		result.add(start);
		if(start.getTime() == end.getTime()){
			return result;
		}
		Calendar tempStart = Calendar.getInstance();
		tempStart.setTime(start);
		tempStart.add(Calendar.DAY_OF_YEAR, 1);

		Calendar tempEnd = Calendar.getInstance();
		tempEnd.setTime(end);

		while (tempStart.before(tempEnd)) {
			if(weeks.contains(tempStart.get(Calendar.DAY_OF_WEEK)-1)) {
				result.add(tempStart.getTime());
			}
			tempStart.add(Calendar.DAY_OF_YEAR, 1);
		}
		result.add(end);
		return result;
	}

	/**
	 * 校验日期是否合法
	 * @param sourceDate
	 * @return boolean
	 * by llc 2018-08-09
	 */
	public static boolean checkDate(String sourceDate){
		if(sourceDate==null){
			return false;
		}
		try {
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
			dateFormat.setLenient(false);
			dateFormat.parse(sourceDate);
			return true;
		} catch (Exception e) {
		}
		return false;
	}

	/**
	 * 比较日期大小
	 * 说明：如果 strDate1 <= strDate2，返回true，否则返回false
	 * @param strDate1
	 *  @param strDate2
	 * @return boolean
	 * by llc 2018-08-09
	 */
	public static boolean dateCompare(String strDate1, String strDate2) {
		boolean flag = false ;
		if(strDate1 == null || strDate2 == null ){
			return flag;
		}
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		try {
			Date date1 = dateFormat.parse(strDate1);
			Date date2 = dateFormat.parse(strDate2);
			if(date1.getTime() <= date2.getTime()){
				flag = true;
			}else{
				flag = false;
			}

		} catch (Exception e) {
			flag = false;
		}
		return flag;
	}
}
