/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.grant;

import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.DateUtil;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.grant.ConfigBankOutletsWorkDay;
import com.bcxin.platform.domain.grant.PerBankOutletsAppointment;
import com.bcxin.platform.domain.grant.PerJointlyCard;
import com.bcxin.platform.dto.grant.ConfigBankOutletsDTO;
import com.bcxin.platform.dto.grant.ConfigBankOutletsWorkDayTimePeriodDto;
import com.bcxin.platform.dto.grant.PerJointlyCardDTO;
import com.bcxin.platform.dto.message.MessageDomainDTO;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.grant.ConfigBankOutletsWorkDayMapper;
import com.bcxin.platform.mapper.grant.ConfigBankOutletsWorkDayTimePeriodMapper;
import com.bcxin.platform.mapper.grant.PerBankOutletsAppointmentMapper;
import com.bcxin.platform.mapper.grant.PerJointlyCardMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.grant.PerJointlyCardService;
import com.bcxin.platform.util.BH_AESUtil;
import com.bcxin.platform.util.DateUtils;
import com.bcxin.platform.util.ObjectUtils;
import com.bcxin.platform.util.PageInfoUtils;
import com.bcxin.platform.util.excel.ExcelUtil;
import com.bcxin.platform.util.http.HuaWeiSmsContent;
import com.bcxin.platform.util.map.GaodeMapUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class PerJointlyCardServiceImpl
implements PerJointlyCardService {
    @Resource
    public PerJointlyCardMapper perJointlyCardMapper;
    @Resource
    public ConfigBankOutletsWorkDayMapper configBankOutletsWorkDayMapper;
    @Resource
    public ConfigBankOutletsWorkDayTimePeriodMapper configBankOutletsWorkDayTimePeriodMapper;
    @Resource
    public PerBankOutletsAppointmentMapper perBankOutletsAppointmentMapper;
    @Resource
    public CommonService commonService;
    @Resource
    public PerBaseInfoMapper perBaseInfoMapper;

    @Override
    public Result getPerOpenJointlyInfo(PerJointlyCardDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> perIdList = this.perJointlyCardMapper.getNoOpenJointlyPerIdList(dto.getComId());
        Integer openJointlyPerCount = this.perJointlyCardMapper.getOpenJointlyPerCount(dto.getComId());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("openJointlyPerCount", openJointlyPerCount);
        map.put("noOpenJointlyPerCount", perIdList == null ? 0 : perIdList.size());
        return Result.success((String)"", map);
    }

    @Override
    public Result getNoOpenJointlyPerList(PerJointlyCardDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u6761\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getDepartId() != null && dto.getDepartId() == -1L) {
            dto.setDepartId(dto.getComId());
        }
        if (StringUtils.isNotEmpty((String)dto.getDepartIds())) {
            dto.getDepartIds().replaceAll("-1", dto.getComId().toString());
            List departIdStrList = StrSpliter.split((String)dto.getDepartIds(), (String)",", (boolean)true, (boolean)true);
            ArrayList<Long> departIdList = new ArrayList<Long>();
            for (String departIdStr : departIdStrList) {
                departIdList.add(Long.parseLong(departIdStr));
            }
            dto.setDepartIdList(departIdList);
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, String>> list = this.perJointlyCardMapper.getNoOpenJointlyPerList(dto);
        PageInfoUtils<Map<String, String>> pageInfo = new PageInfoUtils<Map<String, String>>(list);
        return Result.success((String)"", pageInfo);
    }

    @Override
    public Result exportNoOpenJointlyPer(PerJointlyCardDTO dto, HttpServletResponse response) throws V5BusinessException {
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "_\u5f00\u901a\u4eba\u5458" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u672a\u5f00\u901a\u4eba\u5458");
            if (dto.getDepartId() != null && dto.getDepartId() == -1L) {
                dto.setDepartId(dto.getComId());
            }
            if (StringUtils.isNotEmpty((String)dto.getDepartIds())) {
                dto.getDepartIds().replaceAll("-1", dto.getComId().toString());
                List departIdStrList = StrSpliter.split((String)dto.getDepartIds(), (String)",", (boolean)true, (boolean)true);
                ArrayList<Long> departIdList = new ArrayList<Long>();
                for (String departIdStr : departIdStrList) {
                    departIdList.add(Long.parseLong(departIdStr));
                }
                dto.setDepartIdList(departIdList);
            }
            List<Map<String, String>> list = this.perJointlyCardMapper.getNoOpenJointlyPerList(dto);
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setAlignment((short)2);
            titleStyle.setVerticalAlignment((short)1);
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));
            HSSFRow rowFirst = sheet1.createRow(0);
            String[] firstArr = new String[]{"\u5e8f\u53f7", "\u59d3\u540d", "\u8eab\u4efd\u8bc1\u53f7", "\u624b\u673a\u53f7", "\u6027\u522b", "\u90e8\u95e8", "\u4eba\u5458\u7c7b\u522b", "\u8ba4\u8bc1\u72b6\u6001", "\u8d44\u683c\u8bc1\u53f7", "\u53d1\u8bc1\u65e5\u671f", "\u662f\u5426\u91c7\u96c6\u8bc1\u4ef6\u7167"};
            for (i = 0; i < firstArr.length; ++i) {
                cell = rowFirst.createCell(i);
                int column = i == 0 ? 1500 : (i == 2 ? 5000 : (i == 5 ? 10000 : 4000));
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(titleStyle);
            }
            for (i = 0; i < firstArr.length; ++i) {
                cell = rowFirst.createCell(i);
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(titleStyle);
            }
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index);
            HSSFRow row = null;
            int rowIndex = 1;
            for (Map<String, String> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue((double)rowIndex);
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("name"));
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("idCardNo"));
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("mobilePhone"));
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("sex"));
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("departName"));
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("perType"));
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("authStatus"));
                if (ObjectUtil.equal((Object)result.get("authStatus"), (Object)"\u5df2\u8ba4\u8bc1")) {
                    cell7.setCellStyle(greenStyle);
                }
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("cerNo"));
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("licenceDate"));
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("isExistsCerPhoto"));
                ++rowIndex;
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new V5BusinessException("-1", e.getMessage());
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return Result.success((String)"\u5bfc\u51fa\u672a\u5f00\u901a\u4eba\u5458\u6587\u4ef6\u5931\u8d25");
    }

    @Override
    public Result getOpenJointlyPerList(PerJointlyCardDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u6761\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getDepartId() != null && dto.getDepartId() == -1L) {
            dto.setDepartId(dto.getComId());
        }
        if (StringUtils.isNotEmpty((String)dto.getDepartIds())) {
            dto.getDepartIds().replaceAll("-1", dto.getComId().toString());
            List departIdStrList = StrSpliter.split((String)dto.getDepartIds(), (String)",", (boolean)true, (boolean)true);
            ArrayList<Long> departIdList = new ArrayList<Long>();
            for (String departIdStr : departIdStrList) {
                departIdList.add(Long.parseLong(departIdStr));
            }
            dto.setDepartIdList(departIdList);
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, String>> list = this.perJointlyCardMapper.getOpenJointlyPerList(dto);
        PageInfoUtils<Map<String, String>> pageInfo = new PageInfoUtils<Map<String, String>>(list);
        return Result.success((String)"", pageInfo);
    }

    @Override
    public Result exportOpenJointlyPer(PerJointlyCardDTO dto, HttpServletResponse response) throws V5BusinessException {
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "_\u5f00\u901a\u4eba\u5458" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u5f00\u901a\u4eba\u5458");
            if (dto.getDepartId() != null && dto.getDepartId() == -1L) {
                dto.setDepartId(dto.getComId());
            }
            if (StringUtils.isNotEmpty((String)dto.getDepartIds())) {
                dto.getDepartIds().replaceAll("-1", dto.getComId().toString());
                List departIdStrList = StrSpliter.split((String)dto.getDepartIds(), (String)",", (boolean)true, (boolean)true);
                ArrayList<Long> departIdList = new ArrayList<Long>();
                for (String departIdStr : departIdStrList) {
                    departIdList.add(Long.parseLong(departIdStr));
                }
                dto.setDepartIdList(departIdList);
            }
            List<Map<String, String>> list = this.perJointlyCardMapper.getOpenJointlyPerList(dto);
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setAlignment((short)2);
            titleStyle.setVerticalAlignment((short)1);
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));
            HSSFRow rowFirst = sheet1.createRow(0);
            String[] firstArr = new String[]{"\u5e8f\u53f7", "\u59d3\u540d", "\u8eab\u4efd\u8bc1\u53f7", "\u624b\u673a\u53f7", "\u90e8\u95e8", "\u94f6\u884c\u5361\u53f7", "\u8d26\u6237\u72b6\u6001", "\u8d26\u6237\u7c7b\u578b", "\u5f00\u6237\u884c", "\u5f00\u6237\u884c\u884c\u53f7", "\u6fc0\u6d3b\u65f6\u95f4", "\u6ce8\u9500\u65f6\u95f4", "\u6ce8\u9500\u539f\u56e0"};
            for (i = 0; i < firstArr.length; ++i) {
                cell = rowFirst.createCell(i);
                int column = i == 0 ? 1500 : (i == 2 || i == 5 || i == 9 || i == 10 || i == 11 ? 5000 : (i == 4 || i == 8 || i == 12 ? 10000 : 4000));
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(titleStyle);
            }
            for (i = 0; i < firstArr.length; ++i) {
                cell = rowFirst.createCell(i);
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(titleStyle);
            }
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index);
            HSSFRow row = null;
            int rowIndex = 1;
            for (Map<String, String> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue((double)rowIndex);
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("name"));
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("idCardNo"));
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("mobilePhone"));
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("departName"));
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("bankCardNo"));
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("bankAccountStatus"));
                if (ObjectUtil.equal((Object)result.get("bankAccountStatus"), (Object)"\u6b63\u5e38")) {
                    cell6.setCellStyle(greenStyle);
                } else if (ObjectUtil.equal((Object)result.get("bankAccountStatus"), (Object)"\u6ce8\u9500")) {
                    cell6.setCellStyle(redStyle);
                }
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("bankAccountType"));
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("bankOutlets"));
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("bankNo"));
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("activeTime"));
                HSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(result.get("cancelTime"));
                HSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(result.get("cancelReason"));
                ++rowIndex;
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new V5BusinessException("-1", e.getMessage());
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return Result.success((String)"\u5bfc\u51fa\u5f00\u901a\u4eba\u5458\u6587\u4ef6\u5931\u8d25");
    }

    @Override
    public Result batchNotice(PerJointlyCardDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getIsCheckAll())) {
            return Result.fail((String)"\u9009\u4e2d\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.equals(dto.getIsCheckAll(), "0") && StringUtil.isEmpty((String)dto.getPerIds())) {
            return Result.fail((String)"\u5fc5\u987b\u9009\u62e9\u53d1\u9001\u4eba\u5458");
        }
        List<Object> perIdList = Lists.newArrayList();
        if (dto.getIsCheckAll().equals("1")) {
            perIdList = this.perJointlyCardMapper.getNoOpenJointlyPerIdList(dto.getComId());
            if (perIdList == null) {
                return Result.fail((String)"\u6240\u6709\u4eba\u5747\u5df2\u5f00\u901a\uff0c\u65e0\u987b\u63d0\u9192");
            }
        } else {
            perIdList = StrSpliter.split((String)dto.getPerIds(), (String)",", (boolean)true, (boolean)true);
        }
        if (perIdList.size() == 0) {
            // empty if block
        }
        String ids = Joiner.on((String)",").skipNulls().join(perIdList);
        MessageDomainDTO messageDomainDTO = new MessageDomainDTO();
        messageDomainDTO.setIds(ids);
        messageDomainDTO.setTitle("\u60a8\u8fd8\u672a\u7533\u8bf7\u5f00\u901a\u4fdd\u5b89\u667a\u80fd\u5361\uff0c\u8bf7\u5c3d\u5feb\u5f00\u901a\uff01");
        messageDomainDTO.setContent("\u60a8\u7684\u4f01\u4e1a\u63d0\u9192\u60a8\uff1a\\n\u8bf7\u5c3d\u5feb\u5f00\u901a\u4fdd\u5b89\u5458\u8bc1\u8054\u540d\u5361\uff08\u8bbf\u95eeApp-\u6211\u7684-\u4fdd\u5b89\u5458\u8bc1\u8054\u540d\u5361\u9875\u9762\u4e86\u89e3\u5f00\u901a\u65b9\u5f0f\uff09\u3002\\n\u82e5\u5df2\u63d0\u4ea4\u7533\u8bf7\u6216\u5df2\u5f00\u901a\u7684\uff0c\u8bf7\u5ffd\u7565\u3002");
        messageDomainDTO.setMessageType("010302");
        messageDomainDTO.setPlatId(10L);
        messageDomainDTO.setWay("3");
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result batchSyncPerJointly(List<Map<String, String>> list) throws V5BusinessException {
        ArrayList<PerJointlyCard> perJointlyCardList = new ArrayList<PerJointlyCard>();
        Date now = new Date();
        for (Map<String, String> map : list) {
            PerJointlyCard perJointlyCard = new PerJointlyCard();
            perJointlyCard.setPerId(Long.parseLong(map.get("perId")));
            perJointlyCard.setCreateTime(now);
            perJointlyCard.setUpdateTime(now);
            perJointlyCard.setIsActive(map.get("isActive"));
            perJointlyCard.setActiveTime(map.get("activeTime"));
            perJointlyCard.setOpenCardTime(map.get("openCardTime"));
            perJointlyCard.setBankCode(map.get("bankCode"));
            perJointlyCard.setBankOutlets(map.get("bankOutlets"));
            perJointlyCard.setBankAccountType(map.get("bankAccountType"));
            perJointlyCard.setBankNo(map.get("bankNo"));
            perJointlyCard.setBankCardNo(map.get("bankCardNo"));
            perJointlyCard.setBankAccountStatus(map.get("bankAccountStatus"));
            perJointlyCard.setCancelTime(map.get("cancelTime"));
            perJointlyCard.setCancelReason(map.get("cancelReason"));
            perJointlyCardList.add(perJointlyCard);
        }
        if (perJointlyCardList.size() > 0) {
            this.perJointlyCardMapper.batchUpdatePerJointlyCard(perJointlyCardList);
        }
        return Result.success((String)"");
    }

    @Override
    public Result getPerJointlyByPerId(Long perId) throws V5BusinessException {
        if (perId == null) {
            return Result.fail((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PerJointlyCard perJointlyCard = this.perJointlyCardMapper.getPerJointlyCard(perId);
        return Result.success((String)"", (Object)perJointlyCard);
    }

    @Override
    public Result getPerJointlyCard(PerJointlyCardDTO dto) throws V5BusinessException {
        PerJointlyCard perJointlyCard = this.perJointlyCardMapper.getPerJointlyCard(dto.getPerId());
        if (perJointlyCard != null && ObjectUtil.equal((Object)perJointlyCard.getBankAccountStatus(), (Object)"0")) {
            return Result.success((String)"");
        }
        return Result.success((String)"", (Object)perJointlyCard);
    }

    @Override
    public Result getBankOutletsList(PerJointlyCardDTO dto) throws V5BusinessException {
        List<ConfigBankOutletsDTO> bankList = this.commonService.getConfigBankOutlets();
        if (StringUtil.isNotEmpty((String)dto.getPerLongitude()) && StringUtil.isNotEmpty((String)dto.getPerLatitude()) && !ObjectUtil.equal((Object)dto.getPerLongitude(), (Object)dto.getPerLatitude()) && bankList != null && bankList.size() > 0) {
            String endLonLat;
            StringBuilder lonLats = new StringBuilder();
            for (ConfigBankOutletsDTO bankDto : bankList) {
                lonLats.append(bankDto.getAddressLongitude()).append(",").append(bankDto.getAddressLatitude()).append("|");
            }
            String lonLatsStr = lonLats.toString();
            String resultStr = GaodeMapUtil.getDistance(lonLatsStr = lonLatsStr.substring(0, lonLatsStr.length() - 1), endLonLat = dto.getPerLongitude() + "," + dto.getPerLatitude());
            if (StringUtil.isNotEmpty((String)resultStr) && !ObjectUtil.equal((Object)resultStr, (Object)"-1")) {
                List list = JSON.parseArray((String)resultStr, Map.class);
                block1: for (int j = 0; j < bankList.size(); ++j) {
                    for (int i = 0; i < list.size(); ++i) {
                        if (i != j) continue;
                        bankList.get(j).setDistance(Long.parseLong(((Map)list.get(i)).get("distance").toString()));
                        continue block1;
                    }
                }
            }
            bankList.sort((x, y) -> Long.compare(x.getDistance(), y.getDistance()));
        }
        return Result.success((String)"", bankList);
    }

    @Override
    public Result getBankOutletsWorkDayList(ConfigBankOutletsWorkDay configBankOutletsWorkDay) throws V5BusinessException {
        if (configBankOutletsWorkDay.getBankOutletsId() == null) {
            return Result.fail((String)"\u94f6\u884c\u7f51\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String startDate = DateUtil.getDateStrAfterToday((int)1);
        if (DateUtils.dateCompare(startDate, "2020-08-24")) {
            startDate = "2020-08-24";
        }
        String endDate = DateUtil.getDateStrAfterToday((int)7);
        List<Map<String, Object>> list = this.configBankOutletsWorkDayMapper.getBankOutletsWorkDayList(configBankOutletsWorkDay.getBankOutletsId(), startDate, endDate);
        return Result.success((String)"", list);
    }

    @Override
    public Result getBankOutletsWorkDayTimePeriodList(ConfigBankOutletsWorkDayTimePeriodDto dto) throws V5BusinessException {
        if (dto.getBankOutletsWorkDayId() == null) {
            return Result.fail((String)"\u94f6\u884c\u7f51\u70b9\u5de5\u4f5c\u65e5ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getAppointmentDate())) {
            return Result.fail((String)"\u9884\u7ea6\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Map<String, Object>> list = this.configBankOutletsWorkDayTimePeriodMapper.getBankOutletsWorkDayTimePeriodMList(dto.getBankOutletsWorkDayId(), dto.getAppointmentDate());
        return Result.success((String)"", list);
    }

    @Override
    public Result reserveBankOutlets(PerBankOutletsAppointment perBankOutletsAppointment) throws V5BusinessException {
        if (perBankOutletsAppointment.getBankOutletsWorkDayTimePeriodId() == null) {
            return Result.fail((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u7f51\u70b9\u5de5\u4f5c\u65e5\u65f6\u95f4\u6bb5");
        }
        if (perBankOutletsAppointment.getAppointmentDate() == null) {
            return Result.fail((String)"\u9884\u7ea6\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String currentTime = DateUtils.formatDate(perBankOutletsAppointment.getCreateTime(), "HH:mm");
        if (currentTime.compareTo("16:30") > 0) {
            return Result.fail((String)"\u5f53\u524d\u5df2\u8d85\u8fc7\u4eca\u65e5\u9884\u7ea6\u65f6\u95f4\uff0c\u8bf7\u660e\u65e5\u518d\u9884\u7ea6\uff01");
        }
        String isCanAppointment = this.perBankOutletsAppointmentMapper.checkIsCanAppointment(perBankOutletsAppointment);
        if (StringUtil.isNotEmpty((String)isCanAppointment) && isCanAppointment.equals("0")) {
            return Result.fail((String)"\u5bf9\u4e0d\u8d77\uff0c\u9884\u7ea6\u4eba\u6570\u5df2\u6ee1\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7f51\u70b9\u6216\u8005\u5176\u4ed6\u65f6\u95f4\u6bb5\u9884\u7ea6\uff01");
        }
        PerBankOutletsAppointment appointment = this.perBankOutletsAppointmentMapper.getPerBankOutletsAppointment(perBankOutletsAppointment.getPerId());
        if (appointment != null) {
            return Result.fail((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u5df2\u6709\u9884\u7ea6\u4fe1\u606f\uff0c\u65e0\u9700\u518d\u9884\u7ea6\uff01");
        }
        Map<String, String> map = this.configBankOutletsWorkDayTimePeriodMapper.getBankOutletsappointmentInfo(perBankOutletsAppointment.getBankOutletsWorkDayTimePeriodId());
        PerBaseInfo perBaseInfo = this.perBaseInfoMapper.selectPerBaseInfoById(perBankOutletsAppointment.getPerId());
        if (StringUtil.isNotEmpty((String)perBaseInfo.getMobilePhone())) {
            HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
            huaWeiSmsContent.setPlatform("PASP");
            huaWeiSmsContent.setSmsCode("B13");
            huaWeiSmsContent.setMobile(perBaseInfo.getMobilePhone());
            huaWeiSmsContent.setParams(JSON.toJSONString((Object)new String[]{map.get("bankOutlets"), DateUtils.formatDate(perBankOutletsAppointment.getAppointmentDate(), new Object[0]) + " " + map.get("startTime") + "~" + map.get("endTime"), map.get("bankAddress")}));
            this.commonService.sendSMS(huaWeiSmsContent);
        }
        this.perBankOutletsAppointmentMapper.insertPerBankOutletsAppointment(perBankOutletsAppointment);
        String tilte = "\u60a8\u5df2\u6210\u529f\u9884\u7ea6\u7f51\u70b9\u73b0\u573a\u529e\u7406\u8054\u540d\u5361\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\uff01";
        String content = "\u60a8\u5df2\u6210\u529f\u9884\u7ea6\u7f51\u70b9\u73b0\u573a\u529e\u7406\u8054\u540d\u5361\uff1a\\n{bankOutlets}\uff1b\\n\u9884\u7ea6\u65f6\u95f4\uff1a{timeArea}\uff1b\\n{bankAddress} \u3002\\n\u8bf7\u643a\u5e26\u8eab\u4efd\u8bc1\u539f\u4ef6\u51c6\u65f6\u5230\u7f51\u70b9\u529e\u7406\uff0c\u82e5\u60a8\u5148\u524d\u6709\u529e\u7406\u8fc7\u6e24\u6d77\u94f6\u884c\u94f6\u884c\u5361\uff0c\u4e5f\u8bf7\u4e00\u5e76\u643a\u5e26\uff0c\u5f00\u901a\u4e1a\u52a1\u65f6\u9700\u8981\u6838\u9a8c\u65e7\u5361";
        content = content.replace("{bankOutlets}", map.get("bankOutlets")).replace("{timeArea}", DateUtils.formatDate(perBankOutletsAppointment.getAppointmentDate(), new Object[0]) + " " + map.get("startTime") + "~" + map.get("endTime")).replace("{bankAddress}", map.get("bankAddress"));
        this.commonService.sendMessageToApp(tilte, content, "010401", perBankOutletsAppointment.getPerId().toString(), null, null);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result getPerBankOutletsAppointment(PerBankOutletsAppointment perBankOutletsAppointment) throws V5BusinessException {
        PerJointlyCard perJointlyCard;
        Map<String, String> map = this.perBankOutletsAppointmentMapper.getPerBankOutletsAppointmentByPerId(perBankOutletsAppointment.getPerId());
        if (map == null) {
            return Result.success((String)"");
        }
        Date eTime = DateUtil.convertStringToDate((String)(map.get("appointmentDate") + " " + map.get("endTime")));
        if (StringUtil.isNotEmpty((String)map.get("appointmentDate")) && StringUtil.isNotEmpty((String)map.get("endTime")) && System.currentTimeMillis() > eTime.getTime() && (perJointlyCard = this.perJointlyCardMapper.getPerJointlyCard(perBankOutletsAppointment.getPerId())) != null && ObjectUtil.equal((Object)perJointlyCard.getBankAccountStatus(), (Object)"0")) {
            return Result.success((String)"");
        }
        return Result.success((String)"", map);
    }

    @Override
    public Result cancelReserveBankOutlets(PerBankOutletsAppointment perBankOutletsAppointment) throws V5BusinessException {
        this.perBankOutletsAppointmentMapper.deletePerBankOutletsAppointment(perBankOutletsAppointment);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result getJointlyCardApplyUrl(Long perId) throws UnsupportedEncodingException {
        Map<String, String> map = this.perBaseInfoMapper.findPerDecByperIdForBHAPI(perId);
        if (map == null) {
            return Result.fail((String)"\u672a\u627e\u5230\u4eba\u5458\u6216\u4f01\u4e1a");
        }
        if (StringUtil.isEmpty((String)map.get("EntAddress")) || StringUtil.isEmpty((String)map.get("ZipCode"))) {
            return Result.fail((String)"\u5730\u5740\u6216\u90ae\u7f16\u672a\u5b8c\u5584");
        }
        String applyUrl = this.commonService.getSystemConfig("BOHAI_JOINTLYCARD_APPLY_URL");
        String queryUrl = this.commonService.getSystemConfig("BOHAI_JOINTLYCARD_QUERY_URL");
        String aesKey = this.commonService.getSystemConfig("BOHAI_JOINTLYCARD_APPLY_AESKEY");
        String aesStr = BH_AESUtil.AES_Encrypt(aesKey, JSON.toJSONString(map));
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("applyUrl", applyUrl + URLEncoder.encode(aesStr, "UTF-8"));
        paramMap.put("queryUrl", queryUrl);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)paramMap);
    }

    @Override
    public Result getJointlyCardApplyConditions(Long perId, Long comId) throws UnsupportedEncodingException {
        Map<String, String> map;
        int isZZ = 1;
        int isBGD = 1;
        int isCZZP = 0;
        String address = null;
        PerBaseInfo perBaseInfo = this.perBaseInfoMapper.selectPerBaseInfoById(perId);
        if (StringUtils.isNotEmpty((String)perBaseInfo.getIdCardNo())) {
            // empty if block
        }
        if ((map = this.perBaseInfoMapper.findPerDecByperIdForBHAPI(perId)) == null) {
            isZZ = 0;
            isBGD = 0;
        } else {
            address = map.get("EntAddress");
            if (StringUtils.isEmpty((String)map.get("EntName")) || StringUtils.isEmpty((String)map.get("EntAddress")) || StringUtils.isEmpty((String)map.get("EntPhone")) || StringUtil.isEmpty((String)map.get("ZipCode"))) {
                isBGD = 0;
            }
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("isZZ", isZZ);
        paramMap.put("isBGD", isBGD);
        paramMap.put("isCZZP", isCZZP);
        paramMap.put("comAddress", address);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)paramMap);
    }
}

