/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util.map;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.util.HttpUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.NameValuePair;

public class GaodeMapUtil {
    private static final String KEY = "b005b544c167cbb933edf53a0ab46e5f";
    private static final String OUTPUT = "JSON";
    private static final String GET_LNG_LAT_URL = "http://restapi.amap.com/v3/geocode/geo";
    private static final String GET_ADDRESS_URL = "http://restapi.amap.com/v3/geocode/regeo";
    private static final String GET_DISTANCE = "http://restapi.amap.com/v3/distance";

    public static String getAddressByLonLat(double gdLon, double gdLat) {
        String location = gdLon + "," + gdLat;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("location", location);
        try {
            String url = GaodeMapUtil.jointUrl(params, OUTPUT, KEY, GET_ADDRESS_URL);
            return HttpUtils.doPost(url, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getLonLarByAddress(String address) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", address);
        try {
            String url = GaodeMapUtil.jointUrl(params, OUTPUT, KEY, GET_LNG_LAT_URL);
            String jsonResult = HttpUtils.doPost(url, params);
            JSONObject jsonObject = JSON.parseObject((String)jsonResult);
            if (ObjectUtil.equal((Object)jsonObject.get((Object)"status"), (Object)"1")) {
                JSONArray geocodes = jsonObject.getJSONArray("geocodes");
                String geocode = JSON.toJSONString((Object)geocodes.get(0));
                JSONObject geocodeObj = JSON.parseObject((String)geocode);
                String lonAndLat = geocodeObj.getString("location");
                HashMap<String, String> resultMap = new HashMap<String, String>();
                if (StringUtils.isNotEmpty((String)lonAndLat) && lonAndLat.contains(",")) {
                    String[] lonAndLatArr = lonAndLat.split(",");
                    resultMap.put("\u7ecf\u5ea6", lonAndLatArr[0]);
                    resultMap.put("\u7eac\u5ea6", lonAndLatArr[1]);
                    return ((Object)resultMap).toString();
                }
                return "\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5f02\u5e38";
            }
            return "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private static String jointUrl(Map<String, Object> params, String output, String key, String url) throws IOException {
        StringBuilder baseUrl = new StringBuilder();
        baseUrl.append(url);
        int index = 0;
        Set<Map.Entry<String, Object>> entrys = params.entrySet();
        for (Map.Entry<String, Object> param : entrys) {
            if (index == 0) {
                baseUrl.append("?");
            } else {
                baseUrl.append("&");
            }
            baseUrl.append(param.getKey()).append("=").append(URLEncoder.encode(param.getValue().toString(), "utf-8"));
            ++index;
        }
        baseUrl.append("&output=").append(output).append("&key=").append(key);
        return baseUrl.toString();
    }

    public static String getDistance(String startLonLat, String endLonLat) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String jsonResult = "";
        try {
            String url = "http://restapi.amap.com/v3/distance?key=b005b544c167cbb933edf53a0ab46e5f&type=1&origins=" + startLonLat + "&destination=" + endLonLat;
            jsonResult = HttpUtils.doGet(url, params);
            JSONObject jsonObject = JSON.parseObject((String)jsonResult);
            if (ObjectUtil.equal((Object)jsonObject.get((Object)"status"), (Object)"1")) {
                return jsonObject.get((Object)"results").toString();
            }
            return "-1";
        }
        catch (Exception e) {
            return "-1";
        }
    }

    public static void main(String[] args) throws IOException {
        String result = GaodeMapUtil.getDistance("116.365607,39.906509|116.323814,39.947207", "116.479996,39.985572");
        System.out.println(result);
    }
}

