/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util.file;

import cn.hutool.core.io.FileUtil;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.util.file.BcxinFileUtils;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipCompressor {
    private static Logger log = LoggerFactory.getLogger(ZipCompressor.class);
    static final int BUFFER = 8192;
    private File zipFile;

    public ZipCompressor(String pathName) {
        this.zipFile = new File(pathName);
    }

    public void compressSingle(String srcPathName) {
        File file = new File(srcPathName);
        if (!file.exists()) {
            throw new RuntimeException(srcPathName + "\u4e0d\u5b58\u5728\uff01");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.zipFile);
            CheckedOutputStream cos = new CheckedOutputStream(fileOutputStream, new CRC32());
            ZipOutputStream out = new ZipOutputStream((OutputStream)cos);
            String basedir = "";
            this.compressByType(file, out, basedir);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6267\u884c\u538b\u7f29\u64cd\u4f5c\u65f6\u53d1\u751f\u5f02\u5e38:" + e);
            throw new RuntimeException(e);
        }
    }

    public void compressFileList(List<String> filePaths) {
        ArrayList files = Lists.newArrayList();
        for (String filePath : filePaths) {
            File policyFile;
            if (!StringUtils.isNotEmpty((String)filePath) || !(policyFile = new File(filePath)).exists()) continue;
            files.add(policyFile);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.zipFile);
            CheckedOutputStream cos = new CheckedOutputStream(fileOutputStream, new CRC32());
            ZipOutputStream out = new ZipOutputStream((OutputStream)cos);
            for (File file : files) {
                String basedir = "";
                this.compressByType(file, out, basedir);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6267\u884c\u538b\u7f29\u64cd\u4f5c\u65f6\u53d1\u751f\u5f02\u5e38:" + e);
            throw new RuntimeException(e);
        }
        String fileFolder = "";
        for (File file : files) {
            if (StringUtils.isEmpty((String)fileFolder)) {
                fileFolder = file.getParent();
            }
            if (file.isFile() && file.exists()) {
                log.debug("\u5220\u9664\u6587\u4ef6[{}]", (Object)file.getPath());
                file.delete();
            }
            if (!file.isDirectory()) continue;
            log.debug("\u5220\u9664\u6587\u4ef6\u5939[{}]", (Object)file.getPath());
            BcxinFileUtils.deleteFolder(file);
        }
        if (StringUtils.isNotEmpty((String)fileFolder)) {
            FileUtil.del((String)fileFolder);
        }
    }

    private void compressByType(File file, ZipOutputStream out, String basedir) {
        if (file.isDirectory()) {
            log.info("\u538b\u7f29\uff1a" + basedir + file.getName());
            this.compressDirectory(file, out, basedir);
        } else {
            log.info("\u538b\u7f29\uff1a" + basedir + file.getName());
            this.compressFile(file, out, basedir);
        }
    }

    private void compressDirectory(File dir, ZipOutputStream out, String basedir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files.length == 0) {
            try {
                ZipEntry zipEntry = new ZipEntry(dir.getName() + "/");
                out.putNextEntry(zipEntry);
                out.closeEntry();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (int i = 0; i < files.length; ++i) {
            this.compressByType(files[i], out, basedir + dir.getName() + "/");
        }
    }

    private void compressFile(File file, ZipOutputStream out, String basedir) {
        if (!file.exists()) {
            return;
        }
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(basedir + file.getName());
            out.putNextEntry(entry);
            byte[] data = new byte[8192];
            while ((count = bis.read(data, 0, 8192)) != -1) {
                out.write(data, 0, count);
            }
            bis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        ZipCompressor zc = new ZipCompressor("d:\\szhzip2.zip");
        ArrayList filePath = Lists.newArrayList();
        filePath.add("D:\\_act_23494896_t_20170822094542\\2\u5e94\u6025\u9884\u6848\u5927\u591a\u6570");
        filePath.add("D:\\_act_23494896_t_20170822094542\\\u9644\u4ef6");
        filePath.add("D:\\_act_23494896_t_20170822094542\\\u5b89\u5168\u4fdd\u536b\u5de5\u4f5c\u65b9\u6848.docx");
        filePath.add("D:\\_act_23494896_t_20170822094542\\\u5b89\u5168\u5de5\u4f5c\u65b9\u6848.doc");
        zc.compressFileList(filePath);
    }
}

