/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.http.util.TextUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class RecallMessageContent
extends MessageContent {
    private long messageId;
    private String operatorId;
    private String originalSender;
    private int originalContentType;
    private String originalSearchableContent;
    private String originalContent;
    private String originalExtra;
    private byte[] originalBinaryContent;
    private int originalMediaType;
    private String originalMediaUrl;
    private long originalMessageTimestamp;

    public long getMessageId() {
        return this.messageId;
    }

    public String getOperatorId() {
        return this.operatorId;
    }

    public String getOriginalSender() {
        return this.originalSender;
    }

    public int getOriginalContentType() {
        return this.originalContentType;
    }

    public String getOriginalSearchableContent() {
        return this.originalSearchableContent;
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public String getOriginalExtra() {
        return this.originalExtra;
    }

    public long getOriginalMessageTimestamp() {
        return this.originalMessageTimestamp;
    }

    public byte[] getOriginalBinaryContent() {
        return this.originalBinaryContent;
    }

    public int getOriginalMediaType() {
        return this.originalMediaType;
    }

    public String getOriginalMediaUrl() {
        return this.originalMediaUrl;
    }

    @Override
    public int getContentType() {
        return 80;
    }

    @Override
    public int getPersistFlag() {
        return 1;
    }

    @Override
    public MessagePayload encode() {
        throw new RuntimeException("Recall message cannot encode");
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
        this.operatorId = payload.getContent();
        this.messageId = Long.parseLong(new String(Base64.getDecoder().decode(payload.getBase64edData()), StandardCharsets.UTF_8));
        if (!TextUtils.isEmpty((CharSequence)payload.getExtra())) {
            try {
                JSONObject dictionary = (JSONObject)new JSONParser().parse(payload.getExtra());
                this.originalSender = (String)dictionary.get((Object)"s");
                if (dictionary.containsKey((Object)"t")) {
                    this.originalContentType = ((Number)dictionary.get((Object)"t")).intValue();
                }
                this.originalSearchableContent = (String)dictionary.get((Object)"sc");
                this.originalContent = (String)dictionary.get((Object)"c");
                this.originalExtra = (String)dictionary.get((Object)"e");
                if (dictionary.containsKey((Object)"ts")) {
                    this.originalMessageTimestamp = ((Number)dictionary.get((Object)"ts")).longValue();
                }
                if (dictionary.containsKey((Object)"mt")) {
                    this.originalMediaType = ((Number)dictionary.get((Object)"mt")).intValue();
                }
                this.originalMediaUrl = (String)dictionary.get((Object)"mu");
                if (dictionary.containsKey((Object)"mb")) {
                    this.originalBinaryContent = Base64.getDecoder().decode((String)dictionary.get((Object)"mb"));
                }
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

