
package com.bcxin.identify.util.getui;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.identify.util.Result;
import com.bcxin.identify.util.codes.CommonConst;
import com.bcxin.identify.util.common.IdWorker;
import com.bcxin.identify.util.common.StringUtil;
import com.bcxin.identify.util.sys.ConfigUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.*;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
public class GeTuiUtil {

    private static final Logger logger = LoggerFactory.getLogger(GeTuiUtil.class);

    private static String url = GeTuiConst.GATEWAY_URL;
    private static String url_uni2 = GeTuiConst.GATEWAY_UNI2_URL;
    private static String url_online_uni2 = GeTuiConst.GATEWAY_UNI2_ONLINE_URL;

    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    private static final String APPLICATION_JSON = "application/json;charset=utf-8";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";
    private static String APPID;
    private static String APPKEY;
    private static String MASTERSECRET;
    static {
        APPKEY = ConfigUtil.getValue(CommonConst.GETUI_APP_KEY);
        APPID = ConfigUtil.getValue(CommonConst.GETUI_APP_ID);
        MASTERSECRET = ConfigUtil.getValue(CommonConst.GETUI_MASTER_SECRET);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        /*Long timep = System.currentTimeMillis();
        String sign = APPKEY+timep+MASTERSECRET;
        sign = DigestUtils.sha256Hex(sign.getBytes());
        JSONObject json = new JSONObject();
        json.put("sign",sign);
        json.put("timestamp",String.valueOf(timep));
        json.put("appkey",APPKEY);
        Result ret = sendMsg(POST, "",APPID+GeTuiConst.POST_AUTH, json.toJSONString());
        JSONObject j = (JSONObject) ret.getData();
        System.out.println(j.get("expire_time"));
        System.out.println(j.get("token"));*/
//        String payload = "{\"createdTime\":1732685781479,\"employeeId\":\"14nr5DyZ\",\"id\":1059142776535728100,\"name\":\"妫佳悦\",\"organizationId\":\"aSuXCEfz\",\"roomNo\":\"1241127003\",\"tencentUserId\":\"bjbPiCGI\",\"type\":\"video\",\"userId\":\"10202401250934360001\",\"yardmanType\":\"1\"}";
        String payload = "{\"createdTime\":1732685781479,\"employeeId\":\"14nr5DyZ\",\"id\":1059142776535728100,\"name\":\"妫佳悦\",\"organizationId\":\"aSuXCEfz\",\"roomNo\":\"1241127027\",\"tencentUserId\":\"bjbPiCGI\",\"type\":\"video\",\"userId\":\"10202401250934360001\",\"yardmanType\":\"1\"}";
        List<String> clientids = new ArrayList<>();
        clientids.add("b8c4012b321e396db6b2dc5812cb96f8");
        pushSingleByUni2("xxxxxxx110", "asd",clientids, payload);
    }

    /**
     * <b> 鉴权获取token </b>
     * @author ZXF
     * @create 2021/05/13 0013 16:13
     * @version
     * @注意事项 </b>
     */
    public static Result auth() {
        Long timep = System.currentTimeMillis();
        String sign = APPKEY+timep+MASTERSECRET;
        sign = DigestUtils.sha256Hex(sign.getBytes());
        JSONObject json = new JSONObject();
        json.put("sign",sign);
        json.put("timestamp",String.valueOf(timep));
        json.put("appkey",APPKEY);
        return GeTuiUtil.sendMsg(GeTuiUtil.POST, "",APPID+ GeTuiConst.POST_AUTH, json.toJSONString());
    }

    /**
     * <b> 执行cid单推，当前使用纯透传消息的模式 </b>
     * @author ZXF
     * @create 2021/05/13 0013 16:13
     * @version
     * @注意事项 </b>
     */
    public static Result pushSingle(Integer ttl,String[] cids, String token, String msg, String title, String body) {
        Long timep = System.currentTimeMillis();
        String sign = APPKEY+timep+MASTERSECRET;
        sign = DigestUtils.sha256Hex(sign.getBytes());
        JSONObject json = new JSONObject();
        JSONObject settings = new JSONObject();
        JSONObject strategy = new JSONObject();
        JSONObject audience = new JSONObject();
        JSONObject push_message = new JSONObject();
        JSONObject push_channel = new JSONObject();
        json.put("request_id", String.valueOf(IdWorker.getId()));
        settings.put("ttl",ttl);
        strategy.put("default",1);
        settings.put("strategy",strategy);
        json.put("settings",settings);
        audience.put("cid",cids);
        json.put("audience",audience);
        push_message.put("transmission",msg);
        json.put("push_message",push_message);
        if(StringUtil.isNotEmpty(body)){
            JSONObject ios = new JSONObject();
            JSONObject aps = new JSONObject();
            JSONObject alert = new JSONObject();
            alert.put("title",title);
            alert.put("body",body);
            aps.put("alert",alert);
            aps.put("content-available",0);
//            aps.put("sound","default"); // TODO ound字段为ios通知铃声文件名（包含格式后缀名）。
            aps.put("sound","pushsound.caf"); // TODO ound字段为ios通知铃声文件名（包含格式后缀名）。
            aps.put("category","ACTIONABLE"); // TODO
            ios.put("payload",msg);//增加自定义的数据
            ios.put("aps",aps);//推送通知消息内容
            ios.put("auto_badge","+1");//TODO
            push_channel.put("ios",ios);//ios厂商通道消息
            JSONObject android = new JSONObject();
            JSONObject ups = new JSONObject();
            JSONObject notification = new JSONObject();
            notification.put("title",title);
            notification.put("body",body);
            notification.put("click_type","intent");
            notification.put("intent","intent://io.dcloud.unipush/?#Intent;scheme=unipush;launchFlags=0x4000000;component=com.bcxin.bbdhn/io.dcloud.PandoraEntry;S.UP-OL-SU=true;S.title="+title+";S.content="+msg+";S.payload="+msg+";end");
            ups.put("notification",notification);
            JSONObject options = new JSONObject();
            JSONObject hw = new JSONObject();
            hw.put("/message/android/category","VOIP");// 自分类权益 VOIP音视频通话
            hw.put("/message/android/notification/default_sound",false);// 设置为 false，使用sound自定义铃声
            hw.put("/message/android/notification/sound","/raw/pushsound");// TODO 自定义消息通知铃声，在新创建渠道时有效，此处设置的铃声文件必须存放在应用的/res/raw路径下
            options.put("HW",hw);
            JSONObject xm = new JSONObject();
            xm.put("/extra.sound_uri","android.resource://com.bcxin.bbdhn/raw/pushsound");// TODO 小米后台申请的自定义sound_url地址
            xm.put("/extra.channel_id","109448");// TODO 小米后台申请的"私信"通知类别id
            options.put("XM",xm);
            JSONObject vv = new JSONObject();
            vv.put("/category","IM");// TODO 二级分类
            options.put("VV",vv);
            JSONObject op = new JSONObject();
            op.put("/channel_id","__UNI__359FBBE__01");// OPush平台上所有通道分为“公信”(默认)、“私信”两类，默认下发公信消息。公信消息单日可推送数量有限制，私信消息不限(仅限单个用户)
            options.put("OPG",op);// TODO 当前配置的 公信 通道，每日有推送数量限制，私信通道：OPG
            JSONObject _ups = new JSONObject();
            _ups.put("bigText",title+"<br>"+body);// 通知展示文本+长文本样式的长文本内容
            options.put("UPS",_ups);
            ups.put("options",options);
            android.put("ups",ups);
            push_channel.put("android",android);//厂商通道消息
            json.put("push_channel",push_channel);//厂商通道消息内容
            logger.info("========> 个推CIDS推送.pushSingle.cids:"+JSON.toJSONString(cids));
            Result ret = sendMsg(GeTuiUtil.POST, token,APPID+ GeTuiConst.PUSH_SINGLE_CID, json.toJSONString());
            if(ret.getData()!=null &&JSON.toJSONString(ret.getData()).contains("successed_online")){
                onPushSingle( ttl, cids, token, msg, title, body);
            }
            return ret;
        }
        return Result.fail("http请求异常！");
    }

    public static Result onPushSingle(Integer ttl,String[] cids, String token, String msg, String title, String body) {
        Long timep = System.currentTimeMillis();
        String sign = APPKEY+timep+MASTERSECRET;
        sign = DigestUtils.sha256Hex(sign.getBytes());
        JSONObject json = new JSONObject();
        JSONObject settings = new JSONObject();
        JSONObject strategy = new JSONObject();
        JSONObject audience = new JSONObject();
        JSONObject push_message = new JSONObject();
        json.put("request_id", String.valueOf(IdWorker.getId()));
        settings.put("ttl",ttl);
        strategy.put("default",1);
        settings.put("strategy",strategy);
        json.put("settings",settings);
        audience.put("cid",cids);
        json.put("audience",audience);
        JSONObject pmnotification = new JSONObject();
        pmnotification.put("title",title);
        pmnotification.put("body",body);
        pmnotification.put("bigText",title+"<br>"+body);
        pmnotification.put("channel_level",4);
        pmnotification.put("click_type","startapp");
        push_message.put("notification",pmnotification);
        json.put("push_message",push_message);
        return sendMsg(GeTuiUtil.POST, token,APPID+ GeTuiConst.PUSH_SINGLE_CID, json.toJSONString());
    }

    /**
     * <b> 创建消息体，并返回taskid，为批量推的前置步骤 </b>
     * @author ZXF
     * @create 2024/01/17 0017 14:59
     * @version
     * @注意事项 </b>
     */
    public static Result pushListMessage(Integer ttl, String token, String msg, String title, String body) {
        Long timep = System.currentTimeMillis();
        String sign = APPKEY+timep+MASTERSECRET;
        sign = DigestUtils.sha256Hex(sign.getBytes());
        JSONObject json = new JSONObject();
        JSONObject settings = new JSONObject();
        JSONObject strategy = new JSONObject();
        JSONObject push_message = new JSONObject();
        JSONObject push_channel = new JSONObject();
        json.put("request_id", String.valueOf(IdWorker.getId()));
        settings.put("ttl",ttl);
        strategy.put("default",1);
        settings.put("strategy",strategy);
        json.put("settings",settings);
        json.put("group_name",String.valueOf(System.currentTimeMillis()));
        push_message.put("transmission",msg);
//        push_message.put("notification",msg);
        json.put("push_message",push_message);
        if(StringUtil.isNotEmpty(body)){
            JSONObject ios = new JSONObject();
            JSONObject aps = new JSONObject();
            JSONObject alert = new JSONObject();
            alert.put("title",title);
            alert.put("body",body);
            aps.put("alert",alert);
            aps.put("content-available",0);
//            aps.put("sound","default"); // TODO ound字段为ios通知铃声文件名（包含格式后缀名）。
            aps.put("sound","pushsound.caf"); // TODO ound字段为ios通知铃声文件名（包含格式后缀名）。
            aps.put("category","ACTIONABLE"); // TODO
            ios.put("payload",msg);//增加自定义的数据
            ios.put("aps",aps);//推送通知消息内容
            ios.put("auto_badge","+1");//TODO
            push_channel.put("ios",ios);//ios厂商通道消息
            JSONObject android = new JSONObject();
            JSONObject ups = new JSONObject();
            JSONObject notification = new JSONObject();
            notification.put("title",title);
            notification.put("body",body);
            notification.put("click_type","intent");
            notification.put("intent","intent://io.dcloud.unipush/?#Intent;scheme=unipush;launchFlags=0x4000000;component=com.bcxin.bbdhn/io.dcloud.PandoraEntry;S.UP-OL-SU=true;S.title="+title+";S.content="+msg+";S.payload="+msg+";end");
            ups.put("notification",notification);
            JSONObject options = new JSONObject();
            JSONObject hw = new JSONObject();
            hw.put("/message/android/category","VOIP");// 自分类权益 VOIP音视频通话
            hw.put("/message/android/notification/default_sound",false);// 设置为 false，使用sound自定义铃声
            hw.put("/message/android/notification/sound","/raw/pushsound");// TODO 自定义消息通知铃声，在新创建渠道时有效，此处设置的铃声文件必须存放在应用的/res/raw路径下
            options.put("HW",hw);
            JSONObject xm = new JSONObject();
            xm.put("/extra.sound_uri","android.resource://com.bcxin.bbdhn/raw/pushsound");// TODO 小米后台申请的自定义sound_url地址
            xm.put("/extra.channel_id","109448");// TODO 小米后台申请的"私信"通知类别id
            options.put("XM",xm);
            JSONObject vv = new JSONObject();
            vv.put("/category","IM");// TODO 二级分类
            options.put("VV",vv);
            JSONObject op = new JSONObject();
            op.put("/channel_id","__UNI__359FBBE__01");// OPush平台上所有通道分为“公信”(默认)、“私信”两类，默认下发公信消息。公信消息单日可推送数量有限制，私信消息不限(仅限单个用户)
            options.put("OPG",op);// TODO 当前配置的 公信 通道，每日有推送数量限制，私信通道：OPG
            JSONObject _ups = new JSONObject();
            _ups.put("bigText",title+"<br>"+body);// 通知展示文本+长文本样式的长文本内容
            options.put("UPS",_ups);
            ups.put("options",options);
            android.put("ups",ups);
            push_channel.put("android",android);//厂商通道消息
            json.put("push_channel",push_channel);//厂商通道消息内容
            return sendMsg(GeTuiUtil.POST, token,APPID+ GeTuiConst.PUSH_LIST_MESSAGE, json.toJSONString());
        }
        return Result.fail("http请求异常！");
    }

    /**
     * <b> 对列表中所有cid进行消息推送 </b>
     * @author ZXF
     * @create 2024/01/17 0017 15:07
     * @version
     * @注意事项 </b>
     */
    public static Result pushListCid(String[] cids, String token, String taskid, boolean is_async) {
        Long timep = System.currentTimeMillis();
        String sign = APPKEY+timep+MASTERSECRET;
        sign = DigestUtils.sha256Hex(sign.getBytes());
        JSONObject json = new JSONObject();
        JSONObject audience = new JSONObject();
        json.put("request_id", String.valueOf(IdWorker.getId()));
        json.put("is_async",is_async);
        json.put("taskid",taskid);
        audience.put("cid",cids);
        json.put("audience",audience);
        return sendMsg(GeTuiUtil.POST, token,APPID+ GeTuiConst.PUSH_LIST_CID, json.toJSONString());
    }

    public static Result pushSingleByUni2(String content, String title, List<String> clientids, String payload) {
        if(clientids.size()==0){
            return Result.fail("未指定发送对象！");
        }
        JSONObject body = new JSONObject();
        body.put("content",content);
        body.put("title",title);
        body.put("push_clientid",clientids);
        JSONObject category = new JSONObject();
        category.put("harmony","IM");
        body.put("category",category);
        JSONObject options = new JSONObject();
        JSONObject XM = new JSONObject();
        XM.put("/extra.channel_id","109448");
        options.put("XM","XM");
        body.put("options",options);
        body.put("payload",JSONObject.parse(payload));
        System.out.println(body.toJSONString());
        String ret = doPost(url_uni2,"",body.toJSONString());
        System.out.println(ret);
        JSONObject json = JSONObject.parseObject(ret);
        if("0".equals(json.getString("errCode")) && json.getString("data").contains("successed_online")){
            return pushSingleByUni2Online( content,  title, clientids, payload);
        }
        return Result.fail(json.getString("errMsg"));
    }

    public static Result pushSingleByUni2Online(String content, String title, List<String> clientids, String payload) {
        JSONObject body = new JSONObject();
        body.put("content",content);
        body.put("title",title);
        body.put("push_clientid",clientids);
        JSONObject category = new JSONObject();
        category.put("harmony","IM");
        body.put("category",category);
        JSONObject options = new JSONObject();
        JSONObject XM = new JSONObject();
        XM.put("/extra.channel_id","109448");
        options.put("XM","XM");
        body.put("options",options);
        body.put("payload",JSONObject.parse(payload));
        System.out.println(body.toJSONString());
        String ret = doPost(url_online_uni2,"",body.toJSONString());
        System.out.println(ret);
        JSONObject json = JSONObject.parseObject(ret);
        if("0".equals(json.getString("errCode"))){
            return Result.success(json.getString("errMsg"),json.get("data"));
        }
        return Result.fail(json.getString("errMsg"));
    }

    public static Result test1(String token) {
        JSONObject json = new JSONObject();
        JSONObject audience = new JSONObject();
        String[] cids = {"6df23c6121ddc168b580861f40c57749"};
        audience.put("cid",cids);
        json.put("audience",audience);
        json.put("taskid","RASL_0906_998c314e59f94134b9e5374fded7dc51");
        return sendMsg(GeTuiUtil.POST, token,APPID+ GeTuiConst.PUSH_LIST_CID, json.toJSONString());
    }

    /**
     * <b> 执行cid单推，当前使用纯透传消息的模式(纯通知) </b>
     * @param payload app指定的页面类型参数
     * @author ZXF
     * @create 2021/05/13 0013 16:13
     * @version
     * @注意事项 </b>
     */
    public static Result pushSingleCom(Integer ttl,String[] cids, String token, String msg, String title, String body, String payload) {
        Long timep = System.currentTimeMillis();
        String sign = APPKEY+timep+MASTERSECRET;
        sign = DigestUtils.sha256Hex(sign.getBytes());
        JSONObject json = new JSONObject();
        JSONObject settings = new JSONObject();
        JSONObject audience = new JSONObject();
        JSONObject push_message = new JSONObject();
        JSONObject push_channel = new JSONObject();
        json.put("request_id", String.valueOf(IdWorker.getId()));
        settings.put("ttl",ttl);
        json.put("settings",settings);
        audience.put("cid",cids);
        json.put("audience",audience);
        push_message.put("transmission",msg);
        json.put("push_message",push_message);
        if(StringUtil.isNotEmpty(body)){
            JSONObject ios = new JSONObject();
            JSONObject aps = new JSONObject();
            JSONObject alert = new JSONObject();
            alert.put("title",title);
            alert.put("body",body);
            aps.put("alert",alert);
            ios.put("payload",msg);//增加自定义的数据
            ios.put("aps",aps);//推送通知消息内容
            push_channel.put("ios",ios);//ios厂商通道消息
            JSONObject android = new JSONObject();
            JSONObject ups = new JSONObject();
            JSONObject notification = new JSONObject();
            notification.put("title",title);
            notification.put("body",body);
            notification.put("click_type","intent");
            notification.put("intent","intent://io.dcloud.unipush/?#Intent;scheme=unipush;launchFlags=0x4000000;component=com.bcxin.bbdhn/io.dcloud.PandoraEntry;S.UP-OL-SU=true;S.title="+title+";S.content="+msg+";S.payload="+payload+";end");
            ups.put("notification",notification);
            android.put("ups",ups);
            push_channel.put("android",android);//厂商通道消息
            json.put("push_channel",push_channel);//厂商通道消息内容
            logger.info("========> 个推CIDS推送.pushSingleCom.cids:"+JSON.toJSONString(cids));
            return sendMsg(GeTuiUtil.POST, token,APPID+ GeTuiConst.PUSH_SINGLE_CID, json.toJSONString());
        }
        return Result.fail("http请求异常！");
    }

    public static Result sendMsg(String hostType, String token, String resourceUri, String jsonString) {
        String hUrl = url+resourceUri;
        logger.info(jsonString);
        String ret = "";
        if(GET.equals(hostType)){
            ret = doGet(hUrl);
        }else if(POST.equals(hostType)){
            ret = doPost(hUrl, token, jsonString);
        }else if(PUT.equals(hostType)){
            ret = doPut(hUrl, token, jsonString);
        }else if(DELETE.equals(hostType)){
            ret = doDelete(hUrl, token);
        }
        System.out.println(ret);
        if(StringUtil.isNotEmpty(ret)){
            return msg(ret);
        }
        return Result.fail("http请求异常！");
    }

    public static String doGet(String strUrl) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault()){
            URL url = new URL(strUrl);
            URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
            HttpGet HttpGet = new HttpGet(uri);
            try (CloseableHttpResponse resp = httpClient.execute(HttpGet)) {
                HttpEntity entity = resp.getEntity();
                return EntityUtils.toString(entity, StandardCharsets.UTF_8);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
        return "";
    }

    public static String doPost(String url, String token, String json) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault()){
            HttpPost httppost = new HttpPost(url);
            httppost.addHeader(HTTP.CONTENT_TYPE, APPLICATION_JSON);
            if(StringUtil.isNotEmpty(token)){
                httppost.addHeader("token", token);
            }
            if(StringUtil.isNotEmpty(json)){
                StringEntity se = new StringEntity(json, StandardCharsets.UTF_8);
                se.setContentType(APPLICATION_JSON);
                se.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE, APPLICATION_JSON));
                httppost.setEntity(se);
            }
            try (CloseableHttpResponse response = httpclient.execute(httppost) ){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    return EntityUtils.toString(entity, StandardCharsets.UTF_8);
                }
            }
        } catch (IOException e) {
            logger.error(e.getMessage(),e);
        }
        return "";
    }

    public static String doPut(String url, String token, String json) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault()){
            HttpPut httpput = new HttpPut(url);
            httpput.addHeader(HTTP.CONTENT_TYPE, APPLICATION_JSON);
            if(StringUtil.isNotEmpty(token)){
                httpput.addHeader("token", token);
            }
            if(StringUtil.isNotEmpty(json)){
                StringEntity se = new StringEntity(json, StandardCharsets.UTF_8);
                se.setContentType(CONTENT_TYPE_TEXT_JSON);
                se.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE, APPLICATION_JSON));
                httpput.setEntity(se);
            }
            try (CloseableHttpResponse response = httpclient.execute(httpput) ){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    return EntityUtils.toString(entity, StandardCharsets.UTF_8);
                }
            }
        } catch (IOException e) {
            logger.error(e.getMessage(),e);
        }
        return "";
    }

    public static String doDelete(String strUrl, String token) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault()){
            URL url = new URL(strUrl);
            URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
            HttpDelete HttpDelete = new HttpDelete(uri);
            if(StringUtil.isNotEmpty(token)){
                HttpDelete.addHeader("token", token);
            }
            try (CloseableHttpResponse resp = httpClient.execute(HttpDelete)) {
                HttpEntity entity = resp.getEntity();
                return EntityUtils.toString(entity, StandardCharsets.UTF_8);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
        return "";
    }

    /**
     * <b> 返回结果处理 </b>
     * @author ZXF
     * @create 2020/04/15 0015 14:22
     * @version
     * @注意事项 </b>
     */
    public static Result msg(String ret) {
        String msg = "";
        Map<String, Object> resultMap = getMapData(ret);
        if(resultMap != null && resultMap.get("code")!=null&&!"0".equals(String.valueOf(resultMap.get("code")))){
            String error_code = String.valueOf(resultMap.get("code"));
            msg = GTErrorEnum.errorMsg(error_code);
            return Result.fail(msg);
        }
        return Result.success(Result.SUCCESS_MSG,resultMap.get("data"));
    }

    public static Map<String, Object> getMapData(String ret) {
        return JSON.parseObject(ret, Map.class);
    }

}
